/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.metadata.dao;

import java.sql.ResultSet;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.exception.OrmException;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.SqlParameter;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.ksql.util.StringUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.AbstractMetadata;
import kd.bos.metadata.Plugin;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.form.DesignFormMeta;
import kd.bos.metadata.form.PrintMetadata;

public class PrintMetadataWriter {
    private static final Log logger = LogFactory.getLog(PrintMetadataWriter.class);
    private static final String EXISTED_SQL = "select top 1 %s from %s where %s = ? ";
    private static final String INSERT_SQL = "insert into %s (fid, fprinttplid, fbillformid, fcreatetime, fmodifytime,fmodifierid,fcreatorid, fenable) values (?, ?, ?, ?, ?, ?, ?, ?)";
    private static final String UPDATE_SQL = "update %s set  fmodifytime = ?,fmodifierid= ?,fcreatetime = ?,fcreatorid = ? where fprinttplid = ?";
    private static final String DELETE_SQL = "delete from %s where fprinttplid = ?";
    private static final String TABLENAME = "t_bas_printtplinfo";
    private static final String FIELD_PRINT_TP_LID = "fprinttplid";
    private static final String FIX_TIME = "2018-08-08 18:08:08";
    private static final String ERROR_STR_HOLDER = "Error:%s.";

    private PrintMetadataWriter() {
        throw new IllegalStateException("Utility class");
    }

    public static void savePrintTemplateInfo(AbstractMetadata metadata) {
        if (metadata instanceof PrintMetadata) {
            PrintMetadata printMeta = (PrintMetadata)metadata;
            if (PrintMetadataWriter.isExistedInfo(printMeta.getId())) {
                PrintMetadataWriter.updatePrintInfo(printMeta.getId(), printMeta.getIsv());
            } else {
                PrintMetadataWriter.insertPrintInfo(printMeta.getEntityId(), printMeta.getId(), printMeta.getIsv());
            }
        }
    }

    public static void savePrintTemplateInfo(DesignFormMeta metadata) {
        if ("PrintModel".equalsIgnoreCase(metadata.getModelType())) {
            if (PrintMetadataWriter.isExistedInfo(metadata.getId())) {
                PrintMetadataWriter.updatePrintInfo(metadata.getId(), metadata.getIsv());
            } else {
                PrintMetadataWriter.insertPrintInfo(metadata.getEntityId(), metadata.getId(), metadata.getIsv());
            }
        }
    }

    public static void delete(String id) {
        PrintMetadataWriter.deletePrintInfo(id);
    }

    public static void addKSRefId(Map<String, Plugin> ksIds, List<Plugin> list) {
        for (int i = 0; i < list.size(); ++i) {
            Plugin plugin = list.get(i);
            if (1 != plugin.getType()) continue;
            ksIds.put(plugin.getFpk(), plugin);
        }
    }

    private static boolean isExistedInfo(String metaId) {
        String sql = String.format(EXISTED_SQL, "fid", TABLENAME, FIELD_PRINT_TP_LID);
        Object[] params = new SqlParameter[]{new SqlParameter(FIELD_PRINT_TP_LID, 12, (Object)metaId)};
        boolean isExistedInfo = (Boolean)DB.query((DBRoute)DBRoute.basedata, (String)sql, (Object[])params, (ResultSetHandler)new ResultSetHandler<Boolean>(){

            public Boolean handle(ResultSet rs) throws Exception {
                return rs.next();
            }
        });
        return isExistedInfo;
    }

    private static void insertPrintInfo(String entityId, String metaId, String isv) {
        String formNumber = MetadataDao.getNumberById(entityId);
        String sql = String.format(INSERT_SQL, TABLENAME);
        long id = DB.genLongId((String)TABLENAME);
        Object[] params = new SqlParameter[8];
        SimpleDateFormat dateformat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date createdate = new Date();
        Date modifydate = new Date();
        String creator = RequestContext.get().getUserId();
        if (StringUtil.isEmpty((String)isv) || "kingdee".equalsIgnoreCase(isv)) {
            try {
                createdate = dateformat.parse(FIX_TIME);
                modifydate = dateformat.parse(FIX_TIME);
            }
            catch (ParseException e) {
                throw new KDException(null, new Object[]{String.format(ResManager.loadKDString((String)"%s\u65e5\u671f\u8f6c\u6362\u9519\u8bef", (String)"PrintMetadataWriter_0", (String)"bos-metadata", (Object[])new Object[0]), e)});
            }
            creator = "1";
        }
        params[0] = new SqlParameter("fid", -5, (Object)id);
        params[1] = new SqlParameter(FIELD_PRINT_TP_LID, 12, (Object)metaId);
        params[2] = new SqlParameter("fbillformid", 12, (Object)formNumber);
        params[3] = new SqlParameter("fcreatetime", 91, (Object)createdate);
        params[4] = new SqlParameter("fmodifytime", 91, (Object)modifydate);
        params[5] = new SqlParameter("fmodifierid", -5, (Object)0);
        params[6] = new SqlParameter("fcreatorid", -5, (Object)creator);
        params[7] = new SqlParameter("fenable", 12, (Object)"1");
        try (TXHandle h = TX.requiresNew();){
            DB.execute((DBRoute)DBRoute.basedata, (String)sql, (Object[])params);
        }
        catch (Throwable e) {
            if (e instanceof KDException) {
                throw (KDException)e;
            }
            if (e instanceof OrmException) {
                throw (OrmException)e;
            }
            throw new KDException(e, BosErrorCode.sQL, new Object[]{String.format(ERROR_STR_HOLDER, e.getMessage())});
        }
    }

    private static void updatePrintInfo(String metaId, String isv) {
        Object[] params;
        boolean updateCreateTime = false;
        String sql = String.format(UPDATE_SQL, TABLENAME);
        SimpleDateFormat dateformat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date createdate = new Date();
        Date modifydate = new Date();
        String creator = RequestContext.get().getUserId();
        String modifier = RequestContext.get().getUserId();
        Long creatorId = Long.parseLong(creator);
        Long modifierId = Long.parseLong(modifier);
        if (StringUtil.isEmpty((String)isv) || "kingdee".equalsIgnoreCase(isv)) {
            try {
                createdate = dateformat.parse(FIX_TIME);
                modifydate = dateformat.parse(FIX_TIME);
                updateCreateTime = true;
            }
            catch (ParseException e) {
                throw new KDException(null, new Object[]{String.format(ResManager.loadKDString((String)"%s\u65e5\u671f\u8f6c\u6362\u9519\u8bef", (String)"PrintMetadataWriter_0", (String)"bos-metadata", (Object[])new Object[0]), e)});
            }
            creatorId = 1L;
            modifierId = 0L;
        }
        if (updateCreateTime) {
            params = new SqlParameter[]{new SqlParameter("fmodifytime", 91, (Object)modifydate), new SqlParameter("fmodifierid", -5, (Object)modifierId), new SqlParameter("fcreatetime", 91, (Object)createdate), new SqlParameter("fcreatorid", -5, (Object)creatorId), new SqlParameter(FIELD_PRINT_TP_LID, 12, (Object)metaId)};
        } else {
            params = new SqlParameter[4];
            sql = sql.replace("fcreatetime = ?,", "");
            params[0] = new SqlParameter("fmodifytime", 91, (Object)modifydate);
            params[1] = new SqlParameter("fmodifierid", -5, (Object)modifierId);
            params[2] = new SqlParameter("fcreatorid", -5, (Object)creatorId);
            params[3] = new SqlParameter(FIELD_PRINT_TP_LID, 12, (Object)metaId);
        }
        try (TXHandle h = TX.requiresNew();){
            DB.execute((DBRoute)DBRoute.basedata, (String)sql, (Object[])params);
        }
        catch (Throwable e) {
            if (e instanceof KDException) {
                throw (KDException)e;
            }
            if (e instanceof OrmException) {
                throw (OrmException)e;
            }
            throw new KDException(e, BosErrorCode.sQL, new Object[]{String.format(ERROR_STR_HOLDER, e.getMessage())});
        }
    }

    private static void deletePrintInfo(String id) {
        String sql = String.format(DELETE_SQL, TABLENAME);
        Object[] params = new SqlParameter[]{new SqlParameter(FIELD_PRINT_TP_LID, 12, (Object)id)};
        try (TXHandle h = TX.requiresNew();){
            DB.execute((DBRoute)DBRoute.basedata, (String)sql, (Object[])params);
        }
        catch (Throwable e) {
            if (e instanceof KDException) {
                throw (KDException)e;
            }
            if (e instanceof OrmException) {
                throw (OrmException)e;
            }
            throw new KDException(e, BosErrorCode.sQL, new Object[]{String.format(ERROR_STR_HOLDER, e.getMessage())});
        }
    }
}

