/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.metadata.dao.designer;

import com.google.common.collect.HashMultimap;
import java.sql.ResultSet;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import kd.bos.context.RequestContext;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.exception.KDException;
import kd.bos.instance.AppCloudMapping;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.thread.ThreadLifeCycleManager;

public class AppCloudMappingImplement
implements AppCloudMapping {
    private static Log log = LogFactory.getLog(AppCloudMappingImplement.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, HashMultimap<String, String>> getAppidsInClouds() {
        List accounts = null;
        try {
            accounts = AccountUtils.getAllAccountsOfCurrentEnv();
        }
        catch (KDException kdException) {
            return Collections.emptyMap();
        }
        ConcurrentHashMap<String, HashMultimap<String, String>> retVal = new ConcurrentHashMap<String, HashMultimap<String, String>>(2);
        ExecutorService es = Executors.newFixedThreadPool(16);
        CountDownLatch latch = new CountDownLatch(accounts.size());
        accounts.forEach(account -> es.submit(() -> {
            try {
                final HashMultimap mulmap = HashMultimap.create();
                ThreadLifeCycleManager.start();
                RequestContext context = RequestContext.create();
                context.setAccountId(account.getAccountId());
                context.setTenantId(account.getTenantId());
                try (TXHandle h = TX.requiresNew();){
                    String sql = "select a.fnumber cloudid, b.fnumber appid from T_META_BIZCLOUD a inner join T_META_BIZAPP b on a.fid=b.FBIZCLOUDID where b.FTYPE = '0' ";
                    DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])new Object[0], (ResultSetHandler)new ResultSetHandler<Map<String, Set<String>>>(){

                        public Map<String, Set<String>> handle(ResultSet rs) throws Exception {
                            while (rs.next()) {
                                String cloudid = rs.getString("cloudid").toUpperCase();
                                String appid = rs.getString("appid");
                                mulmap.put((Object)cloudid, (Object)appid);
                            }
                            return null;
                        }
                    });
                }
                retVal.put(account.getAccountId(), mulmap);
            }
            finally {
                latch.countDown();
            }
        }));
        try {
            boolean await = latch.await(60L, TimeUnit.SECONDS);
            log.info(String.valueOf(await));
        }
        catch (InterruptedException e) {
            log.error((Throwable)e);
        }
        finally {
            es.shutdown();
        }
        return retVal;
    }
}

