/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.metadata.dao.designer;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import kd.bos.algo.DataSet;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.EntityItemTypes;
import kd.bos.entity.EntityType;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.metadata.SimpleFormDesignMeta;
import kd.bos.orm.ORM;
import kd.bos.orm.query.Distinctable;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.query.WithEntityEntryDistinctable;

public class DesignerMetaDao {
    private static String BOS_FORM = "bos_formmeta";

    public SimpleFormDesignMeta[] getFormDesignMeta(QFilter[] filters) {
        IDataEntityType entityType;
        ArrayList idList = new ArrayList();
        try (DataSet ds = ORM.create().queryDataSet("DesignerMetaDao.getFormDesignMeta", BOS_FORM, "id", filters, null, -1, (Distinctable)WithEntityEntryDistinctable.get());){
            ds.forEach(row -> idList.add(row.get(0)));
        }
        Object[] pks = idList.toArray();
        try {
            entityType = (IDataEntityType)OrmUtils.getDataEntityType(SimpleFormDesignMeta.class).clone();
        }
        catch (CloneNotSupportedException e) {
            throw new KDException((Throwable)e, BosErrorCode.bOS, new Object[]{e.getMessage()});
        }
        Object[] objs = BusinessDataReader.load((Object[])pks, (IDataEntityType)DesignerMetaDao.getDataEntityType(entityType));
        SimpleFormDesignMeta[] metas = new SimpleFormDesignMeta[objs.length];
        for (int i = 0; i < metas.length; ++i) {
            metas[i] = (SimpleFormDesignMeta)objs[i];
        }
        return metas;
    }

    public DynamicObject[] getFormDesignMeta(String selectProperties, QFilter[] filters) {
        String[] properties = selectProperties.split(",");
        HashSet<String> select = new HashSet<String>(properties.length);
        for (String prop : properties) {
            select.add(prop.trim());
        }
        EntityType entityType = this.getEntityType(BOS_FORM).getSubEntityType(select);
        ArrayList idList = new ArrayList();
        try (DataSet ds = ORM.create().queryDataSet("DesignerMetaDao.getFormDesignMeta", BOS_FORM, "id", filters, null, -1, (Distinctable)WithEntityEntryDistinctable.get());){
            ds.forEach(row -> idList.add(row.get(0)));
        }
        Object[] pks = idList.toArray();
        return (DynamicObject[])BusinessDataReader.load((Object[])pks, (IDataEntityType)DesignerMetaDao.getDataEntityType((IDataEntityType)entityType));
    }

    private EntityType getEntityType(String formName) {
        String str = this.queryEntityMeta(formName);
        if (StringUtils.isBlank((CharSequence)str)) {
            throw new KDException(BosErrorCode.entityMetaDataNotExist, new Object[]{""});
        }
        EntityType et = (EntityType)EntityItemTypes.fromJsonString((String)str);
        return et;
    }

    private String queryEntityMeta(String number) {
        String sql = "select FDATA from T_META_ENTITY where FNUMBER = ? and FTYPE = 11";
        SqlParameter[] params = new SqlParameter[]{new SqlParameter("FNUMBER", 12, (Object)number)};
        String sRet = this.queryDB(sql, params);
        if (StringUtils.isBlank((CharSequence)sRet)) {
            sRet = "";
        }
        return sRet;
    }

    private String queryDB(String sql, SqlParameter[] params) {
        ResultSetHandler callBackHanlder = rs -> {
            String sFdata = null;
            try {
                if (rs.next()) {
                    sFdata = rs.getString(1);
                }
            }
            catch (SQLException e) {
                throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{String.format("Error:%s", e.getMessage())});
            }
            return sFdata;
        };
        String sRet = (String)DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])params, (ResultSetHandler)callBackHanlder);
        return sRet;
    }

    private static IDataEntityType getDataEntityType(IDataEntityType dataEntityType) {
        return dataEntityType;
    }

    private static String getGrayTableName(String tabName) {
        return tabName;
    }
}

