/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.metadata.deploy;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.CollectionPropertyAttribute;
import kd.bos.dataentity.entity.DefaultValueAttribute;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.serialization.DcBinder;
import kd.bos.dataentity.serialization.DcxmlSerializer;
import kd.bos.metadata.deploy.DeployCardBinder;
import kd.bos.metadata.deploy.DeployFile;

public class DeployCard {
    private static final DeployCardBinder DEPLOY_CARD_BINDER = new DeployCardBinder();
    private String BOSVersion;
    private List<DynamicObject> cards = new ArrayList<DynamicObject>();
    private boolean multilanguage = true;

    @SimplePropertyAttribute
    public String getBOSVersion() {
        if (this.BOSVersion == null) {
            this.BOSVersion = "1.0";
        }
        return this.BOSVersion;
    }

    public void setBOSVersion(String bOSVersion) {
        this.BOSVersion = bOSVersion;
    }

    @CollectionPropertyAttribute(collectionItemPropertyType=Object.class)
    public List<DynamicObject> getCards() {
        return this.cards;
    }

    public static DcBinder getDCBinder() {
        return DEPLOY_CARD_BINDER;
    }

    public DeployFile toDeployFile(String fileName) {
        DcxmlSerializer serializer = new DcxmlSerializer(DeployCard.getDCBinder());
        serializer.setIndent(true);
        serializer.setNewlines(true);
        String fileContent = serializer.serializeToString((Object)this, null);
        return new DeployFile(fileName, fileContent);
    }

    @SimplePropertyAttribute(name="Multilanguage")
    @DefaultValueAttribute(value="true")
    public boolean isMultilanguage() {
        return this.multilanguage;
    }

    public void setMultilanguage(boolean multilanguage) {
        this.multilanguage = multilanguage;
    }
}

