/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.metadata.deploy.gray;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityType;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.AbstractDesignMeta;
import kd.bos.metadata.AbstractMetadata;
import kd.bos.metadata.BuildFormDesignMeta;
import kd.bos.metadata.dao.AbstractMetadataSerializer;
import kd.bos.metadata.dao.AbstractMetadataWriter;
import kd.bos.metadata.dao.MetaRebuilder;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.dao.MetadataReader;
import kd.bos.metadata.dao.MetadataSerializer;
import kd.bos.metadata.deploy.gray.GrayMetaTableCreator;

public class GrayDeployMetadataWriter
extends AbstractMetadataWriter {
    private static final Log log = LogFactory.getLog(GrayDeployMetadataWriter.class);
    private String appGroup;

    public GrayDeployMetadataWriter(String appGroup) {
        this.appGroup = appGroup;
    }

    @Override
    protected AbstractMetadataSerializer initMetadataSerializer(String modelTypeId) {
        return new MetadataSerializer(modelTypeId);
    }

    @Override
    protected AbstractMetadata readBaseMetadata(AbstractMetadata metadata) {
        MetadataReader reader = new MetadataReader();
        reader.setAppGroup(this.appGroup);
        boolean isOriForm = !"2".equals(metadata.getDevType());
        reader.setFillExtends(isOriForm);
        AbstractMetadata baseMetadata = reader.readMeta(metadata.getParentId(), metadata.getDesingerMetaType(), false, true);
        return baseMetadata;
    }

    @Override
    protected IDataEntityType getDataEntityType(AbstractDesignMeta dmeta) {
        DataEntityType det;
        try {
            det = (DataEntityType)OrmUtils.getDataEntityType(dmeta.getClass()).clone();
        }
        catch (CloneNotSupportedException e) {
            throw new KDException((Throwable)e, BosErrorCode.bOS, new Object[]{e.getMessage(), "getDataEntityType"});
        }
        det.setAlias(this.getGrayTableName(det.getAlias()));
        return det;
    }

    public void releaseGray() {
        GrayMetaTableCreator creator = new GrayMetaTableCreator(this.appGroup + "_B");
        boolean isGrayTableBackUp = Boolean.parseBoolean(System.getProperty("gray.tablebackup"));
        if (isGrayTableBackUp) {
            log.info("GrayDeployMetadataWriter releaseGray createTable begin...");
            creator.createTable();
            log.info("GrayDeployMetadataWriter releaseGray createTable end, backAndConverData begin ...");
        }
        if (!this.isGrayGroup()) {
            throw new KDException(BosErrorCode.bOS, new Object[]{"appgroup is null"});
        }
        List<String> tableList = creator.getGrayMetaTableNames();
        creator = new GrayMetaTableCreator(this.appGroup);
        try (TXHandle txh = TX.requiresNew();){
            for (String tableName : tableList) {
                String bakTableName = "";
                if (isGrayTableBackUp) {
                    bakTableName = this.getGrayTableName(tableName) + "_B";
                }
                String[] columns = creator.getSyncGrayMetaTableRefColumn(tableName);
                creator.backAndConverData(tableName, this.getGrayTableName(tableName), bakTableName, columns);
            }
        }
        log.info("GrayDeployMetadataWriter releaseGray backAndConverData end");
    }

    public void dropGrayTable() {
        if (!this.isGrayGroup()) {
            throw new KDException(BosErrorCode.bOS, new Object[]{"appgroup is null"});
        }
        GrayMetaTableCreator creator = new GrayMetaTableCreator(this.appGroup);
        List<String> tableList = creator.getGrayMetaTableNames();
        try {
            for (String tableName : tableList) {
                String appGroupTableName = String.format("%s_%s", tableName, this.appGroup);
                if (!DB.exitsTable((DBRoute)DBRoute.meta, (String)appGroupTableName)) continue;
                DB.execute((DBRoute)DBRoute.meta, (String)String.format("drop table %s;", appGroupTableName));
            }
        }
        catch (Exception e) {
            throw new KDException((Throwable)e, BosErrorCode.bOS, new Object[]{e.getMessage(), "releaseGray"});
        }
    }

    public void dropGrayBackTable() {
        if (!this.isGrayGroup()) {
            throw new KDException(BosErrorCode.bOS, new Object[]{"appgroup is null"});
        }
        GrayMetaTableCreator creator = new GrayMetaTableCreator(this.appGroup);
        List<String> tableList = creator.getGrayMetaTableNames();
        try {
            for (String tableName : tableList) {
                String appGroupTableName = String.format("%s_%s", tableName, this.appGroup + "_B");
                if (!DB.exitsTable((DBRoute)DBRoute.meta, (String)appGroupTableName)) continue;
                DB.execute((DBRoute)DBRoute.meta, (String)String.format("drop table %s;", appGroupTableName));
            }
        }
        catch (Exception e) {
            throw new KDException((Throwable)e, BosErrorCode.bOS, new Object[]{e.getMessage(), "releaseGray"});
        }
    }

    public void clearMetaCache() {
        List ids = (List)DB.query((DBRoute)DBRoute.meta, (String)String.format("select fid from %s", this.getGrayTableName("T_META_FORMDESIGN")), (ResultSetHandler)new ResultSetHandler<List<String>>(){

            public List<String> handle(ResultSet rs) throws Exception {
                ArrayList<String> ids = new ArrayList<String>(rs.getFetchSize());
                while (rs.next()) {
                    ids.add(rs.getString(1));
                }
                return ids;
            }
        });
        MetaRebuilder mr = new MetaRebuilder(this.appGroup);
        List<BuildFormDesignMeta> formDesignMetas = mr.getRebuildFormDesignMeta(ids);
        MetadataDao.clearCache(formDesignMetas);
    }

    private String getGrayTableName(String tabName) {
        if (!this.isGrayGroup()) {
            return tabName;
        }
        return String.format("%s_%s", tabName, this.appGroup);
    }

    private boolean isGrayGroup() {
        return StringUtils.isNotBlank((CharSequence)this.appGroup) && !"defaultGroup".equals(this.appGroup);
    }
}

