/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.metadata.devportal;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.ILocaleValue;
import kd.bos.dataentity.metadata.IComplexProperty;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.serialization.DcBinder;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.devportal.AppElement;
import kd.bos.entity.devportal.AppFunctionPacketElement;
import kd.bos.entity.devportal.AppMenuElement;
import kd.bos.metadata.AbstractMetadata;
import kd.bos.metadata.devportal.AppMetadata;
import kd.bos.metadata.devportal.AppReader;
import kd.bos.metadata.devportal.MetaLocaleItemDetail;
import kd.bos.metadata.devportal.MetaLocaleSrcItem;
import kd.bos.metadata.lang.LangItemBuilder;

public class AppLangItemBuilder
extends LangItemBuilder {
    private static final String APPMETADATA_APPELEMENT = "AppMetadata.AppElement.";
    private static final String APPMETADATA_APPMENUS = "AppMetadata.AppMenus.";
    private static final String APPMETADATA_APPDUNCTIONPACKETS = "AppMetadata.AppFunctionPackets.";
    private String appId;
    private DcBinder binder;
    private String srcNum;
    private LinkedHashMap<String, AbstractMetadata> appMetas;
    private Map<String, MetaLocaleItemDetail> srcNums = new HashMap<String, MetaLocaleItemDetail>();

    public Map<String, MetaLocaleItemDetail> getSrcNums() {
        return this.srcNums;
    }

    public void setSrcNums(Map<String, MetaLocaleItemDetail> srcNums) {
        this.srcNums = srcNums;
    }

    public String getAppId() {
        return this.appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public String getSrcNum() {
        return this.srcNum;
    }

    public void setSrcNum(String srcNum) {
        this.srcNum = srcNum;
    }

    public AppLangItemBuilder(DcBinder binder) {
        super(binder);
        this.binder = binder;
        this.appMetas = new LinkedHashMap();
    }

    public void build(String appId) {
        this.setAppId(appId);
        AppMetadata meta = AppReader.loadMeta(appId, false);
        String inheritPath = meta.getInheritPath();
        String[] parentIds = null;
        if (StringUtils.isNotBlank((CharSequence)inheritPath)) {
            for (String oid : parentIds = inheritPath.split(",")) {
                if (StringUtils.isBlank((CharSequence)oid)) continue;
                this.appMetas.put(oid, AppReader.loadMeta(oid, false));
            }
        }
        this.appMetas.put(appId, meta);
    }

    public void buildAppItemsEx() {
        if (this.appMetas == null || this.appMetas.isEmpty()) {
            return;
        }
        int maxTimes = this.appMetas.size();
        ArrayList<AbstractMetadata> formList = new ArrayList<AbstractMetadata>(this.appMetas.values());
        boolean isFormMeta = formList.get(0) instanceof AppMetadata;
        for (int i = 0; i < maxTimes; ++i) {
            this.srcNum = ((AppMetadata)formList.get(i)).getNumber();
            IDataEntityType currentEntityType = this.binder.getDataEntityType(formList.get(i));
            this.builderResouces(formList.get(i), ((AppMetadata)formList.get(i)).getClass().getSimpleName(), currentEntityType);
        }
    }

    public Map<String, Map<String, JSONObject>> splitReuslts() {
        HashMap<String, Map<String, JSONObject>> result = new HashMap<String, Map<String, JSONObject>>();
        LinkedHashMap<String, Object> appLocaleItems = new LinkedHashMap<String, Object>(10);
        LinkedHashMap<String, Object> appMenuLocaleItems = new LinkedHashMap<String, Object>(10);
        LinkedHashMap<String, Object> appFuncLocaleItems = new LinkedHashMap<String, Object>(10);
        LinkedHashMap appLocaleSrcItems = new LinkedHashMap(10);
        LinkedHashMap appMenuLocaleSrcItems = new LinkedHashMap(10);
        LinkedHashMap appFuncLocaleSrcItems = new LinkedHashMap(10);
        for (Map.Entry<String, MetaLocaleItemDetail> entry : this.srcNums.entrySet()) {
            JSONObject srcvalue;
            JSONObject value;
            String key = entry.getValue().getId();
            if (key.startsWith(APPMETADATA_APPELEMENT)) {
                value = new JSONObject(0);
                srcvalue = new JSONObject(0);
                for (Map.Entry<String, MetaLocaleSrcItem> srcItem : entry.getValue().getPropertyDetail().entrySet()) {
                    value.put(srcItem.getKey(), (Object)srcItem.getValue().getLocaleValue());
                    value.put(srcItem.getKey() + "_srcnum", (Object)srcItem.getValue().getSrcNum());
                }
                appLocaleItems.put(this.appId + "." + key.substring(key.indexOf(APPMETADATA_APPELEMENT) + APPMETADATA_APPELEMENT.length()), value);
                continue;
            }
            if (key.startsWith(APPMETADATA_APPMENUS)) {
                value = new JSONObject(0);
                srcvalue = new JSONObject(0);
                for (Map.Entry<String, MetaLocaleSrcItem> srcItem : entry.getValue().getPropertyDetail().entrySet()) {
                    value.put(srcItem.getKey(), (Object)srcItem.getValue().getLocaleValue());
                    value.put(srcItem.getKey() + "_srcnum", (Object)srcItem.getValue().getSrcNum());
                }
                appMenuLocaleItems.put(key.substring(key.indexOf(APPMETADATA_APPMENUS) + APPMETADATA_APPMENUS.length()), value);
                continue;
            }
            if (!key.startsWith(APPMETADATA_APPDUNCTIONPACKETS)) continue;
            value = new JSONObject(0);
            srcvalue = new JSONObject(0);
            for (Map.Entry<String, MetaLocaleSrcItem> srcItem : entry.getValue().getPropertyDetail().entrySet()) {
                value.put(srcItem.getKey(), (Object)srcItem.getValue().getLocaleValue());
                value.put(srcItem.getKey() + "_srcnum", (Object)srcItem.getValue().getSrcNum());
            }
            appFuncLocaleItems.put(key.substring(key.indexOf(APPMETADATA_APPDUNCTIONPACKETS) + APPMETADATA_APPDUNCTIONPACKETS.length()), value);
        }
        for (Map.Entry<String, MetaLocaleItemDetail> entry : appLocaleSrcItems.entrySet()) {
            appLocaleItems.put(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, MetaLocaleItemDetail> entry : appMenuLocaleSrcItems.entrySet()) {
            appMenuLocaleItems.put(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, MetaLocaleItemDetail> entry : appFuncLocaleSrcItems.entrySet()) {
            appFuncLocaleItems.put(entry.getKey(), entry.getValue());
        }
        result.put("app", appLocaleItems);
        result.put("menus", appMenuLocaleItems);
        result.put("funcs", appFuncLocaleItems);
        return result;
    }

    @Override
    public void buildRes(Object currentEntity, String parentId, IDataEntityType currentEntityType) {
        if (currentEntityType == null) {
            return;
        }
        for (IDataEntityProperty p : currentEntityType.getProperties()) {
            String Id = parentId + "." + p.getName();
            Object val = p.getValue(currentEntity);
            if (p instanceof ISimpleProperty) {
                if (!(val instanceof ILocaleValue) || ((ILocaleValue)val).size() <= 0) continue;
                MetaLocaleItemDetail item = new MetaLocaleItemDetail(this);
                item.setId(Id);
                item.setName(p.getName());
                if (currentEntity instanceof AppElement) {
                    item.setFormId(((AppElement)currentEntity).getMainFormID());
                    item.setSrcNum(this.srcNum);
                }
                if (currentEntity instanceof AppMenuElement) {
                    item.setFormId(((AppMenuElement)currentEntity).getId());
                    item.setSrcNum(this.srcNum);
                }
                if (currentEntity instanceof AppFunctionPacketElement) {
                    item.setFormId(((AppFunctionPacketElement)currentEntity).getId());
                    item.setSrcNum(this.srcNum);
                }
                item.setDataEntity(currentEntity);
                item.setProperty((ISimpleProperty)p);
                item.setPropertyDetail(item.buildSrcItem((ISimpleProperty)p, currentEntity));
                item.markSrcNum();
                this.getLocaleItems().add(item);
                continue;
            }
            if (p instanceof IComplexProperty) {
                this.builderResouces(val, Id, null);
                continue;
            }
            List listValue = (List)val;
            if (listValue == null) continue;
            String objId = null;
            for (Object objVal : listValue) {
                if ("AppFunctionPackets".equals(p.getName())) {
                    AppFunctionPacketElement func = (AppFunctionPacketElement)objVal;
                    objId = func.getId();
                } else if ("AppMenus".equals(p.getName())) {
                    AppMenuElement menu = (AppMenuElement)objVal;
                    objId = menu.getId();
                }
                if (!StringUtils.isNotBlank((CharSequence)objId)) continue;
                this.builderResouces(objVal, parentId + "." + p.getName() + "." + objId, null);
            }
        }
    }

    private void builderResouces(Object currentEntity, String parentId, Object baseEntity) {
        if (currentEntity == null) {
            return;
        }
        IDataEntityType currentEntityType = this.binder.getDataEntityType(currentEntity);
        if (this.shouldCompare(currentEntityType, baseEntity)) {
            this.buildRes(currentEntity, parentId, baseEntity, currentEntityType);
        } else {
            this.buildRes(currentEntity, parentId, currentEntityType);
        }
    }

    protected boolean shouldCompare(IDataEntityType currentEntityType, Object baseEntity) {
        IDataEntityType baseEntityType;
        return baseEntity != null && currentEntityType == (baseEntityType = this.binder.getDataEntityType(baseEntity));
    }
}

