/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.metadata.devportal;

import java.sql.ResultSet;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.cache.CacheConfigInfo;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.cache.LocalMemoryCache;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.AppInfo;
import kd.bos.entity.cache.CacheKeyUtil;
import kd.bos.entity.devportal.AppMenuElement;
import kd.bos.entity.gray.AppGroupUtils;
import kd.bos.metadata.AbstractMetadata;
import kd.bos.metadata.dao.MetadataReader;
import kd.bos.metadata.devportal.AppMetadata;
import kd.bos.metadata.devportal.DesignAppMeta;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class AppReader {
    private static final String APP_ID_BY_NUMBER = "AppIdByNumber";
    private static final String APP_METADATA = "AppMetadata";
    private static final String GET_APPID_BYNUMBER_CACHE = "GetAppIdByNumberCache";
    private static final String GET_NUMBER_BYID_CACHE = "GetAppNumberByIdCache";
    private static final String MASTER_APPINFO_BY_ID = "MasterAppInfoByIdCache";
    private static final String APP_NUMBER_BY_ID = "AppNumberById";
    private static final String T_META_BIZAPP = "T_META_BIZAPP";

    private static LocalMemoryCache getLocalCache() {
        CacheConfigInfo info = new CacheConfigInfo();
        info.setTimeout(43200);
        info.setMaxMemSize(10000);
        return CacheFactory.getCommonCacheFactory().$getOrCreateLocalMemoryCache(CacheKeyUtil.getAcctId(), "AppReader", info);
    }

    private static DistributeSessionlessCache getCache() {
        return CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache(APP_METADATA, new DistributeCacheHAPolicy());
    }

    public static AppMetadata loadMeta(String id, boolean runtime) {
        return AppReader.loadMeta(id, runtime, false);
    }

    public static AppMetadata loadMeta(String id, boolean runtime, boolean isBaseMeta) {
        String realId;
        if (StringUtils.isNotBlank((CharSequence)id) && id.length() <= 10) {
            String realId2 = AppReader.getAppIdByNumber(id);
            if (StringUtils.isNotBlank((CharSequence)realId2)) {
                id = realId2;
            }
            return AppReader.loadMetaById(id, runtime, isBaseMeta);
        }
        AppMetadata appMetadata = AppReader.loadMetaById(id, runtime, isBaseMeta);
        if (appMetadata == null && StringUtils.isNotBlank((CharSequence)(realId = AppReader.getAppIdByNumber(id)))) {
            id = realId;
            appMetadata = AppReader.loadMetaById(id, runtime, isBaseMeta);
        }
        return appMetadata;
    }

    private static AppMetadata loadMetaById(String id, boolean runtime, boolean isBaseMeta) {
        IDataEntityType designerMetaType = OrmUtils.getDataEntityType(DesignAppMeta.class);
        MetadataReader reader = new MetadataReader();
        reader.setAppGroup(AppGroupUtils.getCurrentAppGroup());
        AbstractMetadata meta = reader.readMeta(id, designerMetaType, runtime, isBaseMeta);
        if (meta == null && AppGroupUtils.isGrayGroup()) {
            reader.setAppGroup("defaultGroup");
            meta = reader.readMeta(id, designerMetaType, runtime, isBaseMeta);
        }
        if (meta == null) {
            return null;
        }
        AppMetadata appMeta = (AppMetadata)meta;
        List<AppMenuElement> menuElements = appMeta.getAppMenus();
        Collections.sort(menuElements, new Comparator<AppMenuElement>(){

            @Override
            public int compare(AppMenuElement o1, AppMenuElement o2) {
                return o1.getSeq() - o2.getSeq();
            }
        });
        return appMeta;
    }

    public static String getAppIdByNumber(String number) {
        String key = AppReader.getCacheKey(APP_ID_BY_NUMBER, number);
        LocalMemoryCache localCache = AppReader.getLocalCache();
        String id = (String)localCache.get(key);
        if (StringUtils.isBlank((CharSequence)id) && StringUtils.isNotBlank((CharSequence)(id = AppReader.getCacheAppIdByNumber(number)))) {
            localCache.put(key, (Object)id);
        }
        return id;
    }

    private static String getCacheAppIdByNumber(String number) {
        if (StringUtils.isBlank((CharSequence)number)) {
            return null;
        }
        DistributeSessionlessCache cache = AppReader.getCache();
        String accountId = CacheKeyUtil.getAcctId();
        String key = AppReader.getCacheKey("AppMetadata-" + accountId, GET_APPID_BYNUMBER_CACHE);
        String id = (String)cache.get(key, number);
        if (StringUtils.isBlank((CharSequence)id)) {
            ResultSetHandler<String> action;
            Object[] params;
            String sql = String.format("select FID from %s where FNUMBER = ? ", AppGroupUtils.getCurrentAppGroupTableName((String)T_META_BIZAPP));
            id = (String)DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])(params = new SqlParameter[]{new SqlParameter(":FNUMBER", 12, (Object)number)}), (ResultSetHandler)(action = new ResultSetHandler<String>(){

                public String handle(ResultSet rs) throws Exception {
                    if (rs.next()) {
                        return rs.getString("FID");
                    }
                    return null;
                }
            }));
            if (StringUtils.isBlank((CharSequence)id) && AppGroupUtils.isGrayGroup()) {
                sql = String.format("select FID from %s where FNUMBER = ? ", T_META_BIZAPP);
                id = (String)DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])params, (ResultSetHandler)action);
            }
            if (StringUtils.isNotBlank((CharSequence)id)) {
                String key_numberbyid = AppReader.getCacheKey("AppMetadata-" + accountId, GET_NUMBER_BYID_CACHE);
                cache.put(key, number, (Object)id);
                cache.put(key_numberbyid, id, (Object)number);
            }
        }
        return id;
    }

    public static String getAppNumberById(String id) {
        String key = AppReader.getCacheKey(APP_NUMBER_BY_ID, id);
        LocalMemoryCache localCache = AppReader.getLocalCache();
        String number = (String)localCache.get(key);
        if (StringUtils.isBlank((CharSequence)number) && StringUtils.isNotBlank((CharSequence)(number = AppReader.getCacheAppNumberById(id)))) {
            localCache.put(key, (Object)number);
        }
        return number;
    }

    private static String getCacheAppNumberById(String id) {
        DistributeSessionlessCache cache = AppReader.getCache();
        String accountId = CacheKeyUtil.getAcctId();
        String key = AppReader.getCacheKey("AppMetadata-" + accountId, GET_NUMBER_BYID_CACHE);
        String number = (String)cache.get(key, id);
        if (StringUtils.isBlank((CharSequence)number)) {
            String appGroup = AppGroupUtils.getCurrentAppGroup();
            number = AppReader.queryAppNumberById(appGroup, id);
            if (StringUtils.isBlank((CharSequence)number)) {
                if (AppGroupUtils.isGrayGroup()) {
                    number = AppReader.queryAppNumberById("defaultGroup", id);
                }
            } else {
                cache.put(key, id, (Object)number);
                String key_idbynumber = AppReader.getCacheKey("AppMetadata-" + accountId, GET_APPID_BYNUMBER_CACHE);
                cache.put(key_idbynumber, number, (Object)id);
            }
        }
        return number;
    }

    private static String queryAppNumberById(String appGroup, String id) {
        String sql = String.format("select FNUMBER from %s where FID = ? ", AppGroupUtils.getAppGroupTableName((String)appGroup, (String)T_META_BIZAPP));
        Object[] params = new SqlParameter[]{new SqlParameter(":FID", 12, (Object)id)};
        ResultSetHandler<String> action = new ResultSetHandler<String>(){

            public String handle(ResultSet rs) throws Exception {
                if (rs.next()) {
                    return rs.getString("FNUMBER");
                }
                return null;
            }
        };
        String number = (String)DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])params, (ResultSetHandler)action);
        return number;
    }

    public static void updateAppNumberAndIdCache(String id, String number) {
        DistributeSessionlessCache cache = AppReader.getCache();
        String accountId = CacheKeyUtil.getAcctId();
        String key_numberbyid = AppReader.getCacheKey("AppMetadata-" + accountId, GET_NUMBER_BYID_CACHE);
        String key_idbynumber = AppReader.getCacheKey("AppMetadata-" + accountId, GET_APPID_BYNUMBER_CACHE);
        cache.put(key_numberbyid, id, (Object)number);
        cache.put(key_idbynumber, number, (Object)id);
        LocalMemoryCache localCache = AppReader.getLocalCache();
        String key1 = AppReader.getCacheKey(APP_ID_BY_NUMBER, number);
        String key2 = AppReader.getCacheKey(APP_NUMBER_BY_ID, id);
        localCache.put(key1, (Object)id);
        localCache.put(key2, (Object)number);
    }

    public static void removeAppNumberAndIdCache(String id, String number) {
        DistributeSessionlessCache cache = AppReader.getCache();
        String accountId = CacheKeyUtil.getAcctId();
        String key_numberbyid = AppReader.getCacheKey("AppMetadata-" + accountId, GET_NUMBER_BYID_CACHE);
        String key_idbynumber = AppReader.getCacheKey("AppMetadata-" + accountId, GET_APPID_BYNUMBER_CACHE);
        String masterAppInfoById = AppReader.getCacheKey("AppMetadata-" + accountId, MASTER_APPINFO_BY_ID);
        if (StringUtils.isBlank((CharSequence)number) && StringUtils.isNotBlank((CharSequence)id)) {
            number = AppReader.getAppNumberById(id);
        } else if (StringUtils.isNotBlank((CharSequence)number) && StringUtils.isBlank((CharSequence)id)) {
            id = AppReader.getAppIdByNumber(number);
        }
        LocalMemoryCache localCache = AppReader.getLocalCache();
        String key1 = AppReader.getCacheKey(APP_ID_BY_NUMBER, number);
        String key2 = AppReader.getCacheKey(APP_NUMBER_BY_ID, id);
        if (StringUtils.isNotBlank((CharSequence)id)) {
            cache.remove(key_numberbyid, id);
            cache.remove(masterAppInfoById, id);
            localCache.remove(new String[]{key2});
        }
        if (StringUtils.isNotBlank((CharSequence)number)) {
            cache.remove(key_idbynumber, number);
            localCache.remove(new String[]{key1});
        }
    }

    public static void cleanAllAppNumberAndIdCache() {
        DistributeSessionlessCache cache = AppReader.getCache();
        String accountId = CacheKeyUtil.getAcctId();
        String key_numberbyid = AppReader.getCacheKey("AppMetadata-" + accountId, GET_NUMBER_BYID_CACHE);
        String key_idbynumber = AppReader.getCacheKey("AppMetadata-" + accountId, GET_APPID_BYNUMBER_CACHE);
        String masterAppInfoById = AppReader.getCacheKey("AppMetadata-" + accountId, MASTER_APPINFO_BY_ID);
        cache.remove(key_numberbyid);
        cache.remove(key_idbynumber);
        cache.remove(masterAppInfoById);
        LocalMemoryCache localCache = AppReader.getLocalCache();
        localCache.clear();
    }

    public static Map<String, String> getAllOriAppNumbers() {
        String sql = String.format("SELECT Fnumber,FID from %s WHERE FType != '2' ", AppGroupUtils.getCurrentAppGroupTableName((String)T_META_BIZAPP));
        ResultSetHandler<Map<String, String>> action = new ResultSetHandler<Map<String, String>>(){

            public Map<String, String> handle(ResultSet rs) throws Exception {
                HashMap<String, String> list = new HashMap<String, String>(16);
                while (rs.next()) {
                    list.put(rs.getString("FID"), rs.getString("Fnumber"));
                }
                return list;
            }
        };
        return (Map)DB.query((DBRoute)DBRoute.meta, (String)sql, null, (ResultSetHandler)action);
    }

    public static AppInfo getMasterAppInfo(String appId) {
        if (appId == null) {
            return null;
        }
        String val = (String)AppReader.getCache().get(AppReader.getMasterInfoCacheKey(), appId);
        if (StringUtils.isNotBlank((CharSequence)val)) {
            AppInfo info = (AppInfo)SerializationUtils.fromJsonString((String)val, AppInfo.class);
            if (StringUtils.isBlank((CharSequence)info.getNumber())) {
                info = null;
            }
            return info;
        }
        String sql = "select a.FType,b.FNumber as FMasterNumber,a.FNumber,a.FBizCloudId, a.FISV from t_meta_bizapp a left join t_meta_bizapp b on a.FMasterId = b.FId where a.FId = ? ";
        Object[] params = new SqlParameter[]{new SqlParameter(":FId", 12, (Object)appId)};
        ResultSetHandler<AppInfo> action = new ResultSetHandler<AppInfo>(){

            public AppInfo handle(ResultSet rs) throws Exception {
                if (rs.next()) {
                    AppInfo appInfo = new AppInfo();
                    String type = rs.getString(1);
                    appInfo.setType(type);
                    if ("2".equals(type)) {
                        appInfo.setNumber(rs.getString(2));
                    } else {
                        appInfo.setNumber(rs.getString(3));
                    }
                    appInfo.setCloudId(rs.getString(4));
                    appInfo.setIsv(rs.getString(5));
                    return appInfo;
                }
                return null;
            }
        };
        AppInfo info = (AppInfo)DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])params, (ResultSetHandler)action);
        if (info != null) {
            AppReader.getCache().put(AppReader.getMasterInfoCacheKey(), appId, (Object)SerializationUtils.toJsonString((Object)info));
        }
        return info;
    }

    private static String getMasterInfoCacheKey() {
        String accountId = CacheKeyUtil.getAcctId();
        return AppReader.getCacheKey("AppMetadata-" + accountId, MASTER_APPINFO_BY_ID);
    }

    private static String getCacheKey(String key, String number) {
        String appGroup = AppGroupUtils.getCurrentAppGroup();
        return String.format("%s_%s_%s", key, appGroup, number);
    }
}

