/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.metadata.devportal;

import java.util.List;
import java.util.Map;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.devportal.AppMenuElement;
import kd.bos.exception.KDBizException;
import kd.bos.metadata.dao.IMetadataDaoPlugIn;
import kd.bos.metadata.dao.MetadataServicePlugInProxy;
import kd.bos.metadata.dao.MetadataWriter;
import kd.bos.metadata.devportal.AppMetadata;
import kd.bos.metadata.exception.ErrorInfo;
import kd.bos.orm.datasync.DtsExcludeSyncContext;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class AppWriter {
    private IMetadataDaoPlugIn plugIn;
    private String appGroup = "defaultGroup";

    public String getAppGroup() {
        return this.appGroup;
    }

    public void setAppGroup(String appGroup) {
        this.appGroup = appGroup;
        if (this.plugIn != null && StringUtils.isNotBlank((CharSequence)appGroup)) {
            this.plugIn.setAppGroup(appGroup);
        }
    }

    public AppWriter() {
        new AppWriter("AppModel");
    }

    public AppWriter(String modelTypeId) {
        this.plugIn = MetadataServicePlugInProxy.create(modelTypeId);
    }

    public Map<String, Object> save(AppMetadata appMetadata) {
        MetadataWriter writer = new MetadataWriter("AppModel");
        writer.setAppGroup(this.appGroup);
        List<AppMenuElement> menuElements = appMetadata.getAppMenus();
        menuElements.sort((o1, o2) -> {
            if (o1.getSeq() - o2.getSeq() != 0) {
                return o1.getSeq() - o2.getSeq();
            }
            return o1.getId().compareTo(o2.getId());
        });
        return writer.save(appMetadata);
    }

    public Map<String, Object> save(AppMetadata ... appMetadatas) {
        MetadataWriter writer = new MetadataWriter("AppModel");
        writer.setAppGroup(this.appGroup);
        Map<String, Object> result = writer.save(appMetadatas);
        return result;
    }

    public void rebuildRuntimeAppMeta(AppMetadata ... metadatas) {
        try (DtsExcludeSyncContext context = DtsExcludeSyncContext.create();){
            this.plugIn.saveRuntimeMeta(metadatas);
            List<ErrorInfo> buildErrors = this.plugIn.getBuildErrors(metadatas);
            for (ErrorInfo errorInfo : buildErrors) {
                if (errorInfo.getLevel() != 2) continue;
                throw new KDBizException(errorInfo.getError());
            }
        }
    }
}

