/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.metadata.devportal;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.exception.OrmException;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.util.SAXReaderUtil;
import kd.sdk.annotation.SdkPublic;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

@SdkPublic
public class DifferenceOperationParseUtil {
    private static final String DESERIALIZE_DOCUMENT_EXCEPTION = "Deserialize.DocumentException";
    private SAXReader saxReader;

    private SAXReader getSaxReader() {
        if (this.saxReader == null) {
            this.saxReader = SAXReaderUtil.getSAXReader();
        }
        return this.saxReader;
    }

    public final Map<String, Object> getDiffOperationsFromString(String xml) {
        HashMap<String, Object> retMap = new HashMap<String, Object>();
        SAXReader reader = this.getSaxReader();
        StringReader strReader = new StringReader(xml);
        try {
            Document doc = reader.read((Reader)strReader);
            String xpath = "//AppMenuElement | //AppFunctionPacketElement";
            List operations = doc.selectNodes(xpath);
            for (Element e : operations) {
                String partentId;
                String id;
                String action = e.attributeValue("action");
                if (action == null) {
                    action = "addNew";
                    id = e.elementText("Id");
                    retMap.put(id, action);
                } else if (action.equals("edit") || action.equals("remove")) {
                    id = e.attributeValue("oid");
                    retMap.put(id, action);
                }
                if (!StringUtils.isNotBlank((CharSequence)(partentId = e.elementText("ParentId"))) || retMap.get(partentId) != null && retMap.get(partentId).equals("addNew")) continue;
                retMap.put(partentId, "edit");
            }
            return retMap;
        }
        catch (DocumentException e) {
            throw new OrmException(DESERIALIZE_DOCUMENT_EXCEPTION, e.getMessage());
        }
    }

    public final List<Map<String, Object>> getDiffPluginsFromString(String xml) {
        SAXReader reader = this.getSaxReader();
        StringReader strReader = new StringReader(xml);
        try {
            Document doc = reader.read((Reader)strReader);
            String xpath = "//Plugin";
            List operations = doc.selectNodes(xpath);
            ArrayList<Map<String, Object>> plugins = new ArrayList<Map<String, Object>>();
            for (Element e : operations) {
                String action = e.attributeValue("action");
                if (action == null) {
                    if (e.elementText("Type") == null) continue;
                    HashMap<String, String> plugin = new HashMap<String, String>();
                    plugin.put("id", e.elementText("FPK"));
                    plugin.put("number", e.elementText("ScriptNumber"));
                    plugin.put("name", e.elementText("ClassName"));
                    plugins.add(plugin);
                    continue;
                }
                if (!action.equals("edit") && !action.equals("remove")) continue;
            }
            return plugins;
        }
        catch (DocumentException e) {
            throw new OrmException(DESERIALIZE_DOCUMENT_EXCEPTION, e.getMessage());
        }
    }

    public final String getParentIdIfExtendApp(String xml) {
        SAXReader reader = this.getSaxReader();
        StringReader strReader = new StringReader(xml);
        try {
            Document doc = reader.read((Reader)strReader);
            String appXpath = "//AppMetadata";
            String parentId = ((Element)doc.selectSingleNode(appXpath)).elementText("ParentId");
            if (StringUtils.isBlank((CharSequence)parentId)) {
                parentId = " ";
            }
            return parentId;
        }
        catch (DocumentException e) {
            throw new OrmException(DESERIALIZE_DOCUMENT_EXCEPTION, e.getMessage());
        }
    }
}

