/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.metadata.entity;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.database.DbMetadataTable;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntryType;
import kd.bos.entity.JsonSubEntryType;
import kd.bos.entity.property.SubEntryTextProp;
import kd.bos.metadata.dao.AlterTableUtil;
import kd.bos.metadata.entity.Entity;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.SubEntryEntity;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class JsonSubEntryEntity
extends SubEntryEntity {
    private static final String ALTER_ADD_SQL = "ALTER TABLE %s ADD %s;";

    @Override
    protected EntryType createDataEntityType() {
        return new JsonSubEntryType();
    }

    @Override
    public DynamicProperty registerProperty(DynamicObjectType dt) {
        DynamicProperty property = super.registerProperty(dt);
        property.setDbIgnore(true);
        property.setAlias(null);
        SubEntryTextProp entryTextProp = new SubEntryTextProp();
        String name = this.getKey() + "_json";
        entryTextProp.setName(this.getKey() + "_json");
        entryTextProp.setAlias("f" + this.getKey());
        entryTextProp.setDbIgnore(false);
        entryTextProp.setDisplayName(new LocaleString(name));
        dt.registerSimpleProperty((DynamicSimpleProperty)entryTextProp);
        return property;
    }

    @Override
    public List<Map<String, Object>> createEntityTreeNodes(boolean isAllNode, int level, boolean isIncludeEntry) {
        return new ArrayList<Map<String, Object>>();
    }

    public void genAddSubEntryField(EntityMetadata entityMetadata) {
        Entity entryEntity = (Entity)entityMetadata.getItemById(this.getParentEntryId());
        String fieldName = "f" + this.getKey();
        DbMetadataTable tableSchema = AlterTableUtil.getTableSchema(entityMetadata.getDBRouteKey(), entryEntity.getTableName(), false);
        RefObject refObject = new RefObject();
        if (tableSchema == null || !tableSchema.getColumns().TryGetValue(fieldName, refObject)) {
            String fieldDesc = String.format("%s CLOB DEFAULT('%s') NOT NULL", fieldName, " ");
            DB.execute((DBRoute)DBRoute.of((String)entityMetadata.getDBRouteKey()), (String)String.format(ALTER_ADD_SQL, entryEntity.getTableName(), fieldDesc), null);
        }
    }
}

