/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.metadata.entity.businessfield;

import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DefaultValueAttribute;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.property.AmountProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.PrivacyProp;
import kd.bos.form.field.AmountEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.metadata.entity.commonfield.DecimalField;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.entity.commonfield.IPrivacyField;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class AmountField
extends DecimalField
implements IPrivacyField {
    private static final long serialVersionUID = 6389558655740831409L;
    private String currencyFieldId;
    private int amountPrecisionType = 0;
    private int privacyType;

    @SimplePropertyAttribute
    public String getCurrencyFieldId() {
        return this.currencyFieldId;
    }

    public void setCurrencyFieldId(String currencyFieldId) {
        this.currencyFieldId = currencyFieldId;
    }

    @SimplePropertyAttribute(name="AmountPrecisionType")
    @DefaultValueAttribute(value="0")
    public int getAmountPrecisionType() {
        return this.amountPrecisionType;
    }

    public void setAmountPrecisionType(int amountPrecisionType) {
        this.amountPrecisionType = amountPrecisionType;
    }

    @Override
    @SimplePropertyAttribute
    public int getPrivacyType() {
        return this.privacyType;
    }

    public void setPrivacyType(int privacyType) {
        this.privacyType = privacyType;
    }

    @Override
    public Field<?> getControlField() {
        return this.entityMetadata.getFieldById(this.currencyFieldId);
    }

    @Override
    protected DecimalProp createDynamicProperty() {
        return new AmountProp();
    }

    @Override
    protected void setDynamicProperty(DecimalProp prop) {
        super.setDynamicProperty(prop);
        prop.setEncrypt(this.isEncrypt());
        AmountProp amountProp = (AmountProp)prop;
        amountProp.setScale(AmountPrecisionMapping.getScaleById(this.getAmountPrecisionType(), this.getScale()));
        amountProp.setPrecision(AmountPrecisionMapping.getPrecisionById(this.getAmountPrecisionType(), this.getPrecision()));
    }

    @Override
    protected FieldEdit createServerEditor() {
        AmountEdit amountEdit = new AmountEdit();
        return amountEdit;
    }

    @Override
    public Map<String, Object> createEditor() {
        Map<String, Object> editor = super.createEditor();
        Field<?> fld = this.entityMetadata.getFieldById(this.currencyFieldId);
        if (fld != null) {
            editor.put("sf", fld.getKey().toLowerCase());
        } else {
            editor.put("sf", "_MainCurrency_");
        }
        editor.put("nt", "amount");
        if (this.getClass().isAssignableFrom(AmountField.class)) {
            editor.put("pc", AmountPrecisionMapping.getPrecisionById(this.getAmountPrecisionType(), this.getPrecision()));
            editor.put("sc", AmountPrecisionMapping.getScaleById(this.getAmountPrecisionType(), this.getScale()));
        }
        return editor;
    }

    @Override
    public void resetItemId(Map<String, String> idMap) {
        super.resetItemId(idMap);
        String newid = idMap.get(this.getCurrencyFieldId());
        if (newid != null) {
            this.setCurrencyFieldId(newid);
        }
    }

    @Override
    public Map<String, Object> createEntityTreeNode() {
        Map<String, Object> col = super.createEntityTreeNode();
        col.put("DataType", "amount");
        col.put("Encrypt", this.isEncrypt());
        return col;
    }

    @Override
    public DynamicProperty registerProperty(DynamicObjectType dt) {
        DynamicProperty prop = super.registerProperty(dt);
        if (this.privacyType != 0 && prop != null) {
            boolean dbIgnore = StringUtils.isBlank((CharSequence)this.getFieldName());
            ((DecimalProp)prop).setPrivacyType((long)this.privacyType);
            ((DecimalProp)prop).setEncrypt(false);
            PrivacyProp property = new PrivacyProp();
            property.setName(prop.getName() + "_pr");
            property.setAlias(dbIgnore ? "" : prop.getAlias() + "_pr");
            property.setOriginalPropKey(this.getKey());
            property.setDbIgnore(dbIgnore);
            dt.registerSimpleProperty((DynamicSimpleProperty)property);
        }
        return prop;
    }

    public int getScaleByPrecisionType() {
        return AmountPrecisionMapping.getScaleById(this.getAmountPrecisionType(), super.getScale());
    }

    public int getPrecisionByPrecisionType() {
        return AmountPrecisionMapping.getPrecisionById(this.getAmountPrecisionType(), super.getPrecision());
    }

    @Override
    public int getPrecision() {
        return this.getPrecisionByPrecisionType();
    }

    @Override
    public int getScale() {
        return this.getScaleByPrecisionType();
    }

    static class AmountPrecisionMapping {
        private static Map<Integer, String> values = new HashMap<Integer, String>();

        AmountPrecisionMapping() {
        }

        public static int getPrecisionById(int id, int defaultPrecision) {
            if (values.containsKey(id)) {
                String value = values.get(id);
                return Integer.parseInt(value.split(",")[0]);
            }
            return defaultPrecision;
        }

        public static int getScaleById(int id, int defaultScale) {
            if (values.containsKey(id)) {
                String value = values.get(id);
                return Integer.parseInt(value.split(",")[1]);
            }
            return defaultScale;
        }

        static {
            values.put(0, "23,10");
            values.put(1, "19,4");
        }
    }
}

