/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.metadata.entity.businessfield;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.CollectionPropertyAttribute;
import kd.bos.dataentity.entity.ComplexPropertyAttribute;
import kd.bos.dataentity.entity.DefaultValueAttribute;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BasedataTypeEnum;
import kd.bos.entity.property.EntityTreeNode;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.RefProp;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.BillEntity;
import kd.bos.metadata.entity.Entity;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.EntryEntity;
import kd.bos.metadata.entity.RuntimeEntityMeta;
import kd.bos.metadata.entity.businessfield.AbstractBasedataField;
import kd.bos.metadata.entity.businessfield.BasedataEntitymetaReader;
import kd.bos.metadata.entity.businessfield.IBasedataField;
import kd.bos.metadata.entity.commonfield.Field;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class MulBasedataField
extends Field<MulBasedataProp>
implements IBasedataField {
    private String tableName;
    private boolean lableHyperlink;
    private LocaleString emptyText;
    private boolean allowAutoList = true;
    private boolean cacheLookUpList = true;
    private String baseEntityId;
    private String displayProp = "name";
    private String editSearchProp;
    private List<RefProp> refProps = new ArrayList<RefProp>();
    private String mobileList;
    private FilterCondition filter;
    private String orgFuncs;
    private EntityMetadata refBaseEntityMeta;
    private boolean showUsed = true;
    private String orgFieldId;
    private boolean showFrequent;
    private boolean openFuzzyQuery = true;
    private String selectedItemStyle = "text";
    private boolean multiLine = false;
    private int basedataEditStyle;
    private String basedataBtnIcon;
    private boolean foldingState = true;
    private String layoutId;

    public MulBasedataField() {
        this.defValueType = 0;
    }

    @SimplePropertyAttribute(name="RefLayout")
    public String getLayoutId() {
        return this.layoutId;
    }

    public void setLayoutId(String layoutId) {
        this.layoutId = layoutId;
    }

    @SimplePropertyAttribute(name="OpenFuzzyQuery")
    @DefaultValueAttribute(value="true")
    public boolean isOpenFuzzyQuery() {
        return this.openFuzzyQuery;
    }

    public void setOpenFuzzyQuery(boolean isOpenFuzzyQuery) {
        this.openFuzzyQuery = isOpenFuzzyQuery;
    }

    @Override
    public BasedataTypeEnum getBasedataTypeEnum() {
        return BasedataTypeEnum.BaseData;
    }

    @SimplePropertyAttribute
    public String getOrgFieldId() {
        return this.orgFieldId;
    }

    public void setOrgFieldId(String orgFieldId) {
        this.orgFieldId = orgFieldId;
    }

    @SimplePropertyAttribute(name="ShowUsed")
    @DefaultValueAttribute(value="true")
    public boolean isShowUsed() {
        return this.showUsed;
    }

    public void setShowUsed(boolean isShowUsed) {
        this.showUsed = isShowUsed;
    }

    @SimplePropertyAttribute(name="OrgFuncs")
    public String getOrgFuncs() {
        return this.orgFuncs;
    }

    public void setOrgFuncs(String orgFuncs) {
        this.orgFuncs = orgFuncs;
    }

    @Override
    @ComplexPropertyAttribute
    public FilterCondition getFilter() {
        return this.filter;
    }

    public void setFilter(FilterCondition filter) {
        this.filter = filter;
    }

    @SimplePropertyAttribute
    public String getTableName() {
        return this.tableName;
    }

    @Override
    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    @SimplePropertyAttribute
    public String getMobileList() {
        return this.mobileList;
    }

    public void setMobileList(String mobileList) {
        this.mobileList = mobileList;
    }

    @SimplePropertyAttribute(name="LableHyperlink")
    @DefaultValueAttribute(value="true")
    public boolean isLableHyperlink() {
        return this.lableHyperlink;
    }

    public void setLableHyperlink(boolean lableHyperlink) {
        this.lableHyperlink = lableHyperlink;
    }

    @SimplePropertyAttribute
    public LocaleString getEmptyText() {
        return this.emptyText;
    }

    public void setEmptyText(LocaleString emptyText) {
        this.emptyText = emptyText;
    }

    @SimplePropertyAttribute(name="AllowAutoList")
    @DefaultValueAttribute(value="true")
    public boolean isAllowAutoList() {
        return this.allowAutoList;
    }

    @SimplePropertyAttribute(name="ShowFrequent")
    public boolean isShowFrequent() {
        return this.showFrequent;
    }

    public void setShowFrequent(boolean isShowFrequent) {
        this.showFrequent = isShowFrequent;
    }

    public void setAllowAutoList(boolean allowAutoList) {
        this.allowAutoList = allowAutoList;
    }

    @SimplePropertyAttribute(name="CacheLookUpList")
    @DefaultValueAttribute(value="true")
    public boolean isCacheLookUpList() {
        return this.cacheLookUpList;
    }

    public void setCacheLookUpList(boolean cacheLookUpList) {
        this.cacheLookUpList = cacheLookUpList;
    }

    @Override
    @SimplePropertyAttribute
    public String getBaseEntityId() {
        return this.baseEntityId;
    }

    public void setBaseEntityId(String baseEntityId) {
        this.baseEntityId = baseEntityId;
    }

    @Override
    @CollectionPropertyAttribute(collectionItemPropertyType=RefProp.class)
    public List<RefProp> getRefProps() {
        return this.refProps;
    }

    @SimplePropertyAttribute
    @DefaultValueAttribute(value="name")
    public String getDisplayProp() {
        return this.displayProp;
    }

    public void setDisplayProp(String displayProp) {
        this.displayProp = displayProp;
    }

    @SimplePropertyAttribute
    @DefaultValueAttribute(value="text")
    public String getSelectedItemStyle() {
        return this.selectedItemStyle;
    }

    public void setSelectedItemStyle(String selectedItemStyle) {
        this.selectedItemStyle = selectedItemStyle;
    }

    @SimplePropertyAttribute(name="MultiLine")
    @DefaultValueAttribute(value="false")
    public boolean isMultiLine() {
        return this.multiLine;
    }

    public void setMultiLine(boolean multiLine) {
        this.multiLine = multiLine;
    }

    @SimplePropertyAttribute(name="FoldingState")
    @DefaultValueAttribute(value="true")
    public boolean isFoldingState() {
        return this.foldingState;
    }

    public void setFoldingState(boolean foldingState) {
        this.foldingState = foldingState;
    }

    @SimplePropertyAttribute(name="BasedataEditStyle")
    public int getBasedataEditStyle() {
        return this.basedataEditStyle;
    }

    public void setBasedataEditStyle(int basedataEditStyle) {
        this.basedataEditStyle = basedataEditStyle;
    }

    @SimplePropertyAttribute(name="BasedataBtnIcon")
    public String getBasedataBtnIcon() {
        return this.basedataBtnIcon;
    }

    public void setBasedataBtnIcon(String basedataBtnIcon) {
        this.basedataBtnIcon = basedataBtnIcon;
    }

    @SimplePropertyAttribute
    public String getEditSearchProp() {
        return this.displayProp;
    }

    public void setEditSearchProp(String editSearchProp) {
        this.editSearchProp = editSearchProp;
    }

    @Override
    protected FieldEdit createServerEditor() {
        return new MulBasedataEdit();
    }

    @Override
    protected void setServerEditorProperties(FieldEdit editor) {
        super.setServerEditorProperties(editor);
        MulBasedataEdit be = (MulBasedataEdit)editor;
        be.setDisplayProp(this.getDisplayProp());
        be.setShowUsed(this.showUsed);
        be.setShowFrequent(this.isShowFrequent());
        if (StringUtils.isNotEmpty((CharSequence)this.layoutId)) {
            be.setLayoutId(this.layoutId);
        }
    }

    @Override
    protected MulBasedataProp createDynamicProperty() {
        DynamicObjectType type = new DynamicObjectType(this.getKey());
        type.setAlias(this.tableName);
        type.setDbIgnore(StringUtils.isBlank((CharSequence)this.tableName));
        type.setDBRouteKey(StringUtils.isNotBlank((CharSequence)this.tableName) ? this.entityMetadata.getDBRouteKey() : "");
        this.registerProperties(type);
        MulBasedataProp prop = new MulBasedataProp(this.getKey(), type);
        prop.setMustInput(this.isMustInput());
        return prop;
    }

    @Override
    protected void setDynamicProperty(MulBasedataProp prop) {
        Field<?> field;
        super.setDynamicProperty(prop);
        prop.setAlias(this.getTableName());
        prop.setDbIgnore(StringUtils.isBlank((CharSequence)this.getTableName()));
        String name = (String)prop.getDisplayName().getDefaultItem();
        prop.setOrgFunc(this.orgFuncs);
        if (this.getBaseEntityId() != null) {
            String number = MetadataDao.getEntityNumberById(this.getBaseEntityId());
            if (number == null) {
                this.addBuildError(2, "BaseEntityId", String.format(ResManager.loadKDString((String)"%s\u5173\u8054\u7684\u57fa\u7840\u8d44\u6599\u4e0d\u5b58\u5728\u3002", (String)"MulBasedataField_0", (String)"bos-metadata", (Object[])new Object[0]), name));
            }
            prop.setBaseEntityId(number);
            prop.setMustInput(this.isMustInput());
            prop.setDisplayProp(this.displayProp);
            prop.setEditSearchProp(this.getEditSearchProp());
        } else {
            this.addBuildError(2, "BaseEntityId", String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u5173\u8054\u7684\u201c\u57fa\u7840\u8d44\u6599\u7c7b\u578b\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"MulBasedataField_1", (String)"bos-metadata", (Object[])new Object[0]), name));
        }
        if (!StringUtils.isBlank((CharSequence)this.orgFieldId) && (field = this.entityMetadata.getFieldById(this.orgFieldId)) != null) {
            prop.setOrgProp(field.getKey().toLowerCase());
        }
        prop.setShowUsed(this.isShowUsed());
    }

    protected void registerProperties(DynamicObjectType type) {
        String pkName = "pkid";
        LongProp pkProp = new LongProp();
        pkProp.setName(pkName);
        pkProp.setPrimaryKey(true);
        pkProp.setAlias("F" + pkName);
        type.registerSimpleProperty((DynamicSimpleProperty)pkProp);
        if (this.getBaseEntityId() != null) {
            BasedataProp baseProp = new BasedataProp();
            String number = MetadataDao.getEntityNumberById(this.getBaseEntityId());
            baseProp.setBaseEntityId(number);
            baseProp.setAlias("FBasedataId");
            baseProp.setName("fbasedataid");
            baseProp.setDisplayProp(this.getDisplayProp());
            baseProp.setEditSearchProp(this.getEditSearchProp());
            baseProp.setDbIgnore(true);
            type.addProperty((DynamicProperty)baseProp);
        }
    }

    @Override
    public Map<String, Object> createEditor() {
        Map<String, Object> ctlRet = super.createEditor();
        ctlRet.put("type", "mulbasedata");
        AbstractBasedataField.setDisplayPropCtl(ctlRet, this.getDisplayProp(), "dsp", "con");
        AbstractBasedataField.setDisplayPropCtl(ctlRet, this.getEditSearchProp(), "ep", "epcon");
        if (this.lableHyperlink) {
            ctlRet.put("ln", this.lableHyperlink);
        }
        if (StringUtils.isNotBlank((Object)this.emptyText)) {
            ctlRet.put("emptytip", this.emptyText);
        }
        if (!this.allowAutoList) {
            ctlRet.put("al", this.allowAutoList);
        }
        if (!this.cacheLookUpList) {
            ctlRet.put("cl", this.cacheLookUpList);
        }
        if (this.showFrequent) {
            ctlRet.put("sft", this.isShowFrequent());
        }
        if (!this.openFuzzyQuery) {
            ctlRet.put("ofq", this.isOpenFuzzyQuery());
        }
        ctlRet.put("sis", this.getSelectedItemStyle());
        ctlRet.put("multiLine", this.isMultiLine());
        if (!this.isFoldingState()) {
            ctlRet.put("foldingState", this.isFoldingState());
        }
        if (this.basedataEditStyle != 0) {
            ctlRet.put("editStyle", this.getBasedataEditStyle());
        }
        if (StringUtils.isNotBlank((CharSequence)this.getBasedataBtnIcon())) {
            ctlRet.put("fontClass", this.getBasedataBtnIcon());
        }
        if (this.getBaseEntityId() != null) {
            String number = MetadataDao.getEntityNumberById(this.getBaseEntityId());
            ctlRet.put("ei", number);
        }
        return ctlRet;
    }

    @Override
    public RuntimeEntityMeta createRuntimeEntityMeta() {
        return this.entityMetadata.createRuntimeEntityMeta();
    }

    @Override
    public List<Map<String, Object>> createEntityTreeNodes(boolean isAllNode, int level) {
        ArrayList<Map<String, Object>> cols = new ArrayList<Map<String, Object>>();
        if (this.getBaseEntityId() == null && !isAllNode) {
            return cols;
        }
        String number = MetadataDao.getEntityNumberById(this.getBaseEntityId());
        if (number == null) {
            return cols;
        }
        BasedataEntityType dt = (BasedataEntityType)EntityMetadataCache.getSubDataEntityType((String)number, (Collection)this.getRuntimeRefProps());
        EntityItem<?> entityItem = this.entityMetadata.getItemById(this.getParentId());
        EntityTreeNode entityTreeNode = new EntityTreeNode(this.getKey(), this.getName().toString(), entityItem instanceof EntryEntity, true, BasedataTypeEnum.MulBaseData, level, this.getBaseEntityId());
        entityTreeNode.setFieldPropAliasEmpty(StringUtils.isBlank((CharSequence)this.getTableName()));
        List entityTreeNodeListMap = dt.createEntityTreeNodes(entityTreeNode, true, isAllNode);
        for (Map entityTreeNodeMap : entityTreeNodeListMap) {
            StringBuilder sBuilder = new StringBuilder();
            Object filterNameObject = entityTreeNodeMap.get("FilterName");
            if (filterNameObject != null) {
                sBuilder.append(filterNameObject.toString());
            } else {
                sBuilder.append(entityTreeNodeMap.get("Id").toString());
            }
            int indexOf = this.getKey().length() + 1;
            if (indexOf > 0) {
                sBuilder.insert(indexOf, "fbasedataid.");
            }
            entityTreeNodeMap.put("FilterName", sBuilder);
        }
        return entityTreeNodeListMap;
    }

    @Override
    public String getFilterControlType() {
        return "basedata";
    }

    @Override
    public int getFieldDBType() {
        EntityMetadata entityMetadata;
        int pkType = 0;
        String baseEntityId = this.getBaseEntityId();
        if (baseEntityId != null && (entityMetadata = BasedataEntitymetaReader.readEntityMeta(baseEntityId)) != null) {
            for (Entity<?, ?> entity : entityMetadata.getEntitys()) {
                if (!(entity instanceof BillEntity)) continue;
                pkType = ((BillEntity)entity).getPkType() == 0 ? 12 : -5;
                break;
            }
        }
        return pkType;
    }
}

