/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.metadata.entity.commonfield;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.CollectionPropertyAttribute;
import kd.bos.dataentity.entity.DefaultValueAttribute;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.PrivacyProp;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.metadata.entity.commonfield.ComboItem;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.entity.commonfield.IPrivacyField;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class ComboField
extends Field<ComboProp>
implements IPrivacyField {
    private String changeListeners;
    protected List<ComboItem> items = new ArrayList<ComboItem>();
    private boolean showDropDown;
    private boolean editable;
    private String defValue;
    private LocaleString emptyText;
    private int maxLength = 50;
    private int privacyType;
    private boolean comboValueCheck;
    protected boolean showClearBtn = true;
    private String optionDisplayMode = "combo";

    @SimplePropertyAttribute(name="ShowClearBtn")
    @DefaultValueAttribute(value="true")
    public boolean isShowClearBtn() {
        return this.showClearBtn;
    }

    public void setShowClearBtn(boolean showClearBtn) {
        this.showClearBtn = showClearBtn;
    }

    @CollectionPropertyAttribute(collectionItemPropertyType=ComboItem.class)
    public List<ComboItem> getItems() {
        return this.items;
    }

    public void setItems(List<ComboItem> items) {
        this.items = items;
    }

    @SimplePropertyAttribute
    public String getChangeListeners() {
        return this.changeListeners;
    }

    public void setChangeListeners(String changeListeners) {
        this.changeListeners = changeListeners;
    }

    @SimplePropertyAttribute(name="ShowDropDown")
    private boolean isShowDropDown() {
        return this.showDropDown;
    }

    public void setShowDropDown(boolean showDropDown) {
        this.showDropDown = showDropDown;
    }

    @SimplePropertyAttribute(name="Editable")
    private boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    @SimplePropertyAttribute
    public String getDefValue() {
        return this.defValue;
    }

    public void setDefValue(String defValue) {
        this.defValue = defValue;
    }

    @SimplePropertyAttribute
    public LocaleString getEmptyText() {
        return this.emptyText;
    }

    public void setEmptyText(LocaleString value) {
        this.emptyText = value;
    }

    @SimplePropertyAttribute(name="ComboValueCheck")
    public boolean isComboValueCheck() {
        return this.comboValueCheck;
    }

    public void setComboValueCheck(boolean comboValueCheck) {
        this.comboValueCheck = comboValueCheck;
    }

    @SimplePropertyAttribute(name="OptionDisplayMode")
    @DefaultValueAttribute(value="combo")
    public String getOptionDisplayMode() {
        return this.optionDisplayMode;
    }

    public void setOptionDisplayMode(String optionDisplayMode) {
        this.optionDisplayMode = optionDisplayMode;
    }

    @Override
    public String getCompareGroupID() {
        return "10,11";
    }

    @Override
    protected ComboProp createDynamicProperty() {
        return new ComboProp();
    }

    @Override
    protected void setDynamicProperty(ComboProp prop) {
        super.setDynamicProperty(prop);
        ArrayList<ValueMapItem> valueItems = new ArrayList<ValueMapItem>(10);
        for (ComboItem comboItem : this.getItems()) {
            ValueMapItem valueMapItem = new ValueMapItem(comboItem.getImageKey(), comboItem.getValue(), comboItem.getCaption(), comboItem.isItemVisible());
            valueItems.add(valueMapItem);
        }
        prop.setComboItems(valueItems);
        prop.setDefValue((Object)this.getDefValue());
        prop.setEditable(this.isEditable());
        prop.setComboValueCheck(this.isComboValueCheck());
        prop.setOptionDisplayMode(this.getOptionDisplayMode());
    }

    @Override
    public Map<String, Object> createEditor() {
        List<Object> items;
        Map<String, Object> ctlRet = super.createEditor();
        if (!this.isShowDropDown()) {
            ctlRet.put("sd", this.isShowDropDown());
        }
        if (StringUtils.isNotBlank((CharSequence)this.changeListeners)) {
            items = new ArrayList();
            for (String listen : this.changeListeners.split(",")) {
                if (!StringUtils.isNotBlank((CharSequence)listen)) continue;
                items.add(listen);
            }
            ctlRet.put("cl", items);
        }
        if (this.isEditable()) {
            ctlRet.put("eb", true);
            ctlRet.put("type", "editcombo");
        } else {
            ctlRet.put("type", "combo");
        }
        if (StringUtils.equals((CharSequence)this.getOptionDisplayMode(), (CharSequence)"flat")) {
            ctlRet.put("type", "radiooptgroup");
        }
        items = this.getStore(!this.isMustInput());
        ctlRet.put("st", items);
        if (StringUtils.isNotBlank((Object)this.getEmptyText())) {
            ctlRet.put("emptytip", this.getEmptyText());
        }
        if (this.getClass().isAssignableFrom(ComboField.class)) {
            if (this.isMustInput()) {
                ctlRet.put("scbt", "undefined");
            } else {
                ctlRet.put("scbt", this.isShowClearBtn());
            }
        }
        return ctlRet;
    }

    private List<Object> getStore(boolean allowNull) {
        ArrayList<Object> items = new ArrayList<Object>();
        Collections.sort(this.getItems(), new Comparator<ComboItem>(){

            @Override
            public int compare(ComboItem o1, ComboItem o2) {
                return Integer.compare(o1.getSeq(), o2.getSeq());
            }
        });
        if (this.isEditable()) {
            for (ComboItem item : this.getItems()) {
                if (StringUtils.isNotBlank((CharSequence)item.getImageKey())) {
                    while (item.getImageKey().startsWith("//")) {
                        item.setImageKey(item.getImageKey().replace("//", "/"));
                    }
                }
                items.add(this.createEnumValue(item.getValue()));
            }
        } else {
            for (ComboItem item : this.getItems()) {
                if (StringUtils.isNotBlank((CharSequence)item.getImageKey())) {
                    while (item.getImageKey().startsWith("//")) {
                        item.setImageKey(item.getImageKey().replace("//", "/"));
                    }
                }
                items.add(this.createEnumItem(item.getValue(), item.getCaption(), item.getImageKey(), item.isItemVisible(), item.isDisable()));
            }
        }
        return items;
    }

    protected Object createEnumItem(Object value, LocaleString displayValue, String imageKey, boolean visible) {
        ArrayList<Object> item = new ArrayList<Object>();
        item.add(value);
        item.add(displayValue);
        item.add(imageKey);
        item.add(visible);
        return item;
    }

    protected Object createEnumItem(Object value, LocaleString displayValue, String imageKey, boolean visible, boolean disable) {
        List item = (List)this.createEnumItem(value, displayValue, imageKey, visible);
        item.add(disable);
        return item;
    }

    protected Object createEnumValue(Object value) {
        ArrayList<Object> item = new ArrayList<Object>();
        item.add(value);
        return item;
    }

    @Override
    protected FieldEdit createServerEditor() {
        return new ComboEdit();
    }

    @Override
    public Map<String, Object> createEntityTreeNode() {
        Map<String, Object> col = super.createEntityTreeNode();
        col.put("Type", "ComboListColumnAp");
        col.put("SchemeFilterApType", "SchemeComboFilterColumnAp");
        col.put("MobCommonFilterApType", "MobCommonFilterColumnAp");
        col.put("IsMulti", true);
        col.put("Custom", false);
        return col;
    }

    @Override
    public String getFilterControlType() {
        return "enum";
    }

    @SimplePropertyAttribute
    @DefaultValueAttribute(value="50")
    public int getMaxLength() {
        return this.maxLength;
    }

    public void setMaxLength(int maxLength) {
        this.maxLength = maxLength;
    }

    @Override
    @SimplePropertyAttribute
    public int getPrivacyType() {
        return this.privacyType;
    }

    public void setPrivacyType(int privacyType) {
        this.privacyType = privacyType;
    }

    @Override
    public DynamicProperty registerProperty(DynamicObjectType dt) {
        DynamicProperty prop = super.registerProperty(dt);
        if (this.privacyType != 0 && prop != null) {
            boolean dbIgnore = StringUtils.isBlank((CharSequence)this.getFieldName());
            ((ComboProp)prop).setPrivacyType((long)this.privacyType);
            ((ComboProp)prop).setEncrypt(false);
            PrivacyProp property = new PrivacyProp();
            property.setName(prop.getName() + "_pr");
            property.setAlias(dbIgnore ? "" : prop.getAlias() + "_pr");
            property.setOriginalPropKey(this.getKey());
            property.setDbIgnore(dbIgnore);
            dt.registerSimpleProperty((DynamicSimpleProperty)property);
        }
        return prop;
    }
}

