/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.metadata.entity.commonfield;

import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DefaultValueAttribute;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.property.LargeTextProp;
import kd.bos.entity.property.TextProp;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.LargeTextEdit;
import kd.bos.form.field.LargeTextOtherEdit;
import kd.bos.metadata.entity.commonfield.IDBField;
import kd.bos.metadata.entity.commonfield.TextField;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class LargeTextField
extends TextField {
    private int maxLength = 255;
    private String editingMode = "summary";
    private static final String LARGETEXT = "largeText";
    private int dbType = -9;

    @Override
    public int getFieldDBType() {
        return this.dbType;
    }

    @Override
    public List<IDBField> getDBFields() {
        List<IDBField> list = super.getDBFields();
        LargeTextField field = new LargeTextField();
        field.setFieldName(this.getTagFieldName());
        field.dbType = 2011;
        list.add(field);
        return list;
    }

    @SimplePropertyAttribute
    @DefaultValueAttribute(value="summary")
    public String getEditingMode() {
        return this.editingMode;
    }

    public void setEditingMode(String editingMode) {
        this.editingMode = editingMode;
    }

    @Override
    @SimplePropertyAttribute
    @DefaultValueAttribute(value="255")
    public int getMaxLength() {
        return this.maxLength;
    }

    @Override
    public void setMaxLength(int value) {
        this.maxLength = value;
    }

    public String getTagPropertyName() {
        if (StringUtils.isBlank((CharSequence)this.getKey())) {
            return "";
        }
        return this.getKey() + "_tag";
    }

    public String getTagFieldName() {
        if (StringUtils.isBlank((CharSequence)this.getFieldName())) {
            return "";
        }
        return this.getFieldName() + "_tag";
    }

    private LocaleString buildTagName() {
        LocaleString detailNames = ResManager.getLocaleString((String)"\u8be6\u60c5", (String)"LargeTextField_0", (String)"bos-metadata");
        if (this.getName() == null) {
            return detailNames;
        }
        LocaleString tagNames = new LocaleString();
        if (!detailNames.isEmpty() && StringUtils.isBlank((CharSequence)this.getName().toString())) {
            tagNames.putAll((Map)detailNames);
        }
        for (Map.Entry item : this.getName().entrySet()) {
            String localeId = (String)item.getKey();
            String detailName = (String)detailNames.get((Object)localeId);
            String fieldName = (String)this.getName().get((Object)localeId);
            if (StringUtils.isBlank((CharSequence)fieldName)) {
                tagNames.setItem(localeId, (Object)detailName);
                continue;
            }
            tagNames.setItem(localeId, (Object)String.format("%s_%s", fieldName, detailName));
        }
        return tagNames;
    }

    @Override
    protected FieldEdit createServerEditor() {
        if (LARGETEXT.equals(this.editingMode)) {
            return new LargeTextOtherEdit();
        }
        return new LargeTextEdit();
    }

    @Override
    public TextProp createDynamicProperty() {
        LargeTextProp largeTextProp = new LargeTextProp();
        largeTextProp.setEncrypt(this.isEncrypt());
        largeTextProp.setEditingMode(this.editingMode);
        return largeTextProp;
    }

    @Override
    public DynamicProperty registerProperty(DynamicObjectType dt) {
        DynamicProperty property = super.registerProperty(dt);
        TextProp tagProp = new TextProp();
        tagProp.setDisplayName(this.buildTagName());
        tagProp.setName(this.getTagPropertyName());
        tagProp.setAlias(this.getTagFieldName());
        tagProp.setDbIgnore(StringUtils.isBlank((CharSequence)this.getTagFieldName()));
        tagProp.setDefaultValue((Object)"");
        tagProp.setFeatures(this.getFeatures().getValue());
        if (property != null && property.getTableGroup() != null) {
            tagProp.setTableGroup(property.getTableGroup());
        }
        tagProp.setSysField(true);
        dt.registerSimpleProperty((DynamicSimpleProperty)tagProp);
        return property;
    }

    @Override
    protected void setDynamicProperty(TextProp prop) {
        super.setDynamicProperty(prop);
    }

    @Override
    public Map<String, Object> createEditor() {
        Map<String, Object> ctl = super.createEditor();
        ctl.put("editingMode", this.editingMode);
        ctl.put("type", LARGETEXT);
        return ctl;
    }
}

