/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.metadata.entity.commonfield;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class LongPressItem
implements Serializable {
    private String id;
    private String key;
    private LocaleString name;
    private String opKey;
    private String visible = "init,new,edit,view,submit,audit";
    private String lock;
    private int index = 0;
    private static Map<String, Integer> mapVis = new HashMap<String, Integer>(6);
    private static Map<String, Integer> mapLock = new HashMap<String, Integer>(5);

    public LongPressItem() {
    }

    public LongPressItem(String id, String key, String name, String opKey, String visible, String lock) {
        this.id = id;
        this.key = key;
        this.name = new LocaleString(name);
        this.opKey = opKey;
        this.visible = visible;
        this.lock = lock;
    }

    public LongPressItem(String id, String key, String name, String opKey, String visible, String lock, int index) {
        this.id = id;
        this.key = key;
        this.name = new LocaleString(name);
        this.opKey = opKey;
        this.visible = visible;
        this.lock = lock;
        this.index = index;
    }

    @SimplePropertyAttribute
    public LocaleString getName() {
        return this.name;
    }

    public void setName(LocaleString name) {
        this.name = name;
    }

    private int getVisibleValue() {
        String visible = this.getVisible();
        if (visible == null) {
            return 63;
        }
        if (StringUtils.isEmpty((CharSequence)visible)) {
            return 0;
        }
        String[] strs = visible.split(",");
        int ret = 0;
        for (String str : strs) {
            if (!mapVis.containsKey(str)) continue;
            ret |= mapVis.get(str).intValue();
        }
        return ret;
    }

    private int getLockValue() {
        String lock = this.getLock();
        if (StringUtils.isBlank((CharSequence)lock)) {
            return 0;
        }
        String[] strs = lock.split(",");
        int ret = 0;
        for (String str : strs) {
            if (!mapLock.containsKey(str)) continue;
            ret |= mapLock.get(str).intValue();
        }
        return ret;
    }

    public Map<String, Object> createControl() {
        HashMap<String, Object> ctl = new HashMap<String, Object>();
        ctl.put("key", this.getKey());
        ctl.put("visible", this.getVisibleValue());
        ctl.put("lock", this.getLockValue());
        ctl.put("title", this.getName());
        ctl.put("opk", this.getOpKey());
        return ctl;
    }

    @SimplePropertyAttribute(isPrimaryKey=true)
    public String getId() {
        if (StringUtils.isBlank((CharSequence)this.id)) {
            this.id = DB.genStringId((String)"");
        }
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @SimplePropertyAttribute
    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    @SimplePropertyAttribute(name="OpKey")
    public String getOpKey() {
        return this.opKey;
    }

    public void setOpKey(String opKey) {
        this.opKey = opKey;
    }

    @SimplePropertyAttribute
    public String getVisible() {
        return this.visible;
    }

    public void setVisible(String visible) {
        this.visible = visible;
    }

    @SimplePropertyAttribute
    public String getLock() {
        return this.lock;
    }

    public void setLock(String lock) {
        this.lock = lock;
    }

    @SimplePropertyAttribute
    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    static {
        mapVis.put("new", 1);
        mapVis.put("edit", 2);
        mapVis.put("view", 4);
        mapVis.put("init", 8);
        mapVis.put("submit", 16);
        mapVis.put("audit", 32);
        mapLock.put("new", 1);
        mapLock.put("edit", 2);
        mapLock.put("view", 4);
        mapLock.put("submit", 16);
        mapLock.put("audit", 32);
    }
}

