/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.metadata.entity.commonfield;

import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import kd.bos.dataentity.entity.DefaultValueAttribute;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.ext.DataEntityExtPointProxy;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.entity.property.PrivacyProp;
import kd.bos.entity.property.TextProp;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.GLangTextEdit;
import kd.bos.metadata.entity.commonfield.IMuliLangTextExtService;
import kd.bos.metadata.entity.commonfield.TextField;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class MuliLangTextField
extends TextField {
    private static final long serialVersionUID = 925386279875999430L;
    private boolean mutiLine;
    private boolean gl;
    private LocaleString defValue = new LocaleString();

    @SimplePropertyAttribute(name="GL")
    @DefaultValueAttribute(value="false")
    public boolean isGL() {
        return this.gl;
    }

    public void setGL(boolean gl) {
        this.gl = gl;
    }

    @SimplePropertyAttribute(name="MutiLine")
    public boolean isMutiLine() {
        return this.mutiLine;
    }

    public void setMutiLine(boolean value) {
        this.mutiLine = value;
    }

    @Override
    public TextProp createDynamicProperty() {
        MuliLangTextProp muliLangTextProp = new MuliLangTextProp();
        return muliLangTextProp;
    }

    @Override
    public DynamicProperty registerProperty(DynamicObjectType dt) {
        DynamicProperty property = super.registerProperty(dt);
        boolean dbIgnore = StringUtils.isBlank((CharSequence)this.getFieldName());
        DynamicObjectType localeDt = dt.getOrCreateLocaleType();
        TextProp sp = new TextProp();
        sp.setName(this.getKey());
        sp.setAlias(this.getFieldName());
        sp.setEncrypt(this.isEncrypt());
        sp.setDbIgnore(dbIgnore);
        sp.setDefaultValue((Object)"");
        sp.setDisplayName(this.getName());
        localeDt.registerSimpleProperty((DynamicSimpleProperty)sp);
        if (this.getPrivacyType() != 0) {
            sp.setEncrypt(false);
            sp.setPrivacyType((long)this.getPrivacyType());
            PrivacyProp localePrivacy = new PrivacyProp();
            localePrivacy.setName(sp.getName() + "_pr");
            localePrivacy.setAlias(dbIgnore ? "" : sp.getAlias() + "_pr");
            localePrivacy.setOriginalPropKey(this.getKey());
            localePrivacy.setDbIgnore(dbIgnore);
            localeDt.registerSimpleProperty((DynamicSimpleProperty)localePrivacy);
        }
        return property;
    }

    @Override
    protected void setDynamicProperty(TextProp prop) {
        super.setDynamicProperty(prop);
        prop.setEncrypt(this.isEncrypt());
        prop.setDefValue((Object)this.getMultiDefValue());
        if (this.isGL()) {
            prop.setDbIgnore(StringUtils.isBlank((CharSequence)this.getFieldName()));
            if (prop instanceof MuliLangTextProp) {
                ((MuliLangTextProp)prop).setGL(true);
                ((MuliLangTextProp)prop).setGlangText(this.isGlang2Text());
            }
        } else {
            prop.setDbIgnore(true);
        }
    }

    @Override
    public Map<String, Object> createEditor() {
        Map<String, Object> ctl = super.createEditor();
        if (this.isGlang2Text()) {
            ctl.put("type", "text");
        } else {
            ctl.put("type", "localeText");
        }
        ctl.put("multiLine", this.mutiLine);
        return ctl;
    }

    @Override
    public String getDefValue() {
        return this.defValue == null ? null : this.defValue.getLocaleValue();
    }

    @Override
    @Deprecated
    public void setDefValue(String defValue) {
        if (this.defValue == null) {
            this.defValue = new LocaleString();
        }
        this.defValue.setLocaleValue(defValue);
    }

    @SimplePropertyAttribute(name="DefValue")
    public LocaleString getMultiDefValue() {
        return this.defValue;
    }

    public void setMultiDefValue(LocaleString multiDefValue) {
        this.defValue = multiDefValue;
    }

    private boolean isGlang2Text() {
        if (!this.isGL()) {
            return false;
        }
        String fieldKey = this.getKey();
        String entityNumber = this.entityMetadata != null ? this.entityMetadata.getKey() : "";
        AtomicBoolean onlyGlang = new AtomicBoolean(false);
        DataEntityExtPointProxy pointProxy = DataEntityExtPointProxy.create(IMuliLangTextExtService.class, (String)"kd.bos.metadata.entity.commonfield.MuliLangTextField.useGlangText");
        pointProxy.call(plugin -> onlyGlang.set(plugin.useGlangText(entityNumber, fieldKey)));
        return onlyGlang.get();
    }

    @Override
    protected FieldEdit createServerEditor() {
        if (this.isGlang2Text()) {
            GLangTextEdit edit = new GLangTextEdit();
            edit.setSensitiveInfo(this.isSensitiveInfo());
            return edit;
        }
        return super.createServerEditor();
    }
}

