/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.metadata.entity.commonfield;

import java.util.Map;
import kd.bos.dataentity.entity.DefaultValueAttribute;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.property.TextProp;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.TelephoneEdit;
import kd.bos.metadata.entity.commonfield.Field;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class TelephoneField
extends Field<TextProp> {
    private int maxLength = 30;
    private String defValue;
    private boolean validateRule = true;
    private LocaleString emptyText;
    private boolean password;

    @Override
    public String getFilterControlType() {
        return "text";
    }

    @Override
    public String getRptColFieldType() {
        return "text";
    }

    @Override
    public Map<String, Object> createEditor() {
        Map<String, Object> editor = super.createEditor();
        editor.put("type", "telephone");
        editor.put("vlr", this.isValidateRule());
        editor.put("maxlength", 30);
        if (StringUtils.isNotBlank((Object)this.getEmptyText())) {
            editor.put("emptytip", this.getEmptyText());
        }
        return editor;
    }

    @Override
    protected FieldEdit createServerEditor() {
        TelephoneEdit edit = new TelephoneEdit();
        return edit;
    }

    @Override
    protected void setDynamicProperty(TextProp prop) {
        super.setDynamicProperty(prop);
        prop.setEncrypt(this.isEncrypt());
        prop.setMaxLenth(this.getMaxLength());
        prop.setDefValue((Object)this.getDefValue());
        prop.setPassword(this.isPassword());
    }

    @Override
    public TextProp createDynamicProperty() {
        return new TextProp();
    }

    @Override
    public Map<String, Object> createEntityTreeNode() {
        Map<String, Object> col = super.createEntityTreeNode();
        col.put("Encrypt", this.isEncrypt());
        return col;
    }

    @Deprecated
    @SimplePropertyAttribute
    @DefaultValueAttribute(value="30")
    public int getMaxLength() {
        return this.maxLength;
    }

    @Deprecated
    public void setMaxLength(int maxLength) {
        this.maxLength = maxLength;
    }

    @SimplePropertyAttribute
    public String getDefValue() {
        return this.defValue;
    }

    public void setDefValue(String defValue) {
        this.defValue = defValue;
    }

    @SimplePropertyAttribute(name="ValidateRule")
    @DefaultValueAttribute(value="true")
    public boolean isValidateRule() {
        return this.validateRule;
    }

    public void setValidateRule(boolean validateRule) {
        this.validateRule = validateRule;
    }

    @SimplePropertyAttribute
    public LocaleString getEmptyText() {
        return this.emptyText;
    }

    public void setEmptyText(LocaleString emptyText) {
        this.emptyText = emptyText;
    }

    @SimplePropertyAttribute(name="Password")
    public boolean isPassword() {
        return this.password;
    }

    public void setPassword(boolean value) {
        this.password = value;
    }
}

