/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.metadata.entity.rule;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dataentity.utils.Uuid16;
import kd.bos.metadata.exception.ErrorInfo;
import kd.bos.metadata.form.rule.FormRuleActionType;
import kd.bos.metadata.form.rule.FormRuleActionTypeCache;

public class BizRuleAction {
    private String id;
    private int seq;
    private LocaleString description = new LocaleString();
    private String actionType;
    private int raiseEventType;
    private String groupName;
    private List<ErrorInfo> errorInfos = new ArrayList<ErrorInfo>();
    private Set<String> dependencyFields = new HashSet<String>();

    @SimplePropertyAttribute
    public String getGroupName() {
        return this.groupName;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    @SimplePropertyAttribute
    public int getRET() {
        return this.raiseEventType;
    }

    public void setRET(int raiseEventType) {
        this.raiseEventType = raiseEventType;
    }

    @Deprecated
    public String getDescription() {
        String localDescription = this.description.toString();
        return localDescription == null ? "" : localDescription;
    }

    public void setDescription(String description) {
        this.description = new LocaleString(description);
    }

    @SimplePropertyAttribute(name="Description")
    public LocaleString getLocalDescription() {
        return this.description;
    }

    public void setLocalDescription(LocaleString description) {
        this.description = description;
    }

    @SimplePropertyAttribute
    public String getActionType() {
        return this.actionType;
    }

    public void setActionType(String actionType) {
        this.actionType = actionType;
    }

    @SimplePropertyAttribute(isPrimaryKey=true)
    public String getId() {
        if (StringUtils.isBlank((CharSequence)this.id)) {
            this.id = Uuid16.create().toString();
        }
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @SimplePropertyAttribute
    public int getSeq() {
        return this.seq;
    }

    public void setSeq(int seq) {
        this.seq = seq;
    }

    public List<ErrorInfo> getErrorInfos() {
        return this.errorInfos;
    }

    public Set<String> getDependencyFields() {
        return this.dependencyFields;
    }

    public void addDependencyFields(Set<String> dependencyFields) {
        this.dependencyFields.addAll(dependencyFields);
    }

    public Map<String, Object> buildAction() {
        this.errorInfos.clear();
        this.dependencyFields.clear();
        HashMap<String, Object> action = new HashMap<String, Object>();
        action.put("class", "kd.bos.form.rule.ClientAction");
        action.put("actionId", this.getId());
        action.put("ret", this.buildRunRaiseEvent());
        action.put("dependencyFields", this.getDependencyFields());
        return action;
    }

    public int buildRunRaiseEvent() {
        FormRuleActionType type = FormRuleActionTypeCache.geFormRuleActionType(this.getActionType());
        if (type == null) {
            return this.raiseEventType;
        }
        return this.raiseEventType & type.getRaiseEventType();
    }
}

