/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.metadata.entity.validation;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.consts.BOSExtPackage;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DcxmlSerializer;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.operate.OpDefinitionSource;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.entity.validation.ValidationType;
import kd.bos.metadata.entity.validation.ValidationTypes;
import kd.bos.utils.LocalMemroyCacheUtil;
import kd.bos.utils.LocaleBuildUtils;
import kd.sdk.annotation.SdkPublic;
import org.dom4j.Document;

@SdkPublic
public class ValidationTypeLoader {
    private static final Log LOG = LogFactory.getLog(ValidationTypeLoader.class);
    private static final String EXT_VALIDATION_TYPES_FROM_DB = "extValidationTypesFromDB";
    private static ValidationTypes cacheTypes;
    private static final String XML_FILENAME = "/ValidationTypes_";
    private static final String XML_ENDSUFFIX = ".xml";
    private static List<IDataEntityType> dts;
    private static final String SQL_VALIDATIONTYPES = "select a.fid, a.fnumber, a.ferrorlevel, a.fformid, a.frunclass, a.fisv, a.frange, a.fopwhitelist, a.fopblacklist, b.fname, b.fdesc, B.FLocaleId from t_dm_validator a left join t_dm_validator_L b on B.FId=A.FId where a.fenable = ?";

    public static void resetCache() {
        cacheTypes = null;
        LocalMemroyCacheUtil.clear((String)EXT_VALIDATION_TYPES_FROM_DB);
    }

    public static synchronized ValidationTypes load() {
        if (cacheTypes == null || cacheTypes.isCacheOverTime()) {
            cacheTypes = ValidationTypeLoader.loadFromXml();
        }
        if (!cacheTypes.isLoaded(Lang.get())) {
            ValidationTypeLoader.fillLoacle(cacheTypes, Lang.get());
        }
        ValidationTypes types = new ValidationTypes();
        types.getTypes().addAll(cacheTypes.getTypes());
        types.getTypes().addAll(ValidationTypeLoader.loadFromDB().getTypes());
        return types;
    }

    private static ValidationTypes loadFromDB() {
        ValidationTypes validationTypes = (ValidationTypes)LocalMemroyCacheUtil.get((String)EXT_VALIDATION_TYPES_FROM_DB);
        if (null != validationTypes && !validationTypes.isCacheOverTime()) {
            return validationTypes;
        }
        SqlParameter enable = new SqlParameter(1, (Object)"1");
        Object[] parameters = new SqlParameter[]{enable};
        ArrayList<ValidationType> validationTypeList = new ArrayList();
        try {
            validationTypeList = (List)DB.query((DBRoute)DBRoute.meta, (String)SQL_VALIDATIONTYPES, (Object[])parameters, rs -> {
                HashMap<String, ValidationType> map = new HashMap<String, ValidationType>(32);
                while (rs.next()) {
                    String frange;
                    ValidationType validationType;
                    String fid = rs.getString("fid");
                    String lang = rs.getString("FLocaleId");
                    if (!map.containsKey(fid)) {
                        String frange2;
                        validationType = new ValidationType();
                        validationType.setId(rs.getString("fnumber"));
                        validationType.setSettingFormId(rs.getString("fformid"));
                        validationType.setRunClass(rs.getString("frunclass"));
                        validationType.setErrorLevel(rs.getString("ferrorlevel"));
                        validationType.setOpWhiteList(rs.getString("fopwhitelist"));
                        validationType.setOpBlackList(rs.getString("fopblacklist"));
                        String fname = rs.getString("fname");
                        String name = new LocaleString(lang, fname);
                        validationType.setName((LocaleString)name);
                        String fdesc = rs.getString("fdesc");
                        LocaleString desc = new LocaleString(lang, fdesc);
                        validationType.setDesc(desc);
                        switch (frange2 = rs.getString("frange")) {
                            case "all": {
                                validationType.setAppliedRange(0);
                            }
                        }
                        validationType.setSrcType(OpDefinitionSource.DM_EXT);
                        map.put(fid, validationType);
                        continue;
                    }
                    validationType = (ValidationType)map.get(fid);
                    switch (frange = rs.getString("frange")) {
                        case "app": {
                            String appNumbers = validationType.getAppNumbers() + "," + rs.getString("appnumber");
                            validationType.setAppNumbers(appNumbers);
                        }
                    }
                    String fname = rs.getString("fname");
                    LocaleString name = validationType.getName();
                    if (name == null) {
                        name = new LocaleString();
                        validationType.setName(name);
                    }
                    name.put(lang, (Object)fname);
                    String fdesc = rs.getString("fdesc");
                    LocaleString desc = validationType.getDesc();
                    if (desc == null) {
                        desc = new LocaleString();
                        validationType.setDesc(desc);
                    }
                    desc.put(lang, (Object)fdesc);
                }
                ArrayList list = new ArrayList(map.size());
                list.addAll(map.values());
                return list;
            });
        }
        catch (Exception e) {
            LOG.error("validation loadFromDB error:{}", (Throwable)e);
        }
        validationTypes = new ValidationTypes();
        validationTypes.setTypes(validationTypeList);
        LocalMemroyCacheUtil.put((String)EXT_VALIDATION_TYPES_FROM_DB, (Object)validationTypes);
        return validationTypes;
    }

    public static ValidationTypes load(String appNumber, String entityNumber, String opType) {
        ValidationTypes types = new ValidationTypes();
        ValidationTypes allTypes = ValidationTypeLoader.load();
        for (ValidationType validationType : allTypes.getTypes()) {
            if (!ValidationTypeLoader.canAppliy(validationType, appNumber, entityNumber, opType)) continue;
            types.getTypes().add(validationType);
        }
        return types;
    }

    private static ValidationTypes loadFromXml() {
        ValidationTypes types = ValidationTypeLoader.loadFromXmlOri();
        ValidationTypeLoader.fillLoacle(types, Lang.get());
        return types;
    }

    private static void fillLoacle(ValidationTypes types, Lang lang) {
        if (types.isLoaded(lang)) {
            return;
        }
        String langStr = lang.toString();
        HashMap<String, ValidationType> dict = new HashMap<String, ValidationType>(10);
        for (ValidationType type : types.getTypes()) {
            dict.put(type.getId(), type);
        }
        for (String cloudNumber : BOSExtPackage.getExtPackageNumbers()) {
            ValidationTypes currTypes = ValidationTypeLoader.get(cloudNumber, lang);
            for (ValidationType validateType : currTypes.getTypes()) {
                ValidationType target = (ValidationType)dict.get(validateType.getId());
                if (target == null) continue;
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)validateType.getName().getItem(langStr)))) {
                    target.getName().setItem(langStr, validateType.getName().getItem(langStr));
                }
                if (!StringUtils.isNotBlank((CharSequence)((CharSequence)validateType.getDesc().getItem(langStr)))) continue;
                target.getDesc().setItem(langStr, validateType.getDesc().getItem(langStr));
            }
        }
        if (!Boolean.getBoolean("sys.domainmodel.oldlocale.disable")) {
            for (ValidationType validationType : types.getTypes()) {
                LocaleString res_Desc;
                LocaleString desc;
                LocaleString res_name;
                LocaleString name = validationType.getName();
                if (name != null && StringUtils.equals((CharSequence)((CharSequence)name.getItem(langStr)), (CharSequence)((CharSequence)name.getItem(Lang.zh_CN.toString()))) && StringUtils.isNotBlank((CharSequence)((CharSequence)(res_name = ResManager.getLocaleString((String)" ", (String)("DM_Name_" + validationType.getId()), (String)"ValidationType")).getItem(langStr)))) {
                    validationType.getName().setItem(langStr, res_name.getItem(langStr));
                }
                if ((desc = validationType.getDesc()) == null || !StringUtils.equals((CharSequence)((CharSequence)desc.getItem(langStr)), (CharSequence)((CharSequence)desc.getItem(Lang.zh_CN.toString()))) || !StringUtils.isNotBlank((CharSequence)((CharSequence)(res_Desc = ResManager.getLocaleString((String)" ", (String)("DM_Desc_" + validationType.getId()), (String)"ValidationType")).getItem(langStr)))) continue;
                validationType.getDesc().setItem(langStr, res_Desc.getItem(langStr));
            }
        }
        types.setLoaded(lang);
    }

    public static ValidationTypes loadFromXmlOri() {
        ValidationTypes types = new ValidationTypes();
        ArrayList notExistCloudNumbers = new ArrayList(200);
        ArrayList<String> existCloudNumbers = new ArrayList<String>(100);
        ArrayList<String> typeNames = new ArrayList<String>(10);
        for (String cloudNumber : BOSExtPackage.getExtPackageNumbers()) {
            ValidationTypes currTypes = ValidationTypeLoader.get(cloudNumber, Lang.zh_CN);
            if (!currTypes.getTypes().isEmpty()) {
                types.getTypes().addAll(currTypes.getTypes());
                typeNames.clear();
                for (ValidationType validateType : currTypes.getTypes()) {
                    validateType.setSrcType(OpDefinitionSource.XML);
                    validateType.setSrcApp(cloudNumber);
                    typeNames.add(validateType.getId());
                }
                continue;
            }
            existCloudNumbers.add(String.format("%s:[%s]", cloudNumber, StringUtils.join((Object[])typeNames.toArray(), (String)",")));
        }
        types.setLoaded(Lang.zh_CN);
        LOG.info(String.format("\u6821\u9a8c\u5668\u8bfb\u53d6\u5b8c\u6bd5\uff1a[%s]; \u65e0\u6821\u9a8c\u5668\u7684\u5e94\u7528\uff1a[%s]", StringUtils.join((Object[])existCloudNumbers.toArray(), (String)","), StringUtils.join((Object[])notExistCloudNumbers.toArray(), (String)",")));
        return types;
    }

    private static ValidationTypes get(String cloudNumber, Lang lang) {
        String fileName = XML_FILENAME + cloudNumber.toLowerCase() + XML_ENDSUFFIX;
        URL url = ValidationTypes.class.getResource(fileName);
        DcxmlSerializer ser = new DcxmlSerializer(dts);
        ser.getBinder().setLCId(lang.toString());
        ValidationTypes types = new ValidationTypes();
        if (url != null) {
            try {
                Document doc = LocaleBuildUtils.getSaxReader().read(url);
                LocaleBuildUtils.replaceLocaleVars((String)fileName, (Document)doc, (String)lang.toString());
                ValidationTypes t = (ValidationTypes)ser.deserialize(doc, null);
                if (t != null) {
                    types.getTypes().addAll(t.getTypes());
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return types;
    }

    private static boolean canAppliy(ValidationType validationType, String appNumber, String entityNumber, String opType) {
        if (validationType.isDisabled()) {
            return false;
        }
        if (StringUtils.isNotBlank((CharSequence)opType)) {
            if (StringUtils.isNotBlank((CharSequence)validationType.getOpBlackList()) && ValidationTypeLoader.containsStr(validationType.getOpBlackList(), opType, ",")) {
                return false;
            }
            if (StringUtils.isNotBlank((CharSequence)validationType.getOpWhiteList()) && !ValidationTypeLoader.containsStr(validationType.getOpWhiteList(), opType, ",")) {
                return false;
            }
        }
        if (validationType.getAppliedRange() == 0) {
            return true;
        }
        if (validationType.getAppliedRange() == 1 || validationType.getAppliedRange() == 2) {
            if (StringUtils.isNotBlank((CharSequence)validationType.getAppNumbers())) {
                if (StringUtils.isBlank((CharSequence)appNumber)) {
                    return false;
                }
                return ValidationTypeLoader.containsStr(validationType.getAppNumbers(), appNumber, ",");
            }
        } else if (validationType.getAppliedRange() == 2 && StringUtils.isNotBlank((CharSequence)validationType.getEntityNumber())) {
            return StringUtils.equalsIgnoreCase((CharSequence)validationType.getEntityNumber(), (CharSequence)entityNumber);
        }
        return true;
    }

    private static boolean containsStr(String str1, String str2, String separatorChars) {
        String[] strings;
        for (String string : strings = StringUtils.split((String)str1, (String)separatorChars)) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)str2, (CharSequence)string)) continue;
            return true;
        }
        return false;
    }

    static {
        dts = new ArrayList<IDataEntityType>();
        dts.add(OrmUtils.getDataEntityType(ValidationType.class));
        dts.add(OrmUtils.getDataEntityType(ValidationTypes.class));
    }
}

