/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.metadata.form.control;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.dataentity.entity.CollectionPropertyAttribute;
import kd.bos.dataentity.entity.ComplexPropertyAttribute;
import kd.bos.dataentity.entity.DefaultValueAttribute;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.Tips;
import kd.bos.form.control.Button;
import kd.bos.metadata.entity.commonfield.DropdownItem;
import kd.bos.metadata.entity.operation.Operation;
import kd.bos.metadata.form.ControlAp;
import kd.bos.script.annotations.KSMethod;
import kd.bos.script.annotations.KSObject;
import kd.bos.upload.UploadOption;
import kd.sdk.annotation.SdkPublic;

@KSObject(name="ButtonAp")
@SdkPublic
public class ButtonAp
extends ControlAp<Button> {
    private boolean uploadable;
    private UploadOption uploadConfig;
    private String operationKey;
    private boolean commitValidate;
    private int btnStyle;
    private String imageKey;
    private LocaleString busyTip;
    private List<DropdownItem> dropdownItems = new ArrayList<DropdownItem>();
    private int dropdownItemsType;
    private boolean TakeCert;
    private boolean FollowTheme;
    private String imgWidth;
    private String imgHeight;
    private String fontClass;
    private Tips ctlTips;
    private boolean controlLoading = true;

    @SimplePropertyAttribute(name="ControlLoading")
    @DefaultValueAttribute(value="true")
    public boolean isControlLoading() {
        return this.controlLoading;
    }

    public void setControlLoading(boolean controlLoading) {
        this.controlLoading = controlLoading;
    }

    @ComplexPropertyAttribute
    public Tips getCtlTips() {
        return this.ctlTips;
    }

    public void setCtlTips(Tips ctlTips) {
        this.ctlTips = ctlTips;
    }

    @SimplePropertyAttribute
    public int getDropdownItemsType() {
        return this.dropdownItemsType;
    }

    public void setDropdownItemsType(int dropdownItemsType) {
        this.dropdownItemsType = dropdownItemsType;
    }

    @SimplePropertyAttribute
    public String getOperationKey() {
        return this.operationKey;
    }

    public void setOperationKey(String operationKey) {
        this.operationKey = operationKey;
    }

    @SimplePropertyAttribute
    public int getButtonStyle() {
        return this.btnStyle;
    }

    public void setButtonStyle(int btnStyle) {
        this.btnStyle = btnStyle;
    }

    @SimplePropertyAttribute
    public String getfontClass() {
        return this.fontClass;
    }

    public void setfontClass(String fontClass) {
        this.fontClass = fontClass;
    }

    @SimplePropertyAttribute
    public String getImageKey() {
        return this.imageKey;
    }

    public void setImageKey(String imageKey) {
        this.imageKey = imageKey;
    }

    @SimplePropertyAttribute(name="CommitValidate")
    public boolean isCommitValidate() {
        return this.commitValidate;
    }

    public void setCommitValidate(boolean commitValidation) {
        this.commitValidate = commitValidation;
    }

    @CollectionPropertyAttribute(collectionItemPropertyType=DropdownItem.class)
    public List<DropdownItem> getDropdownItems() {
        return this.dropdownItems;
    }

    @Override
    @KSMethod
    public Map<String, Object> createControl() {
        Map<String, Object> ctl = super.createControl();
        ctl.put("type", "button");
        ctl.put("text", this.getName());
        ctl.put("showStyle", this.getDropdownItemsType());
        if (this.btnStyle != 0) {
            ctl.put("btns", this.getButtonStyle());
        }
        if (StringUtils.isNotBlank((CharSequence)this.getOperationKey())) {
            ctl.put("opk", this.getOperationKey());
        }
        this.sendPermissionId2Front(ctl, this.getOperationKey());
        if (this.btnStyle == 4 && StringUtils.isNotBlank((CharSequence)this.fontClass)) {
            ctl.put("fontClass", this.fontClass);
        }
        if (StringUtils.isNotBlank((CharSequence)this.imageKey)) {
            ctl.put("imageKey", this.imageKey);
        }
        if (this.commitValidate) {
            ctl.put("cv", this.commitValidate);
        }
        if (this.dropdownItems.size() > 0) {
            ctl.put("items", this.createItems());
            ctl.put("type", "menubutton");
        }
        if (this.getBusyTip() != null) {
            ctl.put("busyTip", this.getBusyTip());
        }
        if (this.TakeCert) {
            ctl.put("tc", this.TakeCert);
        }
        if (this.FollowTheme) {
            ctl.put("followTheme", this.FollowTheme);
        }
        if (StringUtils.isNotBlank((CharSequence)this.imgHeight)) {
            ctl.put("imgHeight", this.imgHeight);
        }
        if (StringUtils.isNotBlank((CharSequence)this.imgWidth)) {
            ctl.put("imgWidth", this.imgWidth);
        }
        if (this.isUploadable()) {
            ctl.put("iu", this.isUploadable());
            ctl.put("uconfig", this.getUploadConfig());
        }
        if (this.getCtlTips() != null) {
            ctl.put("tips", this.getCtlTips());
        }
        if (this.controlLoading) {
            ctl.put("controlLoading", this.controlLoading);
        }
        return ctl;
    }

    private List<Map<String, Object>> createItems() {
        ArrayList<Map<String, Object>> items = new ArrayList<Map<String, Object>>(10);
        for (DropdownItem item : this.dropdownItems) {
            Optional<Operation> value;
            Map<String, Object> ctrl = item.createControl();
            if (StringUtils.isNotBlank((CharSequence)item.getOperationKey()) && this.formMetadata != null && (value = this.formMetadata.getEntityMetadata().getRootEntity().getOperations().stream().filter(o -> StringUtils.equals((CharSequence)item.getOperationKey(), (CharSequence)o.getKey())).findFirst()).isPresent()) {
                Optional<Operation> submit;
                Operation oper = value.get();
                if ("submitandnew".equalsIgnoreCase(oper.getOperationType()) && (submit = this.formMetadata.getEntityMetadata().getRootEntity().getOperations().stream().filter(o -> StringUtils.equals((CharSequence)"submit", (CharSequence)o.getOperationType())).findFirst()).isPresent() && StringUtils.isNotBlank((CharSequence)submit.get().getPermissionItemId())) {
                    ctrl.put("permissionId", submit.get().getPermissionItemId());
                }
                if (StringUtils.isNotBlank((CharSequence)oper.getPermissionItemId())) {
                    ctrl.put("permissionId", oper.getPermissionItemId());
                }
            }
            items.add(ctrl);
        }
        return items;
    }

    @Override
    public void endInit() {
        super.endInit();
        if (this.isNewVersion()) {
            this.sortItem();
        }
    }

    private boolean isNewVersion() {
        if (this.dropdownItems == null || this.dropdownItems.isEmpty()) {
            return false;
        }
        for (DropdownItem item : this.dropdownItems) {
            int rowKey = item.getIndex();
            if (0 != rowKey) continue;
            return false;
        }
        return true;
    }

    private void sortItem() {
        Collections.sort(this.dropdownItems, new Comparator<DropdownItem>(){

            @Override
            public int compare(DropdownItem o1, DropdownItem o2) {
                if (StringUtils.isBlank((Object)o1.getIndex()) || StringUtils.isBlank((Object)o2.getIndex())) {
                    return 0;
                }
                Integer rowkey1 = o1.getIndex();
                Integer rowkey2 = o2.getIndex();
                return rowkey1.compareTo(rowkey2);
            }
        });
    }

    @Override
    protected Button createRuntimeControl() {
        Button btn = new Button();
        return btn;
    }

    @Override
    protected void setRuntimeSimpleProperties(Button ctl) {
        super.setRuntimeSimpleProperties(ctl);
        ctl.setOperationKey(this.operationKey);
    }

    @SimplePropertyAttribute
    @KSMethod
    public LocaleString getBusyTip() {
        return this.busyTip;
    }

    public void setBusyTip(LocaleString busyTip) {
        this.busyTip = busyTip;
    }

    @SimplePropertyAttribute(name="TakeCert")
    public boolean isTakeCert() {
        return this.TakeCert;
    }

    public void setTakeCert(boolean TakeCert) {
        this.TakeCert = TakeCert;
    }

    @SimplePropertyAttribute(name="FollowTheme")
    public boolean isFollowTheme() {
        return this.FollowTheme;
    }

    public void setFollowTheme(boolean followTheme) {
        this.FollowTheme = followTheme;
    }

    @SimplePropertyAttribute(name="ImgWidth")
    public String getImgWidth() {
        return this.imgWidth;
    }

    public void setImgWidth(String imgWidth) {
        this.imgWidth = imgWidth;
    }

    @SimplePropertyAttribute(name="ImgHeight")
    public String getImgHeight() {
        return this.imgHeight;
    }

    public void setImgHeight(String imgHeight) {
        this.imgHeight = imgHeight;
    }

    @SimplePropertyAttribute(name="Uploadable")
    public boolean isUploadable() {
        return this.uploadable;
    }

    public void setUploadable(boolean uploadable) {
        this.uploadable = uploadable;
    }

    @ComplexPropertyAttribute
    public UploadOption getUploadConfig() {
        return this.uploadConfig;
    }

    public void setUploadConfig(UploadOption uploadConfig) {
        this.uploadConfig = uploadConfig;
    }
}

