/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.metadata.form.control;

import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.SubEntryEntity;
import kd.bos.metadata.entity.businessfield.ExchangeRateField;
import kd.bos.metadata.entity.commonfield.ComboField;
import kd.bos.metadata.entity.commonfield.ComboItem;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.exception.ErrorInfo;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.control.EntryAp;
import kd.bos.metadata.form.control.FieldAp;
import kd.bos.util.StringUtils;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class ExchangeRateGroupCheckUtil {
    private static final String PLUGINS = "Plugins";
    private static final String NEW = "new";
    private static final String EDIT = "edit";
    private static final String VISIBLE = "Visible";
    private static final String LOCK = "Lock";
    private static final String MUST_INPUT = "MustInput";
    private static final String ITEMS = "Items";
    private static final String FIRE_UPD_EVT = "FireUpdEvt";

    public static void checkExchangeRateGroupField(FormMetadata formMetadata, EntityMetadata entityMetadata) {
        for (ControlAp<?> controlAp : formMetadata.getItems()) {
            EntityItem<?> entityItem;
            if (!(controlAp instanceof FieldAp) || !((entityItem = entityMetadata.getItemById(((FieldAp)controlAp).getFieldId())) instanceof ExchangeRateField)) continue;
            ExchangeRateGroupCheckUtil.checkExchangeRateGroupValid(formMetadata, entityMetadata, (ExchangeRateField)entityItem, (FieldAp)controlAp);
        }
    }

    public static void checkExchangeRateGroupValid(FormMetadata formMetadata, EntityMetadata entityMetadata, ExchangeRateField exchangeRateField, FieldAp exRateFieldAp) {
        if (!ExchangeRateGroupCheckUtil.checkGroupBindRelation(formMetadata, entityMetadata, exchangeRateField)) {
            return;
        }
        if (!ExchangeRateGroupCheckUtil.checkMobileControlComplete(formMetadata, entityMetadata, exchangeRateField)) {
            return;
        }
        ExchangeRateGroupCheckUtil.checkIsInSubEntryEntity(formMetadata, entityMetadata, exchangeRateField);
        ExchangeRateGroupCheckUtil.checkVisibleLockStatus(formMetadata, entityMetadata, exchangeRateField, exRateFieldAp);
        ExchangeRateGroupCheckUtil.checkMustInput(formMetadata, entityMetadata, exchangeRateField);
        ExchangeRateGroupCheckUtil.checkQuotationItems(formMetadata, entityMetadata, exchangeRateField);
        ExchangeRateGroupCheckUtil.checkFireUptEvt(formMetadata, entityMetadata, exchangeRateField);
        ExchangeRateGroupCheckUtil.chechGroupControlPosition(formMetadata, entityMetadata, exchangeRateField);
    }

    private static void addBuildError(EntityMetadata entityMetadata, ExchangeRateField field, String propertyName, String error) {
        ErrorInfo info = new ErrorInfo();
        info.setItemId(field.getId());
        info.setPropertyName(propertyName);
        info.setType("entity");
        info.setLevel(2);
        info.setError(error);
        entityMetadata.addError(info);
    }

    private static void addBuildWarn(EntityMetadata entityMetadata, ExchangeRateField field, String propertyName, String error) {
        ErrorInfo info = new ErrorInfo();
        info.setItemId(field.getId());
        info.setPropertyName(propertyName);
        info.setType("entity");
        info.setLevel(1);
        info.setError(error);
        entityMetadata.addError(info);
    }

    private static void checkIsInSubEntryEntity(FormMetadata formMetadata, EntityMetadata entityMetadata, ExchangeRateField exchangeRateField) {
        EntityItem<?> parentEntity;
        if (ExchangeRateGroupCheckUtil.isMobileFormModelType(formMetadata)) {
            return;
        }
        String parentId = exchangeRateField.getParentId();
        if (StringUtils.isNotEmpty((String)parentId) && (parentEntity = entityMetadata.getItemById(parentId)) instanceof SubEntryEntity) {
            String errorInfo = ResManager.loadKDString((String)"\u6c47\u7387\u63a7\u4ef6\u7ec4\u4e0d\u53ef\u5728\u5b50\u5355\u636e\u4f53\u4e2d\u3002", (String)"ExchangeRateGroupCheckUtil_21", (String)"bos-metadata", (Object[])new Object[0]);
            ExchangeRateGroupCheckUtil.addBuildError(entityMetadata, exchangeRateField, "Type", errorInfo);
        }
    }

    private static boolean checkMobileControlComplete(FormMetadata formMetadata, EntityMetadata entityMetadata, ExchangeRateField exchangeRateField) {
        if (ExchangeRateGroupCheckUtil.isMobileFormModelType(formMetadata)) {
            FieldAp oriFieldAp = ExchangeRateGroupCheckUtil.getFieldApFromId(formMetadata, entityMetadata, exchangeRateField.getOriginalCurrencyFieldId());
            FieldAp tarFieldAp = ExchangeRateGroupCheckUtil.getFieldApFromId(formMetadata, entityMetadata, exchangeRateField.getTargetCurrencyFieldId());
            FieldAp exRateTypeFieldAp = ExchangeRateGroupCheckUtil.getFieldApFromId(formMetadata, entityMetadata, exchangeRateField.getExRateTypeFieldId());
            FieldAp exRateDateFieldAp = ExchangeRateGroupCheckUtil.getFieldApFromId(formMetadata, entityMetadata, exchangeRateField.getExRateDateFieldId());
            FieldAp quotationFieldAp = ExchangeRateGroupCheckUtil.getFieldApFromId(formMetadata, entityMetadata, exchangeRateField.getExRateQuotationId());
            if (oriFieldAp == null || tarFieldAp == null || exRateTypeFieldAp == null || exRateDateFieldAp == null || quotationFieldAp == null) {
                ExchangeRateGroupCheckUtil.addBuildWarn(entityMetadata, exchangeRateField, "Control", ResManager.loadKDString((String)"\u79fb\u52a8\u7aef\u8868\u5355\u6c47\u7387\u5b57\u6bb5\u4e0d\u5168", (String)"ExchangeRateGroupCheckUtil_28", (String)"bos-metadata", (Object[])new Object[0]));
                return false;
            }
            return true;
        }
        return true;
    }

    private static boolean isMobileFormModelType(FormMetadata formMetadata) {
        String modelType = formMetadata.getModelType();
        return "MobileFormModel".equals(modelType) || "MobileBillFormModel".equals(modelType);
    }

    private static FieldAp getFieldApFromId(FormMetadata formMetadata, EntityMetadata entityMetadata, String fieldId) {
        List<ControlAp<?>> controlApList = formMetadata.getItems();
        FieldAp fieldAp = null;
        for (ControlAp<?> controlAp : controlApList) {
            if (!(controlAp instanceof FieldAp) || !((FieldAp)controlAp).getFieldId().equals(fieldId)) continue;
            fieldAp = (FieldAp)controlAp;
            break;
        }
        return fieldAp;
    }

    private static boolean checkGroupBindRelation(FormMetadata formMetadata, EntityMetadata entityMetadata, ExchangeRateField exchangeRateField) {
        if (ExchangeRateGroupCheckUtil.isMobileFormModelType(formMetadata)) {
            return true;
        }
        String errorInfo = "";
        if (ExchangeRateGroupCheckUtil.getFieldById(entityMetadata, exchangeRateField.getOriginalCurrencyFieldId()) == null) {
            errorInfo = String.format(ResManager.loadKDString((String)"%1$s\u539f\u5e01%2$s", (String)"ExchangeRateGroupCheckUtil_29", (String)"bos-metadata", (Object[])new Object[0]), errorInfo, ",");
        }
        if (ExchangeRateGroupCheckUtil.getFieldById(entityMetadata, exchangeRateField.getTargetCurrencyFieldId()) == null) {
            errorInfo = String.format(ResManager.loadKDString((String)"%1$s\u76ee\u6807\u5e01%2$s", (String)"ExchangeRateGroupCheckUtil_30", (String)"bos-metadata", (Object[])new Object[0]), errorInfo, ",");
        }
        if (ExchangeRateGroupCheckUtil.getFieldById(entityMetadata, exchangeRateField.getExRateTypeFieldId()) == null) {
            errorInfo = String.format(ResManager.loadKDString((String)"%1$s\u6c47\u7387\u8868%2$s", (String)"ExchangeRateGroupCheckUtil_31", (String)"bos-metadata", (Object[])new Object[0]), errorInfo, ",");
        }
        if (ExchangeRateGroupCheckUtil.getFieldById(entityMetadata, exchangeRateField.getExRateDateFieldId()) == null) {
            errorInfo = String.format(ResManager.loadKDString((String)"%1$s\u6c47\u7387\u65e5\u671f%2$s", (String)"ExchangeRateGroupCheckUtil_32", (String)"bos-metadata", (Object[])new Object[0]), errorInfo, ",");
        }
        if (ExchangeRateGroupCheckUtil.getFieldById(entityMetadata, exchangeRateField.getExRateQuotationId()) == null) {
            errorInfo = String.format(ResManager.loadKDString((String)"%1$s\u6362\u7b97\u65b9\u5f0f%2$s", (String)"ExchangeRateGroupCheckUtil_33", (String)"bos-metadata", (Object[])new Object[0]), errorInfo, ",");
        }
        if (StringUtils.isNotEmpty((String)errorInfo)) {
            errorInfo = errorInfo.substring(0, errorInfo.length() - 1);
            errorInfo = String.format(ResManager.loadKDString((String)"\u6c47\u7387\u63a7\u4ef6\u5fc5\u987b\u7ed1\u5b9a%s\u3002", (String)"ExchangeRateGroupCheckUtil_2", (String)"bos-metadata", (Object[])new Object[0]), errorInfo);
            ExchangeRateGroupCheckUtil.addBuildWarn(entityMetadata, exchangeRateField, "Binding", errorInfo);
            return false;
        }
        return true;
    }

    private static Field getFieldById(EntityMetadata entityMetadata, String id) {
        return entityMetadata.getFieldById(id);
    }

    private static void checkVisibleLockStatus(FormMetadata formMetadata, EntityMetadata entityMetadata, ExchangeRateField exchangeRateField, FieldAp exRateAp) {
        String warnMsg;
        FieldAp quotationAp = ExchangeRateGroupCheckUtil.getFieldApFromId(formMetadata, entityMetadata, exchangeRateField.getExRateQuotationId());
        String exRateLockInfo = exRateAp.getLock();
        if (quotationAp == null) {
            return;
        }
        String quotationVisibleInfo = quotationAp.getVisible();
        String quotationLockInfo = quotationAp.getLock();
        HashSet<String> visiableStatus = new HashSet<String>();
        visiableStatus.add(NEW);
        visiableStatus.add(EDIT);
        visiableStatus.add("view");
        visiableStatus.add("submit");
        visiableStatus.add("audit");
        visiableStatus.add("init");
        boolean quotationVisiableInfoWarn = false;
        for (String status : visiableStatus) {
            if (quotationVisibleInfo.contains(status)) continue;
            quotationVisiableInfoWarn = true;
            break;
        }
        if (quotationVisiableInfoWarn) {
            warnMsg = ResManager.loadKDString((String)"\u8bf7\u5c06%s\u5b57\u6bb5\u53ef\u89c1\u6027\u5168\u90e8\u8bbe\u7f6e\u4e3a\u53ef\u89c1\u3002\u5426\u5219\u53ef\u80fd\u5bfc\u81f4\u95f4\u63a5\u6c47\u7387\u7279\u6027\u542f\u52a8\u540e\u90e8\u5206\u72b6\u6001\u65e0\u6cd5\u770b\u5230\u8be5\u5b57\u6bb5\u3002", (String)"ExchangeRateGroupCheckUtil_25", (String)"bos-metadata", (Object[])new Object[0]);
            ExchangeRateGroupCheckUtil.addBuildWarn(entityMetadata, exchangeRateField, VISIBLE, String.format(warnMsg, quotationAp.getName().getLocaleValue()));
        }
        if (exRateLockInfo.contains(NEW) || exRateLockInfo.contains(EDIT)) {
            warnMsg = ResManager.loadKDString((String)"\u8bf7\u53bb\u9664%s\u5b57\u6bb5\u65b0\u589e\u9501\u5b9a\u3001\u4fee\u6539\u9501\u5b9a\u5c5e\u6027\u3002\u5426\u5219\u4f1a\u5bfc\u81f4\u6c47\u7387\u76f8\u5173\u5b57\u6bb5\u4e4b\u95f4\u7684\u8054\u52a8\u4ea4\u4e92\u89c4\u5219\u65e0\u6cd5\u9002\u914d\u3002", (String)"ExchangeRateGroupCheckUtil_23", (String)"bos-metadata", (Object[])new Object[0]);
            ExchangeRateGroupCheckUtil.addBuildWarn(entityMetadata, exchangeRateField, LOCK, String.format(warnMsg, exRateAp.getName().getLocaleValue()));
        }
        if (!quotationLockInfo.contains(NEW) || !quotationLockInfo.contains(EDIT)) {
            warnMsg = ResManager.loadKDString((String)"\u8bf7\u5c06%s\u5b57\u6bb5\u8bbe\u7f6e\u4e3a\u65b0\u589e\u9501\u5b9a\uff0c\u4fee\u6539\u9501\u5b9a\u3002\u5426\u5219\u7528\u6237\u53ef\u624b\u5de5\u4fee\u6539\u8be5\u5b57\u6bb5\uff0c\u5bfc\u81f4\u4e1a\u52a1\u6570\u636e\u4e0d\u4e00\u81f4\u3002", (String)"ExchangeRateGroupCheckUtil_24", (String)"bos-metadata", (Object[])new Object[0]);
            ExchangeRateGroupCheckUtil.addBuildWarn(entityMetadata, exchangeRateField, LOCK, String.format(warnMsg, quotationAp.getName().getLocaleValue()));
        }
    }

    private static void checkMustInput(FormMetadata formMetadata, EntityMetadata entityMetadata, ExchangeRateField exchangeRateField) {
        if (ExchangeRateGroupCheckUtil.isMobileFormModelType(formMetadata)) {
            return;
        }
        String warnMsg = ResManager.loadKDString((String)"\u8bf7\u5c06%s\u53ca\u5176\u7ed1\u5b9a\u5b57\u6bb5\u8bbe\u7f6e\u4e3a\u5fc5\u5f55\u3002\u5426\u5219\u53ef\u80fd\u5bfc\u81f4\u4e0a\u63a8\u3001\u4e0b\u63a8\u65f6\u5728\u5176\u4ed6\u5355\u636e\u4fe1\u606f\u7f3a\u5931\u3001\u5355\u636e\u62a5\u9519\u3002", (String)"ExchangeRateGroupCheckUtil_27", (String)"bos-metadata", (Object[])new Object[0]);
        boolean isNeedTips = false;
        if (!((FieldAp)formMetadata.getItem(exchangeRateField.getOriginalCurrencyFieldId())).getField().isMustInput()) {
            isNeedTips = true;
        }
        if (!((FieldAp)formMetadata.getItem(exchangeRateField.getTargetCurrencyFieldId())).getField().isMustInput()) {
            isNeedTips = true;
        }
        if (!((FieldAp)formMetadata.getItem(exchangeRateField.getExRateTypeFieldId())).getField().isMustInput()) {
            isNeedTips = true;
        }
        if (!((FieldAp)formMetadata.getItem(exchangeRateField.getExRateDateFieldId())).getField().isMustInput()) {
            isNeedTips = true;
        }
        if (!((FieldAp)formMetadata.getItem(exchangeRateField.getId())).getField().isMustInput()) {
            isNeedTips = true;
        }
        if (!((FieldAp)formMetadata.getItem(exchangeRateField.getExRateQuotationId())).getField().isMustInput()) {
            isNeedTips = true;
        }
        if (isNeedTips) {
            String exRateName = formMetadata.getItem(exchangeRateField.getId()).getName().getLocaleValue();
            ExchangeRateGroupCheckUtil.addBuildWarn(entityMetadata, exchangeRateField, MUST_INPUT, String.format(warnMsg, exRateName));
        }
    }

    private static void checkQuotationItems(FormMetadata formMetadata, EntityMetadata entityMetadata, ExchangeRateField exchangeRateField) {
        if (ExchangeRateGroupCheckUtil.isMobileFormModelType(formMetadata)) {
            return;
        }
        ComboField quotationField = (ComboField)entityMetadata.getItemById(exchangeRateField.getExRateQuotationId());
        List<ComboItem> items = quotationField.getItems();
        boolean isVaild = true;
        if (items.size() != 2) {
            isVaild = false;
        } else {
            ComboItem inDirectRate;
            ComboItem directRate = items.get(0);
            if (!directRate.getValue().equals("0") || directRate.getSeq() != 0 || !directRate.isItemVisible()) {
                isVaild = false;
            }
            if (!(inDirectRate = items.get(1)).getValue().equals("1") || inDirectRate.getSeq() != 1 || !inDirectRate.isItemVisible()) {
                isVaild = false;
            }
        }
        if (!isVaild) {
            ExchangeRateGroupCheckUtil.addBuildWarn(entityMetadata, exchangeRateField, ITEMS, String.format(ResManager.loadKDString((String)"\u8bf7\u786e\u4fdd\u4e0d\u8981\u4fee\u6539%s\u5b57\u6bb5\u7684\u4e0b\u62c9\u9879\u3002", (String)"ExchangeRateGroupCheckUtil_9", (String)"bos-metadata", (Object[])new Object[0]), quotationField.getName().getLocaleValue()));
        }
    }

    private static void checkFireUptEvt(FormMetadata formMetadata, EntityMetadata entityMetadata, ExchangeRateField exchangeRateField) {
        FieldAp fieldApFromId5;
        FieldAp fieldApFromId4;
        FieldAp fieldApFromId3;
        FieldAp fieldApFromId2;
        FieldAp fieldApFromId1;
        String warnMsg = ResManager.loadKDString((String)"\u8bf7\u6253\u5f00%s\u53ca\u5176\u7ed1\u5b9a\u5b57\u6bb5\u7684\u201c\u5373\u65f6\u89e6\u53d1\u503c\u66f4\u65b0\u201d\u5f00\u5173\u3002\u5426\u5219\u4f1a\u5bfc\u81f4\u5e01\u79cd\u3001\u6c47\u7387\u65e5\u671f\u7b49\u5b57\u6bb5\u66f4\u65b0\u540e\uff0c\u6362\u7b97\u65b9\u5f0f\u548c\u6c47\u7387\u65e0\u6cd5\u81ea\u52a8\u66f4\u65b0\u3002", (String)"ExchangeRateGroupCheckUtil_26", (String)"bos-metadata", (Object[])new Object[0]);
        boolean isNeedTips = false;
        FieldAp fieldApFromId = ExchangeRateGroupCheckUtil.getFieldApFromId(formMetadata, entityMetadata, exchangeRateField.getOriginalCurrencyFieldId());
        if (fieldApFromId != null && !fieldApFromId.isFireUpdEvt()) {
            isNeedTips = true;
        }
        if ((fieldApFromId1 = ExchangeRateGroupCheckUtil.getFieldApFromId(formMetadata, entityMetadata, exchangeRateField.getTargetCurrencyFieldId())) != null && !fieldApFromId1.isFireUpdEvt()) {
            isNeedTips = true;
        }
        if ((fieldApFromId2 = ExchangeRateGroupCheckUtil.getFieldApFromId(formMetadata, entityMetadata, exchangeRateField.getExRateTypeFieldId())) != null && !fieldApFromId2.isFireUpdEvt()) {
            isNeedTips = true;
        }
        if ((fieldApFromId3 = ExchangeRateGroupCheckUtil.getFieldApFromId(formMetadata, entityMetadata, exchangeRateField.getExRateDateFieldId())) != null && !fieldApFromId3.isFireUpdEvt()) {
            isNeedTips = true;
        }
        if ((fieldApFromId4 = ExchangeRateGroupCheckUtil.getFieldApFromId(formMetadata, entityMetadata, exchangeRateField.getId())) != null && !fieldApFromId4.isFireUpdEvt()) {
            isNeedTips = true;
        }
        if ((fieldApFromId5 = ExchangeRateGroupCheckUtil.getFieldApFromId(formMetadata, entityMetadata, exchangeRateField.getExRateQuotationId())) != null && !fieldApFromId5.isFireUpdEvt()) {
            isNeedTips = true;
        }
        if (isNeedTips && fieldApFromId4 != null) {
            String exRateName = fieldApFromId4.getName().getLocaleValue();
            ExchangeRateGroupCheckUtil.addBuildWarn(entityMetadata, exchangeRateField, FIRE_UPD_EVT, String.format(warnMsg, exRateName));
        }
    }

    private static void chechGroupControlPosition(FormMetadata formMetadata, EntityMetadata entityMetadata, ExchangeRateField exchangeRateField) {
        if (ExchangeRateGroupCheckUtil.isMobileFormModelType(formMetadata)) {
            return;
        }
        FieldAp exRateAp = (FieldAp)formMetadata.getItem(exchangeRateField.getId());
        FieldAp quotationAp = (FieldAp)formMetadata.getItem(exchangeRateField.getExRateQuotationId());
        ControlAp<?> originalCurrencyParentAp = formMetadata.getItem(formMetadata.getItem(exchangeRateField.getOriginalCurrencyFieldId()).getParentId());
        ControlAp<?> targetCurrencyParentAp = formMetadata.getItem(formMetadata.getItem(exchangeRateField.getTargetCurrencyFieldId()).getParentId());
        ControlAp<?> exRateTypeParentAp = formMetadata.getItem(formMetadata.getItem(exchangeRateField.getExRateTypeFieldId()).getParentId());
        ControlAp<?> exRateDateParentAp = formMetadata.getItem(formMetadata.getItem(exchangeRateField.getExRateDateFieldId()).getParentId());
        ControlAp<?> exRateParentAp = formMetadata.getItem(exRateAp.getParentId());
        ControlAp<?> quotationParentAp = formMetadata.getItem(quotationAp.getParentId());
        if (!exRateParentAp.getId().equals(quotationParentAp.getId()) && (exRateParentAp instanceof EntryAp || quotationParentAp instanceof EntryAp)) {
            ExchangeRateGroupCheckUtil.addBuildWarn(entityMetadata, exchangeRateField, PLUGINS, ResManager.loadKDString((String)"\u8bf7\u786e\u4fdd\u7ed1\u5b9a\u7684\u6c47\u7387\u548c\u6362\u7b97\u65b9\u5f0f\u5728\u540c\u4e00\u4e2a\u5355\u636e\u4f53\u6216\u8005\u540c\u65f6\u5728\u5355\u636e\u5934\u3002", (String)"ExchangeRateGroupCheckUtil_13", (String)"bos-metadata", (Object[])new Object[0]));
        }
        if (!(exRateParentAp instanceof EntryAp) && !(quotationParentAp instanceof EntryAp)) {
            if (originalCurrencyParentAp instanceof EntryAp || targetCurrencyParentAp instanceof EntryAp || exRateTypeParentAp instanceof EntryAp || exRateDateParentAp instanceof EntryAp) {
                ExchangeRateGroupCheckUtil.addBuildWarn(entityMetadata, exchangeRateField, PLUGINS, ResManager.loadKDString((String)"\u8bf7\u786e\u4fdd\u7ed1\u5b9a\u5b57\u6bb5\u4e0d\u5728\u5355\u636e\u4f53\u4e2d\u3002", (String)"ExchangeRateGroupCheckUtil_14", (String)"bos-metadata", (Object[])new Object[0]));
            }
        } else {
            boolean isInSameEntry = true;
            if (originalCurrencyParentAp instanceof EntryAp && !originalCurrencyParentAp.getId().equals(exRateParentAp.getId())) {
                isInSameEntry = false;
            }
            if (targetCurrencyParentAp instanceof EntryAp && !targetCurrencyParentAp.getId().equals(exRateParentAp.getId())) {
                isInSameEntry = false;
            }
            if (exRateTypeParentAp instanceof EntryAp && !exRateTypeParentAp.getId().equals(exRateParentAp.getId())) {
                isInSameEntry = false;
            }
            if (exRateDateParentAp instanceof EntryAp && !exRateDateParentAp.getId().equals(exRateParentAp.getId())) {
                isInSameEntry = false;
            }
            if (!isInSameEntry) {
                ExchangeRateGroupCheckUtil.addBuildWarn(entityMetadata, exchangeRateField, PLUGINS, ResManager.loadKDString((String)"\u8bf7\u786e\u4fdd\u7ed1\u5b9a\u5b57\u6bb5\u5728\u540c\u4e00\u4e2a\u5355\u636e\u4f53\u4e0a\u3002", (String)"ExchangeRateGroupCheckUtil_15", (String)"bos-metadata", (Object[])new Object[0]));
            }
        }
    }
}

