/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.metadata.form.control;

import java.util.LinkedHashMap;
import java.util.Map;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.control.RichTextEditor;
import kd.bos.metadata.form.ControlAp;
import kd.bos.script.annotations.KSObject;
import kd.sdk.annotation.SdkPublic;

@KSObject(name="RichTextEditorAp")
@SdkPublic
public class RichTextEditorAp
extends ControlAp<RichTextEditor> {
    private int richTextEditorStyle;
    private boolean autoSave;
    private boolean contentEncode;
    private boolean lockPrintable;
    private int model;
    private Map<String, Object> toolbarItems = new ToolbarItems();
    private int maxRichTextLength = 20;

    @Override
    public Map<String, Object> createControl() {
        Map<String, Object> ctl = super.createControl();
        ctl.put("type", "richtexteditor");
        if (this.richTextEditorStyle > 0) {
            ctl.put("rtes", this.richTextEditorStyle);
        }
        if (this.autoSave) {
            ctl.put("autosave", this.autoSave);
        }
        if (this.isContentEncode()) {
            ctl.put("contentencode", this.isContentEncode());
        }
        if (this.isLockPrintable()) {
            ctl.put("ilp", this.isLockPrintable());
        }
        if (this.getToolbarItems().size() > 0) {
            ctl.put("toolbarItems", this.getToolbarItems());
        }
        if (this.getModel() >= 0) {
            ctl.put("model", this.getModel());
        }
        if (this.getMaxRichTextLength() != 0 && this.getMaxRichTextLength() != 20) {
            ctl.put("maxRichTextLength", this.getMaxRichTextLength());
        }
        return ctl;
    }

    @Override
    protected RichTextEditor createRuntimeControl() {
        RichTextEditor editor = new RichTextEditor();
        editor.setContentEncode(this.isContentEncode());
        editor.setMaxRichTextLength(this.getMaxRichTextLength());
        return editor;
    }

    @SimplePropertyAttribute(name="RichTextEditorStyle")
    public int getRichTextEditorStyle() {
        return this.richTextEditorStyle;
    }

    public void setRichTextEditorStyle(int richTextEditorStyle) {
        this.richTextEditorStyle = richTextEditorStyle;
    }

    @SimplePropertyAttribute(name="AutoSave")
    public boolean isAutoSave() {
        return this.autoSave;
    }

    public void setAutoSave(boolean autoSave) {
        this.autoSave = autoSave;
    }

    @SimplePropertyAttribute(name="ContentEncode")
    public boolean isContentEncode() {
        return this.contentEncode;
    }

    public void setContentEncode(boolean contentEncode) {
        this.contentEncode = contentEncode;
    }

    @SimplePropertyAttribute(name="LockPrintable")
    public boolean isLockPrintable() {
        return this.lockPrintable;
    }

    public void setLockPrintable(boolean lockPrintable) {
        this.lockPrintable = lockPrintable;
    }

    @SimplePropertyAttribute(name="ToolbarItems")
    public Map<String, Object> getToolbarItems() {
        return this.toolbarItems;
    }

    public void setToolbarItems(Map<String, Object> toolbarItems) {
        if (toolbarItems == null) {
            this.toolbarItems = null;
            return;
        }
        ToolbarItems tools = new ToolbarItems();
        tools.putAll(toolbarItems);
        this.toolbarItems = tools;
    }

    @SimplePropertyAttribute(name="Model")
    public int getModel() {
        return this.model;
    }

    public void setModel(int model) {
        this.model = model;
    }

    @SimplePropertyAttribute(name="MaxRichTextLength")
    public int getMaxRichTextLength() {
        return this.maxRichTextLength;
    }

    public void setMaxRichTextLength(int maxRichTextLength) {
        this.maxRichTextLength = maxRichTextLength;
    }

    static class ToolbarItems
    extends LinkedHashMap {
        ToolbarItems() {
        }

        @Override
        public String toString() {
            return SerializationUtils.toJsonString((Object)this);
        }
    }
}

