/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.metadata.form.rule;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.TimeZone;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.rule.FieldAttribute;
import kd.bos.metadata.form.rule.OMScanner;
import org.apache.commons.codec.binary.Base64;

public class ObjectMapper {
    private static String datePatternString = "yyyy-MM-dd'T'HH:mm:ss";
    private static String dateTimeZone = "UTC";
    private static Log log = LogFactory.getLog(ObjectMapper.class);

    public static void setDatePatterString(String datePattern) {
        datePatternString = datePattern;
    }

    public static String getDatePatternString() {
        return datePatternString;
    }

    public static void setDateTimeZne(String timeZone) {
        dateTimeZone = timeZone;
    }

    public static String getDateTimeZone() {
        return dateTimeZone;
    }

    public static String toXML(Object xmlObject) {
        String xmlString = "";
        xmlString = xmlString + ObjectMapper.stringForObject(xmlObject, xmlObject.getClass(), true);
        return xmlString;
    }

    public static Object fromXML(String xmlString, Class<?> desiredClass) {
        OMScanner scanner = new OMScanner(xmlString);
        scanner.skipToString("<" + ObjectMapper.unquailifiedClassNameForClass(desiredClass));
        scanner.skipToString(">");
        Object newObject = ObjectMapper.getNodeValue(scanner, desiredClass, ObjectMapper.unquailifiedClassNameForClass(desiredClass));
        return newObject;
    }

    private static String stringForObject(Object object, Class<?> desiredClass, Boolean printTopClass) {
        StringBuilder objectString = new StringBuilder();
        if (desiredClass != null) {
            Field[] fields;
            if (printTopClass.booleanValue()) {
                objectString.append("<").append(ObjectMapper.unquailifiedClassNameForClass(desiredClass)).append(">");
            }
            for (Field field : fields = desiredClass.getDeclaredFields()) {
                Object objects;
                field.setAccessible(true);
                try {
                    if (field.get(object) == null) {
                        continue;
                    }
                }
                catch (IllegalAccessException | IllegalArgumentException e1) {
                    log.warn((Throwable)e1);
                }
                objectString.append("<").append(ObjectMapper.checkForAnnotaions(field)).append(">");
                if (String.class.equals(field.getType()) || Number.class.equals(field.getType()) || field.getType().isPrimitive()) {
                    try {
                        objectString.append(field.get(object).toString());
                    }
                    catch (IllegalAccessException | IllegalArgumentException e) {
                        log.warn((Throwable)e);
                    }
                } else if (field.getType().equals(byte[].class)) {
                    try {
                        objectString.append(Base64.encodeBase64String((byte[])((byte[])field.get(object))));
                    }
                    catch (IllegalAccessException | IllegalArgumentException e) {
                        log.error((Throwable)e);
                    }
                } else if (field.getType().equals(Date.class)) {
                    SimpleDateFormat format = new SimpleDateFormat(datePatternString);
                    format.setTimeZone(TimeZone.getTimeZone(dateTimeZone));
                    try {
                        objectString.append(format.format(field.get(object)));
                    }
                    catch (IllegalAccessException | IllegalArgumentException exception) {
                        log.warn((Throwable)exception);
                    }
                } else if (field.getType().getName().charAt(0) == '[') {
                    objects = null;
                    try {
                        objects = (Object[])field.get(object);
                    }
                    catch (IllegalAccessException | IllegalArgumentException exception) {
                        log.warn((Throwable)exception);
                    }
                    if (objects != null) {
                        for (Object object1 : objects) {
                            objectString.append("<").append(ObjectMapper.unquailifiedClassNameForClass(object1.getClass())).append(">");
                            objectString.append(ObjectMapper.stringForObject(object1, object1.getClass(), false));
                            objectString.append("</").append(ObjectMapper.unquailifiedClassNameForClass(object1.getClass())).append(">");
                        }
                    }
                } else if (field.getType().equals(ArrayList.class)) {
                    objects = new ArrayList();
                    try {
                        objects = (ArrayList)field.get(object);
                    }
                    catch (IllegalAccessException | IllegalArgumentException exception) {
                        log.warn((Throwable)exception);
                    }
                    Iterator iterator = ((ArrayList)objects).iterator();
                    while (iterator.hasNext()) {
                        Object object1 = iterator.next();
                        if (ObjectMapper.unquailifiedClassNameForClass(object1.getClass()).equals("String")) {
                            objectString.append("<string>").append(object1).append("</string>");
                            continue;
                        }
                        objectString.append("<").append(ObjectMapper.unquailifiedClassNameForClass(object1.getClass())).append(">");
                        objectString.append(ObjectMapper.stringForObject(object1, object1.getClass(), false));
                        objectString.append("</").append(ObjectMapper.unquailifiedClassNameForClass(object1.getClass())).append(">");
                    }
                } else {
                    try {
                        objectString.append(ObjectMapper.stringForObject(field.get(object), field.getType(), false));
                    }
                    catch (IllegalAccessException | IllegalArgumentException e) {
                        log.warn((Throwable)e);
                    }
                }
                objectString.append("</").append(ObjectMapper.checkForAnnotaions(field)).append(">");
            }
            if (printTopClass.booleanValue()) {
                objectString.append("</").append(ObjectMapper.unquailifiedClassNameForClass(desiredClass)).append(">");
            }
        }
        return objectString.toString();
    }

    private static String checkForAnnotaions(Field f) {
        String returnValue = "";
        try {
            Annotation a = f.getAnnotations()[0];
            if (a.annotationType() == FieldAttribute.class) {
                FieldAttribute annotation = (FieldAttribute)a;
                f.setAccessible(true);
                returnValue = annotation.value();
                if (StringUtils.isEmpty((CharSequence)returnValue)) {
                    return f.getName();
                }
            }
        }
        catch (Exception e) {
            returnValue = f.getName();
        }
        return returnValue;
    }

    private static String unquailifiedClassNameForClass(Class<?> inputClass) {
        return inputClass.getName().substring(inputClass.getName().lastIndexOf(46) + 1);
    }

    private static Object getNodeValue(OMScanner scanner, Class<?> desiredClass, String tagName) {
        Object object = null;
        try {
            object = desiredClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            log.error((Throwable)e);
        }
        while (!scanner.endOfTag(tagName) && scanner.hasNext()) {
            String nextTag = scanner.nextXMLTag();
            if (nextTag.contains(" /")) {
                scanner.skipEmptyTag();
                continue;
            }
            Class<ArrayList> elementClass = null;
            Field elementField = null;
            if (object == null) {
                return object;
            }
            for (Field field : object.getClass().getDeclaredFields()) {
                if (!ObjectMapper.checkForAnnotaions(field).equalsIgnoreCase(nextTag)) continue;
                elementClass = field.getType();
                elementField = field;
                break;
            }
            if (elementClass == null || elementField == null) break;
            try {
                if (String.class.equals(elementClass)) {
                    elementField.set(object, scanner.readNextTagValue());
                    continue;
                }
                if (Date.class.equals(elementClass)) {
                    SimpleDateFormat format = new SimpleDateFormat(datePatternString);
                    format.setTimeZone(TimeZone.getTimeZone(dateTimeZone));
                    try {
                        elementField.set(object, format.parse(scanner.readNextTagValue()));
                    }
                    catch (ParseException e) {
                        log.warn((Throwable)e);
                    }
                    continue;
                }
                if (Double.class.equals(elementClass)) {
                    elementField.set(object, Double.valueOf(scanner.readNextTagValue()));
                    continue;
                }
                if (Double.TYPE.equals(elementClass)) {
                    elementField.set(object, Double.parseDouble(scanner.readNextTagValue()));
                    continue;
                }
                if (Integer.class.equals(elementClass)) {
                    elementField.set(object, Integer.valueOf(scanner.readNextTagValue()));
                    continue;
                }
                if (Integer.TYPE.equals(elementClass)) {
                    elementField.set(object, Integer.parseInt(scanner.readNextTagValue()));
                    continue;
                }
                if (Float.class.equals(elementClass)) {
                    elementField.set(object, Float.valueOf(scanner.readNextTagValue()));
                    continue;
                }
                if (Float.TYPE.equals(elementClass)) {
                    elementField.set(object, Float.valueOf(Float.parseFloat(scanner.readNextTagValue())));
                    continue;
                }
                if (Boolean.class.equals(elementClass)) {
                    elementField.set(object, Boolean.valueOf(scanner.readNextTagValue()));
                    continue;
                }
                if (Boolean.TYPE.equals(elementClass)) {
                    elementField.set(object, Boolean.parseBoolean(scanner.readNextTagValue()));
                    continue;
                }
                if (elementClass.isAssignableFrom(ArrayList.class)) {
                    ParameterizedType pType = (ParameterizedType)elementField.getGenericType();
                    if (pType.getActualTypeArguments().length <= 0) continue;
                    elementField.set(object, ObjectMapper.GetArrayValue(scanner, nextTag, (Class)pType.getActualTypeArguments()[0]));
                    continue;
                }
                if (byte[].class.equals(elementClass)) {
                    elementField.set(object, Base64.decodeBase64((String)scanner.readNextTagValue()));
                    continue;
                }
                scanner.skipToString("<" + nextTag);
                scanner.skipToString(">");
                elementField.set(object, ObjectMapper.getNodeValue(scanner, elementClass, nextTag));
                scanner.skipToString("</" + nextTag + ">");
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                log.warn((Throwable)e);
            }
        }
        return object;
    }

    private static Object getArrayNodeValue(OMScanner scanner, String arrayName, Class<?> desiredClass) throws IllegalArgumentException, ReflectiveOperationException {
        Object object = null;
        if (desiredClass != null) {
            try {
                object = desiredClass.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                log.warn((Throwable)e);
            }
            if (object == null) {
                return null;
            }
            while (!scanner.endOfTag(arrayName) && scanner.hasNext()) {
                String nextTag = scanner.nextXMLTag();
                Class<?> elementClass = null;
                Field elementField = null;
                for (Field field : desiredClass.getDeclaredFields()) {
                    if (!ObjectMapper.checkForAnnotaions(field).equalsIgnoreCase(nextTag)) continue;
                    elementClass = field.getType();
                    elementField = field;
                    break;
                }
                if (elementClass == null) {
                    scanner.skipToString("<" + nextTag);
                    scanner.skipToString(">");
                    scanner.skipToString("</" + nextTag + ">");
                    continue;
                }
                if (elementField == null) {
                    return object;
                }
                if (elementClass.equals(String.class)) {
                    elementField.set(object, scanner.readNextTagValue());
                    continue;
                }
                if (elementClass.equals(Integer.class)) {
                    elementField.set(object, Integer.valueOf(scanner.readNextTagValue()));
                    continue;
                }
                if (elementClass.equals(Integer.TYPE)) {
                    elementField.set(object, Integer.parseInt(scanner.readNextTagValue()));
                    continue;
                }
                if (elementClass.equals(Float.class)) {
                    elementField.set(object, Float.valueOf(scanner.readNextTagValue()));
                    continue;
                }
                if (elementClass.equals(Float.TYPE)) {
                    elementField.set(object, Float.valueOf(Float.parseFloat(scanner.readNextTagValue())));
                    continue;
                }
                if (elementClass.equals(Double.class)) {
                    elementField.set(object, Double.valueOf(scanner.readNextTagValue()));
                    continue;
                }
                if (elementClass.equals(Double.TYPE)) {
                    elementField.set(object, Double.parseDouble(scanner.readNextTagValue()));
                    continue;
                }
                if (elementClass.equals(Boolean.class)) {
                    elementField.set(object, Boolean.valueOf(scanner.readNextTagValue()));
                    continue;
                }
                if (elementClass.equals(Boolean.TYPE)) {
                    elementField.set(object, Boolean.parseBoolean(scanner.readNextTagValue()));
                    continue;
                }
                if (elementClass.equals(byte[].class)) {
                    elementField.set(object, Base64.decodeBase64((String)scanner.readNextTagValue()));
                    continue;
                }
                scanner.skipToString("<" + nextTag);
                scanner.skipToString(">");
                elementField.set(object, ObjectMapper.getNodeValue(scanner, elementClass, nextTag));
                scanner.skipToString("</" + nextTag + ">");
            }
        }
        return object;
    }

    private static ArrayList<Object> GetArrayValue(OMScanner scanner, String arrayName, Class<?> desiredClass) {
        ArrayList<Object> objects = new ArrayList<Object>();
        if (desiredClass != null) {
            try {
                while (scanner.startOfTag(arrayName) && scanner.hasNext()) {
                    String nextTag = scanner.nextXMLTag();
                    scanner.skipToString("<" + nextTag);
                    scanner.skipToString(">");
                    objects.add(ObjectMapper.getArrayNodeValue(scanner, nextTag, desiredClass));
                    scanner.skipToString("</" + nextTag + ">");
                }
            }
            catch (IllegalArgumentException | ReflectiveOperationException e) {
                log.warn((Throwable)e);
            }
        }
        return objects;
    }
}

