/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.metadata.model.plugin;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.data.BusinessDataReader;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.AbstractMetadata;
import kd.bos.metadata.Plugin;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.operation.Operation;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.model.plugin.AbstractModelOperater;
import kd.bos.metadata.model.plugin.FormPluginParse;
import kd.bos.metadata.model.plugin.IPluginParse;
import kd.bos.metadata.model.plugin.ListPluginParse;
import kd.bos.metadata.model.plugin.MobListPluginParse;
import kd.bos.metadata.model.plugin.MobPluginParse;
import kd.bos.metadata.model.plugin.OperatePluginParse;
import kd.bos.orm.ORM;
import kd.bos.orm.datamanager.DataEntityCacheManager;
import kd.bos.orm.query.Distinctable;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.query.WithEntityEntryDistinctable;

public class PluginModelOperater
extends AbstractModelOperater {
    private static final String PLUGIN_NUMBER = "bos_devpn_pluginlistinfo";
    private static final String PLUGIN_REF_ENTITY = "quoteinfo";
    private Map<String, Object> mapPluginInfo = new HashMap<String, Object>();
    private Map<String, List<Map<String, Object>>> mapPluginRefInfo = new HashMap<String, List<Map<String, Object>>>();
    private Log logger = LogFactory.getLog(PluginModelOperater.class);

    @Override
    protected void buildModel(AbstractMetadata metadata) {
        this.loadPluginMetadata(metadata);
    }

    @Override
    protected void saveModel() {
        this.updatePluginInfo2DB();
    }

    @Override
    protected void updateModel(String number) {
        Object[] dyms;
        ArrayList<String> lstPlgName = new ArrayList<String>(10);
        for (String name : this.mapPluginRefInfo.keySet()) {
            lstPlgName.add(name);
        }
        String selectFields = "id,name,type,desc,isenable,quoteinfo,objname,objnumber,objtype,appid,reftype,enable,refname";
        String[] properties = selectFields.split(",");
        HashSet<String> select = new HashSet<String>(properties.length);
        for (String prop : properties) {
            select.add(prop.trim());
        }
        DynamicObjectType type = EntityMetadataCache.getSubDataEntityType((String)PLUGIN_NUMBER, select);
        boolean bRet = false;
        QFilter q = new QFilter("quoteinfo.objnumber", "=", (Object)number).or(new QFilter("name", "in", (Object)lstPlgName.toArray()));
        QFilter[] filters = new QFilter[]{q};
        ArrayList<Object> pks = new ArrayList<Object>();
        ArrayList idList = new ArrayList();
        Object[] objectArray = null;
        try (DataSet ds = ORM.create().queryDataSet("BusinessDataServiceHelper.load", PLUGIN_NUMBER, "id", filters, null, -1, (Distinctable)WithEntityEntryDistinctable.get());){
            ds.forEach(row -> idList.add(row.get(0)));
        }
        catch (Throwable object) {
            objectArray = object;
            throw object;
        }
        for (DynamicObject dynamicObject : dyms = BusinessDataReader.load((Object[])idList.toArray(), (DynamicObjectType)type, (Boolean)Boolean.FALSE)) {
            String pluginName;
            List<Map<String, Object>> plgRefs;
            DynamicObjectCollection refEntity = (DynamicObjectCollection)dynamicObject.get(PLUGIN_REF_ENTITY);
            if (!refEntity.isEmpty()) {
                Iterator it = refEntity.iterator();
                while (it.hasNext()) {
                    DynamicObject refItem = (DynamicObject)it.next();
                    String objnumber = refItem.getString("objnumber");
                    if (!number.equalsIgnoreCase(objnumber)) continue;
                    it.remove();
                }
            }
            if ((plgRefs = this.mapPluginRefInfo.get(pluginName = dynamicObject.getString("name"))) != null) {
                Plugin plg = (Plugin)this.mapPluginInfo.get(pluginName);
                this.mapPlugin2DynamicObject(plg, dynamicObject);
                this.initPluginRef2DynamicObject(refEntity, pluginName);
                this.removeMapPluginInfo(pluginName);
            }
            if (!refEntity.isEmpty()) continue;
            pks.add(dynamicObject.getPkValue());
        }
        BusinessDataWriter.save((IDataEntityType)type, (Object[])dyms);
        BusinessDataWriter.delete((IDataEntityType)type, (Object[])pks.toArray());
        this.updatePluginInfo2DB();
    }

    private void plugin2Cache(IPluginParse pp, Plugin plg) {
        List<Map<String, Object>> plgRefs;
        Object pluginInfo = null;
        String key = plg.getClassName();
        pluginInfo = this.mapPluginInfo.get(key);
        if (pluginInfo == null) {
            this.mapPluginInfo.put(key, plg);
        }
        if ((plgRefs = this.mapPluginRefInfo.get(key)) == null) {
            plgRefs = new ArrayList<Map<String, Object>>();
            this.mapPluginRefInfo.put(key, plgRefs);
        }
        HashMap<String, Object> plgRef = new HashMap<String, Object>();
        plgRef.put("name", pp.getName());
        plgRef.put("number", pp.getNumber());
        plgRef.put("appid", pp.getAppId());
        plgRef.put("enable", plg.isEnabled());
        plgRef.put("type", pp.getModelType());
        plgRef.put("reftype", pp.getRefType());
        if (pp.getRef() != null) {
            plgRef.put("ref", pp.getRef());
        }
        plgRefs.add(plgRef);
    }

    private void loadPluginMetadata(AbstractMetadata metadata) {
        block16: {
            block14: {
                FormPluginParse pp;
                List<Plugin> lstPlugin;
                FormMetadata fdt;
                block15: {
                    if (!(metadata instanceof FormMetadata)) break block14;
                    fdt = (FormMetadata)metadata;
                    lstPlugin = null;
                    pp = null;
                    String modelType = fdt.getModelType();
                    if (!"MobileBillFormModel".equalsIgnoreCase(modelType)) break block15;
                    pp = new MobPluginParse(fdt);
                    lstPlugin = pp.getPlugins();
                    if (lstPlugin != null && !lstPlugin.isEmpty()) {
                        for (Plugin plg : lstPlugin) {
                            this.plugin2Cache(pp, plg);
                        }
                    }
                    if ((lstPlugin = (pp = new MobListPluginParse(fdt)).getPlugins()) == null || lstPlugin.isEmpty()) break block16;
                    for (Plugin plg : lstPlugin) {
                        this.plugin2Cache(pp, plg);
                    }
                    break block16;
                }
                pp = new FormPluginParse(fdt);
                lstPlugin = pp.getPlugins();
                if (!lstPlugin.isEmpty()) {
                    for (Plugin plg : lstPlugin) {
                        this.plugin2Cache(pp, plg);
                    }
                }
                if ((lstPlugin = (pp = new ListPluginParse(fdt)).getPlugins()) != null && !lstPlugin.isEmpty()) {
                    for (Plugin plg : lstPlugin) {
                        this.plugin2Cache(pp, plg);
                    }
                }
                if ((lstPlugin = (pp = new MobPluginParse(fdt)).getPlugins()) != null && !lstPlugin.isEmpty()) {
                    for (Plugin plg : lstPlugin) {
                        this.plugin2Cache(pp, plg);
                    }
                }
                if ((lstPlugin = (pp = new MobListPluginParse(fdt)).getPlugins()) == null || lstPlugin.isEmpty()) break block16;
                for (Plugin plg : lstPlugin) {
                    this.plugin2Cache(pp, plg);
                }
                break block16;
            }
            if (metadata instanceof EntityMetadata) {
                EntityMetadata emt = (EntityMetadata)metadata;
                List<Operation> lstOpts = null;
                OperatePluginParse pp = null;
                String modelType = emt.getModelType();
                pp = new OperatePluginParse(emt);
                lstOpts = pp.getOperations();
                if (lstOpts != null && !lstOpts.isEmpty()) {
                    for (Operation opt : lstOpts) {
                        List<Plugin> lstPlugin = opt.getPlugins();
                        if (lstPlugin == null || lstPlugin.isEmpty()) continue;
                        pp.setOperation(opt);
                        for (Plugin plg : lstPlugin) {
                            this.plugin2Cache(pp, plg);
                        }
                    }
                }
            }
        }
    }

    private void mapPlugin2DynamicObject(Plugin plg, DynamicObject dym) {
        dym.set("name", (Object)plg.getClassName());
        dym.set("type", (Object)AbstractModelOperater.PLUGIN_TYPE.FORM.ordinal());
        dym.set("isenable", (Object)plg.isEnabled());
        dym.set("desc", (Object)plg.getDescription());
    }

    private void mapPluginRef2DynamicObject(Map<String, Object> map, DynamicObject dym) {
        dym.set("objname", map.get("name"));
        dym.set("objnumber", map.get("number"));
        String type = (String)map.get("type");
        try {
            AbstractModelOperater.OBJECT_TYPE ot = AbstractModelOperater.OBJECT_TYPE.valueOf(type);
            dym.set("objtype", (Object)ot.ordinal());
        }
        catch (Exception e) {
            dym.set("objtype", (Object)1);
        }
        dym.set("appid", map.get("appid"));
        dym.set("enable", map.get("enable"));
        dym.set("reftype", map.get("reftype"));
        if (map.get("ref") != null) {
            dym.set("refname", map.get("ref"));
        }
    }

    private boolean updatePluginInfo2DB() {
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)PLUGIN_NUMBER);
        ArrayList<DynamicObject> plugins = new ArrayList<DynamicObject>(10);
        for (Object value : this.mapPluginInfo.values()) {
            DynamicObject plugin = (DynamicObject)type.createInstance();
            this.mapPlugin2DynamicObject((Plugin)value, plugin);
            DynamicObjectCollection refEntity = plugin.getDynamicObjectCollection(PLUGIN_REF_ENTITY);
            String pluginName = plugin.getString("name");
            this.initPluginRef2DynamicObject(refEntity, pluginName);
            plugins.add(plugin);
        }
        if (!plugins.isEmpty()) {
            for (int i = 0; i < plugins.size(); i += 100) {
                try {
                    int len = Math.min(i + 100, plugins.size());
                    List tmp = plugins.subList(i, len);
                    BusinessDataWriter.save((IDataEntityType)type, (Object[])tmp.toArray());
                    continue;
                }
                catch (Exception e) {
                    this.logger.error((Throwable)e);
                }
            }
            return true;
        }
        this.mapPluginInfo.clear();
        this.mapPluginRefInfo.clear();
        this.mapPluginInfo = null;
        this.mapPluginRefInfo = null;
        return false;
    }

    private void removeMapPluginInfo(String pluginName) {
        this.mapPluginInfo.remove(pluginName);
        this.mapPluginRefInfo.remove(pluginName);
    }

    public void buildRefPlugin(AbstractMetadata formmeta, AbstractMetadata entitymeta) {
        this.loadPluginMetadata(formmeta);
        this.loadPluginMetadata(entitymeta);
        this.updatePluginInfo2DB();
    }

    @Override
    public void clear() {
        this.clearPlugin();
        this.clearPluginRef();
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)PLUGIN_NUMBER);
        DataEntityCacheManager cacheManager = new DataEntityCacheManager((IDataEntityType)type);
        cacheManager.removeByDt();
    }

    private void clearPlugin() {
        String sql = "TRUNCATE TABLE t_bas_plugin";
        DB.execute((DBRoute)DBRoute.basedata, (String)sql);
    }

    private void clearPluginRef() {
        String sql = "TRUNCATE TABLE t_bas_plugin_ref";
        DB.execute((DBRoute)DBRoute.basedata, (String)sql);
    }

    private void initPluginRef2DynamicObject(DynamicObjectCollection refEntity, String pluginName) {
        String key = pluginName;
        List<Map<String, Object>> pluginRefs = this.mapPluginRefInfo.get(key);
        for (Map<String, Object> pluginRef : pluginRefs) {
            DynamicObject refItem = refEntity.addNew();
            this.mapPluginRef2DynamicObject(pluginRef, refItem);
        }
    }
}

