/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.metadata.treebuilder;

import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class FieldTreeShowHelper {
    private static final String FORMID_MUL_FIELD_TREE = "bos_mulfieldtree";
    private static final String FORMID_SINGLE_FIELD_TREE = "bos_singlefieldtree";
    public static final String CUSTPARAM_ENTITY_NUMBER = "entitynumber";
    public static final String CUSTPARAM_SELECTED_FIELDS = "selectedfields";
    public static final String PAGE_CACHE_TREE_NODE_JSON = "fieldtreeshow_treenodejson";

    private FieldTreeShowHelper() {
    }

    public static void showMulEntityFieldTree(IFormView parentView, String entityNumber, String selectedFields, CloseCallBack closeCallBack) {
        FieldTreeShowHelper.showForm(parentView, FORMID_MUL_FIELD_TREE, entityNumber, null, selectedFields, closeCallBack);
    }

    public static void showMulTreeNode(IFormView parentView, String treeNodeJson, String selectedFields, CloseCallBack closeCallBack) {
        FieldTreeShowHelper.showForm(parentView, FORMID_MUL_FIELD_TREE, null, treeNodeJson, selectedFields, closeCallBack);
    }

    public static void showMulTreeNode(IFormView parentView, TreeNode rootNode, String selectedFields, CloseCallBack closeCallBack) {
        String treeNodeJson = SerializationUtils.toJsonString((Object)rootNode);
        FieldTreeShowHelper.showForm(parentView, FORMID_MUL_FIELD_TREE, null, treeNodeJson, selectedFields, closeCallBack);
    }

    public static void showSingleEntityFieldTree(IFormView parentView, String entityNumber, CloseCallBack closeCallBack) {
        FieldTreeShowHelper.showForm(parentView, FORMID_SINGLE_FIELD_TREE, entityNumber, null, null, closeCallBack);
    }

    public static void showSingleTreeNode(IFormView parentView, String treeNodeJson, CloseCallBack closeCallBack) {
        FieldTreeShowHelper.showForm(parentView, FORMID_SINGLE_FIELD_TREE, null, treeNodeJson, null, closeCallBack);
    }

    public static void showSingleTreeNode(IFormView parentView, TreeNode rootNode, CloseCallBack closeCallBack) {
        String treeNodeJson = SerializationUtils.toJsonString((Object)rootNode);
        FieldTreeShowHelper.showForm(parentView, FORMID_SINGLE_FIELD_TREE, null, treeNodeJson, null, closeCallBack);
    }

    private static void showForm(IFormView parentView, String showFormId, String entityNumber, String treeNodeJson, String selectedFields, CloseCallBack closeCallBack) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(showFormId);
        showParameter.getCustomParams().put(CUSTPARAM_ENTITY_NUMBER, entityNumber);
        showParameter.getCustomParams().put(CUSTPARAM_SELECTED_FIELDS, selectedFields);
        if (StringUtils.isNotBlank((CharSequence)treeNodeJson)) {
            parentView.getPageCache().putBigObject(PAGE_CACHE_TREE_NODE_JSON, treeNodeJson);
        }
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCloseCallBack(closeCallBack);
        parentView.showForm(showParameter);
    }
}

