/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.metadata.treebuilder;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.ItemClassProp;
import kd.bos.entity.property.ItemClassTypeProp;
import kd.bos.entity.property.MasterBasedataProp;
import kd.bos.metadata.treebuilder.BuildOption;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class PropTreeBuildOption
extends BuildOption {
    private String currentEntity;
    private boolean includeChildEntity = true;
    private boolean includeParentEntity = true;
    private boolean specialTreatmentMulBDProp = false;
    private boolean testIncludeFiledNumber = false;
    private HashSet<String> selectedEntity = new HashSet();
    private IDataEntityProperty matchedProperty = null;
    private Set<String> matchedItemClassTypes = null;
    private boolean onlyPhysicsField = true;
    private boolean dynamicText = false;
    private boolean includePKField = false;
    private boolean includeBDPropPK = true;
    private boolean includeBDRefProp = true;
    private boolean includeEntryEntityAsKeyPrefix = false;
    private boolean includeAllMasterProps = false;

    public PropTreeBuildOption() {
    }

    public PropTreeBuildOption(HashSet<String> selectedEntity, IDataEntityProperty matchedProperty) {
        if (selectedEntity != null) {
            this.selectedEntity.addAll(selectedEntity);
        }
        this.matchedProperty = matchedProperty;
    }

    public PropTreeBuildOption(HashSet<String> selectedEntity, Class<?> matchedClassType) {
        if (selectedEntity != null) {
            this.selectedEntity.addAll(selectedEntity);
        }
        this.addMatchedClassTypes(matchedClassType);
    }

    public String getCurrentEntity() {
        return this.currentEntity;
    }

    public void setCurrentEntity(String currentEntity) {
        this.currentEntity = currentEntity;
    }

    public boolean isIncludeParentEntity() {
        return this.includeParentEntity;
    }

    public void setIncludeParentEntity(boolean includeParentEntity) {
        this.includeParentEntity = includeParentEntity;
    }

    public boolean isIncludeChildEntity() {
        return this.includeChildEntity;
    }

    public void setIncludeChildEntity(boolean includeChildEntity) {
        this.includeChildEntity = includeChildEntity;
    }

    public HashSet<String> getSelectedEntity() {
        return this.selectedEntity;
    }

    public IDataEntityProperty getMatchedProperty() {
        return this.matchedProperty;
    }

    public void setMatchedProperty(IDataEntityProperty matchedProperty) {
        this.matchedProperty = matchedProperty;
        this.matchedItemClassTypes = null;
    }

    public Set<String> getMatchedItemClassTypes() {
        if (this.matchedItemClassTypes == null) {
            this.matchedItemClassTypes = this.matchedProperty instanceof ItemClassProp ? this.parseItemClassRefMasterEntity((ItemClassProp)this.matchedProperty) : new HashSet<String>(0);
        }
        return this.matchedItemClassTypes;
    }

    public boolean isOnlyPhysicsField() {
        return this.onlyPhysicsField;
    }

    public void setOnlyPhysicsField(boolean onlyPhysicsField) {
        this.onlyPhysicsField = onlyPhysicsField;
    }

    public boolean isDynamicText() {
        return this.dynamicText;
    }

    public void setDynamicText(boolean dynamicText) {
        this.dynamicText = dynamicText;
    }

    public boolean isIncludePKField() {
        return this.includePKField;
    }

    public void setIncludePKField(boolean includePKField) {
        this.includePKField = includePKField;
    }

    public boolean isIncludeBDPropPK() {
        return this.includeBDPropPK;
    }

    public void setIncludeBDPropPK(boolean includeBDPropPK) {
        this.includeBDPropPK = includeBDPropPK;
    }

    public boolean isIncludeBDRefProp() {
        return this.includeBDRefProp;
    }

    public void setIncludeBDRefProp(boolean includeBDRefProp) {
        this.includeBDRefProp = includeBDRefProp;
    }

    public boolean isIncludeEntryEntityAsKeyPrefix() {
        return this.includeEntryEntityAsKeyPrefix;
    }

    public void setIncludeEntryEntityAsKeyPrefix(boolean includeEntryEntityAsKeyPrefix) {
        this.includeEntryEntityAsKeyPrefix = includeEntryEntityAsKeyPrefix;
    }

    public void setSpecialTreatmentMulBDProp(boolean specialTreatmentMulBDProp) {
        this.specialTreatmentMulBDProp = specialTreatmentMulBDProp;
    }

    public boolean isSpecialTreatmentMulBDProp() {
        return this.specialTreatmentMulBDProp;
    }

    public void setTestIncludeFiledNumber(boolean testIncludeFiledNumber) {
        this.testIncludeFiledNumber = testIncludeFiledNumber;
    }

    public boolean isTestIncludeFiledNumber() {
        return this.testIncludeFiledNumber;
    }

    public boolean isIncludeAllMasterProps() {
        return this.includeAllMasterProps;
    }

    public void setIncludeAllMasterProps(boolean includeAllMasterProps) {
        this.includeAllMasterProps = includeAllMasterProps;
    }

    public Set<String> parseItemClassRefMasterEntity(ItemClassProp itemClassProp) {
        HashSet<String> entityNumbers = new HashSet<String>(4);
        entityNumbers.addAll(this.parseBDRefMasterEntity((BasedataProp)itemClassProp));
        MainEntityType mainType = null;
        for (IDataEntityType parentType = itemClassProp.getParent(); parentType != null; parentType = parentType.getParent()) {
            if (!(parentType instanceof MainEntityType)) continue;
            mainType = (MainEntityType)parentType;
            break;
        }
        if (mainType == null) {
            return entityNumbers;
        }
        IDataEntityProperty typeProp = mainType.findProperty(itemClassProp.getTypePropName());
        if (!(typeProp instanceof ItemClassTypeProp)) {
            return entityNumbers;
        }
        for (Map.Entry entry : ((ItemClassTypeProp)typeProp).getItemTypes().entrySet()) {
            if (entry.getValue() instanceof BasedataEntityType) {
                IDataEntityProperty masterProp;
                BasedataEntityType bdType = (BasedataEntityType)entry.getValue();
                entityNumbers.add(bdType.getName());
                if (bdType.getMasteridType() != 2 || !StringUtils.isNotBlank((CharSequence)bdType.getMasteridPropName()) || !((masterProp = bdType.findProperty(bdType.getMasteridPropName())) instanceof MasterBasedataProp)) continue;
                entityNumbers.add(((MasterBasedataProp)masterProp).getBaseEntityId());
                continue;
            }
            entityNumbers.add(((DynamicObjectType)entry.getValue()).getName());
        }
        return entityNumbers;
    }

    public Set<String> parseBDRefMasterEntity(BasedataProp bdProp) {
        HashSet<String> entityNumbers = new HashSet<String>(2);
        if (bdProp.getComplexType() instanceof BasedataEntityType) {
            IDataEntityProperty masterProp;
            BasedataEntityType bdType = (BasedataEntityType)bdProp.getComplexType();
            entityNumbers.add(bdType.getName());
            if (bdType.getMasteridType() == 2 && StringUtils.isNotBlank((CharSequence)bdType.getMasteridPropName()) && (masterProp = bdType.findProperty(bdType.getMasteridPropName())) instanceof MasterBasedataProp) {
                entityNumbers.add(((MasterBasedataProp)masterProp).getBaseEntityId());
            }
        }
        return entityNumbers;
    }
}

