/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.metadata.vercompare;

import java.sql.ResultSet;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DcBinder;
import kd.bos.dataentity.serialization.DcxmlSerializer;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.metadata.deploy.DeployAppMetadata;
import kd.bos.metadata.deploy.DeployMetadata;
import kd.bos.metadata.deploy.DeployMetadataBinder;
import kd.bos.metadata.devportal.DesignAppMeta;
import kd.bos.metadata.devportal.DesignAppMetaL;
import kd.bos.metadata.entity.DesignEntityMeta;
import kd.bos.metadata.entity.DesignEntityMetaL;
import kd.bos.metadata.form.DesignFormMeta;
import kd.bos.metadata.form.DesignFormMetaL;
import kd.bos.metadata.vercompare.IXmlCompare;
import kd.bos.metadata.vercompare.MergeContext;
import kd.bos.metadata.vercompare.MetaMergeUtils;

public class XcDeployForm
implements IXmlCompare {
    private boolean formIsChange = true;
    private String localeId;
    private MergeContext mergeContext;

    public MergeContext getMergeContext() {
        return this.mergeContext;
    }

    public void setMergeContext(MergeContext mergeContext) {
        this.mergeContext = mergeContext;
    }

    public String getLocaleId() {
        return this.localeId;
    }

    public void setLocaleId(String localeId) {
        this.localeId = localeId;
    }

    public boolean isFormIsChange() {
        return this.formIsChange;
    }

    public void setFormIsChange(boolean formIsChange) {
        this.formIsChange = formIsChange;
    }

    @Override
    public String merge(Object formMeta, Object entityMeta) {
        if (formMeta == null) {
            return null;
        }
        if (formMeta instanceof DesignAppMeta) {
            return this.getAppDeployFile((DesignAppMeta)formMeta);
        }
        if (formMeta instanceof DesignAppMetaL) {
            return this.getMultiLangAppDeployMetadataXml((DesignAppMetaL)formMeta);
        }
        if (formMeta instanceof DesignFormMetaL) {
            return this.getMultiLangDeployMetadataXml((DesignFormMetaL)formMeta, (DesignEntityMetaL)entityMeta);
        }
        return this.getFormDeployFile((DesignFormMeta)formMeta, (DesignEntityMeta)entityMeta);
    }

    private String getFormDeployFile(DesignFormMeta designFormMeta, DesignEntityMeta designEntityMeta) {
        String id = designFormMeta.getId();
        DeployMetadata deploy = new DeployMetadata();
        deploy.setBizappId(this.getAppIdByFormId(id));
        deploy.setBizunitId(this.getUnitIdByFormId(id));
        deploy.setMultilanguage(false);
        deploy.getDesignMetas().add(designFormMeta);
        if (designFormMeta.getId().equals(designFormMeta.getEntityId()) && designEntityMeta != null) {
            deploy.getDesignMetas().add(designEntityMeta);
        }
        String masterId = "2".equals(designFormMeta.getDevType()) ? designFormMeta.getMasterId() : id;
        deploy.setMasterId(masterId);
        deploy.setId(id);
        deploy.setVersion(designFormMeta.getVersion());
        return this.getDeployMetadataXml(deploy);
    }

    private String getMultiLangDeployMetadataXml(DesignFormMetaL designFormMetaL, DesignEntityMetaL designEntityMetaL) {
        String id = designFormMetaL.getId();
        String masterId = MetaMergeUtils.getMasterId(id, "page");
        DeployMetadata metadata = new DeployMetadata();
        metadata.setId(id);
        metadata.setMasterId(masterId);
        long multiLangVersion = this.mergeContext.getMultiLangVersion();
        long version = 0L;
        if (multiLangVersion != 0L) {
            version = multiLangVersion;
        }
        if (version == 0L) {
            version = designFormMetaL.getVersion() == 0L ? System.currentTimeMillis() : designFormMetaL.getVersion();
        }
        metadata.setVersion(version);
        metadata.getDesignMetas().add(designFormMetaL);
        if (designEntityMetaL != null) {
            metadata.getDesignMetas().add(designEntityMetaL);
        }
        return this.getDeployMetadataXml(metadata);
    }

    private String getMultiLangAppDeployMetadataXml(DesignAppMetaL designAppMetaL) {
        String id = designAppMetaL.getId();
        String masterId = MetaMergeUtils.getMasterId(id, "app");
        DeployAppMetadata metadata = new DeployAppMetadata();
        metadata.setId(id);
        metadata.setMasterId(masterId);
        metadata.getDesignMetas().add(designAppMetaL);
        return this.getDeployMetadataXml(metadata);
    }

    private String getAppDeployFile(DesignAppMeta designAppMeta) {
        DeployAppMetadata deploy = new DeployAppMetadata();
        String id = designAppMeta.getId();
        deploy.setMultilanguage(false);
        deploy.getDesignMetas().add(designAppMeta);
        String masterId = "2".equals(designAppMeta.getDevType()) ? designAppMeta.getMasterId() : id;
        deploy.setMasterId(masterId);
        deploy.setId(id);
        deploy.setVersion(0L);
        return this.getDeployMetadataXml(deploy);
    }

    private String getDeployMetadataXml(DeployMetadata deployMetadata) {
        DcxmlSerializer serializer = new DcxmlSerializer((DcBinder)new DeployMetadataBinder());
        serializer.setIndent(true);
        serializer.setNewlines(true);
        String fileContent = serializer.serializeToString((Object)deployMetadata, null);
        if (!fileContent.startsWith("<?xml version=\"1.0\" encoding=\"UTF-8\"?>") && !(fileContent = serializer.serializeToString((Object)this, null)).startsWith("<?xml version=\"1.0\" encoding=\"UTF-8\"?>")) {
            throw new KDException(BosErrorCode.jSONParsing, new Object[]{ResManager.loadKDString((String)"\u5143\u6570\u636e\u5e8f\u5217\u5316\u6587\u4ef6\u51fa\u73b0\u5f02\u5e38\uff01", (String)"DeployMetadata_0", (String)"bos-metadata", (Object[])new Object[0])});
        }
        return fileContent;
    }

    private String getAppIdByFormId(String formId) {
        String sql = String.format("select FBizAppId from %s where FFormId = ? ", "t_meta_bizunitrelform");
        Object[] params = new SqlParameter[]{new SqlParameter(":FFormId", 12, (Object)formId)};
        ResultSetHandler<String> action = new ResultSetHandler<String>(){

            public String handle(ResultSet rs) throws Exception {
                if (rs.next()) {
                    return rs.getString(1);
                }
                return null;
            }
        };
        return (String)DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])params, (ResultSetHandler)action);
    }

    private String getUnitIdByFormId(String formId) {
        String sql = String.format("select FBIZUNITID from %s where FFormId = ? ", "t_meta_bizunitrelform");
        Object[] params = new SqlParameter[]{new SqlParameter(":FFormId", 12, (Object)formId)};
        ResultSetHandler<String> action = new ResultSetHandler<String>(){

            public String handle(ResultSet rs) throws Exception {
                if (rs.next()) {
                    return rs.getString(1);
                }
                return null;
            }
        };
        return (String)DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])params, (ResultSetHandler)action);
    }
}

