/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.metadata.vercompare;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.tree.TreeNode;
import kd.bos.metadata.DesignMeta;
import kd.bos.metadata.DesignMetaL;
import kd.bos.metadata.entity.DesignEntityMeta;
import kd.bos.metadata.entity.DesignEntityMetaL;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.form.DesignFormMeta;
import kd.bos.metadata.form.DesignFormMetaL;
import kd.bos.metadata.vercompare.DcTreeNode;
import kd.bos.metadata.vercompare.DcTreeNodeUtil;
import kd.bos.metadata.vercompare.IXmlCompare;
import kd.bos.metadata.vercompare.MergeContext;
import kd.bos.metadata.vercompare.XcDeployForm;
import kd.bos.metadata.vercompare.XcEntityMetadata;
import kd.bos.metadata.vercompare.XcFormMetadata;
import kd.bos.metadata.vercompare.XmlCompareFactory;

public class XmlFormMetadata
implements IXmlCompare,
Serializable {
    private static final long serialVersionUID = -5407420611164503903L;
    private boolean isLayout = false;
    private XcFormMetadata form;
    private XcEntityMetadata entity;

    public boolean isLayout() {
        return this.isLayout;
    }

    public void setLayout(boolean layout) {
        this.isLayout = layout;
    }

    public XcFormMetadata getForm() {
        return this.form;
    }

    public void setForm(XcFormMetadata form) {
        this.form = form;
    }

    public XcEntityMetadata getEntity() {
        return this.entity;
    }

    public void setEntity(XcEntityMetadata entity) {
        this.entity = entity;
    }

    @Override
    public List<DcTreeNode> compareToNode(String xmlVer1, String xmlVer2, boolean isOnlyDiff) {
        ArrayList<DcTreeNode> dcTreeNodes = new ArrayList<DcTreeNode>(2);
        this.form = new XcFormMetadata();
        DcTreeNode formNode = this.form.compare(xmlVer1, xmlVer2, isOnlyDiff);
        this.entity = new XcEntityMetadata();
        DcTreeNode entityNode = this.entity.compare(xmlVer1, xmlVer2, isOnlyDiff);
        dcTreeNodes.add(formNode);
        if (entityNode != null) {
            dcTreeNodes.add(entityNode);
        }
        return dcTreeNodes;
    }

    @Override
    public String buildXml(List<DcTreeNode> dcTreeNodes, TreeNode treeNodes, List<String> selectIds, MergeContext context) {
        TreeNode entityMetadata;
        TreeNode formNode;
        String[] formIds = (String[])selectIds.stream().filter(s -> s.startsWith("FormMetadata")).toArray(String[]::new);
        String[] entityIds = null;
        if (!this.isLayout) {
            entityIds = (String[])selectIds.stream().filter(s -> s.startsWith("EntityMetadata")).toArray(String[]::new);
        }
        if (dcTreeNodes.isEmpty()) {
            return null;
        }
        if (formIds.length == 1 && "FormMetadata".equals(formIds[0]) && (formNode = treeNodes.getTreeNode("FormMetadata")) != null && formNode.getData() == null) {
            formIds = null;
        }
        DcTreeNode selectFormNode = DcTreeNodeUtil.selectNodes(dcTreeNodes.get(0), formIds);
        if (entityIds != null && entityIds.length == 1 && "EntityMetadata".equals(entityIds[0]) && !this.isLayout && (entityMetadata = treeNodes.getTreeNode("EntityMetadata")) != null && entityMetadata.getData() == null) {
            entityIds = null;
        }
        DcTreeNode selectEntityNode = entityIds == null || dcTreeNodes.size() < 2 ? null : DcTreeNodeUtil.selectNodes(dcTreeNodes.get(1), entityIds);
        return this.buildXml(selectFormNode, selectEntityNode, formIds, context);
    }

    public String buildXml(DcTreeNode formNode, DcTreeNode entityNode, String[] formIds, MergeContext mergeContext) {
        Object mergeEntityMeta;
        Object mergeFormMeta;
        XcFormMetadata formMetadata = this.form;
        DesignFormMeta designFormMeta = null;
        DesignEntityMeta designEntityMeta = null;
        DesignFormMetaL designFormMetaL = null;
        DesignEntityMetaL designEntityMetaL = null;
        if (StringUtils.isBlank((Object)formNode)) {
            mergeFormMeta = formMetadata.merge(formMetadata.getLastSerializer().getFormMetadata(), null, mergeContext);
            if (mergeFormMeta instanceof DesignFormMeta) {
                designFormMeta = (DesignFormMeta)mergeFormMeta;
            } else if (mergeFormMeta instanceof DesignFormMetaL) {
                designFormMetaL = (DesignFormMetaL)mergeFormMeta;
            }
        } else {
            mergeFormMeta = formMetadata.merge(formMetadata.getLastSerializer().getFormMetadata(), formNode, mergeContext);
            if (mergeFormMeta instanceof DesignFormMeta) {
                designFormMeta = (DesignFormMeta)mergeFormMeta;
            } else if (mergeFormMeta instanceof DesignFormMetaL) {
                designFormMetaL = (DesignFormMetaL)mergeFormMeta;
            }
        }
        XcEntityMetadata entityMetadata = this.entity;
        if (StringUtils.isBlank((Object)entityNode) && !this.isLayout) {
            mergeEntityMeta = entityMetadata.merge(entityMetadata.getLastSerializer().getEntityMetadata(), null, mergeContext);
            if (mergeEntityMeta instanceof DesignEntityMeta) {
                designEntityMeta = (DesignEntityMeta)mergeEntityMeta;
            } else if (mergeEntityMeta instanceof DesignEntityMetaL) {
                designEntityMetaL = (DesignEntityMetaL)mergeEntityMeta;
            }
        } else if (!this.isLayout) {
            mergeContext.setFormMetadata(formMetadata.getFormMetadata());
            mergeEntityMeta = entityMetadata.merge(entityMetadata.getLastSerializer().getEntityMetadata(), entityNode, mergeContext);
            if (mergeEntityMeta instanceof DesignEntityMeta) {
                designEntityMeta = (DesignEntityMeta)mergeEntityMeta;
            } else if (mergeEntityMeta instanceof DesignEntityMetaL) {
                designEntityMetaL = (DesignEntityMetaL)mergeEntityMeta;
            }
        }
        if (designFormMeta != null) {
            this.setTemplate(designFormMeta, entityMetadata);
        }
        IXmlCompare deployForm = XmlCompareFactory.get("DeployForm");
        if (formIds == null) {
            ((XcDeployForm)deployForm).setFormIsChange(false);
        }
        if (mergeContext.isMultiLang()) {
            MergeContext context = new MergeContext();
            context.setMultiLangVersion(this.form.getBaseSerializer().getDeployMetadata().getVersion());
            ((XcDeployForm)deployForm).setMergeContext(context);
            return deployForm.merge(designFormMetaL, designEntityMetaL);
        }
        return deployForm.merge(designFormMeta, designEntityMeta);
    }

    public void setDesignMetaL(DesignMetaL designMetaL, DesignMetaL baseDesignMeta) {
        designMetaL.setPkId(baseDesignMeta.getPkId());
    }

    public void setDesignMeta(DesignMeta designMeta, DesignMeta baseDesignMeta) {
        designMeta.setVersion(baseDesignMeta.getVersion());
    }

    private void setTemplate(DesignFormMeta formMeta, XcEntityMetadata xcEntityMetadata) {
        EntityMetadata entityMetadata;
        if (!this.isLayout && xcEntityMetadata != null && (entityMetadata = xcEntityMetadata.getEntityMetadata()) != null && entityMetadata.getRootEntity() != null) {
            formMeta.setTemplate(entityMetadata.getRootEntity().isTemplate());
        }
    }
}

