/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.metadata.vercompare.app;

import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.AbstractDesignMeta;
import kd.bos.metadata.AbstractMetadata;
import kd.bos.metadata.dao.MetadataReader;
import kd.bos.metadata.dao.MetadataSerializer;
import kd.bos.metadata.deploy.DeployAppMetadata;
import kd.bos.metadata.devportal.AppMetadata;
import kd.bos.metadata.devportal.DesignAppMeta;
import kd.bos.metadata.devportal.DesignAppMetaL;
import kd.bos.metadata.vercompare.DeployFormSerializer;

public class AppMetaSerializer
extends DeployFormSerializer {
    private static Log log = LogFactory.getLog(AppMetaSerializer.class);
    private AppMetadata appMetadata;
    private AppMetadata baseAppMetadata;
    private DesignAppMeta designAppMeta;
    private DesignAppMetaL designAppMetaL;
    private MetadataSerializer serializer;

    public AppMetadata getAppMetadata() {
        return this.appMetadata;
    }

    public AppMetadata getBaseAppMetadata() {
        return this.baseAppMetadata;
    }

    public DesignAppMeta getDesignAppMeta() {
        return this.designAppMeta;
    }

    public DesignAppMetaL getDesignAppMetaL() {
        return this.designAppMetaL;
    }

    public MetadataSerializer getSerializer() {
        return this.serializer;
    }

    public AppMetaSerializer(String xml) {
        super(xml);
        this.serializerToObject();
    }

    @Override
    public void serializerToObject() {
        super.serializerToObject();
        String xml = null;
        DeployAppMetadata deployAppMetadata = (DeployAppMetadata)this.getDeployMetadata();
        if (deployAppMetadata != null && !deployAppMetadata.getDesignMetas().isEmpty()) {
            for (AbstractDesignMeta designMeta : deployAppMetadata.getDesignMetas()) {
                if (designMeta instanceof DesignAppMeta) {
                    this.designAppMeta = (DesignAppMeta)designMeta;
                    xml = designMeta.getDataXml();
                    continue;
                }
                if (!(designMeta instanceof DesignAppMetaL)) continue;
                this.designAppMetaL = (DesignAppMetaL)designMeta;
                xml = designMeta.getDataXml();
            }
        }
        this.serializer = new MetadataSerializer("AppModel", true);
        this.handleFormMetadata(this.serializer, xml);
    }

    private void handleFormMetadata(MetadataSerializer serializer, String xml) {
        if (xml != null) {
            this.appMetadata = (AppMetadata)this.getMetadata(serializer, xml);
            this.baseAppMetadata = (AppMetadata)this.getBaseMetadata(serializer, xml);
        }
    }

    private AbstractMetadata readBaseMetadata(AbstractMetadata metadata) {
        MetadataReader reader = new MetadataReader();
        String devType = this.getType(metadata, "app");
        if (StringUtils.isBlank((CharSequence)devType)) {
            throw new RuntimeException(String.format("appId %s type is blank", metadata.getId()));
        }
        boolean isOriForm = !"2".equals(devType);
        reader.setFillExtends(isOriForm);
        return reader.readMeta(metadata.getParentId(), metadata.getDesingerMetaType(), false, true);
    }

    private Object getBaseMetadata(MetadataSerializer serializer, String xml) {
        AbstractMetadata sourceMeta = (AbstractMetadata)serializer.deserializeFromXml(xml, null);
        if (StringUtils.isBlank((CharSequence)sourceMeta.getParentId())) {
            return null;
        }
        return this.readBaseMetadata(sourceMeta);
    }

    private Object getMetadata(MetadataSerializer serializer, String xml) {
        AbstractMetadata sourceMeta = (AbstractMetadata)serializer.deserializeFromXml(xml, null);
        if (StringUtils.isBlank((CharSequence)sourceMeta.getParentId())) {
            return sourceMeta;
        }
        AbstractMetadata sourceBaseMetadata = this.readBaseMetadata(sourceMeta);
        return serializer.deserializeFromXml(xml, sourceBaseMetadata);
    }
}

