/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service;

import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.instance.Instance;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class ServiceFactory {
    private static Map<String, String> serviceMap = new HashMap<String, String>();
    private static Log log = LogFactory.getLog((String)"ServiceFactory");
    private static final ThreadLocal<Map<String, Object>> serviceInstanceMap = new ThreadLocal();

    public static <T> T getService(Class<T> clazz) {
        String key = clazz.getSimpleName();
        if (serviceInstanceMap.get() != null && serviceInstanceMap.get().containsKey(key)) {
            return (T)serviceInstanceMap.get().get(key);
        }
        return (T)ServiceFactory.getService(key);
    }

    public static void putService(String serviceName, String serviceImpl) {
        serviceMap.put(serviceName, serviceImpl);
    }

    public static Object getService(String serviceName) {
        String className = serviceMap.get(serviceName);
        if (className == null) {
            String appName = Instance.getAppName();
            throw new RuntimeException(String.format(ResManager.loadKDString((String)"%1$s\u5bf9\u5e94\u7684\u670d\u52a1\u5b9e\u73b0\u5728%2$s\u672a\u627e\u5230", (String)"ServiceFactory_0", (String)"bos-core-api", (Object[])new Object[0]), serviceName, appName));
        }
        return TypesContainer.getOrRegisterSingletonInstance((String)className);
    }

    static {
        serviceMap.put("DesignMetadataService", "kd.bos.service.metadata.design.DesignMetadataServiceImpl");
        serviceMap.put("DebugMetadataService", "kd.bos.service.metadata.DebugMetadataServiceImpl");
        serviceMap.put("MetaTemplateService", "kd.bos.mservice.metatemplate.MetaTemplateServiceImpl");
        serviceMap.put("MetadataService", "kd.bos.service.metadata.MetadataServiceImpl");
        serviceMap.put("FormService", "kd.bos.mservice.form.FormServiceImpl");
        serviceMap.put("CardService", "kd.bos.service.card.CardServiceImpl");
        serviceMap.put("NotificationFormService", "kd.bos.mservice.notification.NotificationFormServiceImpl");
        serviceMap.put("SchTaskFormService", "kd.bos.mservice.task.SchTaskFormServiceImpl");
        serviceMap.put("FormConfigService", "kd.bos.mservice.form.FormServiceImpl");
        serviceMap.put("OperationService", "kd.bos.service.operation.OperationServiceImpl");
        serviceMap.put("OperationWebApi", "kd.bos.mservice.form.OperationWebApiImpl");
        serviceMap.put("DeployService", "kd.bos.service.upgrade.DeployServiceImpl");
        serviceMap.put("MQDeployService", "kd.bos.service.upgrade.MQDeployServiceImpl");
        serviceMap.put("UnitTestService", "kd.bos.mservice.form.unittest.UnitTestServiceImpl");
        serviceMap.put("DevPortalService", "kd.bos.devportal.service.DevPortalServiceImpl");
        serviceMap.put("QueryService", "kd.bos.mservice.query.QueryServiceImpl");
        serviceMap.put("PrintService", "kd.bos.mservice.print.PrintServiceImp");
        serviceMap.put("PermissionService", "kd.bos.permission.service.PermissionServiceImpl");
        serviceMap.put("INoCodePermissionService", "kd.bos.permission.nocode.service.NoCodePermissionServiceImpl");
        serviceMap.put("ICorePermissionService", "kd.bos.permission.service.PermissionServiceImpl");
        serviceMap.put("IUserService", "kd.bos.permission.service.UserServiceImpl");
        serviceMap.put("PatchService", "kd.bos.service.upgrade.PatchServiceImpl");
        serviceMap.put("IOrgService", "kd.bos.org.service.OrgService");
        serviceMap.put("ICodeRuleService", "kd.bos.coderule.service.CodeRuleServiceImp");
        serviceMap.put("ICoreCodeRuleService", "kd.bos.coderule.service.CodeRuleServiceImp");
        serviceMap.put("BizAppService", "kd.bos.devportal.service.BizAppServiceImpl");
        serviceMap.put("BizUnitService", "kd.bos.devportal.service.BizUnitServiceImpl");
        serviceMap.put("IWorkflowService", "kd.bos.workflow.service.impl.WorkflowServiceImpl");
        serviceMap.put("IEventService", "kd.bos.workflow.service.impl.WorkflowServiceImpl");
        serviceMap.put("BizScriptService", "kd.bos.devportal.service.BizScriptServiceImpl");
        serviceMap.put("BizCloudService", "kd.bos.devportal.service.BizCloudServiceImpl");
        serviceMap.put("IMessageService", "kd.bos.message.service.MessageServiceImpl");
        serviceMap.put("SchemeService", "kd.bos.smc.service.SchemeServiceImpl");
        serviceMap.put("ConvertService", "kd.bos.service.botp.ConvertServiceImpl");
        serviceMap.put("BFTrackerService", "kd.bos.service.botp.BFTrackerServiceImpl");
        serviceMap.put("ICtConvertService", "kd.bos.service.ctbotp.convert.CtConvertServiceImpl");
        serviceMap.put("ICtSaveService", "kd.bos.service.ctbotp.save.CtSaveServiceImpl");
        serviceMap.put("ICtSyncService", "kd.bos.service.ctbotp.sync.CtSyncServiceImpl");
        serviceMap.put("ReportService", "kd.bos.mservice.report.ReportServiceImpl");
        serviceMap.put("JobDispatcher", "kd.bos.schedule.serviceImpl.JobDispatcherImpl");
        serviceMap.put("ScheduleManager", "kd.bos.schedule.serviceImpl.ScheduleManagerImpl");
        serviceMap.put("ServerManager", "kd.bos.schedule.serviceImpl.ServerManagerImpl");
        serviceMap.put("IScheduleDeployService", "kd.bos.schedule.service.ScheduleDeployServiceImpl");
        serviceMap.put("ManageService", "kd.bos.smc.service.ManageServiceImpl");
        serviceMap.put("OperationWebApi", "kd.bos.mservice.form.OperationWebApiImpl");
        serviceMap.put("DebugService", "kd.bos.mservice.serverscript.debug.DebugServiceImpl");
        serviceMap.put("ImageService", "kd.bos.imageplatform.service.ImageServiceImpl");
        serviceMap.put("ILogService", "kd.bos.log.service.LogServiceImpl");
        serviceMap.put("IBizModifyDirtyManager", "kd.bos.mservice.bizlog.BizModifyDirtyManager");
        serviceMap.put("IBizModifyQueryService", "kd.bos.mservice.bizlog.BizModifyQueryService");
        serviceMap.put("IInteService", "kd.bos.inte.service.InteServiceImpl");
        serviceMap.put("ILicenseService", "kd.bos.license.service.LicenseServiceImpl");
        serviceMap.put("ICoreLicenseService", "kd.bos.license.service.LicenseServiceImpl");
        serviceMap.put("ILicenseGrayService", "kd.bos.license.service.LicenseGrayServiceImpl");
        serviceMap.put("IMessageCenterService", "kd.bos.workflow.message.service.impl.MessageCenterServiceImpl");
        serviceMap.put("DataMutexService", "kd.bos.mutex.impl.DataMutexImpl");
        serviceMap.put("HealthValidateService", "kd.bos.mservice.healthvalidate.HealthValidateServiceImpl");
        serviceMap.put("QingService", "kd.bos.mservice.qing.QingServiceImpl");
        serviceMap.put("QingServerRequestDispatcher", "kd.bos.mservice.qing.QingServerRequestDispatcherImpl");
        serviceMap.put("QingLicenseService", "kd.bos.mservice.qing.QingLicenseServiceImpl");
        serviceMap.put("ApiService", "kd.bos.service.webapi.ApiServiceImpl");
        serviceMap.put("SystemParamService", "kd.bos.mservice.sysparam.SystemParamServiceImpl");
        serviceMap.put("EarlyWarnService", "kd.bos.service.earlywarn.EarlyWarnServiceImpl");
        serviceMap.put("WarnScheduleFormService", "kd.bos.mservice.earlywarn.WarnScheduleFormServiceImpl");
        serviceMap.put("RunModeService", "kd.bos.mservice.runmode.RunModeServiceImpl");
        serviceMap.put("IAttachmentService", "kd.bos.service.attachment.AttachmentServiceImpl");
        serviceMap.put("IAttachmentOperateService", "kd.bos.service.attachment.AttachmentOperateServiceImpl");
        serviceMap.put("IImageOperateService", "kd.bos.service.image.ImageOperateServiceImpl");
        serviceMap.put("IImageService", "kd.bos.service.image.ImageServiceImpl");
        serviceMap.put("AdminOrgFreezeChecker", "kd.bos.org.service.AdminOrgFreezeChecker");
        serviceMap.put("BDCtrlStrategeDutyChecker", "kd.bos.org.service.BDCtrlStrategeDutyChecker");
        serviceMap.put("OrgRelationDutyChecker", "kd.bos.org.service.OrgRelationDutyChecker");
        serviceMap.put("AsyncOpBizRuleActionService", "kd.bos.service.operation.bizrule.asyncbizrule.AsyncOpBizRuleActionServiceImpl");
        serviceMap.put("MetadataLogService", "kd.bos.service.metadata.log.MetadataLogServiceImpl");
        serviceMap.put("ProductSettingService", "kd.bos.productmodel.ProductSettingServiceImpl");
        serviceMap.put("ICoreProductSettingService", "kd.bos.productmodel.ProductSettingServiceImpl");
        serviceMap.put("ScriptUpgradeService", "kd.bos.service.upgrade.ScriptUpgradeServiceImpl");
        serviceMap.put("ApiSwaggerService", "kd.bos.service.webapi.ApiSwaggerServiceImpl");
        serviceMap.put("IAttachmentManagerService", "kd.bos.service.attachment.AttachmentManagerService");
        serviceMap.put("IBaseMessageService", "kd.bos.message.service.BaseMessageServiceImpl");
        serviceMap.put("JarDeployService", "kd.bos.service.upgrade.JarDeployServiceImpl");
        serviceMap.put("IBaseDataService", "kd.bos.basedata.service.BaseDataServiceImpl");
        serviceMap.put("IAssistantDataService", "kd.bos.basedata.service.AssistantDataServiceImpl");
        serviceMap.put("AisEntityService", "kd.bos.ais.mservice.AisEntityServiceImpl");
        serviceMap.put("GetPromptWordService", "kd.bos.inte.service.helper.GetPromptWordService");
        serviceMap.put("ApplyPromptWordService", "kd.bos.inte.service.helper.ApplyPromptWordService");
        serviceMap.put("importService", "kd.bos.form.plugin.impt.ImportService");
        serviceMap.put("BosPrintBusinessService", "kd.bos.print.business.service.BosPrintBusinessServiceImpl");
        serviceMap.put("BosPrintService", "kd.bos.print.service.BosPrintServiceImpl");
        serviceMap.put("IPrintService", "kd.bos.mservice.print.PrintServiceImp");
        serviceMap.put("IExportService", "kd.bos.mservice.svc.expt.ExportServiceImpl");
        serviceMap.put("IEarlyWarnProxy", "kd.bos.mservice.svc.earlywarn.EarlyWarnProxyImpl");
        serviceMap.put("IWaterMarkProxy", "kd.bos.mservice.svc.watermark.WaterMarkProxyImpl");
        serviceMap.put("IAttachmentModelProxy", "kd.bos.mservice.svc.attach.AttachmentModelProxyImpl");
        serviceMap.put("IAttachmentFieldModelProxy", "kd.bos.mservice.svc.attach.AttachmentFieldModelProxyImpl");
        serviceMap.put("IAttachmentMetaProxy", "kd.bos.mservice.svc.attach.AttachmentMetaProxyImpl");
        serviceMap.put("IPictureMetaProxy", "kd.bos.mservice.svc.picture.PictureMetaProxyImpl");
        serviceMap.put("IAddressService", "kd.bos.i18n.mservice.impl.AddressServiceImpl");
        serviceMap.put("ICalendarService", "kd.bos.i18n.mservice.impl.CalendarServiceImpl");
        serviceMap.put("IIdentityService", "kd.bos.i18n.mservice.impl.IdentityServiceImpl");
        serviceMap.put("IExchangeRateService", "kd.bos.i18n.mservice.impl.ExchangeRateServiceImpl");
        serviceMap.put("ITaxNumberService", "kd.bos.i18n.mservice.impl.TaxNumberServiceImpl");
        serviceMap.put("GetPromptService", "kd.bos.inte.service.helper.GetPromptServiceImpl");
        serviceMap.put("PortalService", "kd.bos.mservice.portal.PortalServiceImpl");
        serviceMap.put("PluginFormService", "kd.bos.mservice.plugin.PluginFormServiceImpl");
        serviceMap.put("IWorkingPlanService", "kd.bos.i18n.mservice.impl.WorkingPlanServiceImpl");
        serviceMap.put("DMDeployService", "kd.bos.service.domaindefine.DMDeployServiceImpl");
        serviceMap.put("BaseDataControllerService", "kd.bos.mservice.basedata.BaseDataControllerServiceImpl");
        serviceMap.put("RuntimeMetadataShareService", "kd.bos.service.sharemeta.RuntimeMetadataShareServiceImpl");
        serviceMap.put("IAdminDivisionService", "kd.bos.i18n.mservice.impl.AdminDivisionServiceImpl");
        serviceMap.put("TelephoneService", "kd.bos.i18n.mservice.impl.TelephoneServiceImpl");
        serviceMap.put("IDevService", "kd.bos.devportal.service.DevServiceImpl");
        serviceMap.put("RuntimeFlexMetaService", "kd.bos.service.metadata.RuntimeFlexMetaServiceImpl");
        serviceMap.put("IAmountConvertService", "kd.bos.i18n.mservice.impl.AmountConvertServiceImpl");
        serviceMap.put("IPrivacyEnableQueryService", "kd.bos.privacy.service.PrivacyEnableQueryService");
        serviceMap.put("EncryptSchemeService", "kd.bos.permission.service.scheme.DefEncryptSchemeServiceImpl");
        serviceMap.put("IISVService", "kd.bos.isv.ISVService");
        serviceMap.put("IExtLoginConfigService", "kd.bos.portal.service.ExtLoginConfigService");
        serviceMap.put("NoCodeMetadataService", "kd.bos.service.metadata.NoCodeMetadataServiceImpl");
        serviceMap.put("NoCodeRuntimeService", "kd.bos.service.nocode.NoCodeRuntimeServiceImpl");
        serviceMap.put("INoCodeWorkflowService", "kd.bos.workflow.service.impl.NoCodeWorkflowServiceImpl");
        serviceMap.put("ListService", "kd.bos.mservice.list.ListServiceImpl");
        serviceMap.put("kd.bos.mservice.list.ListColumnCompareService", "kd.bos.mvc.list.service.ListColumnCompareServiceImpl");
        serviceMap.put("IFlowService", "kd.bos.service.kingflow.KFlowEmptyImpl");
        serviceMap.put("IFlowDesignService", "kd.bos.service.kingflow.KFlowDesignEmptyImpl");
        serviceMap.put("IGPTService", "kd.bos.form.gpt.GPTServiceImpl");
        serviceMap.put("KsCallBackService", "kd.bos.devportal.service.KsCallBackServiceImpl");
        serviceMap.put("IGPTScriptService", "kd.bos.devportal.script.npm.gpt.GPTScriptServiceImpl");
        serviceMap.put("QACallBackService", "kd.bos.gptas.qa.service.QACallBackServiceImpl");
        serviceMap.put("IHotTipsService", "kd.bos.service.tips.HotTipsServiceImpl");
        serviceMap.put("InitailVersionService", "kd.bos.portal.service.InitailVersionServiceImpl");
        serviceMap.put("ILoginUserService", "kd.bos.login.service.impl.LoginUserServiceImpl");
        serviceMap.put("INewPortalService", "kd.bos.portal.service.impl.NewPortalSettingServiceImpl");
        serviceMap.put("IHandWrittenSignService", "kd.bos.portal.service.impl.HandWrittenSignServiceImpl");
        serviceMap.put("ReportExportServiceImpl", "kd.bos.mvc.report.export.ReportExportServiceImpl");
        serviceMap.put("IMCUploadFileService", "kd.bos.portal.service.impl.MCUploadFileServiceImpl");
        serviceMap.put("EmbeddingService", "kd.bos.gptas.embedding.EmbeddingServiceImpl");
        serviceMap.put("ICtsyBaseService", "kd.bos.base.ctsy.service.CtsyBaseServiceImpl");
        serviceMap.put("ICtsyApiDispatchService", "kd.bos.service.ctsy.CtsyApiDispatchServiceImpl");
        serviceMap.put("ICtsyMetadataService", "kd.bos.service.metadata.CtsyMetadataServiceImpl");
        serviceMap.put("DynamicPluginService", "kd.bos.service.dynplugin.DynamicPluginServiceImpl");
        serviceMap.put("IOnlineSessionService", "kd.bos.smc.user.service.impl.OnlineSessionServiceImpl");
        serviceMap.put("CloudCommunityService", "kd.bos.login.service.Impl.CommunityuserServiceImpl");
        serviceMap.put("ScriptLibService", "kd.sdk.bos.service.ScriptLibServiceImpl");
        serviceMap.put("ScriptService", "kd.bos.kingscript.openapi.development.ScriptService");
        serviceMap.put("ChatCallback", "kd.bos.gptas.agent.llm.callback.ChatCallbackProxy");
        serviceMap.put("DevAssistantService", "kd.bos.gptas.agent.DevAssistantServiceImpl");
    }
}

