/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.list.query;

import java.util.ArrayList;
import java.util.List;
import kd.bos.data.BusinessDataWriter;
import kd.bos.data.PkSnapshotFactory;
import kd.bos.dataentity.entity.PkSnapshotSet;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.filter.FilterScheme;
import kd.bos.entity.filter.FilterSchemeL;
import kd.bos.entity.filter.LocaleFilterScheme;
import kd.bos.entity.filter.SchemeShareUser;
import kd.bos.entity.filter.ShareFilterScheme;
import kd.bos.exception.KDBizException;
import kd.bos.list.query.SchemeQuery;
import kd.bos.orm.datamanager.DataEntityCacheManager;

public class SchemeWriter {
    private static final String BOSBUSINESSDAO = "bos-business-dao";

    private SchemeWriter() {
    }

    private static void checkFilterSchemeNull(FilterScheme fScheme) {
        if (fScheme == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u65b9\u6848\u5df2\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u3002", (String)"SchemeWriter_0", (String)BOSBUSINESSDAO, (Object[])new Object[0]));
        }
    }

    public static void shareScheme(String schemeid) {
        SchemeQuery schemeQuery = new SchemeQuery();
        FilterScheme scheme = schemeQuery.getScheme(schemeid);
        SchemeWriter.checkFilterSchemeNull(scheme);
        if (!scheme.isShare()) {
            SchemeWriter.copyIDToSchemeId(schemeid, schemeQuery);
            scheme.setShare(true);
            DataEntityType dataEntityType = (DataEntityType)OrmUtils.getDataEntityType(FilterScheme.class);
            PkSnapshotSet pkSnapshotSet = new PkSnapshotSet();
            pkSnapshotSet.Snapshots.add(PkSnapshotFactory.createDataEntitiesSnapshot(dataEntityType, scheme));
            dataEntityType.setPkSnapshot((Object)scheme, pkSnapshotSet);
            BusinessDataWriter.save((IDataEntityType)dataEntityType, new FilterScheme[]{scheme});
        }
    }

    public static void deleteShareScheme(long shareSchemeId) {
        SchemeQuery schemeQuery = new SchemeQuery();
        ShareFilterScheme sharedScheme = schemeQuery.getSharedScheme(shareSchemeId);
        FilterScheme scheme = null;
        if (sharedScheme.getId() != 0L) {
            scheme = schemeQuery.getScheme(sharedScheme.getSchemeId());
            SchemeWriter.checkFilterSchemeNull(scheme);
        }
        if (scheme != null) {
            scheme.setShare(false);
            DataEntityType dataEntityType = (DataEntityType)OrmUtils.getDataEntityType(FilterScheme.class);
            PkSnapshotSet pkSnapshotSet = new PkSnapshotSet();
            pkSnapshotSet.Snapshots.add(PkSnapshotFactory.createDataEntitiesSnapshot(dataEntityType, scheme));
            dataEntityType.setPkSnapshot((Object)scheme, pkSnapshotSet);
            BusinessDataWriter.save((IDataEntityType)dataEntityType, new FilterScheme[]{scheme});
            List<SchemeShareUser> schemeShareUsers = schemeQuery.getSchemeShareUsers(shareSchemeId);
            ArrayList<Long> schemeShareUserIds = new ArrayList<Long>(10);
            for (SchemeShareUser schemeShareUser : schemeShareUsers) {
                schemeShareUserIds.add(schemeShareUser.getPkId());
            }
            BusinessDataWriter.delete(OrmUtils.getDataEntityType(ShareFilterScheme.class), new Object[]{shareSchemeId});
            BusinessDataWriter.delete(OrmUtils.getDataEntityType(SchemeShareUser.class), schemeShareUserIds.toArray());
        }
    }

    public static void copyIDToSchemeId(String schemeid) {
        SchemeWriter.copyIDToSchemeId(schemeid, new SchemeQuery());
    }

    private static void copyIDToSchemeId(String schemeid, SchemeQuery schemeQuery) {
        FilterScheme scheme = schemeQuery.getScheme(schemeid);
        SchemeWriter.checkFilterSchemeNull(scheme);
        LocaleFilterScheme schemeL = schemeQuery.getSchemeL(schemeid);
        for (FilterSchemeL filterSchemeL : schemeL.values()) {
            if (!StringUtils.isBlank((CharSequence)filterSchemeL.getSchemeId())) continue;
            filterSchemeL.setSchemeId(schemeid);
            SchemeWriter.saveFilterSchemeL(filterSchemeL);
            SchemeWriter.clearFilterSchemeCache(scheme);
        }
    }

    private static void clearFilterSchemeCache(FilterScheme filterScheme) {
        DataEntityType dataEntityType = (DataEntityType)OrmUtils.getDataEntityType(FilterScheme.class);
        DataEntityCacheManager cacheManager = new DataEntityCacheManager((IDataEntityType)dataEntityType);
        cacheManager.removeByPrimaryKey(new Object[]{filterScheme.getId()});
    }

    private static void saveFilterSchemeL(FilterSchemeL filterSchemeL) {
        DataEntityType dataEntityType = (DataEntityType)OrmUtils.getDataEntityType(FilterSchemeL.class);
        PkSnapshotSet pkSnapshotSet = new PkSnapshotSet();
        pkSnapshotSet.Snapshots.add(PkSnapshotFactory.createDataEntitiesSnapshot(dataEntityType, filterSchemeL));
        dataEntityType.setPkSnapshot((Object)filterSchemeL, pkSnapshotSet);
        BusinessDataWriter.save((IDataEntityType)dataEntityType, new FilterSchemeL[]{filterSchemeL});
    }
}

