/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.list.query.impl;

import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.entity.QueryEntityType;
import kd.bos.entity.datamodel.ListField;
import kd.bos.entity.list.QueryBuilder;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.orm.ORM;
import kd.bos.orm.query.Distinctable;
import kd.bos.orm.query.WithEntityEntryDistinctable;
import kd.bos.xdb.QueryTimeout;

public class CountQuery {
    private CountQuery() {
    }

    public static boolean isExceedMaxCount(QueryBuilder queryBuilder) {
        queryBuilder.setExceedMaxCount(true);
        return CountQuery.getCount(queryBuilder) > queryBuilder.getMaxReturnData();
    }

    public static int getCount(QueryBuilder queryBuilder) {
        if (queryBuilder.getEntityType() instanceof QueryEntityType) {
            QueryEntityType qet = (QueryEntityType)queryBuilder.getEntityType();
            return qet.getQueryDataCount(queryBuilder, queryBuilder.getSelectFields());
        }
        if (queryBuilder.getEntityType() != null) {
            int count;
            if (queryBuilder.getPkFields().isEmpty()) {
                throw new KDException(new ErrorCode("CountQuery.getCount.pkFieldsEmpty", "PK fields is empty"), new Object[0]);
            }
            ORM orm = ORM.create();
            StringBuilder selectFileds = new StringBuilder();
            for (ListField field : queryBuilder.getPkFields()) {
                selectFileds.append(field.getFieldName());
                selectFileds.append(',');
            }
            orm.setDataEntityType(queryBuilder.getEntityName(), queryBuilder.getEntityType());
            try (QueryTimeout timeout = DB.timeout((int)queryBuilder.getTimeOutSecends());){
                count = !queryBuilder.isExceedMaxCount() ? orm.count(queryBuilder.getEntityType().getDBRouteKey(), queryBuilder.getEntityType().getName(), selectFileds.substring(0, selectFileds.length() - 1), queryBuilder.getFilters(), (Distinctable)WithEntityEntryDistinctable.get()) : orm.count(queryBuilder.getEntityType().getDBRouteKey(), queryBuilder.getEntityType().getName(), selectFileds.substring(0, selectFileds.length() - 1), queryBuilder.getFilters(), (Distinctable)WithEntityEntryDistinctable.get(), queryBuilder.getMaxReturnData() + 1);
            }
            catch (KDException e) {
                if (e.getErrorCode() == BosErrorCode.sQLRWTimeOut) {
                    throw new KDBizException(e.getErrorCode(), new Object[]{ResManager.loadKDString((String)"\u603b\u6761\u6570\u8ba1\u7b97\u8d85\u65f6\uff0c\u8bf7\u5c1d\u8bd5\u7f29\u5c0f\u67e5\u8be2\u8303\u56f4\u3002", (String)"CountQuery_0", (String)"bos-dao", (Object[])new Object[0])});
                }
                throw e;
            }
            return count;
        }
        return 0;
    }

    public static int getBillDataCount(QueryBuilder queryBuilder) {
        if (queryBuilder.getEntityType() != null) {
            ORM orm = ORM.create();
            orm.setDataEntityType(queryBuilder.getEntityName(), queryBuilder.getEntityType());
            return orm.count(queryBuilder.getEntityType().getDBRouteKey(), queryBuilder.getEntityType().getName(), ((ListField)queryBuilder.getPkFields().get(0)).getFieldName(), queryBuilder.getFilters(), (Distinctable)WithEntityEntryDistinctable.get());
        }
        return 0;
    }
}

