/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.list.query.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kd.bos.algo.Algo;
import kd.bos.algo.CacheHint;
import kd.bos.algo.CachedDataSet;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.dataset.cache.CachedDataSetBuilder;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.entity.cache.CacheKeyUtil;
import kd.bos.entity.list.QueryBuilder;
import kd.bos.entity.list.QueryResult;
import kd.bos.entity.list.SummaryResult;
import kd.bos.list.query.DBCostCache;
import kd.bos.list.query.QueryUtils;
import kd.bos.util.ConfigurationUtil;

public class DataSetIdCache
implements DBCostCache {
    @Override
    public void cacheData(String pageId, DataSet ds) {
        DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("form-pagecache", new DistributeCacheHAPolicy(true, true));
        int timeout = CacheKeyUtil.getPageCacheKeyTimeout();
        CacheHint cacheHint = new CacheHint();
        cacheHint.setPageSize(ConfigurationUtil.getInteger((String)"bos.billlist.pagesize", (Integer)1000).intValue());
        cacheHint.setTimeout((long)timeout, TimeUnit.SECONDS);
        CachedDataSetBuilder cacheBuilder = new CachedDataSetBuilder(ds.getRowMeta(), cacheHint, this.getClass().getSimpleName() + ".cacheData.dataset");
        cacheBuilder.append(ds.iterator());
        CachedDataSet cds = cacheBuilder.build();
        if (!"run".equals(cache.get(pageId + "BILLLIST_cacheState"))) {
            cds.close();
        } else {
            cache.put(pageId, (Object)cds.getCacheId(), timeout, TimeUnit.SECONDS);
        }
    }

    @Override
    public void cacheData(String pageId, List<Row> rows, RowMeta rowMeta) {
        DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("form-pagecache", new DistributeCacheHAPolicy(true, true));
        int timeout = CacheKeyUtil.getPageCacheKeyTimeout();
        CacheHint cacheHint = new CacheHint();
        cacheHint.setPageSize(ConfigurationUtil.getInteger((String)"bos.billlist.pagesize", (Integer)1000).intValue());
        cacheHint.setTimeout((long)timeout, TimeUnit.SECONDS);
        CachedDataSetBuilder cacheBuilder = new CachedDataSetBuilder(rowMeta, cacheHint, this.getClass().getSimpleName() + ".cacheData.rows");
        cacheBuilder.append(rows.iterator());
        CachedDataSet cds = cacheBuilder.build();
        cache.put(pageId, (Object)cds.getCacheId(), timeout, TimeUnit.SECONDS);
    }

    @Override
    public void cacheData(String pageId, String msg) {
        DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("form-pagecache", new DistributeCacheHAPolicy(true, true));
        int timeout = CacheKeyUtil.getPageCacheKeyTimeout();
        cache.put(pageId, (Object)msg, timeout, TimeUnit.SECONDS);
    }

    @Override
    public void cacheData(String cacheKey, Map<String, String> map) {
        DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("form-pagecache", new DistributeCacheHAPolicy(true, true));
        int timeout = CacheKeyUtil.getPageCacheKeyTimeout();
        cache.put(cacheKey, map, timeout, TimeUnit.SECONDS);
    }

    @Override
    public String getCacheMsg(String pageId) {
        DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("form-pagecache", new DistributeCacheHAPolicy(true, true));
        return (String)cache.get(pageId);
    }

    @Override
    public QueryResult getCacheData(String cacheId, QueryBuilder queryBuilder) {
        CachedDataSet cds = Algo.getCacheDataSet((String)cacheId);
        QueryUtils queryUtils = new QueryUtils(queryBuilder);
        return queryUtils.getQueryResult((Iterator<Row>)cds.iterator(0, queryBuilder.getStart() + queryBuilder.getLimit()), cds.getRowMeta(), false);
    }

    @Override
    public int getCacheCount(String cacheId) {
        CachedDataSet cds = Algo.getCacheDataSet((String)cacheId);
        return cds.getRowCount();
    }

    @Override
    public Map<String, String> getCacheMap(String cacheKey) {
        DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("form-pagecache", new DistributeCacheHAPolicy(true, true));
        return cache.getAll(cacheKey);
    }

    @Override
    public void cacheSumResults(List<SummaryResult> sumResults, String cacheId) {
        HashMap<String, String> sumResultsMap = new HashMap<String, String>(16);
        int indexFlag = 0;
        for (SummaryResult sumResult : sumResults) {
            sumResultsMap.put("BILLLIST_sumResults" + indexFlag, QueryUtils.objToStr(sumResult));
            ++indexFlag;
        }
        this.cacheData(cacheId, sumResultsMap);
    }

    @Override
    public List<SummaryResult> getCacheSumResults(String cacheId) {
        DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("form-pagecache", new DistributeCacheHAPolicy(true, true));
        ArrayList<SummaryResult> sumResults = new ArrayList<SummaryResult>(16);
        Map sumCacheMap = cache.getAll(cacheId);
        for (Map.Entry entry : sumCacheMap.entrySet()) {
            sumResults.add((SummaryResult)QueryUtils.strToObj((String)entry.getValue()));
        }
        return sumResults;
    }

    @Override
    public List<Row> getCacheDataRows(String cacheId, QueryBuilder queryBuilder) {
        CachedDataSet cds = Algo.getCacheDataSet((String)cacheId);
        return cds.getList(queryBuilder.getStart(), queryBuilder.getLimit());
    }
}

