/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.list.query.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import kd.bos.algo.Algo;
import kd.bos.algo.CacheHint;
import kd.bos.algo.CachedDataSet;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.RowMetaFactory;
import kd.bos.algo.RowUtil;
import kd.bos.algo.dataset.AbstractRow;
import kd.bos.algo.dataset.RowFactory;
import kd.bos.algo.dataset.cache.CachedDataSetBuilder;
import kd.bos.algo.util.ArrayKey;
import kd.bos.algo.util.bitset.BitSetFactory;
import kd.bos.algo.util.bitset.LongBitSet;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.NumberFormatProvider;
import kd.bos.entity.QueryEntityType;
import kd.bos.entity.cache.CacheKeyUtil;
import kd.bos.entity.datamodel.FmtField;
import kd.bos.entity.datamodel.ListField;
import kd.bos.entity.datamodel.NumberPrecision;
import kd.bos.entity.list.QueryBuilder;
import kd.bos.entity.list.SummaryResult;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.LongProp;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.exception.XDBErrorCode;
import kd.bos.ksql.util.StringUtil;
import kd.bos.list.query.DBCostCache;
import kd.bos.list.query.DBCostCacheFactory;
import kd.bos.list.query.Mapper;
import kd.bos.list.query.PageRowCacheUtils;
import kd.bos.list.query.QueryUtils;
import kd.bos.list.query.impl.DataSetMapper;
import kd.bos.list.query.impl.Query;
import kd.bos.orm.ORM;
import kd.bos.orm.impl.ORMConfiguration;
import kd.bos.orm.query.Distinctable;
import kd.bos.orm.query.ORMException;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.query.WithEntityEntryDistinctable;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.thread.ThreadLifeCycleManager;
import kd.bos.util.ConfigurationUtil;
import kd.bos.xdb.QueryTimeout;

public class IdQuery
extends Query {
    protected static DBCostCache ics = DBCostCacheFactory.createCache();
    private Map<String, String> idCacheMap;
    private List<SummaryResult> cacheSummaryResultList = new ArrayList<SummaryResult>();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public DynamicObjectCollection getData(QueryBuilder queryBuilder) {
        try (QueryTimeout timeout = DB.timeout((int)queryBuilder.getTimeOutSecends());){
            DynamicObjectCollection dynamicObjectCollection = this.getResult(queryBuilder);
            return dynamicObjectCollection;
        }
        catch (KDException e) {
            if (e.getErrorCode() == BosErrorCode.sQLRWTimeOut) {
                throw new KDBizException(e.getErrorCode(), new Object[]{ResManager.loadKDString((String)"\u67e5\u8be2\u8d85\u65f6\uff0c\u8bf7\u5c1d\u8bd5\u7f29\u5c0f\u67e5\u8be2\u8303\u56f4\u3002", (String)"IdQuery_0", (String)"bos-dao", (Object[])new Object[0])});
            }
            if (e.getErrorCode() == XDBErrorCode.exceedShardingTableQueryLimit) {
                throw new KDBizException(e.getErrorCode(), new Object[]{ResManager.loadKDString((String)"\u67e5\u8be2\u6570\u636e\u8303\u56f4\u8fc7\u5927\uff0c\u8bf7\u5c1d\u8bd5\u7f29\u5c0f\u67e5\u8be2\u8303\u56f4\u3002", (String)"IdQuery_1", (String)"bos-dao", (Object[])new Object[0])});
            }
            if (e.getErrorCode() == ORMException.excessiveInParameters) {
                throw new KDBizException(e.getErrorCode(), new Object[]{ResManager.loadKDString((String)"\u67e5\u8be2\u6570\u636e\u8303\u56f4\u8fc7\u5927\uff0c\u8bf7\u5c1d\u8bd5\u7f29\u5c0f\u67e5\u8be2\u8303\u56f4\u3002", (String)"LimitInSize_0", (String)"bos-dao", (Object[])new Object[0])});
            }
            if (e.getErrorCode() != BosErrorCode.tableNotDefined) throw e;
            throw new KDBizException(e.getErrorCode(), new Object[]{ResManager.loadKDString((String)"\u6ca1\u6709\u7ef4\u62a4\u5b9e\u4f53\u5c5e\u6027\u4e2d\u7684\u8868\u540d\uff0c\u4e0d\u80fd\u9884\u89c8\u3002", (String)"IdQuery_2", (String)"bos-dao", (Object[])new Object[0])});
        }
    }

    private DynamicObjectCollection getResult(QueryBuilder queryBuilder) {
        this.idCacheMap = new HashMap<String, String>();
        String cacheKey = PageRowCacheUtils.getCacheKey();
        Map<String, String> allCachemap = ics.getCacheMap(cacheKey);
        String controlKey = PageRowCacheUtils.getControlKey();
        String mapKeyPrfix = StringUtil.isEmpty((String)controlKey) ? "" : controlKey;
        PageRowCacheUtils.touchFlag();
        if (this.isCache(allCachemap, mapKeyPrfix)) {
            String cacheId = allCachemap.get(mapKeyPrfix + "BILLLIST_cacheId");
            CachedDataSet cds = Algo.getCacheDataSet((String)cacheId);
            int rowCount = cds.getRowCount();
            int start = queryBuilder.getStart();
            String bdcMsg = allCachemap.get(mapKeyPrfix + "BILLLIST_billDataCount");
            int billDataCount = StringUtil.isEmpty((String)bdcMsg) ? 0 : Integer.parseInt(bdcMsg);
            DynamicObjectCollection collection = null;
            if (start >= rowCount) {
                collection = new DynamicObjectCollection(queryBuilder.getReturnEntityType(), null);
            } else {
                List<Object> sortLs = cds.getList(start, queryBuilder.getLimit());
                try (DataSet ds = this.getDataSetByPks(queryBuilder, (List<Row>)sortLs);){
                    List<Object> dsLs = queryBuilder.isNeedResum() ? this.dataSetToRowList(mapKeyPrfix, ds, queryBuilder, false) : this.dataSetToRowList(ds);
                    collection = this.getDynamicCollection((List<Row>)dsLs, (List<Row>)(queryBuilder.isNeedResum() ? dsLs : sortLs), ds.getRowMeta(), queryBuilder);
                    if (!queryBuilder.isNeedResum()) {
                        this.cacheSummaryResultList = QueryUtils.getSRList(allCachemap.get(mapKeyPrfix + "BILLLIST_sumResults"));
                    }
                }
            }
            this.setQueryResult(collection, rowCount, billDataCount, queryBuilder, this.cacheSummaryResultList);
            return collection;
        }
        int rowSize = 0;
        try (DataSet ds = this.queryDB(queryBuilder);){
            String orderBys = queryBuilder.getOrderBys();
            DataSet newDS = !StringUtils.isEmpty((CharSequence)orderBys) ? this.distinctDataSet(ds, orderBys, queryBuilder) : ds;
            List<Row> dsLs = this.dataSetToRowList(mapKeyPrfix, newDS, queryBuilder, true);
            rowSize = dsLs.size();
            List<Row> sortLs = queryBuilder.isNeedResum() ? dsLs : this.getRowList(dsLs, queryBuilder.getStart(), queryBuilder.getLimit());
            try (DataSet allFieldDs = this.getDataSetByPks(queryBuilder, sortLs);){
                DynamicObjectCollection collection = this.getDynamicCollection(this.dataSetToRowList(allFieldDs), sortLs, allFieldDs.getRowMeta(), queryBuilder);
                String bdcMsg = this.idCacheMap.get(mapKeyPrfix + "BILLLIST_billDataCount");
                int billDataCount = StringUtil.isEmpty((String)bdcMsg) ? 0 : Integer.parseInt(bdcMsg);
                this.setQueryResult(collection, rowSize, billDataCount, queryBuilder, this.cacheSummaryResultList);
            }
            if (!queryBuilder.isNeedResum()) {
                if (rowSize <= queryBuilder.getLimit()) {
                    this.idCacheMap.put(mapKeyPrfix + "BILLLIST_cacheId", "onlyonepage_" + rowSize);
                    ics.cacheData(cacheKey, this.idCacheMap);
                } else if (!"run".equals(allCachemap.get(mapKeyPrfix + "BILLLIST_cacheState"))) {
                    es.execute(ThreadLifeCycleManager.wrapRunnable((Runnable)new IdRunner(cacheKey, this.idCacheMap, mapKeyPrfix, queryBuilder, dsLs, RequestContext.get())));
                }
            }
        }
        return this.queryResult.getCollection();
    }

    private DataSet distinctDataSet(DataSet ds, String orderBys, QueryBuilder queryBuilder) {
        List<String> orderByList = this.orderByToList(orderBys);
        ArrayList<String> fieldNames = new ArrayList<String>();
        ArrayList<DataType> dataTypes = new ArrayList<DataType>();
        for (String name : ds.getRowMeta().getFieldNames()) {
            if (this.isMultiBasedata(queryBuilder.getEntityName(), name) && orderByList.contains(name)) continue;
            fieldNames.add(name);
            dataTypes.add(ds.getRowMeta().getField(name).getDataType());
        }
        if (fieldNames.size() != ds.getRowMeta().getFieldCount()) {
            RowMeta meta = RowMetaFactory.createRowMeta((String[])fieldNames.toArray(new String[fieldNames.size()]), (DataType[])dataTypes.toArray(new DataType[dataTypes.size()]));
            DataSetBuilder builder = Algo.create((String)"IdQuery").createDataSetBuilder(meta);
            HashSet<String> keys = new HashSet<String>();
            for (Row row : ds) {
                StringBuilder key = new StringBuilder();
                Object[] values = new Object[fieldNames.size()];
                int count = 0;
                for (String fieldName : fieldNames) {
                    key.append(row.get(fieldName)).append("#");
                    values[count++] = row.get(fieldName);
                }
                String keyString = key.toString();
                if (!keys.add(keyString)) continue;
                builder.append(values);
            }
            ds = builder.build();
            return ds;
        }
        return ds;
    }

    protected boolean isMultiBasedata(String entityName, String fieldName) {
        if (!fieldName.startsWith(entityName + ".")) {
            fieldName = entityName + "." + fieldName;
        }
        int i;
        while ((i = fieldName.lastIndexOf(".")) >= 0) {
            String fullObjectName = fieldName.substring(0, i);
            IDataEntityType iDataEntityType = ORMConfiguration.innerGetDataEntityType((String)fullObjectName, new HashMap());
            if (ORMConfiguration.isMulBasedata((IDataEntityType)iDataEntityType)) {
                return true;
            }
            fieldName = fullObjectName;
        }
        return false;
    }

    private List<String> orderByToList(String orderBy) {
        if (!StringUtils.isEmpty((CharSequence)orderBy)) {
            String[] orderBys = orderBy.split(",");
            ArrayList<String> orerByList = new ArrayList<String>(2);
            for (String order : orderBys) {
                orerByList.add(order.split(" ")[0]);
            }
            return orerByList;
        }
        return new ArrayList<String>();
    }

    private boolean isCache(Map<String, String> allCachemap, String mapKeyPrfix) {
        String cacheId = allCachemap.get(mapKeyPrfix + "BILLLIST_cacheId");
        String cacheState = allCachemap.get(mapKeyPrfix + "BILLLIST_cacheState");
        return StringUtils.isNotEmpty((CharSequence)cacheId) && !cacheId.startsWith("onlyonepage_") && "end".equals(cacheState);
    }

    @Override
    protected DataSet queryDB(QueryBuilder queryBuilder) {
        Object sumFields;
        String rootEntityName = queryBuilder.getEntityName();
        HashSet<String> selectFiledSet = new HashSet<String>(16);
        ArrayList selectFiledList = new ArrayList(16);
        if (queryBuilder.isNeedResum() && (sumFields = queryBuilder.getSumFields()) != null && !sumFields.isEmpty()) {
            selectFiledList.addAll(sumFields);
        }
        selectFiledList.addAll(queryBuilder.getPkFields());
        for (ListField field : selectFiledList) {
            selectFiledSet.add(field.getFieldName());
        }
        String orderByStr = queryBuilder.getOrderBys();
        if (!StringUtil.isEmpty((String)orderByStr)) {
            String[] tempStrs = orderByStr.trim().split(",");
            for (String temp : tempStrs) {
                selectFiledSet.add(temp.trim().split(" ")[0].toLowerCase());
            }
        }
        StringBuilder selectFileds = new StringBuilder();
        for (String field : selectFiledSet) {
            selectFileds.append(field);
            selectFileds.append(',');
        }
        if (queryBuilder.getEntityType() instanceof QueryEntityType) {
            return this.queryDBForQuerySource(queryBuilder, selectFileds);
        }
        ORM orm = ORM.create();
        orm.setDataEntityType(queryBuilder.getEntityName(), queryBuilder.getEntityType());
        if (this.dataEntityTypes != null) {
            for (IDataEntityType iDataEntityType : this.dataEntityTypes) {
                orm.setDataEntityType(iDataEntityType.getName(), iDataEntityType);
            }
        }
        DataSet dataSet = orm.queryDataSet(this.getClass().getName(), queryBuilder.getEntityName(), selectFileds.substring(0, selectFileds.length() - 1), queryBuilder.getFilters(), queryBuilder.getOrderBys(), this.getMaxRowCount(queryBuilder), (Distinctable)WithEntityEntryDistinctable.get());
        return dataSet;
    }

    private DataSet queryDBForQuerySource(QueryBuilder queryBuilder, StringBuilder selectFileds) {
        QueryEntityType qet = (QueryEntityType)queryBuilder.getEntityType();
        DataSet queryDataSet = qet.getQueryDataSet(queryBuilder, selectFileds.toString(), false);
        if (!StringUtils.isEmpty((CharSequence)queryBuilder.getOrderBys())) {
            String[] orderBys = queryBuilder.getOrderBys().split(",");
            for (int i = 0; i < orderBys.length; ++i) {
                orderBys[i] = orderBys[i] == null ? null : orderBys[i].trim();
            }
            return queryDataSet.distinct().orderBy(orderBys);
        }
        return queryDataSet.distinct();
    }

    private int getMaxRowCount(QueryBuilder queryBuilder) {
        String maxRowStr;
        int maxrowcount;
        int cacheRowCount = queryBuilder.getMaxReturnData();
        return cacheRowCount > (maxrowcount = Integer.parseInt(maxRowStr = System.getProperty("bos.billlist.maxRowCount", "100000"))) ? maxrowcount : cacheRowCount;
    }

    protected DynamicObjectCollection getDynamicCollection(List<Row> dsLs, List<Row> sortDsLs, RowMeta dsRowMeta, QueryBuilder qb) {
        final List pkFields = qb.getPkFields();
        String seqField = qb.getSeqField();
        if (sortDsLs == null) {
            sortDsLs = dsLs;
        }
        final HashMap<ArrayKey, Integer> sortMap = new HashMap<ArrayKey, Integer>(16);
        int sortIndex = qb.getStart();
        for (Row row : sortDsLs) {
            Object[] keyValues = this.getPksValue(pkFields, row);
            ArrayKey ak = new ArrayKey(keyValues);
            sortMap.put(ak, ++sortIndex);
        }
        dsLs.sort(new Comparator<Row>(){

            @Override
            public int compare(Row row1, Row row2) {
                Object[] row1KeyValues = IdQuery.this.getPksValue(pkFields, row1);
                Object[] row2KeyValues = IdQuery.this.getPksValue(pkFields, row2);
                ArrayKey row1Ak = new ArrayKey(row1KeyValues);
                ArrayKey row2Ak = new ArrayKey(row2KeyValues);
                if (Objects.isNull(sortMap.get(row1Ak))) {
                    return -1;
                }
                if (Objects.isNull(sortMap.get(row2Ak))) {
                    return 1;
                }
                return ((Integer)sortMap.get(row1Ak)).compareTo((Integer)sortMap.get(row2Ak));
            }
        });
        if (StringUtil.isEmpty((String)seqField)) {
            return this.getDynamicObjectCollection((MainEntityType)qb.getEntityType(), qb.getReturnEntityType(), dsLs, dsRowMeta, qb.getPkFields());
        }
        ArrayList<Row> seqRows = new ArrayList<Row>();
        RowMeta seqRowMeta = this.rowMetaAddField(dsRowMeta, seqField, (DataType)DataType.IntegerType);
        boolean isFirstFlag = true;
        boolean isAddSeqField = true;
        for (Row row : dsLs) {
            Object[] rowKeyValues;
            ArrayKey rowAk;
            if (isFirstFlag) {
                isAddSeqField = this.isAddSeqField(((AbstractRow)row).getRowMeta(), seqField);
                isFirstFlag = false;
            }
            if (Objects.isNull(sortMap.get(rowAk = new ArrayKey(rowKeyValues = this.getPksValue(pkFields, row))))) continue;
            if (isAddSeqField) {
                int seqIndex = (Integer)sortMap.get(rowAk);
                seqRows.add(this.rowAddField(row, seqRowMeta, seqIndex));
                continue;
            }
            seqRows.add(row);
        }
        return this.getDynamicObjectCollection((MainEntityType)qb.getEntityType(), qb.getReturnEntityType(), seqRows, seqRowMeta, qb.getPkFields());
    }

    private boolean isAddSeqField(RowMeta meta, String seqField) {
        for (Field field : meta.getFields()) {
            if (!seqField.equals(field.getName()) && !seqField.equals(field.getAlias())) continue;
            return false;
        }
        return true;
    }

    private DynamicObjectCollection getDynamicObjectCollection(MainEntityType mainEntityType, DynamicObjectType dt, List<Row> rowList, RowMeta rowMeta, List<ListField> pkListFields) {
        DataSetMapper dataSetMapper = new DataSetMapper(mainEntityType, dt, rowMeta, rowList, pkListFields);
        return dataSetMapper.getDynamicObjectCollection();
    }

    private DataSet getDataSetByPks(QueryBuilder qb, List<Row> rows) {
        List pkFields = qb.getPkFields();
        int pkSize = pkFields.size();
        int rowSize = rows.size();
        QFilter[] filters = new QFilter[pkSize];
        int index = 0;
        for (ListField field : pkFields) {
            boolean entryHaveNull = false;
            ArrayList<Object> pkObjValues = new ArrayList<Object>(rowSize);
            String filterPk = field.getFieldName();
            for (int i = 0; i < rowSize; ++i) {
                Object pkObj = rows.get(i).get(filterPk);
                if (this.pkValueIsNull(pkObj)) {
                    entryHaveNull = true;
                    continue;
                }
                pkObjValues.add(pkObj);
            }
            filters[index] = new QFilter(filterPk, "in", pkObjValues);
            if (entryHaveNull) {
                filters[index] = filters[index].or(QFilter.notExists((String)filterPk));
            }
            ++index;
        }
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        if (qb.isNeedResum() && !qb.isSelectedAllRows()) {
            qFilters.addAll(Arrays.asList(qb.getFilters()));
        } else {
            qFilters.addAll(Arrays.asList(filters));
        }
        if (qb.isNeedResum() && !StringUtil.isEmpty((String)qb.getOrderBys())) {
            String[] tempStrs;
            HashSet<String> selectFiledSet = new HashSet<String>(16);
            ArrayList selectFiledList = new ArrayList(16);
            List sumFields = qb.getSumFields();
            if (sumFields != null && !sumFields.isEmpty()) {
                selectFiledList.addAll(sumFields);
            }
            selectFiledList.addAll(qb.getPkFields());
            for (ListField field : selectFiledList) {
                selectFiledSet.add(field.getFieldName());
            }
            for (String temp : tempStrs = qb.getOrderBys().split(",")) {
                selectFiledSet.add(temp.trim().split(" ")[0]);
            }
            String lowerSelectFields = qb.getSelectFields().toLowerCase(Locale.ENGLISH) + ",";
            StringBuilder selectFileds = new StringBuilder(qb.getSelectFields()).append(",");
            for (String field : selectFiledSet) {
                boolean exists = false;
                String lowerField = field.toLowerCase(Locale.ENGLISH);
                if (lowerSelectFields.startsWith(lowerField)) {
                    boolean bl = exists = lowerSelectFields.startsWith(lowerField + " ") || lowerSelectFields.startsWith(lowerField + ",");
                }
                if (!exists) {
                    boolean bl = exists = lowerSelectFields.indexOf(" " + lowerField + " ") != -1 || lowerSelectFields.indexOf("," + lowerField + " ") != -1 || lowerSelectFields.indexOf("," + lowerField + ",") != -1 || lowerSelectFields.indexOf(" " + lowerField + ",") != -1;
                }
                if (exists) continue;
                selectFileds.append(field).append(',');
            }
            qb.setSelectFields(selectFileds.substring(0, selectFileds.length() - 1));
        }
        ORM orm = ORM.create();
        orm.setDataEntityType(qb.getEntityName(), qb.getEntityType());
        if (qb.getEntityType() instanceof QueryEntityType) {
            QueryEntityType queryEntityType = (QueryEntityType)qb.getEntityType();
            return queryEntityType.getQueryDataSetByPK(qb, qFilters, qb.getSelectFields(), false);
        }
        return orm.queryDataSet(this.getClass().getName(), qb.getEntityName(), qb.getSelectFields(), qFilters.toArray(new QFilter[0]), qb.isNeedResum() ? qb.getOrderBys() : null, 0, -1, (Distinctable)WithEntityEntryDistinctable.get());
    }

    private Object[] getPksValue(List<ListField> pkFields, Row row) {
        ArrayList<Object> pkValues = new ArrayList<Object>();
        for (ListField field : pkFields) {
            String pk = field.getFieldName();
            Object pkObj = row.get(pk);
            if (this.pkValueIsNull(pkObj)) continue;
            pkValues.add(pkObj);
        }
        return pkValues.toArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<Row> dataSetToRowList(DataSet ds) {
        try {
            ArrayList<Row> dsLs = new ArrayList<Row>();
            for (Row row : ds) {
                dsLs.add(RowUtil.persist((Row)row));
            }
            ArrayList<Row> arrayList = dsLs;
            return arrayList;
        }
        finally {
            ds.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Row> dataSetToRowList(String mapKeyPrfix, DataSet ds, QueryBuilder qb, boolean isNeedCache) {
        try {
            RowsResult rowsResult = this.getRowsResult(ds, qb);
            this.cacheSummaryResults(mapKeyPrfix, qb, isNeedCache, rowsResult);
            List<Row> list = rowsResult.getDealRows();
            return list;
        }
        finally {
            ds.close();
        }
    }

    protected RowsResult getRowsResult(DataSet ds, QueryBuilder qb) {
        Map<String, SummaryResult> sumResultsMap = this.getSumResultsMap(qb);
        int pkSize = qb.getPkFields().size();
        ArrayList<Row> dealRows = new ArrayList<Row>();
        Object prePK = null;
        int billDataCount = 0;
        Object billPrePk = null;
        RowMeta dsRowMeta = ds.getRowMeta();
        QueryUtils queryUtils = new QueryUtils(qb);
        int n = dsRowMeta.getFieldCount();
        Map<String, Mapper> mappers = this.getMappers(qb, dsRowMeta, n);
        String seqFieldStr = qb.getSeqField();
        boolean seqIsEntity = StringUtil.isEmpty((String)seqFieldStr);
        RowMeta seqRowMeta = null;
        int seqIndex = qb.getStart() + 1;
        if (!seqIsEntity) {
            seqRowMeta = this.rowMetaAddField(ds.getRowMeta(), seqFieldStr, (DataType)DataType.IntegerType);
        }
        boolean isString = true;
        LongBitSet bitSet = BitSetFactory.createLong();
        HashSet<String> ids = new HashSet<String>();
        int count = 0;
        ISimpleProperty primaryKey = qb.getEntityType().getPrimaryKey();
        if (!"java.lang.String".equalsIgnoreCase(primaryKey.getPropertyType().getName())) {
            isString = false;
        }
        boolean orderByIdFirst = this.orderByIdFirst(qb);
        String billPkStr = primaryKey.getName();
        for (Row row : ds) {
            Row perRow = RowUtil.persist((Row)row);
            if (!qb.getSumFields().isEmpty()) {
                queryUtils.addRowSummaryResult(perRow, mappers, sumResultsMap);
            }
            Object billCurPK = perRow.get(billPkStr);
            if (orderByIdFirst) {
                if (!billCurPK.equals(billPrePk)) {
                    ++billDataCount;
                }
                billPrePk = billCurPK;
            } else if (isString) {
                ids.add(String.valueOf(billCurPK));
            } else if (!bitSet.get(Long.parseLong(String.valueOf(billCurPK)))) {
                ++count;
                bitSet.set(Long.parseLong(String.valueOf(billCurPK)));
            }
            Row seqRow = null;
            if (!seqIsEntity) {
                seqRow = this.rowAddField(perRow, seqRowMeta, seqIndex);
                ++seqIndex;
            } else {
                seqRow = perRow;
            }
            dealRows.add(seqRow);
        }
        if (!orderByIdFirst) {
            billDataCount = isString ? ids.size() : count;
        }
        ArrayList<SummaryResult> summaryResults = new ArrayList<SummaryResult>();
        summaryResults.addAll(sumResultsMap.values());
        return new RowsResult(dealRows, billDataCount, summaryResults);
    }

    private boolean orderByIdFirst(QueryBuilder queryBuilder) {
        List<String> orderByList = this.orderByToList(queryBuilder.getOrderBys());
        return !CollectionUtils.isEmpty(orderByList) && "id".equalsIgnoreCase(orderByList.get(0));
    }

    private void cacheSummaryResults(String mapKeyPrfix, QueryBuilder qb, boolean isNeedCache, RowsResult rowResult) {
        if (!qb.getSumFields().isEmpty()) {
            this.cacheSummaryResultList = rowResult.getSummaryResults();
            if (isNeedCache && !qb.isNeedResum()) {
                this.idCacheMap.put(mapKeyPrfix + "BILLLIST_sumResults", QueryUtils.sRListToStr(rowResult.getSummaryResults()));
            }
        }
        if (isNeedCache && !qb.isNeedResum()) {
            this.idCacheMap.put(mapKeyPrfix + "BILLLIST_billDataCount", Integer.toString(rowResult.getBillDataCount()));
        }
    }

    protected Map<String, Mapper> getMappers(QueryBuilder qb, RowMeta dsRowMeta, int n) {
        HashMap<String, Mapper> mappers = new HashMap<String, Mapper>();
        for (int i = 0; i < n; ++i) {
            DynamicProperty property = qb.getReturnEntityType().getProperty(dsRowMeta.getField(i).getName());
            if (property == null) continue;
            Mapper mapper = new Mapper();
            mapper.index = i;
            mapper.property = property instanceof BasedataProp ? ((BasedataProp)property).getRefIdProp() : property;
            mappers.put(dsRowMeta.getField(i).getName().toLowerCase(), mapper);
        }
        return mappers;
    }

    protected Map<String, SummaryResult> getSumResultsMap(QueryBuilder qb) {
        LinkedHashMap<String, SummaryResult> sumResultsMap = new LinkedHashMap<String, SummaryResult>(16);
        if (!qb.getSumFields().isEmpty()) {
            for (ListField sumField : qb.getSumFields()) {
                SummaryResult summaryResult = new SummaryResult(sumField.getListFieldKey().replace('.', '_'), null, sumField.getSummary());
                sumResultsMap.put(sumField.getListFieldKey().replace('.', '_'), summaryResult);
            }
        }
        return sumResultsMap;
    }

    protected Row rowAddField(Row row, RowMeta newRowMeta, Object fieldValue) {
        Object[] rowValues = RowUtil.toArray((Row)row);
        int len = rowValues.length;
        Object[] newValues = new Object[len + 1];
        System.arraycopy(rowValues, 0, newValues, 0, len);
        newValues[len] = fieldValue;
        return RowFactory.createRow((RowMeta)newRowMeta, (Object[])newValues);
    }

    protected RowMeta rowMetaAddField(RowMeta rowMeta, String fieldName, DataType fieldType) {
        int count = rowMeta.getFieldCount();
        String[] fieldNames = new String[count + 1];
        DataType[] dataTypes = new DataType[count + 1];
        List dsDataType = rowMeta.getTypes();
        for (int i = 0; i < count; ++i) {
            fieldNames[i] = rowMeta.getFieldName(i);
            dataTypes[i] = (DataType)dsDataType.get(i);
        }
        fieldNames[count] = fieldName;
        dataTypes[count] = fieldType;
        return RowMetaFactory.createRowMeta((String[])fieldNames, (DataType[])dataTypes);
    }

    private List<Row> getRowList(List<Row> rows, int begin, final int limit) {
        final Iterator<Row> iter = rows.iterator();
        for (int i = 0; i < begin && iter.hasNext(); ++i) {
            iter.next();
        }
        Iterator<Row> limitIter = new Iterator<Row>(){
            int i = 0;

            @Override
            public Row next() {
                return (Row)iter.next();
            }

            @Override
            public boolean hasNext() {
                if (++this.i > limit) {
                    return false;
                }
                return iter.hasNext();
            }
        };
        ArrayList<Row> limitRows = new ArrayList<Row>();
        while (limitIter.hasNext()) {
            limitRows.add((Row)limitIter.next());
        }
        return limitRows;
    }

    protected void setQueryResult(DynamicObjectCollection collection, int dataCount, int billDataCount, QueryBuilder qb, List<SummaryResult> summaryResults) {
        this.queryResult.setCollection(collection);
        this.queryResult.setDataCount(dataCount);
        this.queryResult.setBillDataCount(billDataCount);
        ArrayList<FmtField> fmtFields = new ArrayList<FmtField>(16);
        for (ListField field : qb.getDecimalFields()) {
            FmtField fmtField = new FmtField(field.getSrcFieldProp(), field.getListFieldKey().replace('.', '_'), field.getControlField() != null ? field.getControlField().getFieldName() : "");
            fmtField.setControlFieldKey(field.getControlField() != null ? field.getControlField().getListFieldKey() : "");
            fmtFields.add(fmtField);
        }
        NumberFormatProvider numberFormatProvider = new NumberFormatProvider(fmtFields, collection);
        this.queryResult.setNumberFormatProvider(numberFormatProvider);
        if (!qb.getSumFields().isEmpty()) {
            for (SummaryResult summaryResult : summaryResults) {
                NumberPrecision numberPrecision = numberFormatProvider.getFormatPrecision(summaryResult.getFieldName(), null);
                numberPrecision.setResult(summaryResult.getNumberPrecision().getResult());
                summaryResult.setNumberPrecision(numberPrecision);
            }
            this.queryResult.setSummaryResults(summaryResults);
        }
    }

    private String cacheData(QueryBuilder qb, List<Row> rows) {
        if (!qb.getSumFields().isEmpty()) {
            List pkFields = qb.getPkFields();
            int pkSize = pkFields.size();
            String[] fieldNames = new String[pkSize];
            DataType[] dataTypes = new DataType[pkSize];
            for (int i = 0; i < pkSize; ++i) {
                fieldNames[i] = ((ListField)pkFields.get(i)).getFieldName();
                dataTypes[i] = ((ListField)pkFields.get(i)).getSrcFieldProp() instanceof LongProp ? DataType.LongType : DataType.StringType;
            }
            RowMeta idRowMeta = RowMetaFactory.createRowMeta((String[])fieldNames, (DataType[])dataTypes);
            ArrayList<Row> cacheRows = new ArrayList<Row>(16);
            RowMeta rowMeta = idRowMeta;
            String seqField = qb.getSeqField();
            boolean seqIsEntity = StringUtil.isEmpty((String)seqField);
            if (!seqIsEntity) {
                rowMeta = this.rowMetaAddField(idRowMeta, seqField, (DataType)DataType.IntegerType);
            }
            for (Row row : rows) {
                Object[] values = new Object[pkSize];
                for (int i = 0; i < pkSize; ++i) {
                    values[i] = row.get(((ListField)pkFields.get(i)).getFieldName());
                }
                Row idRow = RowFactory.createRow((RowMeta)idRowMeta, (Object[])values);
                if (!seqIsEntity) {
                    idRow = this.rowAddField(idRow, rowMeta, row.get(seqField));
                }
                cacheRows.add(idRow);
            }
            return this.cacheRowList(cacheRows, rowMeta);
        }
        RowMeta rowMeta = ((AbstractRow)rows.get(0)).getRowMeta();
        return this.cacheRowList(rows, rowMeta);
    }

    private String cacheRowList(List<Row> rows, RowMeta rowMeta) {
        CacheHint cacheHint = new CacheHint();
        cacheHint.setPageSize(ConfigurationUtil.getInteger((String)"bos.billlist.pagesize", (Integer)1000).intValue());
        int timeout = CacheKeyUtil.getPageCacheKeyTimeout();
        cacheHint.setTimeout((long)timeout, TimeUnit.SECONDS);
        CachedDataSetBuilder cacheBuilder = new CachedDataSetBuilder(rowMeta, cacheHint, this.getClass().getSimpleName() + ".cacheAlgo.rows");
        cacheBuilder.append(rows.iterator());
        CachedDataSet cds = cacheBuilder.build();
        return cds.getCacheId();
    }

    private boolean pkValueIsNull(Object pkValue) {
        return pkValue == null || "0".equals(String.valueOf(pkValue)) || String.valueOf(pkValue).length() == 0;
    }

    protected Set<String> selectFieldsToSet(String selectFields) {
        HashSet<String> set = new HashSet<String>(8);
        for (String field : selectFields.split(",")) {
            set.add(field.toLowerCase());
        }
        return set;
    }

    protected Set<String> orderByToSet(String orderBy) {
        return new HashSet<String>(this.orderByToList(orderBy));
    }

    protected List<String> getAllParentObjectNames(String rootEntityName, String field) {
        ArrayList<String> list = new ArrayList<String>(1);
        if (field.startsWith(rootEntityName + ".")) {
            field = field.substring((rootEntityName + ".").length());
        }
        while (field.contains(".")) {
            int index = field.lastIndexOf(".");
            field = field.substring(0, index);
            list.add(field);
        }
        return list;
    }

    class IdRunner
    implements Runnable {
        String cacheKey;
        Map<String, String> map;
        String preFixStr;
        QueryBuilder qb;
        List<Row> rows;
        RequestContext rc;

        public IdRunner(String cacheKey, Map<String, String> map, String preFixStr, QueryBuilder qb, List<Row> rows, RequestContext rc) {
            this.preFixStr = preFixStr;
            this.cacheKey = cacheKey;
            this.map = map;
            this.qb = qb;
            this.rows = rows;
            this.rc = rc;
        }

        @Override
        public void run() {
            RequestContext.copyAndSet((RequestContext)this.rc);
            this.map.put(this.preFixStr + "BILLLIST_cacheState", "run");
            ics.cacheData(this.cacheKey, this.map);
            String cacheId = IdQuery.this.cacheData(this.qb, this.rows);
            this.map.put(this.preFixStr + "BILLLIST_cacheId", cacheId);
            this.map.put(this.preFixStr + "BILLLIST_cacheState", "end");
            ics.cacheData(this.cacheKey, this.map);
        }
    }

    class RowsResult {
        private List<Row> dealRows = new ArrayList<Row>();
        private int billDataCount = 0;
        private List<SummaryResult> summaryResults = new ArrayList<SummaryResult>();

        public List<Row> getDealRows() {
            return this.dealRows;
        }

        public int getBillDataCount() {
            return this.billDataCount;
        }

        public List<SummaryResult> getSummaryResults() {
            return this.summaryResults;
        }

        public RowsResult(List<Row> dealRows, int billDataCount, List<SummaryResult> summaryResults) {
            this.dealRows = dealRows;
            this.billDataCount = billDataCount;
            this.summaryResults = summaryResults;
        }
    }
}

