/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.userconfig;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.cache.CacheKeyUtil;

public class UserConfigDistributeCache {
    private static final String CACHE_DIST_KEY = "bos_userconfig";

    private UserConfigDistributeCache() {
    }

    private static String getCacheRegionKey(String userId) {
        if (StringUtils.isNotEmpty((CharSequence)userId)) {
            return String.format("%s.userconfig.%s", CacheKeyUtil.getAcctId(), userId);
        }
        return String.format("%s.userconfig", CacheKeyUtil.getAcctId());
    }

    private static DistributeSessionlessCache getCache() {
        return CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache(CACHE_DIST_KEY, new DistributeCacheHAPolicy());
    }

    public static <T> T getDistributeCache(String userId, String key, Class<?> typeClass) {
        DistributeSessionlessCache cache = UserConfigDistributeCache.getCache();
        String value = (String)cache.get(UserConfigDistributeCache.getCacheRegionKey(userId), key);
        if (value != null) {
            return (T)SerializationUtils.fromJsonString((String)value, typeClass);
        }
        return null;
    }

    public static <T> List<T> getDistributeCache(String userId, String[] keys, Class<?> typeClass) {
        DistributeSessionlessCache cache = UserConfigDistributeCache.getCache();
        List cacheVals = cache.get(UserConfigDistributeCache.getCacheRegionKey(userId), keys);
        ArrayList<Object> results = new ArrayList<Object>(keys.length);
        for (String value : cacheVals) {
            if (value != null) {
                results.add(SerializationUtils.fromJsonString((String)value, typeClass));
                continue;
            }
            results.add(null);
        }
        return results;
    }

    public static Map<String, String> getDistributeCache(String userId) {
        DistributeSessionlessCache cache = UserConfigDistributeCache.getCache();
        return cache.getAll(userId);
    }

    public static void putDistributeCache(String userId, String key, Object value) {
        if (value == null) {
            return;
        }
        DistributeSessionlessCache cache = UserConfigDistributeCache.getCache();
        cache.put(UserConfigDistributeCache.getCacheRegionKey(userId), key, (Object)SerializationUtils.toJsonString((Object)value));
        cache.put(UserConfigDistributeCache.getCacheRegionKey(key), userId, (Object)"1");
    }

    public static void putDistributeCache(String userId, Map<String, Object> values) {
        if (values == null || values.isEmpty()) {
            return;
        }
        DistributeSessionlessCache cache = UserConfigDistributeCache.getCache();
        HashMap<String, String> cacheVals = new HashMap<String, String>(values.size());
        for (Map.Entry<String, Object> entry : values.entrySet()) {
            if (entry.getValue() != null) {
                cacheVals.put(entry.getKey(), SerializationUtils.toJsonString((Object)entry.getValue()));
            }
            cache.put(UserConfigDistributeCache.getCacheRegionKey(entry.getKey()), userId, (Object)"1");
        }
        if (cacheVals.isEmpty()) {
            return;
        }
        cache.put(UserConfigDistributeCache.getCacheRegionKey(userId), cacheVals);
    }

    public static void removeDistributeCache(String userId, String key) {
        DistributeSessionlessCache cache = UserConfigDistributeCache.getCache();
        cache.remove(UserConfigDistributeCache.getCacheRegionKey(userId), key);
    }

    public static void removeDistributeCache(String key) {
        DistributeSessionlessCache cache = UserConfigDistributeCache.getCache();
        String regionKey = UserConfigDistributeCache.getCacheRegionKey(key);
        Map cacheUsers = cache.getAll(regionKey);
        for (Map.Entry entry : cacheUsers.entrySet()) {
            String userId = (String)entry.getKey();
            UserConfigDistributeCache.removeDistributeCache(userId, key);
        }
        cache.remove(regionKey);
    }

    protected static void removeDistributeCacheByRegion(String regionKey) {
        DistributeSessionlessCache cache = UserConfigDistributeCache.getCache();
        cache.remove(UserConfigDistributeCache.getCacheRegionKey(regionKey));
    }
}

