/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.privacy.service;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.cache.CacheConfigInfo;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.cache.LocalMemoryCache;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.trace.EntityTraceSpan;
import kd.bos.dataentity.trace.EntityTracer;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.privacy.IPrivacyDataPermissionService;
import kd.bos.db.privacy.PrivacyDataConstant;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.cache.CacheKeyUtil;
import kd.bos.entity.property.CreaterProp;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.logorm.LogORM;
import kd.bos.orm.ORM;
import kd.bos.orm.datamanager.DataEntityCacheManager;
import kd.bos.orm.query.Distinctable;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.query.WithEntityEntryDistinctable;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.privacy.model.DecryptLogModel;
import kd.bos.privacy.model.PrivacyEncryptModel;
import kd.bos.privacy.model.SchemeLimitCacheItem;
import kd.bos.privacy.service.PrivacyEnableManager;
import kd.bos.privacy.service.PrivacyEncryptService;
import kd.bos.privacy.utils.PrivacyDataTools;
import kd.bos.service.ServiceFactory;
import kd.bos.threads.ThreadPools;
import kd.bos.workflow.engine.msg.info.MessageInfo;
import kd.bos.workflow.message.api.IMessageCenterService;

public class PrivacyDataPermissionService
implements IPrivacyDataPermissionService {
    private static final Log log = LogFactory.getLog(PrivacyDataPermissionService.class);
    private static final String CACHE_KEY_TOTALCOUNT = "TOTALCOUNT";
    private static final String CACHE_KEY = "privacy-permission";
    private static final int CACHE_USERCLICKCOUNT_TIMEOUT = 3600;
    private static final int CACHE_USER_MESSAGE_TIMEOUT = 3600;
    private static final String CACHE_DESENSITIZE_STRATEGY = "DesensitizeStrategy";
    private static final String CACHE_SCHEMELIMIT = "CACHE_SCHEMELIMIT";
    private static final String CACHE_KEY_FIELD_COUNT = "FIELDCOUNT";
    private static final String BOS_PRIVACY_IMPLEMENT = "bos-privacy-implement";
    private static final PrivacyEncryptService privacyService = new PrivacyEncryptService();
    private static final DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("privacy-permission", new DistributeCacheHAPolicy(true, true));
    private static final String PRIVACY_PERMISSION_SERVICE_REGION = "PrivacyDataPermissionService";

    @Deprecated
    public String getDesensitizeStrategy(String entity, String prop, String operateType) {
        return this.getDesensitizeStrategy(entity, prop, operateType, null);
    }

    public String getDesensitizeStrategy(String entity, String prop, String operateType, Object dObj) {
        Object creatorId;
        Object creator;
        DynamicProperty creatorProp;
        DynamicObject dynamicObject;
        DynamicObjectType dt;
        String specialPerm;
        DynamicObject globalDObj;
        if (!this.isCheckDensenPerm()) {
            return "CLICKVIEW";
        }
        if (kd.bos.util.StringUtils.isEmpty((String)operateType)) {
            return this.getDefaultStrategy();
        }
        if ("API".equals(operateType)) {
            return this.getDesensitizeStrategyByAPI(entity);
        }
        String operType = "LIST".equals(operateType) ? "FORM" : operateType;
        String strategy = this.getDesenStrategy(entity, prop, operType);
        if (strategy == null) {
            // empty if block
        }
        if (strategy == null) {
            strategy = this.getDefaultStrategy();
        }
        if ("DESENSITIZE".equals(strategy) && "FORM".equals(operateType) && dObj instanceof DynamicObject && (globalDObj = this.getGlobalControl()) != null && kd.bos.util.StringUtils.isNotEmpty((String)(specialPerm = globalDObj.getString("specialperm"))) && specialPerm.contains("CREATOR") && (dt = (dynamicObject = (DynamicObject)dObj).getDynamicObjectType()) != null && (creatorProp = dt.getProperty("creator")) instanceof CreaterProp && (creator = creatorProp.getValueFast((Object)dynamicObject)) instanceof DynamicObject && (creatorId = ((DynamicObject)creator).getPkValue()) != null && creatorId.equals(RequestContext.get().getCurrUserId())) {
            return "CLICKVIEW";
        }
        return strategy;
    }

    private String getDesenStrategy(String entity, String prop, String operateType) {
        RequestContext ctx = RequestContext.get();
        Map<String, Map<String, DesenAuthor>> map = this.getDesenStrategyAuthor(ctx.getCurrUserId());
        Map<String, DesenAuthor> entityMap = map.get(entity);
        if (entityMap == null) {
            return null;
        }
        DesenAuthor desenAuthor = entityMap.get(prop);
        if (desenAuthor == null) {
            return null;
        }
        return desenAuthor.getPolicyByOperateType(operateType);
    }

    private Map<String, Map<String, DesenAuthor>> getDesenStrategyAuthor(long userId) {
        String cacheKey = "ALL" + userId;
        LocalMemoryCache localMemoryCache = PrivacyDataPermissionService.getLocalCache(CACHE_DESENSITIZE_STRATEGY);
        Map result = (HashMap)localMemoryCache.get(cacheKey);
        if (result != null) {
            return result;
        }
        result = new HashMap(8);
        String sql = "select A.fentitynumber,A.ffieldident,A.fformpolicy,A.fexportpolicy,A.fprintpolicy from t_privacy_desen_authority A inner join t_privacy_scheme_permuser B on A.fentryid = B.fentryid\nwhere B.FBasedataId = ?;";
        Object[] selectParas = new SqlParameter[]{new SqlParameter(":FBasedataId", 12, (Object)userId)};
        try (DataSet dataSet = DB.queryDataSet((String)"getDesenStrategyAuthor", (DBRoute)DBRoute.of((String)"sys"), (String)sql, (Object[])selectParas);){
            while (dataSet.hasNext()) {
                String field;
                DesenAuthor desenAuthor;
                Row rs = dataSet.next();
                String entitynumber = rs.getString("fentitynumber");
                HashMap<String, DesenAuthor> entityMap = (HashMap<String, DesenAuthor>)result.get(entitynumber);
                if (entityMap == null) {
                    entityMap = new HashMap<String, DesenAuthor>(8);
                    result.put((String)entitynumber, entityMap);
                }
                if ((desenAuthor = (DesenAuthor)entityMap.get(field = rs.getString("ffieldident"))) == null) {
                    desenAuthor = new DesenAuthor();
                    desenAuthor.setEntityNumber(entitynumber);
                    desenAuthor.setFieldIdent(field);
                    entityMap.put(field, desenAuthor);
                }
                desenAuthor.setFormPolicy(rs.getString("fformpolicy"));
                desenAuthor.setExportPolicy(rs.getString("fexportpolicy"));
                desenAuthor.setPrintPolicy(rs.getString("fprintpolicy"));
            }
        }
        catch (Exception e) {
            log.warn((Throwable)e);
            throw e;
        }
        if (result.isEmpty()) {
            result = Collections.emptyMap();
        }
        localMemoryCache.put(cacheKey, result);
        return result;
    }

    private String getDesensitizeStrategyByAPI(String entity) {
        RequestContext ctx = RequestContext.get();
        String api3rdAppId = ctx.getApi3rdAppId();
        if (kd.bos.util.StringUtils.isEmpty((String)api3rdAppId)) {
            return "PLAINTEXT";
        }
        return "DESENSITIZE";
    }

    @Deprecated
    public void checkDecryptPermission(String entity, String prop, String operateType, String operateTerminal) {
        this.checkDecryptPermission(entity, prop, operateType, operateTerminal, null);
    }

    public void checkDecryptPermission(String entity, String prop, String operateType, String operateTerminal, Object dObj) {
        String strategy = this.getDesensitizeStrategy(entity, prop, operateType, dObj);
        if (kd.bos.util.StringUtils.isEmpty((String)strategy) || "DESENSITIZE".equals(strategy)) {
            throw new KDException(PrivacyDataConstant.ERRORCODE, new Object[]{ResManager.loadKDString((String)"\u6ca1\u6709\u6743\u9650\u67e5\u770b\u660e\u6587\u3002", (String)"PrivacyDataPermissionService_0", (String)BOS_PRIVACY_IMPLEMENT, (Object[])new Object[0])});
        }
    }

    public String getDefaultStrategy() {
        if (this.isCheckDensenPerm()) {
            return "DESENSITIZE";
        }
        return "CLICKVIEW";
    }

    private boolean isCheckDensenPerm() {
        DynamicObject globalDObj = this.getGlobalControl();
        if (globalDObj != null) {
            return globalDObj.getBoolean("checkdesenperm");
        }
        return false;
    }

    public boolean isSupportSearch() {
        DynamicObject globalDObj = this.getGlobalControl();
        if (globalDObj != null) {
            return globalDObj.getBoolean("supportsearch");
        }
        return false;
    }

    private DynamicObject getGlobalControl() {
        String cacheKey;
        LocalMemoryCache localMemoryCache = PrivacyDataPermissionService.getLocalCache(CACHE_DESENSITIZE_STRATEGY);
        DynamicObject dynamicObject = (DynamicObject)localMemoryCache.get(cacheKey = "privacy_global_control");
        if (dynamicObject != null) {
            return dynamicObject;
        }
        dynamicObject = PrivacyDataPermissionService.loadSingleFromCache("privacy_global_control", new QFilter[0]);
        if (dynamicObject != null) {
            localMemoryCache.put(cacheKey, (Object)dynamicObject);
        }
        return dynamicObject;
    }

    private static DynamicObject loadSingleFromCache(String entityName, QFilter[] filters) {
        try (EntityTraceSpan span = EntityTracer.create((String)"BusinessDataServiceHelper", (String)"loadSingleFromCache");){
            Map mapObject;
            Object object;
            if (span.isRealtime()) {
                span.addTag("entityname", entityName);
                span.addLocaleTag("filters", (Object)filters);
                span.fireEvent(null);
            }
            MainEntityType type = EntityMetadataCache.getDataEntityType((String)entityName);
            ArrayList idList = new ArrayList();
            DataEntityCacheManager cacheManager = new DataEntityCacheManager((IDataEntityType)type);
            Object[] pks = cacheManager.getCachePks(filters);
            if (pks == null) {
                DataSet ds = ORM.create().queryDataSet("BusinessDataServiceHelper.LoadFromCache", type.getName(), "id", filters, null, -1, (Distinctable)WithEntityEntryDistinctable.get());
                object = null;
                try {
                    ds.forEach(row -> idList.add(row.get(0)));
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    if (ds != null) {
                        if (object != null) {
                            try {
                                ds.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object).addSuppressed(throwable);
                            }
                        } else {
                            ds.close();
                        }
                    }
                }
                pks = idList.toArray();
                cacheManager.putCachePks(filters, pks);
            }
            object = (mapObject = BusinessDataReader.loadFromCache((Object[])pks, (DynamicObjectType)type)).size() > 0 ? (DynamicObject)mapObject.values().toArray()[0] : null;
            return object;
        }
    }

    private int getTotolCount(RequestContext ctx, long schemeId) {
        String key = this.getTotalCountCacheKey(ctx.getCurrUserId());
        String countStr = (String)cache.get(CACHE_KEY_TOTALCOUNT, key);
        int totolCount = 0;
        if (kd.bos.util.StringUtils.isEmpty((String)countStr)) {
            LogORM logORM = LogORM.create();
            QFilter filter = QFilter.of((String)"schemeid = ?", (Object[])new Object[]{schemeId});
            DynamicObjectCollection result = logORM.query("privacy_desen_log", "realcount", new QFilter[]{filter}, Integer.MAX_VALUE, 0);
            for (DynamicObject dynamicObject : result) {
                totolCount += dynamicObject.getInt("realcount");
            }
            cache.put(CACHE_KEY_TOTALCOUNT, key, String.valueOf(totolCount), 3600);
        } else {
            totolCount = Integer.parseInt(countStr);
        }
        return totolCount;
    }

    private int getFieldCount(RequestContext ctx, String entity, String prop) {
        String fieldCountKey = this.getFieldCountCacheKey(ctx.getCurrUserId(), entity, prop);
        String countStr = (String)cache.get(CACHE_KEY_FIELD_COUNT, fieldCountKey);
        int fieldCount = 0;
        if (kd.bos.util.StringUtils.isEmpty((String)countStr)) {
            Date today = PrivacyDataTools.getOperateDate(new Timestamp(System.currentTimeMillis()));
            LogORM logORM = LogORM.create();
            QFilter filter = QFilter.of((String)"fieldident = ?", (Object[])new Object[]{prop}).and(new QFilter("entitynumber", "=", (Object)entity)).and(new QFilter("operator", "=", (Object)ctx.getCurrUserId())).and(new QFilter("opdate", "=", (Object)today));
            DynamicObjectCollection result = logORM.query("privacy_desen_log", "realcount", new QFilter[]{filter}, 1, 0);
            if (result.size() > 0) {
                fieldCount = ((DynamicObject)result.get(0)).getInt("realcount");
            }
            cache.put(CACHE_KEY_FIELD_COUNT, fieldCountKey, String.valueOf(fieldCount), 3600);
        } else {
            fieldCount = Integer.parseInt(countStr);
        }
        return fieldCount;
    }

    private void action_forewarn(SchemeLimitCacheItem schemeLimitCacheItem, String entity, String prop, String operateType, String operateTerminal, int clickCount) {
        String key = "CACHE_USER_MESSAGE_" + CacheKeyUtil.getAcctId() + RequestContext.get().getCurrUserId() + "_" + schemeLimitCacheItem.getSchemeId();
        String isSend = (String)cache.get(key);
        if ("true".equals(isSend)) {
            log.info("Don't send it for now, forewarn was sent within time " + key);
            return;
        }
        String msgContent = schemeLimitCacheItem.getTemplate();
        String notifyTypes = schemeLimitCacheItem.getMessagechannel();
        DynamicObjectCollection receiver = schemeLimitCacheItem.getReceiver();
        ArrayList<Long> receiverIds = new ArrayList<Long>(2);
        String compileMsgContent = this.expressionResolution(msgContent, entity, prop, clickCount);
        for (DynamicObject dynamicObject1 : receiver) {
            receiverIds.add((Long)dynamicObject1.getPkValue());
        }
        if (receiverIds.size() == 0) {
            log.info("\u6ca1\u6709\u6307\u5b9a\u6267\u884c\u4f5c\u4e1a\u7684\u7528\u6237\u6216\u8005\u6d88\u606f\u63a5\u6536\u4eba");
        } else if (kd.bos.util.StringUtils.isBlank((String)notifyTypes)) {
            log.info("\u6ca1\u6709\u914d\u7f6e\u6d88\u606f\u6e20\u9053notifyTypes");
        } else if (kd.bos.util.StringUtils.isBlank((String)msgContent)) {
            log.info("\u6d88\u606f\u5185\u5bb9msgContent is null");
        } else {
            Object[] notifyTypeArray = notifyTypes.split(",");
            String channels = StringUtils.join((Object[])notifyTypeArray, (String)",");
            MessageInfo messageInfo = this.buildMsgInfo(receiverIds, compileMsgContent, channels);
            IMessageCenterService messageService = (IMessageCenterService)ServiceFactory.getService(IMessageCenterService.class);
            messageService.sendMessage(messageInfo);
            log.info(String.format("\u53d1\u9001\u901a\u77e5\u6210\u529f: entity %s prop %s operateType %s operateTerminal %s", entity, prop, operateType, operateTerminal));
            cache.put(key, (Object)"true", 3600);
        }
    }

    private MessageInfo buildMsgInfo(List<Long> receiverIds, String compileMsgContent, String channels) {
        MessageInfo messageInfo = new MessageInfo();
        messageInfo.setType("message");
        messageInfo.setContent(compileMsgContent);
        messageInfo.setUserIds(receiverIds);
        messageInfo.setTitle(ResManager.loadKDString((String)"\u89e3\u5bc6\u63a7\u5236\u901a\u77e5", (String)"PrivacyDataPermissionService_3", (String)BOS_PRIVACY_IMPLEMENT, (Object[])new Object[0]));
        messageInfo.setTag(ResManager.loadKDString((String)"\u89e3\u5bc6\u63a7\u5236\u901a\u77e5", (String)"PrivacyDataPermissionService_3", (String)BOS_PRIVACY_IMPLEMENT, (Object[])new Object[0]));
        messageInfo.setNotifyType(channels);
        return messageInfo;
    }

    private void recordDecryptLog(long schemeId, String entity, String prop, String operateType, String operateTerminal) {
        RequestContext ctx = RequestContext.get();
        long userId = ctx.getCurrUserId();
        Timestamp timestamp = new Timestamp(System.currentTimeMillis());
        DecryptLogModel logModel = new DecryptLogModel();
        logModel.setEntity(entity);
        logModel.setOperateTerminal(operateTerminal);
        logModel.setOperateTime(timestamp);
        logModel.setOperateType(operateType);
        logModel.setOperatorId(userId);
        logModel.setOperatorName(ctx.getUserName());
        logModel.setProp(prop);
        logModel.setSchemeId(schemeId);
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)entity);
        IDataEntityProperty property = mainType.findProperty(prop);
        logModel.setEntityName(mainType.getDisplayName().getLocaleValue());
        logModel.setPropName(property.getDisplayName().getLocaleValue());
        this.addLogModel(logModel);
    }

    private void addLogModel(DecryptLogModel logModel) {
        ThreadPools.executeOnce((String)"privacycenter-decryptlogtask-thread", (Runnable)new DecryptLogTask(logModel));
    }

    public void clearCache() {
        PrivacyDataPermissionService.getLocalCache(CACHE_DESENSITIZE_STRATEGY).clear();
        cache.remove(CACHE_DESENSITIZE_STRATEGY);
        cache.remove(CACHE_SCHEMELIMIT);
        cache.remove(CACHE_KEY_TOTALCOUNT);
        cache.remove(CACHE_KEY_FIELD_COUNT);
    }

    private String getFieldCountCacheKey(long userId, String entity, String prop) {
        int day = Calendar.getInstance().get(5);
        return "fieldCount_" + CacheKeyUtil.getAcctId() + userId + entity + prop + day;
    }

    private String getTotalCountCacheKey(long userId) {
        int day = Calendar.getInstance().get(5);
        return "totalCount_" + CacheKeyUtil.getAcctId() + userId + day;
    }

    private SchemeLimitCacheItem getSchemeLimitItem(String entity, String prop) {
        Map<String, SchemeLimitCacheItem> entityMap = this.getALLSchemeLimitItem().get(entity);
        SchemeLimitCacheItem limitItem = entityMap == null ? new SchemeLimitCacheItem() : entityMap.get(prop);
        limitItem.setSchemeId(this.getSchemeId(entity, prop));
        if (limitItem.getSchemeId() == 0L) {
            log.info("privacycenter getSchemeLimitItem can't find scheme entity : {}, prop : {}", (Object)entity, (Object)prop);
            return limitItem;
        }
        DynamicObject globalDObj = this.getGlobalControl();
        if (globalDObj != null) {
            limitItem.setDailyTotalLimit(globalDObj.getInt("dailytotallimit"));
            if (kd.bos.util.StringUtils.isEmpty((String)limitItem.getMessagechannel()) || kd.bos.util.StringUtils.isEmpty((String)limitItem.getTemplate()) || limitItem.getReceiver() == null || limitItem.getReceiver().isEmpty()) {
                limitItem.setMessagechannel(globalDObj.getString("messagechannel"));
                limitItem.setTemplate(globalDObj.getString("template"));
                limitItem.setReceiver(globalDObj.getDynamicObjectCollection("receiver"));
            }
            if (limitItem.getDailyLimit() == 0 || limitItem.getDailyLimit() > limitItem.getDailyTotalLimit()) {
                limitItem.setRule(globalDObj.getString("controlrule"));
            }
        }
        return limitItem;
    }

    private Map<String, Map<String, SchemeLimitCacheItem>> getALLSchemeLimitItem() {
        String cacheKey = "GETALLSCHEMELIMITITEM";
        LocalMemoryCache localMemoryCache = PrivacyDataPermissionService.getLocalCache(CACHE_DESENSITIZE_STRATEGY);
        Map result = (Map)localMemoryCache.get(cacheKey);
        if (result != null) {
            return result;
        }
        String sql = "select B.fentitynumber fentitynumber, B.ffieldident ffieldident, B.fdailylimit  dailylimit, B.frule frule  from t_privacy_decrypt_control B ";
        result = (Map)DB.query((DBRoute)DBRoute.of((String)"sys"), (String)sql, rs -> {
            HashMap map = new HashMap(8);
            while (rs.next()) {
                String field;
                SchemeLimitCacheItem limitItem;
                String entitynumber = rs.getString("fentitynumber");
                HashMap<String, SchemeLimitCacheItem> entityMap = (HashMap<String, SchemeLimitCacheItem>)map.get(entitynumber);
                if (entityMap == null) {
                    entityMap = new HashMap<String, SchemeLimitCacheItem>(8);
                    map.put(entitynumber, entityMap);
                }
                if ((limitItem = (SchemeLimitCacheItem)entityMap.get(field = rs.getString("ffieldident"))) == null) {
                    limitItem = new SchemeLimitCacheItem();
                    limitItem.setEntityNumner(entitynumber);
                    limitItem.setFieldIdent(field);
                    entityMap.put(field, limitItem);
                }
                limitItem.setDailyLimit(rs.getInt("dailylimit"));
                limitItem.setRule(rs.getString("frule"));
            }
            return map;
        });
        localMemoryCache.put(cacheKey, (Object)result);
        return result;
    }

    public static List<Map<String, Object>> getUserInfoByID(List<Long> userID) {
        QFilter filterUser = new QFilter("id", "in", userID);
        String selectFileds = "id,fuid,number,name,phone,email";
        QFilter[] filterUsers = new QFilter[]{filterUser};
        Map userMap = BusinessDataReader.loadFromCache((String)"bos_user", (String)selectFileds, (QFilter[])filterUsers);
        if (CollectionUtils.isEmpty((Map)userMap)) {
            return new ArrayList<Map<String, Object>>(0);
        }
        ArrayList<Map<String, Object>> userInfoLst = new ArrayList<Map<String, Object>>(userMap.size());
        HashMap<String, Object> userInfo = null;
        for (DynamicObject obj : userMap.values()) {
            userInfo = new HashMap<String, Object>(16);
            userInfo.put("userID", userID);
            userInfo.put("uid", obj.getString("fuid"));
            userInfo.put("number", obj.getString("number"));
            userInfo.put("name", obj.getString("name"));
            userInfo.put("phone", obj.getString("phone"));
            userInfo.put("email", obj.getString("email"));
            userInfo.put("type", "1");
            userInfoLst.add(userInfo);
        }
        return userInfoLst;
    }

    public static DynamicObject getUserInfoByID(Long userID, String selector) {
        DynamicObject userInfo = BusinessDataReader.loadSingle((Object)userID, (String)"bos_user", (String)selector);
        return userInfo;
    }

    private String expressionResolution(String msgContent, String entityNum, String propNum, int clickCount) {
        String regex = "\\{([^}]*)\\}";
        try {
            MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityNum);
            IDataEntityProperty prop = entityType.findProperty(propNum);
            String entityName = entityType.getDisplayName().getLocaleValue();
            String propertyName = prop.getDisplayName().getLocaleValue();
            RequestContext ctx = RequestContext.get();
            DynamicObject userInfo = PrivacyDataPermissionService.getUserInfoByID(ctx.getCurrUserId(), "id,number,name");
            String userName = userInfo.getString("name");
            String userNumber = userInfo.getString("number");
            Pattern compile = Pattern.compile(regex);
            Matcher matcher = compile.matcher(msgContent);
            while (matcher.find()) {
                String group = matcher.group();
                String fieldName = group.substring(1, group.length() - 1);
                if (StringUtils.isBlank((CharSequence)fieldName)) {
                    msgContent = msgContent.replace(group, "");
                    continue;
                }
                String value = null;
                if ("entityName".equalsIgnoreCase(fieldName)) {
                    value = entityName;
                } else if ("propertyName".equalsIgnoreCase(fieldName)) {
                    value = propertyName;
                } else if ("clickCount".equalsIgnoreCase(fieldName)) {
                    value = String.valueOf(clickCount);
                } else if ("userName".equalsIgnoreCase(fieldName)) {
                    value = userName;
                } else if ("userNumber".equalsIgnoreCase(fieldName)) {
                    value = userNumber;
                }
                msgContent = msgContent.replace(group, StringUtils.isBlank((CharSequence)value) ? "" : value);
            }
            return msgContent;
        }
        catch (Exception var13) {
            log.error("build msgcontent exception: " + var13.getMessage());
            return msgContent;
        }
    }

    private long getSchemeId(String entityNumber, String fieldIdent) {
        Map<String, PrivacyEncryptModel> map = privacyService.getDesensitizeModels(entityNumber).get(fieldIdent);
        long id = 0L;
        if (map == null || map.isEmpty()) {
            return id;
        }
        id = map.values().stream().findFirst().get().getSchemeId();
        return id;
    }

    private static LocalMemoryCache getLocalCache(String type) {
        CacheConfigInfo info = new CacheConfigInfo();
        info.setTimeout(1800);
        info.setMaxItemSize(500);
        return CacheFactory.getCommonCacheFactory().$getOrCreateLocalMemoryCache(RequestContext.getOrCreate().getAccountId(), PRIVACY_PERMISSION_SERVICE_REGION + type, info);
    }

    public boolean isPrivacyEnable() {
        String cacheKey = "PrivacyDataPermission.isPrivacyEnable";
        return (Boolean)ThreadCache.get((Object)cacheKey, () -> {
            if (PrivacyEnableManager.privacyIsEnable() || PrivacyEnableManager.privacyOldIsEnable()) {
                return true;
            }
            return false;
        });
    }

    class DecryptLogTask
    implements Runnable {
        private final DecryptLogModel logModel;

        DecryptLogTask(DecryptLogModel logModel) {
            this.logModel = logModel;
        }

        @Override
        public void run() {
            RequestContext ctx = RequestContext.get();
            try (TXHandle txh = TX.required();){
                try {
                    DynamicObject dynamicObject;
                    MainEntityType privacy_desen_detaillog = EntityMetadataCache.getDataEntityType((String)"privacy_desen_detaillog");
                    ArrayList<DynamicObject> detailList = new ArrayList<DynamicObject>(3);
                    DynamicObject o = new DynamicObject((DynamicObjectType)privacy_desen_detaillog);
                    o.set("fieldident", (Object)this.logModel.getProp());
                    o.set("fieldname", (Object)this.logModel.getPropName());
                    o.set("entityname", (Object)this.logModel.getEntityName());
                    o.set("entitynumber", (Object)this.logModel.getEntity());
                    o.set("operatetype", (Object)this.logModel.getOperateType());
                    o.set("operateterminal", (Object)this.logModel.getOperateTerminal());
                    o.set("opdate", (Object)this.logModel.getOperateTime());
                    o.set("operator", (Object)this.logModel.getOperatorId());
                    o.set("username", (Object)this.logModel.getOperatorName());
                    o.set("schemeid", (Object)this.logModel.getSchemeId());
                    detailList.add(o);
                    LogORM logORM = LogORM.create();
                    logORM.insert(detailList);
                    MainEntityType privacy_desen_log = EntityMetadataCache.getDataEntityType((String)"privacy_desen_log");
                    StringBuilder selectFields = new StringBuilder();
                    for (IDataEntityProperty property : privacy_desen_log.getProperties()) {
                        selectFields.append(property.getName()).append(",");
                    }
                    selectFields.deleteCharAt(selectFields.length() - 1);
                    ArrayList<DynamicObject> insertList = new ArrayList<DynamicObject>(3);
                    ArrayList<DynamicObject> updateList = new ArrayList<DynamicObject>(3);
                    Date operateDate = PrivacyDataTools.getOperateDate(this.logModel.getOperateTime());
                    QFilter filter = QFilter.of((String)"fieldident = ?", (Object[])new Object[]{this.logModel.getProp()}).and(new QFilter("entitynumber", "=", (Object)this.logModel.getEntity())).and(new QFilter("operator", "=", (Object)this.logModel.getOperatorId())).and(new QFilter("opdate", "=", (Object)operateDate));
                    DynamicObjectCollection result = logORM.query("privacy_desen_log", selectFields.toString(), new QFilter[]{filter}, 1, 0);
                    if (result.isEmpty()) {
                        dynamicObject = new DynamicObject((DynamicObjectType)privacy_desen_log);
                        dynamicObject.set("fieldident", (Object)this.logModel.getProp());
                        dynamicObject.set("fieldname", (Object)this.logModel.getPropName());
                        dynamicObject.set("entityname", (Object)this.logModel.getEntityName());
                        dynamicObject.set("entitynumber", (Object)this.logModel.getEntity());
                        dynamicObject.set("realcount", (Object)1);
                        dynamicObject.set("operator", (Object)this.logModel.getOperatorId());
                        dynamicObject.set("username", (Object)this.logModel.getOperatorName());
                        dynamicObject.set("opdate", (Object)operateDate);
                        dynamicObject.set("schemeid", (Object)this.logModel.getSchemeId());
                        insertList.add(dynamicObject);
                        logORM.insert(insertList);
                    } else {
                        dynamicObject = (DynamicObject)result.get(0);
                        dynamicObject.set("realcount", (Object)(dynamicObject.getInt("realcount") + 1));
                        updateList.add(dynamicObject);
                        logORM.update(updateList);
                    }
                    String countKey = PrivacyDataPermissionService.this.getFieldCountCacheKey(ctx.getCurrUserId(), this.logModel.getEntity(), this.logModel.getProp());
                    String count = (String)cache.get(PrivacyDataPermissionService.CACHE_KEY_FIELD_COUNT, countKey);
                    if (!kd.bos.util.StringUtils.isEmpty((String)count)) {
                        cache.put(PrivacyDataPermissionService.CACHE_KEY_FIELD_COUNT, countKey, String.valueOf(Integer.parseInt(count) + 1), 3600);
                    }
                    String totolKey = PrivacyDataPermissionService.this.getTotalCountCacheKey(ctx.getCurrUserId());
                    String totolCount = (String)cache.get(PrivacyDataPermissionService.CACHE_KEY_TOTALCOUNT, totolKey);
                    if (!kd.bos.util.StringUtils.isEmpty((String)totolCount)) {
                        cache.put(PrivacyDataPermissionService.CACHE_KEY_TOTALCOUNT, totolKey, String.valueOf(Integer.parseInt(totolCount) + 1), 3600);
                    }
                }
                catch (Exception e) {
                    txh.markRollback();
                    log.error((Throwable)e);
                }
            }
        }
    }

    static class DesenAuthor {
        private String entityNumber;
        private String fieldIdent;
        private String formPolicy;
        private String exportPolicy;
        private String printPolicy;

        DesenAuthor() {
        }

        public String getEntityNumber() {
            return this.entityNumber;
        }

        public void setEntityNumber(String entityNumber) {
            this.entityNumber = entityNumber;
        }

        public String getFieldIdent() {
            return this.fieldIdent;
        }

        public void setFieldIdent(String fieldIdent) {
            this.fieldIdent = fieldIdent;
        }

        public String getFormPolicy() {
            return this.formPolicy;
        }

        public void setFormPolicy(String formPolicy) {
            this.formPolicy = formPolicy;
        }

        public String getExportPolicy() {
            return this.exportPolicy;
        }

        public void setExportPolicy(String exportPolicy) {
            this.exportPolicy = exportPolicy;
        }

        public String getPrintPolicy() {
            return this.printPolicy;
        }

        public void setPrintPolicy(String printPolicy) {
            this.printPolicy = printPolicy;
        }

        String getPolicyByOperateType(String operateType) {
            if ("FORM".equals(operateType)) {
                return this.getFormPolicy();
            }
            if ("EXPORT".equals(operateType)) {
                return this.getExportPolicy();
            }
            if ("PRINT".equals(operateType)) {
                return this.getPrintPolicy();
            }
            log.info(String.format("operateType %s can't find config, entityNumber : %s , fieldIdent : %s , formPolicy : %s , exportPolicy : %s , printPolicy : %s ", operateType, this.getEntityNumber(), this.getFieldIdent(), this.getFormPolicy(), this.getExportPolicy(), this.getPrintPolicy()));
            return null;
        }
    }
}

