/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.privacy.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.metadata.IColumnValuePair;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.IDeleteMetaRow;
import kd.bos.dataentity.metadata.ISaveDataTable;
import kd.bos.dataentity.metadata.ISaveMetaRow;
import kd.bos.dataentity.metadata.RowOperateType;
import kd.bos.dataentity.metadata.database.DbMetadataColumn;
import kd.bos.dataentity.metadata.database.DbMetadataRelation;
import kd.bos.dataentity.metadata.database.DbMetadataTable;
import kd.bos.dataentity.metadata.database.DbMetadataTableCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.SqlParameter;
import kd.bos.db.privacy.IPrivacyDataStoreService;
import kd.bos.db.privacy.PrivacyDataConstant;
import kd.bos.db.privacy.model.MappingModel;
import kd.bos.db.privacy.model.PrivacyDataModel;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.SubEntryType;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.dataentity.DataManagerImplement;
import kd.bos.orm.dataentity.ShardingHinter;
import kd.bos.orm.datamanager.DataManagerUtils;
import kd.bos.orm.datamanager.IDataManager;
import kd.bos.orm.datamanager.SyncColumnValuePair;
import kd.bos.orm.impl.ORMConfiguration;
import kd.bos.privacy.service.PrivacyEncryptService;
import kd.bos.privacy.service.PrivacyTableBuilderService;
import kd.bos.privacy.utils.HashTool;
import kd.bos.privacy.utils.PrivacyDBUtils;
import kd.bos.privacy.utils.PrivacyDataTools;
import kd.bos.util.StringUtils;
import kd.bos.xdb.hint.HintCondition;
import kd.bos.xdb.hint.ShardingHintContext;
import kd.bos.xdb.sharding.sql.FilterType;

public class PrivacyDataStoreService
implements IPrivacyDataStoreService {
    private static final Log log = LogFactory.getLog(PrivacyDataStoreService.class);
    private static PrivacyEncryptService privacyService = new PrivacyEncryptService();

    private static PrivacyEncryptService getSingtonService() {
        if (privacyService == null) {
            privacyService = new PrivacyEncryptService();
            return privacyService;
        }
        return privacyService;
    }

    public void savePrivacyData(DBRoute dbRoute, Object table, List<Object> shardingIds, Map<String, Object> initValues) {
        if (table instanceof ISaveDataTable) {
            try {
                this._savePrivacyData(dbRoute, (ISaveDataTable)table, shardingIds, initValues);
            }
            catch (Exception e) {
                log.warn("privacydatacenter error", (Throwable)e);
                if (e instanceof KDException) {
                    throw (KDException)e;
                }
                throw new KDException(PrivacyDataConstant.WARNCODE, e.getMessage(), (Throwable)e);
            }
        }
    }

    private void ModifyShardingIdField(DBRoute dbRoute, String tableName) {
        String privacyTableName = PrivacyTableBuilderService.buildPrivacyTableName(tableName);
        if (DB.exitsTable((DBRoute)dbRoute, (String)privacyTableName) && !this.isExistField(dbRoute, privacyTableName, "FSHARDINGID")) {
            String sql = "IF NOT EXISTS (SELECT 1 FROM KSQL_USERCOLUMNS WHERE KSQL_COL_TABNAME = '" + privacyTableName + "' AND KSQL_COL_NAME ='fshardingid') \nALTER TABLE " + privacyTableName + " ADD fshardingid VARCHAR(300)";
            DB.execute((DBRoute)dbRoute, (String)sql);
        }
    }

    private boolean isExistField(DBRoute dbRoute, String tableName, String fieldName) {
        List fields = DB.getColumnNames((DBRoute)dbRoute, (String)tableName);
        if (fields == null || fields.isEmpty()) {
            return false;
        }
        for (String field : fields) {
            if (!field.equalsIgnoreCase(fieldName)) continue;
            return true;
        }
        return false;
    }

    public void savePrivacyData(DBRoute dbRoute, Object table, String shardingTableName, String shardingFieldName, List<Object> shardingIds, Map<String, Object> initValues) {
        if (table instanceof ISaveDataTable) {
            String tableName = ((ISaveDataTable)table).getSchema().getName();
            for (Tuple tuple : ((ISaveDataTable)table).getSchema().getColumnsByTableGroup()) {
                if (StringUtils.isEmpty((String)((String)tuple.item1)) || !DB.isSharded((String)shardingTableName)) continue;
                this.ModifyShardingIdField(dbRoute, tableName + "_" + (String)tuple.item1);
            }
            if (DB.isSharded((String)shardingTableName)) {
                this.ModifyShardingIdField(dbRoute, tableName);
            }
        }
        if (DB.isSharded((String)shardingTableName)) {
            Map pkIndexMap = ShardingHinter.queryShardingIndex((DBRoute)dbRoute, (String)shardingTableName, shardingIds);
            HashMap<Object, Set> indexPkListMap = new HashMap<Object, Set>();
            int N = shardingIds.size();
            for (int i = 0; i < N; ++i) {
                Object pk = shardingIds.get(i);
                long index = null != pkIndexMap.get(pk) ? (Long)pkIndexMap.get(pk) : -1L;
                indexPkListMap.computeIfAbsent(index, k -> new HashSet()).add(pk);
            }
            for (Map.Entry entry : indexPkListMap.entrySet()) {
                Set pks = (Set)entry.getValue();
                ShardingHintContext ctx = ShardingHintContext.createAndSet((String)shardingTableName, (HintCondition[])new HintCondition[]{new HintCondition(shardingFieldName, FilterType.in_range, Arrays.asList(pks.toArray()))});
                Throwable throwable = null;
                try {
                    this.savePrivacyData(dbRoute, table, Arrays.asList(pks.toArray()), initValues);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (ctx == null) continue;
                    if (throwable != null) {
                        try {
                            ctx.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    ctx.close();
                }
            }
        } else {
            this.savePrivacyData(dbRoute, table, shardingIds, initValues);
        }
    }

    private void _savePrivacyData(DBRoute dbRoute, ISaveDataTable table, List<Object> shardingIds, Map<String, Object> initValues) throws Exception {
        DbMetadataTable tableInfo = table.getSchema();
        IDataEntityType dataEntityType = tableInfo.getDataEntityTypeMap().getDataEntityType();
        boolean isMultilanguage = false;
        if (dataEntityType.getParent() != null) {
            isMultilanguage = ORMConfiguration.isMultiLangDataEntityType((IDataEntityType)dataEntityType);
        }
        if (isMultilanguage) {
            String tableName = dataEntityType.getParent().getAlias();
            this._savePrivacyData(dbRoute, table, isMultilanguage, tableName, shardingIds, initValues);
        } else {
            String tableName = table.getSchema().getName();
            for (Tuple tuple : table.getSchema().getColumnsByTableGroup()) {
                String t = StringUtils.isEmpty((String)((String)tuple.item1)) ? tableName : tableName + "_" + (String)tuple.item1;
                this._savePrivacyData(dbRoute, table, isMultilanguage, t, shardingIds, initValues);
            }
        }
    }

    private void _savePrivacyData(DBRoute dbRoute, ISaveDataTable table, boolean isMultilanguage, String tableName, List<Object> shardingIds, Map<String, Object> initValues) throws Exception {
        tableName = tableName.toLowerCase(Locale.ENGLISH);
        Set<String> encryptFields = PrivacyDataStoreService.getSingtonService().getEncryptFields(tableName);
        if (encryptFields.isEmpty()) {
            return;
        }
        if (table.getDeleteRows() != null && table.getDeleteRows().length > 0) {
            PrivacyDataModel info;
            IDeleteMetaRow row;
            int i;
            ArrayList<PrivacyDataModel> deleteList = new ArrayList<PrivacyDataModel>(10);
            if (isMultilanguage) {
                for (i = 0; i < table.getDeleteRows().length; ++i) {
                    row = table.getDeleteRows()[i];
                    if (!(initValues.get(row.getOid()) instanceof PrivacyDataModel)) continue;
                    info = (PrivacyDataModel)initValues.get(row.getOid());
                    info.setShardingId((Object)shardingIds.get(0).toString());
                    deleteList.add(info);
                }
            } else {
                for (i = 0; i < table.getDeleteRows().length; ++i) {
                    row = table.getDeleteRows()[i];
                    info = new PrivacyDataModel();
                    info.setTableName(tableName);
                    info.setBizId(row.getOid());
                    info.setShardingId((Object)shardingIds.get(0).toString());
                    deleteList.add(info);
                }
            }
            PrivacyDBUtils.delete(dbRoute, tableName, deleteList, isMultilanguage);
        }
        if (table.getSaveRows() != null) {
            ArrayList<PrivacyDataModel> insertList = new ArrayList<PrivacyDataModel>(10);
            ArrayList<PrivacyDataModel> updateList = new ArrayList<PrivacyDataModel>(10);
            for (int i = 0; i < table.getSaveRows().length; ++i) {
                ISaveMetaRow saveRow = table.getSaveRows()[i];
                if (saveRow.getOperate() == RowOperateType.Insert) {
                    this.savePrivateDataForInsert(tableName, isMultilanguage, encryptFields, insertList, saveRow, shardingIds, initValues);
                    continue;
                }
                if (saveRow.getOperate() != RowOperateType.Update) continue;
                this.savePrivateDataForUpdate(tableName, isMultilanguage, encryptFields, updateList, saveRow, shardingIds, initValues);
            }
            PrivacyDataStoreService.getSingtonService().encode(insertList);
            PrivacyDataStoreService.getSingtonService().encode(updateList);
            PrivacyDBUtils.insert(dbRoute, tableName, insertList, isMultilanguage);
            PrivacyDBUtils.update(dbRoute, tableName, updateList, isMultilanguage);
        }
    }

    private void savePrivateDataForUpdate(String tableName, boolean isMultilanguage, Set<String> encryptFields, List<PrivacyDataModel> updateList, ISaveMetaRow saveRow, List<Object> shardingIds, Map<String, Object> initValues) {
        List dirtyVals = saveRow.getDirtyValues();
        ListIterator it = dirtyVals.listIterator();
        IColumnValuePair OidPair = null;
        String localeId = null;
        if (isMultilanguage) {
            OidPair = saveRow.getParentOid();
            localeId = ((SyncColumnValuePair)saveRow.getOid()).getDataEntity().getString("localeId");
        } else {
            OidPair = saveRow.getOid();
        }
        while (it.hasNext()) {
            IColumnValuePair valuePair = (IColumnValuePair)it.next();
            DbMetadataColumn column = valuePair.getColumn();
            String columnName = valuePair.getColumn().getName().toLowerCase(Locale.ENGLISH);
            if (!encryptFields.contains(columnName)) continue;
            String locale = !isMultilanguage && ILocaleString.class.isAssignableFrom(column.getClrType()) ? "GLang" : localeId;
            Object val = null;
            String valKey = OidPair.getValue() + "$$" + columnName;
            if (isMultilanguage) {
                valKey = valKey + "$$" + localeId;
            }
            val = initValues.containsKey(valKey) ? initValues.get(valKey) : valuePair.getValue();
            PrivacyDataModel info = new PrivacyDataModel();
            info.setBizId(OidPair.getValue());
            info.setFieldName(columnName);
            info.setValue(val);
            info.setLocaleId(locale);
            info.setTableName(tableName);
            info.setShardingId((Object)shardingIds.get(0).toString());
            info.setFieldType(column.getDbType());
            info.setHash(HashTool.sha512(String.valueOf(val)));
            updateList.add(info);
        }
    }

    private void savePrivateDataForInsert(String tableName, boolean isMultilanguage, Set<String> encryptFields, List<PrivacyDataModel> insertList, ISaveMetaRow saveRow, List<Object> shardingIds, Map<String, Object> initValues) {
        List dirtyVals = saveRow.getDirtyValues();
        ListIterator it = dirtyVals.listIterator();
        IColumnValuePair OidPair = null;
        String localeId = null;
        if (isMultilanguage) {
            OidPair = saveRow.getParentOid();
            localeId = ((SyncColumnValuePair)saveRow.getOid()).getDataEntity().getString("localeId");
        } else {
            OidPair = saveRow.getOid();
        }
        while (it.hasNext()) {
            IColumnValuePair valuePair = (IColumnValuePair)it.next();
            DbMetadataColumn column = valuePair.getColumn();
            String columnName = column.getName().toLowerCase(Locale.ENGLISH);
            if (!encryptFields.contains(columnName)) continue;
            Object val = null;
            String valKey = OidPair.getValue() + "$$" + columnName;
            String locale = !isMultilanguage && ILocaleString.class.isAssignableFrom(column.getClrType()) ? "GLang" : localeId;
            if (isMultilanguage || "GLang".equals(locale)) {
                valKey = valKey + "$$" + locale;
            }
            val = initValues.containsKey(valKey) ? initValues.get(valKey) : valuePair.getValue();
            PrivacyDataModel info = new PrivacyDataModel();
            info.setBizId(OidPair.getValue());
            info.setFieldName(columnName);
            info.setValue(val);
            info.setShardingId((Object)shardingIds.get(0).toString());
            info.setLocaleId(locale);
            info.setTableName(tableName);
            info.setFieldType(column.getDbType());
            info.setHash(HashTool.sha512(String.valueOf(val)));
            insertList.add(info);
        }
    }

    public void deletePrivacyData(DBRoute dbRoute, Object type, Object[] rootOids) {
        if (!(type instanceof IDataEntityType)) {
            return;
        }
        String shardingMasterKey = "";
        if (type instanceof SubEntryType) {
            shardingMasterKey = ((SubEntryType)type).getParent().getParent().getPrimaryKey().getAlias();
        } else if (type instanceof EntryType) {
            shardingMasterKey = ((EntryType)type).getParent().getPrimaryKey().getAlias();
        } else if (type instanceof MainEntityType) {
            shardingMasterKey = ((MainEntityType)type).getPrimaryKey().getAlias();
        }
        IDataEntityType dt = (IDataEntityType)type;
        IDataManager dataManager = DataManagerUtils.getDataManager((IDataEntityType)dt);
        if (!(dataManager instanceof DataManagerImplement)) {
            return;
        }
        DbMetadataTableCollection tables = ((DataManagerImplement)dataManager).getDatabase().getTables();
        DbMetadataTable rootTable = dataManager.getDataEntityTypeMap().getDbTable();
        List<SqlParameter> pks = PrivacyDBUtils.getPKs(rootOids, rootTable.getPrimaryKey().getDbType());
        try (ShardingHintContext ctx = ShardingHintContext.createAndSet((String)rootTable.getName(), (HintCondition[])new HintCondition[]{new HintCondition(shardingMasterKey, FilterType.in_range, (Object)rootOids)});){
            for (DbMetadataTable currentTable : tables) {
                String tableName = currentTable.getName();
                for (Tuple tuple : currentTable.getColumnsByTableGroup()) {
                    String t = StringUtils.isEmpty((String)((String)tuple.item1)) ? tableName : tableName + "_" + (String)tuple.item1;
                    SqlBuilder deleteSql = this.getDeleteSql(rootTable, pks, currentTable, t);
                    if (deleteSql == null) continue;
                    DB.update((DBRoute)dbRoute, (SqlBuilder)deleteSql);
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private SqlBuilder getDeleteSql(DbMetadataTable rootTable, List<SqlParameter> pks, DbMetadataTable currentTable, String currentTableName) {
        SqlBuilder deletSqlBuilder = new SqlBuilder().append("DELETE FROM ", new Object[0]);
        ArrayList<Object> pkIdList = new ArrayList<Object>(pks.size());
        for (SqlParameter pk : pks) {
            pkIdList.add(pk.getValue());
        }
        DbMetadataRelation parentRelation = currentTable.getParentRelation();
        if (parentRelation != null) {
            DbMetadataTable childTable = currentTable;
            String childTableName = currentTable.getName();
            if (parentRelation.getParentTable() != rootTable) {
                if (parentRelation.getParentTable().getParentRelation().getParentTable() != rootTable) return null;
                childTable = parentRelation.getParentTable();
                childTableName = childTable.getName();
                parentRelation = childTable.getParentRelation();
                Set<String> encryptFields = PrivacyDataStoreService.getSingtonService().getEncryptFields(currentTableName);
                if (encryptFields.isEmpty()) {
                    return null;
                }
                deletSqlBuilder.append(PrivacyDataTools.getPrivacyDataTableName(currentTableName), new Object[0]).append(String.format(" WHERE fbizid IN(SELECT %s FROM %s WHERE %s in (SELECT %s FROM %s WHERE", currentTable.getPrimaryKey().getName(), currentTable, currentTable.getParentRelation().getParentTable().getPrimaryKey().getName(), currentTable.getParentRelation().getParentTable().getPrimaryKey().getName(), childTableName), new Object[0]).appendIn(parentRelation.getChildColumn().getName(), pkIdList).append(")) ", new Object[0]);
                return deletSqlBuilder;
            } else {
                Set<String> encryptFields = PrivacyDataStoreService.getSingtonService().getEncryptFields(currentTableName);
                if (encryptFields.isEmpty()) {
                    return null;
                }
                deletSqlBuilder.append(PrivacyDataTools.getPrivacyDataTableName(currentTableName), new Object[0]).append(String.format(" WHERE fbizid IN(SELECT %s FROM %s WHERE ", currentTable.getPrimaryKey().getName(), currentTableName), new Object[0]).appendIn(parentRelation.getParentTable().getPrimaryKey().getName(), pkIdList).append(")", new Object[0]);
            }
            return deletSqlBuilder;
        } else {
            Set<String> encryptFields = PrivacyDataStoreService.getSingtonService().getEncryptFields(currentTableName);
            if (encryptFields.isEmpty()) {
                return null;
            }
            deletSqlBuilder.append(PrivacyDataTools.getPrivacyDataTableName(currentTableName), new Object[0]).append(" WHERE ", new Object[0]).appendIn("fbizid", pkIdList);
        }
        return deletSqlBuilder;
    }

    public void insertMapping(String entityNumber, String tableName, String fieldName, String dataClassify, String dbRouterStr, String isLocale, String pkName, String orderBy, Integer fieldType) throws Exception {
    }

    public void deleteMapping(String dbRouter, Map<String, MappingModel> delModels, String isLocale, String pkName) throws Exception {
    }

    public void updatePrivacyMapping(String dbRouter, String oldClassify, MappingModel mm, String isLocale, String pkName, String orderBy, Integer fieldType) throws Exception {
    }

    public Map<String, MappingModel> queryAllMappingModel(String tableName) {
        return null;
    }
}

