/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.privacy.service;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.cache.CacheConfigInfo;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.LocalMemoryCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.privacy.IPrivacyEncryptService;
import kd.bos.db.privacy.PrivacyDataConstant;
import kd.bos.db.privacy.model.PrivacyDataModel;
import kd.bos.exception.KDException;
import kd.bos.inte.api.EnabledLang;
import kd.bos.inte.api.IInteService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.PermissionService;
import kd.bos.permission.model.perm.SchemeDataProcessingResult;
import kd.bos.privacy.DesensitizeStrategyFactory;
import kd.bos.privacy.IDesensitizeStrategy;
import kd.bos.privacy.model.PrivacyEncryptModel;
import kd.bos.privacy.service.PrivacyEnableManager;
import kd.bos.privacy.utils.HashTool;
import kd.bos.privacy.utils.PrivacyDataConvertUtils;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import org.apache.commons.collections.map.CaseInsensitiveMap;

public class PrivacyEncryptService
implements IPrivacyEncryptService {
    private static final String BOS_PRIVACY_IMPLEMENT = "bos-privacy-implement";
    private static final String PRIVACY_ENCRYPT_SERVICE_REGION = "PRIVACY_ENCRYPT_SERVICE_REGION";
    private static final Log log = LogFactory.getLog(PrivacyEncryptService.class);
    public static final String CACHE_TYPE_ENCRYPT = "ENCRYPT";
    public static final String CACHE_TYPE_DESENSITIZE = "DESENSITIZE";
    public static final String CACHE_TYPE_ISDATAMIGRATING = "ISDATAMIGRATING";
    private IDB IDB = new IDB(){

        @Override
        public DataSet queryDataSet(String algoKey, DBRoute dbRoute, String sql) {
            return DB.queryDataSet((String)algoKey, (DBRoute)dbRoute, (String)sql);
        }

        @Override
        public DataSet queryDataSet(String alogKey, DBRoute dbRoute, String sql, SqlParameter[] params) {
            return DB.queryDataSet((String)alogKey, (DBRoute)dbRoute, (String)sql, (Object[])params);
        }
    };

    public void encode(List<PrivacyDataModel> modelList) throws Exception {
        for (PrivacyDataModel model : modelList) {
            this.encodeInternal(model);
        }
    }

    public boolean isDesensitizeField(String entityNumber, String fieldIdent) {
        if (StringUtils.isEmpty((String)entityNumber) || StringUtils.isEmpty((String)fieldIdent)) {
            return false;
        }
        Map<String, Map<String, PrivacyEncryptModel>> models = this.getDesensitizeModels(entityNumber);
        if (models.isEmpty()) {
            return false;
        }
        Map<String, PrivacyEncryptModel> fieldMap = models.get(fieldIdent);
        if (fieldMap == null || fieldMap.isEmpty()) {
            return false;
        }
        boolean isDesensitizeField = false;
        for (Map.Entry<String, PrivacyEncryptModel> entry : fieldMap.entrySet()) {
            PrivacyEncryptModel model = entry.getValue();
            if (!model.isDesensitizeField()) continue;
            isDesensitizeField = model.isDesensitizeField();
            break;
        }
        return isDesensitizeField;
    }

    public boolean isDesensitizeField(String entityNumber, String fieldIdent, String localeId, Object dynamicObject) {
        if (StringUtils.isEmpty((String)entityNumber) || StringUtils.isEmpty((String)fieldIdent) || StringUtils.isEmpty((String)localeId)) {
            return false;
        }
        PrivacyEncryptModel encryptModel = this.getDesensitizeModel(entityNumber, fieldIdent, localeId);
        if (encryptModel == null) {
            return false;
        }
        return encryptModel.isDesensitizeField();
    }

    public boolean isDesensitizeField(String entityNumber, String fieldIdent, String localeId) {
        return this.isDesensitizeField(entityNumber, fieldIdent, localeId, null);
    }

    public void encode(PrivacyDataModel model) throws Exception {
        this.encodeInternal(model);
    }

    public void decode(List<PrivacyDataModel> list) throws Exception {
        for (PrivacyDataModel model : list) {
            this.decodeInternal(model);
        }
    }

    public void decode(Map<String, List<PrivacyDataModel>> modelList) throws Exception {
        this.decodeInternal(modelList);
    }

    public JSONObject decryptData(long schemeId, String bizData) {
        PermissionService service = (PermissionService)ServiceFactory.getService(PermissionService.class);
        return service.decryptData(schemeId, bizData);
    }

    public SchemeDataProcessingResult decryptData(Map<String, List<PrivacyDataModel>> bizData) {
        PermissionService service = (PermissionService)ServiceFactory.getService(PermissionService.class);
        return service.decryptData(bizData);
    }

    public void decode(List<PrivacyDataModel> modelList, String encrypt, Integer version) throws Exception {
        String valStr = "";
        Object val = null;
        long schemeId = Long.parseLong(encrypt);
        for (PrivacyDataModel model : modelList) {
            JSONObject jsonObject = this.decryptData(schemeId, model.getEncryptValue());
            if (!Boolean.TRUE.equals(jsonObject.getBoolean("success"))) {
                log.warn(String.format("decryptData error schemeId: %s and bizData %s", encrypt, model.getEncryptValue()) + jsonObject.toJSONString());
                throw new KDException(PrivacyDataConstant.ERRORCODE, new Object[]{jsonObject.get((Object)"description")});
            }
            valStr = jsonObject.getString("data");
            val = PrivacyDataConvertUtils.convert(valStr, model.getFieldType());
            model.setValue(val);
        }
    }

    public void decode(PrivacyDataModel model) throws Exception {
        this.decodeInternal(model);
    }

    public void desensitize(PrivacyDataModel model) throws Exception {
        this.desensitizeInternal(model);
    }

    public void desensitize(List<PrivacyDataModel> modelList) throws Exception {
        for (PrivacyDataModel model : modelList) {
            this.desensitizeInternal(model);
        }
    }

    public boolean isEncryptField(String tableName, String fieldName) {
        Set<String> encryptFields = this.getEncryptFields(tableName);
        boolean isEncryptField = encryptFields.contains(fieldName);
        return isEncryptField;
    }

    public Object getDesensitizeValue(String entityNum, String fieldIdent, String localeid, Object dynamicObject, Object value) {
        try {
            if (!this.isDesensitizeField(entityNum, fieldIdent)) {
                return value;
            }
            if (value instanceof ILocaleString) {
                ILocaleString localeValue = (ILocaleString)value;
                ArrayList<PrivacyDataModel> list = new ArrayList<PrivacyDataModel>(6);
                List enableLangs = ((IInteService)ServiceFactory.getService(IInteService.class)).getMultiLangEnabledLang();
                for (EnabledLang lang : enableLangs) {
                    String localId = lang.getNumber();
                    PrivacyDataModel data = new PrivacyDataModel();
                    data.setTableName(entityNum);
                    data.setFieldName(fieldIdent);
                    data.setValue(localeValue.get((Object)localId));
                    data.setLocaleId(localId);
                    list.add(data);
                }
                this.desensitize(list);
                LocaleString newVal = new LocaleString();
                for (PrivacyDataModel dataModel : list) {
                    newVal.put((Object)dataModel.getLocaleId(), (Object)dataModel.getDesensitizeValue());
                }
                return newVal;
            }
            PrivacyDataModel data = new PrivacyDataModel();
            data.setTableName(entityNum);
            data.setFieldName(fieldIdent);
            data.setValue(value);
            data.setLocaleId(localeid);
            this.desensitize(data);
            return data.getDesensitizeValue();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Set<String> getEncryptFields(String tableName) {
        Map<String, Map<String, PrivacyEncryptModel>> effectiveTasks = this.geteffectiveTasks();
        Map<String, PrivacyEncryptModel> map = effectiveTasks.get(tableName);
        if (map != null && !map.isEmpty()) {
            String entity = map.entrySet().iterator().next().getValue().getEntityNumber();
            log.warn("\u6570\u636e\u8fc1\u79fb\u4efb\u52a1\u5904\u7406\u4e2d\uff0c\u6682\u4e0d\u80fd\u64cd\u4f5c\u5355\u636e\u3002 tableName\uff1a " + tableName + SerializationUtils.toJsonString(effectiveTasks));
            String msg = String.format(ResManager.loadKDString((String)"\u6570\u636e\u8fc1\u79fb\u4efb\u52a1\u5904\u7406\u4e2d\uff0c\u6682\u4e0d\u80fd\u64cd\u4f5c\u5355\u636e\uff08%s\uff09\u3002", (String)"PrivacyEncryptService_0", (String)BOS_PRIVACY_IMPLEMENT, (Object[])new Object[0]), entity);
            throw new KDException(PrivacyDataConstant.WARNCODE, new Object[]{msg});
        }
        Set<String> encryptFields = this.getEncryptModelsByTable(tableName).keySet();
        return encryptFields;
    }

    public JSONObject encryptData(long schemeId, String bizData) {
        PermissionService service = (PermissionService)ServiceFactory.getService(PermissionService.class);
        return service.encryptData(schemeId, bizData);
    }

    public void buildFuzzyHash(PrivacyDataModel model) {
        model.setFuzzyHash(this.innerBuildFuzzy(model.getValue()));
    }

    public String innerBuildFuzzy(Object origin) {
        if (origin == null) {
            return null;
        }
        if (origin instanceof String) {
            String originStr = (String)origin;
            int length = originStr.length();
            ArrayList<String> subStrList = new ArrayList<String>(length);
            for (int i = 0; i < length - 3; ++i) {
                String substring = originStr.substring(i, i + 4);
                subStrList.add(HashTool.sha512(substring));
            }
            return subStrList.stream().collect(Collectors.joining(""));
        }
        return null;
    }

    private void encodeInternal(PrivacyDataModel model) {
        String valStr = "";
        Object val = null;
        PrivacyEncryptModel encryptModel = this.getEncryptModelsByTable(model.getTableName()).get(model.getFieldName());
        if (encryptModel == null || StringUtils.isEmpty((String)encryptModel.getEncryptAlgorithm())) {
            log.info("encodeInternal.encryptModel is null");
            throw new KDException(PrivacyDataConstant.ERRORCODE, new Object[]{ResManager.loadKDString((String)"\u65e0\u6cd5\u83b7\u53d6\u52a0\u5bc6\u65b9\u6848\u3002", (String)"PrivacyEncryptService_4", (String)BOS_PRIVACY_IMPLEMENT, (Object[])new Object[0])});
        }
        model.setVersion(encryptModel.getVersion().intValue());
        long schemeId = Long.parseLong(encryptModel.getEncryptAlgorithm());
        val = model.getValue();
        valStr = PrivacyDataConvertUtils.convert(val);
        JSONObject jsonObject = this.encryptData(schemeId, valStr);
        if (!Boolean.TRUE.equals(jsonObject.getBoolean("success"))) {
            log.warn(String.format("encryptData error schemeId: %s and bizData %s", schemeId, model.getEncryptValue()) + jsonObject.toJSONString());
            throw new KDException(PrivacyDataConstant.ERRORCODE, new Object[]{jsonObject.get((Object)"description")});
        }
        valStr = jsonObject.getString("data");
        model.setEncrypt(encryptModel.getEncryptAlgorithm());
        model.setEncryptValue(valStr);
    }

    private void decodeInternal(PrivacyDataModel model) {
        String valStr = "";
        Object val = null;
        if (model.getEncrypt() == null) {
            return;
        }
        long schemeId = Long.parseLong(model.getEncrypt());
        JSONObject jsonObject = this.decryptData(schemeId, model.getEncryptValue());
        if (!Boolean.TRUE.equals(jsonObject.getBoolean("success"))) {
            log.warn(String.format("decryptData error schemeId: %s and bizData :%s table :%s field :%s", model.getEncrypt(), model.getEncryptValue(), model.getTableName(), model.getFieldName()) + jsonObject.toJSONString());
            throw new KDException(PrivacyDataConstant.ERRORCODE, new Object[]{jsonObject.get((Object)"description")});
        }
        valStr = jsonObject.getString("data");
        val = PrivacyDataConvertUtils.convert(valStr, model.getFieldType());
        model.setValue(val);
    }

    private void decodeInternal(Map<String, List<PrivacyDataModel>> models) {
        Object val = null;
        if (models.size() <= 0) {
            return;
        }
        long decryptTime = System.currentTimeMillis();
        SchemeDataProcessingResult jsonObject = this.decryptData(models);
        if (!Boolean.TRUE.equals(jsonObject.isSuccess())) {
            throw new KDException(PrivacyDataConstant.ERRORCODE, new Object[]{jsonObject.getDescription()});
        }
    }

    private void desensitizeInternal(PrivacyDataModel model) {
        String localId;
        String fieldIdent;
        String entityNumber = model.getTableName();
        PrivacyEncryptModel encryptModel = this.getDesensitizeModel(entityNumber, fieldIdent = model.getFieldName(), localId = model.getLocaleId());
        if (encryptModel == null || !encryptModel.isDesensitizeField()) {
            if (model.getValue() != null) {
                model.setDesensitizeValue(String.valueOf(model.getValue()));
            }
            return;
        }
        if (encryptModel.getDesensitizeRule() == null && encryptModel.getDesensitizeType() == null) {
            return;
        }
        IDesensitizeStrategy strategy = DesensitizeStrategyFactory.getStrategy(encryptModel.getDesensitizeRule());
        if (strategy == null) {
            throw new RuntimeException(String.format(ResManager.loadKDString((String)"\u5b9e\u4f53[%1$s]\uff0c\u5c5e\u6027[%2$s]\u914d\u7f6e\u7684\u7b56\u7565[%3$s]\u672a\u80fd\u627e\u5230\u5bf9\u5e94\u7b56\u7565", (String)"PrivacyEncryptService_3", (String)BOS_PRIVACY_IMPLEMENT, (Object[])new Object[0]), encryptModel.getTableName(), encryptModel.getFieldName(), encryptModel.getDesensitizeRule()));
        }
        String desensitizeValue = strategy.desensitize(encryptModel, model.getValue());
        model.setDesensitizeValue(desensitizeValue);
    }

    private PrivacyEncryptModel getDesensitizeModel(String entityNumber, String fieldIdent, String localId) {
        PrivacyEncryptModel encryptModelTmp;
        Map<String, Map<String, PrivacyEncryptModel>> encryptModels = this.getDesensitizeModels(entityNumber);
        if (encryptModels == null || encryptModels.isEmpty()) {
            return null;
        }
        Map<String, PrivacyEncryptModel> fieldMap = encryptModels.get(fieldIdent);
        if (fieldMap == null || fieldMap.isEmpty()) {
            return null;
        }
        PrivacyEncryptModel encryptModel = fieldMap.get("default");
        if (encryptModel == null) {
            return null;
        }
        if ("1112".equals(encryptModel.getFieldType()) && this.isMuliEnv() && (encryptModelTmp = fieldMap.get(localId)) != null) {
            encryptModel = encryptModelTmp;
        }
        return encryptModel;
    }

    public void clearCache() {
        this.clearAllCache();
    }

    private void clearAllCache() {
        this.getLocalCache(CACHE_TYPE_ENCRYPT).clear();
        this.getLocalCache(CACHE_TYPE_DESENSITIZE).clear();
        this.getLocalCache(CACHE_TYPE_ISDATAMIGRATING).clear();
        log.info("kd.bos.privacy.service.PrivacyEncryptService.clearCache()");
    }

    public void clearCache(String cacheKey) {
        this.getLocalCache(cacheKey).clear();
        log.info("kd.bos.privacy.service.PrivacyEncryptService.clearCache() and cacheKey:" + cacheKey);
    }

    public Map<String, PrivacyEncryptModel> getEncryptModelsByTable(String tableName) {
        Map<String, Map<String, PrivacyEncryptModel>> decodeTasks;
        Map<String, PrivacyEncryptModel> decodeFields;
        Map<String, PrivacyEncryptModel> result = this.getEncryptModelsByTableInternal(tableName);
        Map<String, PrivacyEncryptModel> ret = null;
        Map<String, Map<String, PrivacyEncryptModel>> encodeTasks = this.getIneffectiveTasks(String.valueOf(1));
        Map<String, PrivacyEncryptModel> encodeFields = encodeTasks.get(tableName);
        if (encodeFields != null && !encodeFields.isEmpty()) {
            ret = new HashMap<String, PrivacyEncryptModel>(result);
            ret.putAll(encodeFields);
        }
        if ((decodeFields = (decodeTasks = this.getIneffectiveTasks(String.valueOf(2))).get(tableName)) != null && !decodeFields.isEmpty()) {
            if (ret == null) {
                ret = new HashMap<String, PrivacyEncryptModel>(result);
            }
            ret.putAll(decodeFields);
        }
        if (ret == null) {
            ret = result;
        }
        return ret;
    }

    private Map<String, PrivacyEncryptModel> getEncryptModelsByTableInternal(String tableName) {
        if (!this.checkBlackListEncrypt(tableName)) {
            return Collections.emptyMap();
        }
        Map<String, PrivacyEncryptModel> tabMap = this.getAllEncryptModels().get(tableName);
        if (tabMap == null) {
            tabMap = Collections.emptyMap();
        }
        return tabMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Map<String, PrivacyEncryptModel>> getAllEncryptModels() {
        String cacheKey;
        if (!PrivacyEnableManager.privacyEncryptIsEnable() && !PrivacyEnableManager.privacyOldIsEnable()) {
            return Collections.emptyMap();
        }
        LocalMemoryCache localMemoryCache = this.getLocalCache(CACHE_TYPE_ENCRYPT);
        Map<String, Map<String, PrivacyEncryptModel>> result = (Map<String, Map<String, PrivacyEncryptModel>>)localMemoryCache.get(cacheKey = "getAllEncryptModels");
        if (result != null) {
            return result;
        }
        LocalMemoryCache localMemoryCache2 = localMemoryCache;
        synchronized (localMemoryCache2) {
            result = new CaseInsensitiveMap(8);
            String sql = "select C.fencrypt_table_name,C.fencrypt_field_name,C.fencrypt_field_ident,C.fencrypt_algorithm,C.fversion,C.fencrypt_entity_number \nfrom t_privacy_scheme_encrypt c where   c.fencrypt_algorithm <> 'NO'  \norder by C.fencrypt_table_name ";
            try (DataSet rs = this.IDB.queryDataSet("PrivacyEncryptService.getAllEncryptModels", DBRoute.of((String)"sys"), sql);){
                while (rs.hasNext()) {
                    Row row = rs.next();
                    PrivacyEncryptModel model = new PrivacyEncryptModel();
                    model.setEncryptAlgorithm(row.getString("fencrypt_algorithm"));
                    model.setVersion(row.getInteger("FVERSION"));
                    model.setEntityNumber(row.getString("fencrypt_entity_number"));
                    model.setFieldIdent(row.getString("fencrypt_field_ident"));
                    model.setTableName(row.getString("fencrypt_table_name"));
                    model.setFieldName(row.getString("fencrypt_field_name"));
                    CaseInsensitiveMap tabMap = result.get(model.getTableName());
                    if (tabMap == null) {
                        tabMap = new CaseInsensitiveMap(8);
                        result.put(model.getTableName(), (Map<String, PrivacyEncryptModel>)tabMap);
                    }
                    tabMap.put(model.getFieldName(), model);
                }
            }
            catch (Exception e) {
                log.error("privacycenter error", (Throwable)e);
                throw e;
            }
            if (result.isEmpty()) {
                result = Collections.emptyMap();
            }
            localMemoryCache.put(cacheKey, result);
        }
        return result;
    }

    public Map<String, Map<String, PrivacyEncryptModel>> getDesensitizeModels(String entityNumber) {
        Map<String, Map<String, PrivacyEncryptModel>> result = this.getAllDesensitizeModels().get(entityNumber);
        if (result == null) {
            return Collections.emptyMap();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Map<String, Map<String, PrivacyEncryptModel>>> getAllDesensitizeModels() {
        String cacheKey;
        if (!PrivacyEnableManager.privacyDesenIsEnable() && !PrivacyEnableManager.privacyOldIsEnable()) {
            return Collections.emptyMap();
        }
        LocalMemoryCache localMemoryCache = this.getLocalCache(CACHE_TYPE_DESENSITIZE);
        Map result = (HashMap)localMemoryCache.get(cacheKey = "getAllDesensitizeModels");
        if (result != null) {
            return result;
        }
        LocalMemoryCache localMemoryCache2 = localMemoryCache;
        synchronized (localMemoryCache2) {
            HashMap<String, PrivacyEncryptModel> fieldMap;
            result = (Map)localMemoryCache.get(cacheKey);
            if (result != null) {
                return result;
            }
            result = new HashMap(8);
            Map<String, String> nonDesensitization = this.loadNoDesensitizationRules();
            HashMap<String, HashSet<PrivacyEncryptModel>> followFieldMap = new HashMap<String, HashSet<PrivacyEncryptModel>>(6);
            try {
                String sql = "SELECT C.fid, C.fdense_field_ident,C.fdesensitize_rule, C.fdense_entity_number,C.fdensefieldlocale,C.fdesensitize_type,C.fplugin,C.fdense_field_type \nFROM T_PRIVACY_SCHEME_DESEN C  where  C.fdesensitiz_status = '1'\norder by C.fdense_entity_number, C.fdense_field_ident,C.fdensefieldlocale desc;";
                try (DataSet rs = this.IDB.queryDataSet("PrivacyEncryptService.getAllDesensitizeModels", DBRoute.of((String)"sys"), sql);){
                    while (rs.hasNext()) {
                        Row row = rs.next();
                        PrivacyEncryptModel model = new PrivacyEncryptModel();
                        model.setSchemeId(row.getLong("fid"));
                        String fieldlocale = row.getString("fdensefieldlocale");
                        if (StringUtils.isEmpty((String)fieldlocale)) {
                            fieldlocale = "default";
                        }
                        model.setDesensitizeType(row.getString("FDESENSITIZE_TYPE"));
                        model.setDesensitizeRule(row.getString("fdesensitize_rule"));
                        model.setEntityNumber(row.getString("fdense_entity_number"));
                        model.setFieldIdent(row.getString("fdense_field_ident"));
                        model.setFieldLocale(fieldlocale);
                        model.setFieldType(row.getString("fdense_field_type"));
                        HashMap<String, HashMap<String, PrivacyEncryptModel>> entityMap = (HashMap<String, HashMap<String, PrivacyEncryptModel>>)result.get(model.getEntityNumber());
                        if (entityMap == null) {
                            entityMap = new HashMap<String, HashMap<String, PrivacyEncryptModel>>(8);
                            result.put((String)model.getEntityNumber(), entityMap);
                        }
                        if ((fieldMap = (Map)entityMap.get(model.getFieldIdent())) == null) {
                            fieldMap = new HashMap<String, PrivacyEncryptModel>(6);
                            entityMap.put(model.getFieldIdent(), fieldMap);
                        }
                        fieldMap.put(model.getFieldLocale(), model);
                        if ("FOLLOW".equals(model.getDesensitizeRule())) {
                            HashSet<PrivacyEncryptModel> followFields = (HashSet<PrivacyEncryptModel>)followFieldMap.get(model.getEntityNumber());
                            if (followFields == null) {
                                followFields = new HashSet<PrivacyEncryptModel>(8);
                                followFieldMap.put(model.getEntityNumber(), followFields);
                            }
                            followFields.add(model);
                            continue;
                        }
                        model.setDesensitizeField(this.isDesensitizeModel(model, nonDesensitization));
                    }
                }
            }
            catch (Exception e) {
                log.warn("privacycenter error", (Throwable)e);
                throw e;
            }
            for (Map.Entry entry : followFieldMap.entrySet()) {
                String entityNumber = (String)entry.getKey();
                Set followFields = (Set)entry.getValue();
                Map entityMap = (Map)result.get(entityNumber);
                if (entityMap == null) continue;
                for (PrivacyEncryptModel model : followFields) {
                    fieldMap = (HashMap<String, PrivacyEncryptModel>)entityMap.get(model.getFieldIdent());
                    PrivacyEncryptModel defaultModel = (PrivacyEncryptModel)fieldMap.get("default");
                    if (defaultModel == null) {
                        fieldMap.remove(model.getFieldLocale());
                        if (!fieldMap.isEmpty()) continue;
                        result.remove(model.getFieldIdent());
                        continue;
                    }
                    model.setDesensitizeRule(defaultModel.getDesensitizeRule());
                    model.setPlugin(defaultModel.getPlugin());
                    model.setDesensitizeType(defaultModel.getDesensitizeType());
                    model.setDesensitizeField(this.isDesensitizeModel(model, nonDesensitization));
                }
            }
            if (result.isEmpty()) {
                result = Collections.emptyMap();
            }
            localMemoryCache.put(cacheKey, result);
        }
        return result;
    }

    private boolean isDesensitizeModel(PrivacyEncryptModel encryptModel, Map<String, String> nonDesensitization) {
        boolean isDesensitizeField;
        String rule = encryptModel.getDesensitizeRule();
        switch (encryptModel.getDesensitizeType()) {
            case "SYSTEM": {
                rule = nonDesensitization.getOrDefault(rule, rule);
                if (StringUtils.isNotEmpty((String)rule) && !rule.equals("NO") && !rule.equals("FOLLOW")) {
                    isDesensitizeField = true;
                    break;
                }
                isDesensitizeField = false;
                break;
            }
            case "CUSTOM": {
                if (StringUtils.isNotEmpty((String)encryptModel.getPlugin())) {
                    isDesensitizeField = true;
                    break;
                }
                isDesensitizeField = false;
                break;
            }
            default: {
                isDesensitizeField = false;
            }
        }
        return isDesensitizeField;
    }

    private Map<String, Map<String, PrivacyEncryptModel>> getIneffectiveTasks(String ftask_type) {
        String cacheKey;
        LocalMemoryCache localMemoryCache = this.getLocalCache(CACHE_TYPE_ISDATAMIGRATING);
        Map result = (HashMap)localMemoryCache.get(cacheKey = "ftask_type_" + ftask_type);
        if (result != null) {
            return result;
        }
        result = new HashMap(6);
        String sql = "SELECT C.fencrypt_table_name,C.fencrypt_field_name,C.fencrypt_field_ident,C.fencrypt_algorithm,C.fversion,C.fencrypt_entity_number,A.foldencrypt_type,A.ftask_type FROM T_PRIVACY_SCHEME_ENCRYPT C right join t_privacy_task A on C.fencrypt_table_name= A.ftable_name and C.fencrypt_field_name = A.ffield_name where (A.ftask_status = '0'  or A.ftask_status = '1' or A.ftask_status = '2'  or A.ftask_status = '4') and A.ftask_type = ?;";
        SqlParameter[] selectParas = new SqlParameter[]{new SqlParameter(":ftask_type", 12, (Object)ftask_type)};
        try (DataSet rs = this.IDB.queryDataSet("PrivacyEncryptService.getIneffectiveTasks", DBRoute.of((String)"sys"), sql, selectParas);){
            while (rs.hasNext()) {
                Row row = rs.next();
                String ftable_name = row.getString("fencrypt_table_name");
                if (StringUtils.isEmpty((String)ftable_name)) continue;
                HashMap<String, PrivacyEncryptModel> fieldMap = (HashMap<String, PrivacyEncryptModel>)result.get(ftable_name);
                if (fieldMap == null) {
                    fieldMap = new HashMap<String, PrivacyEncryptModel>(6);
                    result.put((String)ftable_name, fieldMap);
                }
                PrivacyEncryptModel model = new PrivacyEncryptModel();
                String encryptAlgorithm = String.valueOf(1).equals(row.getString("ftask_type")) ? "fencrypt_algorithm" : "foldencrypt_type";
                model.setEncryptAlgorithm(row.getString(encryptAlgorithm));
                model.setVersion(row.getInteger("FVERSION"));
                model.setEntityNumber(row.getString("fencrypt_entity_number"));
                model.setFieldIdent(row.getString("fencrypt_field_ident"));
                model.setTableName(ftable_name);
                model.setFieldName(row.getString("fencrypt_field_name"));
                fieldMap.put(model.getFieldName(), model);
            }
            if (log.isInfoEnabled()) {
                log.info("getIneffectiveTasks:" + SerializationUtils.toJsonString(result));
            }
        }
        catch (Exception e) {
            log.warn("privacycenter error", (Throwable)e);
            throw e;
        }
        if (result.isEmpty()) {
            result = Collections.emptyMap();
        }
        localMemoryCache.put(cacheKey, result);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Map<String, PrivacyEncryptModel>> geteffectiveTasks() {
        String cacheKey;
        LocalMemoryCache localMemoryCache = this.getLocalCache(CACHE_TYPE_ISDATAMIGRATING);
        Map<String, Map<String, PrivacyEncryptModel>> result = (Map<String, Map<String, PrivacyEncryptModel>>)localMemoryCache.get(cacheKey = "geteffectiveTasks");
        if (result != null) {
            return result;
        }
        LocalMemoryCache localMemoryCache2 = localMemoryCache;
        synchronized (localMemoryCache2) {
            result = (Map)localMemoryCache.get(cacheKey);
            if (result != null) {
                return result;
            }
            result = new CaseInsensitiveMap(8);
            String sql = "SELECT C.fencrypt_table_name,C.fencrypt_field_name,C.fencrypt_field_ident,C.fencrypt_algorithm,C.fversion,C.fencrypt_entity_number,A.foldencrypt_type, A.ftask_type FROM T_PRIVACY_SCHEME_ENCRYPT C right join t_privacy_task A on C.fencrypt_table_name= A.ftable_name and C.fencrypt_field_name = A.ffield_name where A.ftask_status = '2' or A.ftask_status = '5'";
            try (DataSet rs = this.IDB.queryDataSet("PrivacyEncryptService.geteffectiveTasks", DBRoute.of((String)"sys"), sql);){
                while (rs.hasNext()) {
                    Row row = rs.next();
                    String encryptAlgorithm = String.valueOf(1).equals(row.getString("ftask_type")) ? "fencrypt_algorithm" : "foldencrypt_type";
                    String ftable_name = row.getString("fencrypt_table_name");
                    if (StringUtils.isEmpty((String)ftable_name)) continue;
                    CaseInsensitiveMap fieldMap = result.get(ftable_name);
                    if (fieldMap == null) {
                        fieldMap = new CaseInsensitiveMap(8);
                        result.put(ftable_name, (Map<String, PrivacyEncryptModel>)fieldMap);
                    }
                    PrivacyEncryptModel model = new PrivacyEncryptModel();
                    model.setEncryptAlgorithm(row.getString(encryptAlgorithm));
                    model.setVersion(row.getInteger("FVERSION"));
                    model.setEntityNumber(row.getString("fencrypt_entity_number"));
                    model.setFieldIdent(row.getString("fencrypt_field_ident"));
                    model.setTableName(ftable_name);
                    model.setFieldName(row.getString("fencrypt_field_name"));
                    fieldMap.put(model.getFieldName(), model);
                }
                if (log.isInfoEnabled()) {
                    log.info("geteffectiveTasks:" + SerializationUtils.toJsonString((Object)result));
                }
            }
            catch (Exception e) {
                log.warn("privacycenter error", (Throwable)e);
                throw e;
            }
            if (result.isEmpty()) {
                result = Collections.emptyMap();
            }
            localMemoryCache.put(cacheKey, result);
        }
        return result;
    }

    public boolean checkBlackListEncrypt(String tableName) {
        return true;
    }

    private boolean isMuliEnv() {
        boolean isMuliEnv = true;
        List enableLangs = ((IInteService)ServiceFactory.getService(IInteService.class)).getMultiLangEnabledLang();
        if (enableLangs == null || enableLangs.isEmpty() || enableLangs.size() == 1 && ((EnabledLang)enableLangs.get((int)0)).isDefault.booleanValue()) {
            isMuliEnv = false;
        }
        return isMuliEnv;
    }

    protected LocalMemoryCache getLocalCache(String type) {
        CacheConfigInfo info = new CacheConfigInfo();
        info.setTimeout(600);
        info.setMaxItemSize(1000);
        return CacheFactory.getCommonCacheFactory().$getOrCreateLocalMemoryCache(RequestContext.getOrCreate().getAccountId(), PRIVACY_ENCRYPT_SERVICE_REGION + type, info);
    }

    private Map<String, String> loadNoDesensitizationRules() {
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"loadDesensitizationRules", (String)"privacy_desen_rules", (String)"id,number", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)"NO")}, null);){
            HashMap<String, String> strategyMap = new HashMap<String, String>(16);
            while (dataSet.hasNext()) {
                Row data = dataSet.next();
                String number = data.getString("number");
                strategyMap.put(data.getString("id"), number);
            }
            HashMap<String, String> hashMap = strategyMap;
            return hashMap;
        }
    }

    static interface IDB {
        public DataSet queryDataSet(String var1, DBRoute var2, String var3);

        public DataSet queryDataSet(String var1, DBRoute var2, String var3, SqlParameter[] var4);
    }
}

