/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.privacy.task;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.SqlParameter;
import kd.bos.db.privacy.model.PrivacyDataModel;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.privacy.task.BaseTask;
import kd.bos.util.StringUtils;
import kd.bos.xdb.hint.HintCondition;
import kd.bos.xdb.hint.ShardingHintContext;
import kd.bos.xdb.sharding.sql.FilterType;

public class DecodeTask
extends BaseTask {
    private static final Log logger = LogFactory.getLog(DecodeTask.class);
    private static Long queryTime = 0L;
    private static Long decodeTime = 0L;
    private static Long commonLangTime = 0L;
    private static Long privacyDataTime = 0L;
    private static Long clearTime = 0L;
    private static Long totalCount = 0L;
    private static final String BOS_PRIVACY_IMPLEMENT = "bos-privacy-implement";

    @Override
    public void execute() throws Exception {
        Long startTime = null;
        Long tmpTime = null;
        logger.info("privacy task execute start!taskId:" + this.getTaskId() + ",FieldName:" + this.getFieldName() + ",TableName:" + this.getTableName());
        List<PrivacyDataModel> result = null;
        String fid = null;
        logger.debug("privacy task batchQueryPrivacyData start!taskId:" + this.getTaskId() + ",fid:" + fid);
        while (true) {
            startTime = System.currentTimeMillis();
            result = this.batchQueryPrivacyData(fid);
            tmpTime = System.currentTimeMillis() - startTime;
            queryTime = queryTime + tmpTime;
            logger.debug("\u5b8c\u6210\u89e3\u5bc6\u524d\u67e5\u8be2\u6570\u636e:TaskId:" + this.getTaskId() + "#\u6570\u636e" + result.size() + "\u6761,\u67e5\u8be2\u8017\u65f6" + tmpTime + "\u6beb\u79d2!");
            try (TXHandle txh = TX.requiresNew();){
                if (result == null || result.size() == 0) break;
                try {
                    startTime = System.currentTimeMillis();
                    this.decode(result);
                    tmpTime = System.currentTimeMillis() - startTime;
                    decodeTime = decodeTime + tmpTime;
                    logger.debug("privacy task decode complete!taskId:" + this.getTaskId() + ",fid:" + fid + ",\u89e3\u5bc6\u6570\u636e\u8017\u65f6" + tmpTime + "\u6beb\u79d2!");
                    startTime = System.currentTimeMillis();
                    this.batchDecodePrivacyData(result);
                    tmpTime = System.currentTimeMillis() - startTime;
                    privacyDataTime = privacyDataTime + tmpTime;
                    logger.debug("privacy task batchQueryPrivacyData complete!taskId:" + this.getTaskId() + ",fid:" + fid + ",\u8fd8\u539f\u6570\u636e\u8017\u65f6" + tmpTime + "\u6beb\u79d2!");
                    Map<String, List<Object>> rsg = this.splitIds(result);
                    startTime = System.currentTimeMillis();
                    this.clear(rsg.get("ids"), rsg.get("shardingIds"));
                    tmpTime = System.currentTimeMillis() - startTime;
                    clearTime = clearTime + tmpTime;
                    logger.debug("privacy task clear complete!taskId:" + this.getTaskId() + ",fid:" + fid + ",\u5220\u9664\u52a0\u5bc6\u6570\u636e\u8017\u65f6" + tmpTime + "\u6beb\u79d2!");
                    totalCount = totalCount + (long)result.size();
                    logger.debug(String.format("\u5404\u9636\u6bb5\u8017\u65f6\u7d2f\u8ba1\uff1aqueryTime: %1$d\u6beb\u79d2,encodeTime:%2$d\u6beb\u79d2,privacyDataTime:%3$d\u6beb\u79d2,clearTime:%4$d,\u603b\u8bb0\u5f55\u6570:%5$d", queryTime, decodeTime, privacyDataTime, clearTime, totalCount));
                    result.clear();
                }
                catch (Exception e) {
                    logger.info(String.format("privacy task execute error! taskId: %1$d, fid: %2$s", this.getTaskId(), fid));
                    txh.markRollback();
                    throw e;
                }
            }
            startTime = System.currentTimeMillis();
            this.partComplete(fid);
            logger.info("privacy task partComplete success!taskId:" + this.getTaskId() + ",fid:" + fid + ",\u4fee\u6539\u4efb\u52a1\u6570\u636e\u8017\u65f6" + (System.currentTimeMillis() - startTime) + "\u6beb\u79d2!");
        }
        startTime = System.currentTimeMillis();
        this.lastHandle("decode");
        logger.info("privacy task decode lastHandle success!taskId:" + this.getTaskId() + ",fid:" + fid + ",\u8865\u507f\u4efb\u52a1\u6570\u636e\u8017\u65f6" + (System.currentTimeMillis() - startTime) + "\u6beb\u79d2!");
    }

    @Override
    public void leaveOutRecord(String exchange) throws Exception {
        List<PrivacyDataModel> result = null;
        String fid = null;
        while (true) {
            result = this.batchQueryPrivacyData(fid);
            logger.info("\u5b8c\u6210\u8865\u507f\u67e5\u8be2\u4e1a\u52a1\u6570\u636e:TaskId:" + this.getTaskId() + "#\u6570\u636e" + result.size() + "\u6761");
            TXHandle txh = TX.requiresNew();
            Throwable throwable = null;
            try {
                if (result == null || result.size() == 0) {
                    this.setRepeatQueryNumber(this.getRepeatQueryNumber() + 1);
                    Thread.sleep(3000L);
                    if (this.getRepeatQueryNumber() > 1) {
                        logger.debug("\u8865\u507f\u7ed3\u675f:TaskId:" + this.getTaskId());
                        break;
                    }
                    logger.debug("\u6301\u7eed\u8865\u507f\u4e2d:TaskId:" + this.getTaskId() + " \u6b21\u6570\uff1a" + this.getRepeatQueryNumber());
                    continue;
                }
                try {
                    this.decode(result);
                    logger.debug("\u8865\u507f decode complete!taskId:" + this.getTaskId() + ",fid:" + fid);
                    this.batchDecodePrivacyData(result);
                    logger.debug("\u8865\u507f batchQueryPrivacyData complete!taskId:" + this.getTaskId() + ",fid:" + fid);
                    Map<String, List<Object>> rsg = this.splitIds(result);
                    this.clear(rsg.get("ids"), rsg.get("shardingIds"));
                    logger.debug("privacy task clear complete!taskId:" + this.getTaskId() + ",fid:" + fid);
                }
                catch (Exception e) {
                    logger.info("\u8865\u507f execute error!taskId:" + this.getTaskId() + ",fid:" + fid);
                    txh.markRollback();
                    throw e;
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (txh == null) continue;
                if (throwable != null) {
                    try {
                        txh.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                txh.close();
                continue;
            }
            this.partComplete(fid);
            logger.info("\u8865\u507f partComplete success!taskId:" + this.getTaskId() + ",fid:" + fid);
        }
    }

    public void lastHandle(String exchange) {
        try (TXHandle txh = TX.requiresNew();){
            try {
                this.leaveOutRecord(exchange);
                logger.debug("privacy task decode leaveOutRecord success!taskId:" + this.getTaskId() + ",FieldName:" + this.getFieldName() + ",TableName:" + this.getTableName());
                this.updatePrivacyConfigStatus();
                logger.debug("privacy task decode updatePrivacyConfigStatus success!taskId:" + this.getTaskId() + ",FieldName:" + this.getFieldName() + ",TableName:" + this.getTableName());
            }
            catch (Exception e) {
                logger.info("\u4efb\u52a1\u6700\u540e\u8865\u507f\u8fc7\u7a0b\u4e2d\u62a5\u9519:" + this.getTaskId() + "TableName:" + this.getTableName() + "#FieldName:" + this.getFieldName() + "#\u9519\u8bef:" + e.getMessage());
                txh.markRollback();
            }
        }
    }

    private Map<String, List<Object>> splitIds(List<PrivacyDataModel> result) {
        ArrayList<Object> shardingIds = new ArrayList<Object>();
        ArrayList<String> ids = new ArrayList<String>(result.size());
        HashMap<String, List<Object>> rsg = new HashMap<String, List<Object>>();
        rsg.put("ids", ids);
        rsg.put("shardingIds", shardingIds);
        for (PrivacyDataModel pdModel : result) {
            ids.add(pdModel.getId());
            if (shardingIds.contains(pdModel.getShardingId())) continue;
            shardingIds.add(pdModel.getShardingId());
        }
        return rsg;
    }

    private void decode(List<PrivacyDataModel> list) throws Exception {
        for (PrivacyDataModel pd : list) {
            this.getPdService().decode(pd);
        }
    }

    private void clear(List<Object> ids, List<Object> shardingIds) {
        SqlBuilder sqlBd = new SqlBuilder();
        sqlBd.append("delete from " + this.getPyTableName() + " where ", new Object[0]);
        sqlBd.appendIn("fpkid ", ids);
        try (ShardingHintContext ctx = ShardingHintContext.createAndSet((String)this.getShardingMasterTable(), (HintCondition[])new HintCondition[]{new HintCondition(this.getShardingMasterKey(), FilterType.in_range, shardingIds)});){
            DB.execute((DBRoute)DBRoute.of((String)this.getDbRouter()), (SqlBuilder)sqlBd);
        }
    }

    private void batchDecodePrivacyData(List<PrivacyDataModel> pdList) throws Exception {
        block30: {
            String sql = "";
            String multiSql = "";
            ArrayList<Object> shardingIds = new ArrayList<Object>();
            ArrayList<Object> multiShardingIds = new ArrayList<Object>();
            ArrayList<SqlParameter[]> values = new ArrayList<SqlParameter[]>();
            ArrayList<SqlParameter[]> multiValues = new ArrayList<SqlParameter[]>();
            try {
                Throwable throwable;
                ShardingHintContext ctx;
                for (PrivacyDataModel pdModel : pdList) {
                    SqlParameter[] sqlParas;
                    if (StringUtils.isEmpty((String)pdModel.getLocaleId()) || pdModel.getLocaleId().equals("GLang")) {
                        sql = "update " + this.getTableName() + " SET " + pdModel.getFieldName() + " = ? where " + this.getPkName() + "= ? ";
                        sqlParas = new SqlParameter[]{new SqlParameter(":" + pdModel.getFieldName(), pdModel.getFieldType(), pdModel.getValue()), new SqlParameter(":" + this.getPkName(), this.getPkTypes(pdModel.getBizId()), pdModel.getBizId())};
                        values.add(sqlParas);
                        if (shardingIds.contains(pdModel.getShardingId())) continue;
                        shardingIds.add(pdModel.getShardingId());
                        continue;
                    }
                    multiSql = "update " + this.getTableName() + "_l SET " + pdModel.getFieldName() + " = ? where " + this.getPkName() + " = ? and flocaleid = ?";
                    sqlParas = new SqlParameter[]{new SqlParameter(":" + pdModel.getFieldName(), pdModel.getFieldType(), pdModel.getValue()), new SqlParameter(":" + this.getPkName(), this.getPkTypes(pdModel.getBizId()), pdModel.getBizId()), new SqlParameter(":flocaleid", 12, (Object)pdModel.getLocaleId())};
                    multiValues.add(sqlParas);
                    if (multiShardingIds.contains(pdModel.getShardingId())) continue;
                    multiShardingIds.add(pdModel.getShardingId());
                }
                if (values.size() > 0) {
                    ctx = ShardingHintContext.createAndSet((String)this.getShardingMasterTable(), (HintCondition[])new HintCondition[]{new HintCondition(this.getShardingMasterKey(), FilterType.in_range, shardingIds)});
                    throwable = null;
                    try {
                        DB.executeBatch((DBRoute)DBRoute.of((String)this.getDbRouter()), (String)sql, values);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (ctx != null) {
                            if (throwable != null) {
                                try {
                                    ctx.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                            } else {
                                ctx.close();
                            }
                        }
                    }
                }
                if (multiValues.size() <= 0) break block30;
                ctx = ShardingHintContext.createAndSet((String)this.getShardingMasterTable(), (HintCondition[])new HintCondition[]{new HintCondition(this.getShardingMasterKey(), FilterType.in_range, multiShardingIds)});
                throwable = null;
                try {
                    DB.executeBatch((DBRoute)DBRoute.of((String)this.getDbRouter()), (String)multiSql, multiValues);
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    if (ctx != null) {
                        if (throwable != null) {
                            try {
                                ctx.close();
                            }
                            catch (Throwable throwable5) {
                                throwable.addSuppressed(throwable5);
                            }
                        } else {
                            ctx.close();
                        }
                    }
                }
            }
            catch (Exception e) {
                logger.error("decodeTask fail,error msg is :" + e.getMessage());
                throw e;
            }
        }
    }
}

