/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.privacy.task;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.privacy.IPrivacyTaskService;
import kd.bos.privacy.task.BaseTask;
import kd.bos.privacy.task.TaskExecute;
import kd.bos.privacy.task.WatchTask;
import kd.bos.privacy.utils.PrivacyTaskUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class PrivacyTaskService
implements IPrivacyTaskService {
    private static final Log logger = LogFactory.getLog(PrivacyTaskService.class);
    private static final String FENCRYPT_ALGORITHM = "fencrypt_algorithm";
    private static final String FENCRYPT_TABLE_NAME = "fencrypt_table_name";
    private static final String FENCRYPT_FIELD_NAME = "fencrypt_field_name";
    private static final String FENCRYPT_ENTITY_NUMBER = "fencrypt_entity_number";
    private static final String FENCRYPT_STATUS = "fencrypt_status";
    private static final String NO = "NO";
    private static final String BOS_PRIVACY_IMPLEMENT = "bos-privacy-implement";
    private static final String ENCRYPT_SELECT = "t_privacy_scheme_encrypt.fencrypt_cloud_number,t_privacy_scheme_encrypt.fencrypt_entity_number,t_privacy_scheme_encrypt.fencrypt_app_number,t_privacy_scheme_encrypt.fencrypt_field_ident,t_privacy_scheme_encrypt.fencrypt_field_desc,t_privacy_scheme_encrypt.fencrypt_algorithm,t_privacy_scheme_encrypt.fencrypt_version,t_privacy_scheme_encrypt.fencrypt_table_name,t_privacy_scheme_encrypt.fencrypt_field_name,t_privacy_scheme_encrypt.fencrypt_field_type,t_privacy_scheme_encrypt.fencrypt_entity_name,t_privacy_scheme_encrypt.fencrypt_app_name,t_privacy_scheme_encrypt.fencrypt_cloud_name,t_privacy_scheme_encrypt.approute,t_privacy_scheme_encrypt.fencrypt_status,t_privacy_scheme_encrypt.encryptlabelid";

    @Override
    public void executeTask(List<Long> idList) {
        ArrayList<String> taskStatus = new ArrayList<String>(2);
        taskStatus.add(String.valueOf(0));
        List<BaseTask> allTaskData = PrivacyTaskUtils.getAllTaskDataBySchemeId(idList, taskStatus);
        if (CollectionUtils.isEmpty(allTaskData)) {
            throw new KDException(BosErrorCode.bOS, new Object[]{String.format("Error:%s", ResManager.loadKDString((String)"\u6ca1\u6709\u53ef\u6267\u884c\u7684\u6570\u636e\u3002", (String)"PrivacyTaskService_0", (String)BOS_PRIVACY_IMPLEMENT, (Object[])new Object[0]))});
        }
        ArrayList<Long> taskIdList = new ArrayList<Long>(allTaskData.size());
        for (BaseTask baseTask : allTaskData) {
            taskIdList.add(baseTask.getTaskId());
            WatchTask.pushTask(new TaskExecute(baseTask));
        }
        PrivacyTaskUtils.updatePrivacyTaskStatus(taskIdList);
        WatchTask.executeTask();
    }

    @Override
    public void saveEncryptTask(List<Long> schemeIdList) {
        if (this.isTaskNotOver(schemeIdList)) {
            throw new KDException(BosErrorCode.bOS, new Object[]{String.format("Error:%s", ResManager.loadKDString((String)"\u6709\u4efb\u52a1\u672a\u6267\u884c\u5b8c\uff0c\u65e0\u6cd5\u65b0\u589e\u4efb\u52a1", (String)"PrivacyTaskService_1", (String)BOS_PRIVACY_IMPLEMENT, (Object[])new Object[0]))});
        }
        QFilter qFilter = new QFilter("id", "in", schemeIdList);
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"t_privacy_scheme_config", (String)ENCRYPT_SELECT, (QFilter[])new QFilter[]{qFilter});
        if (this.isRepeatOperation(dynamicObjects, 1)) {
            throw new KDException(BosErrorCode.bOS, new Object[]{String.format("Error:%s", ResManager.loadKDString((String)"\u5df2\u7ecf\u52a0\u5bc6\u65e0\u6cd5\u518d\u6b21\u52a0\u5bc6", (String)"PrivacyTaskService_2", (String)BOS_PRIVACY_IMPLEMENT, (Object[])new Object[0]))});
        }
        for (DynamicObject dataEntity : dynamicObjects) {
            Long schemeId = (Long)dataEntity.get("id");
            DynamicObjectCollection encryptList = dataEntity.getDynamicObjectCollection("t_privacy_scheme_encrypt");
            if (encryptList == null || encryptList.size() <= 0) break;
            DynamicObjectCollection changeData = new DynamicObjectCollection();
            ArrayList<Object[]> sqlParams = new ArrayList<Object[]>(encryptList.size());
            HashSet<String> entityNumberSet = new HashSet<String>(encryptList.size());
            for (DynamicObject newObj : encryptList) {
                if (newObj.getString(FENCRYPT_ALGORITHM).equals(NO)) {
                    newObj.set(FENCRYPT_STATUS, (Object)Character.valueOf('1'));
                    continue;
                }
                changeData.add((Object)newObj);
                newObj.set(FENCRYPT_STATUS, (Object)Character.valueOf('0'));
                int taskType = 1;
                String oldEncryptType = newObj.getString(FENCRYPT_ALGORITHM);
                if (!newObj.getString(FENCRYPT_ALGORITHM).equals(NO)) {
                    entityNumberSet.add(newObj.getString(FENCRYPT_ENTITY_NUMBER));
                }
                SqlParameter[] parameter = PrivacyTaskUtils.buildSqlParameter(schemeId, newObj, taskType, oldEncryptType);
                sqlParams.add(parameter);
                PrivacyTaskUtils.printTaskLog(parameter, taskType);
            }
            PrivacyTaskUtils.updateEncryptAlgorithmField(changeData);
            PrivacyTaskUtils.buildPrivacyTable(entityNumberSet);
            BaseTask.batchSave(sqlParams);
        }
    }

    @Override
    public void saveDecryptTask(List<Long> schemeIdList) {
        if (this.isTaskNotOver(schemeIdList)) {
            throw new KDException(BosErrorCode.bOS, new Object[]{String.format("Error:%s", ResManager.loadKDString((String)"\u6709\u4efb\u52a1\u672a\u6267\u884c\u5b8c\uff0c\u65e0\u6cd5\u65b0\u589e\u4efb\u52a1", (String)"PrivacyTaskService_3", (String)BOS_PRIVACY_IMPLEMENT, (Object[])new Object[0]))});
        }
        QFilter qFilter = new QFilter("id", "in", schemeIdList);
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"t_privacy_scheme_config", (String)ENCRYPT_SELECT, (QFilter[])new QFilter[]{qFilter});
        if (this.isRepeatOperation(dynamicObjects, 2)) {
            throw new KDException(BosErrorCode.bOS, new Object[]{String.format("Error:%s", ResManager.loadKDString((String)"\u5df2\u7ecf\u8fdb\u884c\u89e3\u5bc6\u65e0\u6cd5\u518d\u6b21\u89e3\u5bc6", (String)"PrivacyTaskService_4", (String)BOS_PRIVACY_IMPLEMENT, (Object[])new Object[0]))});
        }
        for (DynamicObject dataEntity : dynamicObjects) {
            Long schemeId = (Long)dataEntity.get("id");
            DynamicObjectCollection encryptList = dataEntity.getDynamicObjectCollection("t_privacy_scheme_encrypt");
            if (encryptList == null || encryptList.size() <= 0) break;
            DynamicObjectCollection changeData = new DynamicObjectCollection();
            ArrayList<Object[]> sqlParams = new ArrayList<Object[]>(encryptList.size());
            HashSet<String> entityNumberSet = new HashSet<String>(encryptList.size());
            for (DynamicObject newObj : encryptList) {
                if (newObj.getString(FENCRYPT_ALGORITHM).equals(NO)) {
                    newObj.set(FENCRYPT_STATUS, (Object)Character.valueOf('1'));
                    continue;
                }
                changeData.add((Object)newObj);
                newObj.set(FENCRYPT_STATUS, (Object)Character.valueOf('0'));
                int taskType = 2;
                String oldEncryptType = newObj.getString(FENCRYPT_ALGORITHM);
                if (!newObj.getString(FENCRYPT_ALGORITHM).equals(NO)) {
                    entityNumberSet.add(newObj.getString(FENCRYPT_ENTITY_NUMBER));
                }
                SqlParameter[] parameter = PrivacyTaskUtils.buildSqlParameter(schemeId, newObj, taskType, oldEncryptType);
                sqlParams.add(parameter);
                PrivacyTaskUtils.printTaskLog(parameter, taskType);
            }
            PrivacyTaskUtils.updateEncryptAlgorithmField(changeData);
            PrivacyTaskUtils.buildPrivacyTable(entityNumberSet);
            BaseTask.batchSave(sqlParams);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isTaskNotOver(List<Long> schemeIdList) {
        String sql = "select fid,fschemeid from t_privacy_task  where ftask_status != '3' and fschemeid in (%s)";
        ArrayList<SqlParameter> params = new ArrayList<SqlParameter>(schemeIdList.size());
        ArrayList<String> apps = new ArrayList<String>(schemeIdList.size());
        for (int i = 0; i < schemeIdList.size(); ++i) {
            params.add(new SqlParameter(":fschemeid" + String.valueOf(i), -5, (Object)schemeIdList.get(i)));
            apps.add("?");
        }
        sql = String.format(sql, StringUtils.join((Object[])apps.toArray(), (String)","));
        try (DataSet set = DB.queryDataSet((String)"task.notover", (DBRoute)DBRoute.of((String)"sys"), (String)sql, (Object[])params.toArray(new SqlParameter[params.size()]));){
            boolean bl = set.hasNext();
            return bl;
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            throw e;
        }
    }

    private boolean isRepeatOperation(DynamicObject[] dynamicObjects, final int taskType) {
        DynamicObject dataEntity;
        DynamicObjectCollection encryptList;
        if (dynamicObjects.length <= 0) {
            return true;
        }
        HashSet<String> tableNameset = new HashSet<String>();
        ArrayList<String> fieldNameset = new ArrayList<String>();
        DynamicObject[] dynamicObjectArray = dynamicObjects;
        int n = dynamicObjectArray.length;
        for (int i = 0; i < n && (encryptList = (dataEntity = dynamicObjectArray[i]).getDynamicObjectCollection("t_privacy_scheme_encrypt")) != null && encryptList.size() > 0; ++i) {
            for (DynamicObject newObj : encryptList) {
                if (newObj.getString(FENCRYPT_ALGORITHM).equals(NO)) continue;
                String tableName = newObj.getString(FENCRYPT_TABLE_NAME);
                tableNameset.add(tableName);
                String fieldName = newObj.getString(FENCRYPT_FIELD_NAME);
                fieldNameset.add(fieldName);
            }
        }
        if (tableNameset.isEmpty() || fieldNameset.isEmpty()) {
            return true;
        }
        String sql = "select fid ,fschemeid ,ftask_type ,fcreate_date ,ftable_name ,ffield_name  from t_privacy_task  where ftable_name  in ('" + StringUtils.join((Object[])tableNameset.toArray(), (String)"','") + "') and ffield_name in ('" + StringUtils.join((Object[])fieldNameset.toArray(), (String)"','") + "') order by fcreate_date  desc";
        return (Boolean)DB.query((DBRoute)DBRoute.of((String)"sys"), (String)sql, (ResultSetHandler)new ResultSetHandler<Boolean>(){

            public Boolean handle(ResultSet rs) throws Exception {
                if (rs.next()) {
                    int type = Integer.parseInt(rs.getString("ftask_type"));
                    if (type == taskType) {
                        return true;
                    }
                    return false;
                }
                return false;
            }
        });
    }
}

