/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.privacy.utils;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.SqlParameter;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.privacy.scheme.PrivacyMapping;
import kd.bos.privacy.task.BaseTask;
import kd.bos.privacy.task.DecodeTask;
import kd.bos.privacy.task.EncodeTask;
import kd.bos.privacy.task.ExchangeTask;

public class PrivacyDataTools {
    public static String getPrivacyDataTableName(String table) {
        return PrivacyMapping.buildPrivacyTableName(table);
    }

    public static String buildErrorInfo(Throwable e) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter((Writer)sw, true);
        e.printStackTrace(pw);
        String stackTraceString = sw.getBuffer().toString();
        return stackTraceString;
    }

    public static BaseTask getTaskByPrimaryKey(Long id) throws ParseException {
        BaseTask baseTask = null;
        String sql = "select ftask_type,ftable_name,fentity_number,fdbrouter,fpytable_name,fpktype,fstart_date,fislocale,fiscommonlang,fend_date,fcreate_date,fversion,ftask_status,ffield_name,ffield_type,forderby,fpkname,fpkvalue,forderby_value,foldencrypt_type,ffieldIdent,fid from t_privacy_task where fid = ?";
        Object[] sqlParas = new SqlParameter[]{new SqlParameter(":fid", -5, (Object)id)};
        try (DataSet ds = DB.queryDataSet((String)"getTaskByPrimaryKey", (DBRoute)DBRoute.of((String)"sys"), (String)sql, (Object[])sqlParas);){
            if (ds != null && ds.hasNext()) {
                Row row = ds.next();
                baseTask = PrivacyDataTools.buildTask(row);
            }
            BaseTask baseTask2 = baseTask;
            return baseTask2;
        }
    }

    private static BaseTask buildTask(Row row) throws ParseException {
        BaseTask baseTask = null;
        Integer taskType = 0;
        taskType = Integer.parseInt(row.get("ftask_type").toString());
        switch (taskType) {
            case 3: {
                baseTask = new ExchangeTask();
                baseTask.setTaskType(3);
                break;
            }
            case 2: {
                baseTask = new DecodeTask();
                baseTask.setTaskType(2);
                break;
            }
            case 1: {
                baseTask = new EncodeTask();
                baseTask.setTaskType(1);
            }
        }
        if (baseTask != null) {
            baseTask.setOldEncryptType(row.get("foldencrypt_type") == null ? "" : row.get("foldencrypt_type").toString());
            baseTask.setPkName(row.get("fpkname") == null ? "" : row.get("fpkname").toString());
            baseTask.setEntityNumber(row.get("fentity_number") == null ? "" : row.get("fentity_number").toString());
            baseTask.setOrderBy(row.get("forderby") == null ? "" : row.get("forderby").toString());
            baseTask.setDbRouter(row.get("fdbrouter") == null ? "" : row.get("fdbrouter").toString());
            baseTask.setFieldName(row.get("ffield_name") == null ? "" : row.get("ffield_name").toString());
            baseTask.setTableName(row.get("ftable_name") == null ? "" : row.get("ftable_name").toString());
            baseTask.setFieldType(Integer.parseInt(row.get("ffield_type").toString()));
            baseTask.setPyTableName(row.get("fpytable_name") == null ? "" : row.get("fpytable_name").toString());
            baseTask.setTaskId((Long)row.get("fid"));
            baseTask.setTaskStatus(1);
            baseTask.setIsLocale(row.get("fislocale") == null ? "FALSE" : row.get("fislocale").toString());
            baseTask.setFieldIdent(row.get("ffieldIdent") == null ? "ffieldIdent" : row.get("ffieldIdent").toString());
            baseTask.setIsCommonLang(row.get("fiscommonlang") == null ? "FALSE" : row.get("fiscommonlang").toString());
            baseTask.setPkValue(row.get("fpkvalue") == null ? null : row.get("fpkvalue").toString());
            baseTask.setPkType(row.getInteger("fpkType"));
            baseTask.setOrderByValue(row.get("forderby_value") == null ? "" : row.get("forderby_value").toString());
            baseTask.setVersion(row.getInteger("fversion"));
            baseTask.setTaskStatus(Integer.parseInt(row.get("ftask_status").toString()));
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
            if (row.get("fstart_date") == null) {
                baseTask.setCreateDate(null);
            } else {
                baseTask.setCreateDate(simpleDateFormat.parse(row.get("fstart_date").toString()));
            }
            if (row.get("fend_date") == null) {
                baseTask.setCreateDate(null);
            } else {
                baseTask.setCreateDate(simpleDateFormat.parse(row.get("fend_date").toString()));
            }
            if (row.get("fcreate_date") == null) {
                baseTask.setCreateDate(null);
            } else {
                baseTask.setCreateDate(simpleDateFormat.parse(row.get("fcreate_date").toString()));
            }
        }
        return baseTask;
    }

    public static Date getOperateDate(Timestamp timestamp) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(timestamp);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        Date operateDate = calendar.getTime();
        return operateDate;
    }
}

