/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.privacy.utils;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.exception.KDBizException;
import kd.bos.instance.Instance;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.orm.ORM;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.privacy.scheme.PrivacyMapping;
import kd.bos.privacy.service.PrivacyTableBuilderService;
import kd.bos.privacy.task.BaseTask;
import kd.bos.privacy.task.DecodeTask;
import kd.bos.privacy.task.EncodeTask;
import kd.bos.privacy.task.ExchangeTask;
import kd.bos.servicehelper.MetadataServiceHelper;

public class PrivacyTaskUtils {
    private static final Log logger = LogFactory.getLog(PrivacyTaskUtils.class);
    private static final String FENCRYPT_ALGORITHM = "fencrypt_algorithm";
    private static final String FENCRYPT_TABLE_NAME = "fencrypt_table_name";
    private static final String FENCRYPT_FIELD_NAME = "fencrypt_field_name";
    private static final String FENCRYPT_ENTITY_NUMBER = "fencrypt_entity_number";
    private static final String FENCRYPT_FIELD_IDENT = "fencrypt_field_ident";
    private static final String FENCRYPT_FIELD_TYPE = "fencrypt_field_type";
    private static final String FENCRYPT_VERSION = "fencrypt_version";
    private static final String FENCRYPT_ENTITY_NAME = "fencrypt_entity_name";
    private static final String FENCRYPT_FIELD_DESC = "fencrypt_field_desc";
    private static final String FENCRYPT_STATUS = "fencrypt_status";
    private static final String NO = "NO";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<BaseTask> getAllTaskDataByTaskId(List<Long> idList, List<String> taskStatus) {
        ArrayList<BaseTask> baseTaskList = new ArrayList<BaseTask>();
        if (CollectionUtils.isEmpty(idList)) {
            return baseTaskList;
        }
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select ftask_type,ftable_name,fentity_number,fdbrouter,fpytable_name,fstart_date,", new Object[0]).append("fislocale,fend_date,fcreate_date,fversion,ftask_status,", new Object[0]).append("ffield_name,ffield_type,forderby,fpkname,fpkvalue,forderby_value,", new Object[0]).append("foldencrypt_type,ferrorlogs,fpktype,fiscommonlang,fid,ffieldident from t_privacy_task where ", new Object[0]).appendIn("fid", idList.toArray()).append("and", new Object[0]).appendIn("ftask_status", taskStatus.toArray());
        try (DataSet ds = DB.queryDataSet((String)"getTaskByPrimaryKey", (DBRoute)DBRoute.of((String)"sys"), (SqlBuilder)sqlBuilder);){
            while (ds.hasNext()) {
                Row row = ds.next();
                try {
                    BaseTask baseTask = PrivacyTaskUtils.buildTask(row);
                    if (baseTask == null) continue;
                    baseTaskList.add(baseTask);
                }
                catch (ParseException e) {
                    logger.error("getTaskByPrimaryKey:error info :" + PrivacyTaskUtils.buildErrorInfo(e));
                }
            }
            ArrayList<BaseTask> arrayList = baseTaskList;
            return arrayList;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<BaseTask> getAllTaskDataBySchemeId(List<Long> idList, List<String> taskStatus) {
        ArrayList<BaseTask> baseTaskList = new ArrayList<BaseTask>();
        if (CollectionUtils.isEmpty(idList)) {
            return baseTaskList;
        }
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select ftask_type,ftable_name,fentity_number,fdbrouter,fpytable_name,fstart_date,", new Object[0]).append("fislocale,fend_date,fcreate_date,fversion,ftask_status,", new Object[0]).append("ffield_name,ffield_type,forderby,fpkname,fpkvalue,forderby_value,", new Object[0]).append("foldencrypt_type,ferrorlogs,fpktype,fiscommonlang,fid,ffieldident from t_privacy_task where ", new Object[0]).appendIn("fschemeid", idList.toArray()).append("and", new Object[0]).appendIn("ftask_status", taskStatus.toArray());
        try (DataSet ds = DB.queryDataSet((String)"getTaskByPrimaryKey", (DBRoute)DBRoute.of((String)"sys"), (SqlBuilder)sqlBuilder);){
            while (ds.hasNext()) {
                Row row = ds.next();
                try {
                    BaseTask baseTask = PrivacyTaskUtils.buildTask(row);
                    if (baseTask == null) continue;
                    baseTaskList.add(baseTask);
                }
                catch (ParseException e) {
                    logger.error("getTaskByPrimaryKey:error info :" + PrivacyTaskUtils.buildErrorInfo(e));
                }
            }
            ArrayList<BaseTask> arrayList = baseTaskList;
            return arrayList;
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            throw e;
        }
    }

    private static BaseTask buildTask(Row row) throws ParseException {
        BaseTask baseTask = null;
        Integer taskType = 0;
        taskType = Integer.parseInt(row.get("ftask_type").toString());
        switch (taskType) {
            case 3: {
                baseTask = new ExchangeTask();
                baseTask.setTaskType(3);
                break;
            }
            case 2: {
                baseTask = new DecodeTask();
                baseTask.setTaskType(2);
                break;
            }
            case 1: {
                baseTask = new EncodeTask();
                baseTask.setTaskType(1);
            }
        }
        if (baseTask != null) {
            baseTask.setErrorlogs(row.getString("ferrorlogs"));
            baseTask.setOldEncryptType(row.get("foldencrypt_type") == null ? "" : row.get("foldencrypt_type").toString());
            baseTask.setPkName(row.get("fpkname") == null ? "" : row.get("fpkname").toString());
            baseTask.setEntityNumber(row.get("fentity_number") == null ? "" : row.get("fentity_number").toString());
            baseTask.setOrderBy(row.get("forderby") == null ? "" : row.get("forderby").toString());
            baseTask.setDbRouter(row.get("fdbrouter") == null ? "" : row.get("fdbrouter").toString());
            baseTask.setFieldName(row.get("ffield_name") == null ? "" : row.get("ffield_name").toString());
            baseTask.setTableName(row.get("ftable_name") == null ? "" : row.get("ftable_name").toString());
            baseTask.setFieldType(Integer.parseInt(row.get("ffield_type").toString()));
            baseTask.setPyTableName(row.get("fpytable_name") == null ? "" : row.get("fpytable_name").toString());
            baseTask.setTaskId(row.getLong("fid"));
            baseTask.setFieldIdent(row.get("ffieldident").toString());
            baseTask.setTaskStatus(1);
            baseTask.setIsLocale(row.get("fislocale") == null ? "" : row.get("fislocale").toString());
            baseTask.setIsCommonLang(row.get("fiscommonlang") == null ? "FALSE" : row.get("fiscommonlang").toString());
            baseTask.setPkValue(row.get("fpkvalue"));
            baseTask.setPkType(row.getInteger("fpktype"));
            baseTask.setOrderByValue(row.get("forderby_value") == null ? "" : row.get("forderby_value").toString());
            baseTask.setVersion(row.getInteger("fversion"));
            baseTask.setTaskStatus(Integer.parseInt(row.get("ftask_status").toString()));
            PrivacyTaskUtils.buildExistLastUpdateDate(baseTask);
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
            if (row.get("fstart_date") == null) {
                baseTask.setCreateDate(null);
            } else {
                baseTask.setCreateDate(simpleDateFormat.parse(row.get("fstart_date").toString()));
            }
            if (row.get("fend_date") == null) {
                baseTask.setCreateDate(null);
            } else {
                baseTask.setCreateDate(simpleDateFormat.parse(row.get("fend_date").toString()));
            }
            if (row.get("fcreate_date") == null) {
                baseTask.setCreateDate(null);
            } else {
                baseTask.setCreateDate(simpleDateFormat.parse(row.get("fcreate_date").toString()));
            }
        }
        return baseTask;
    }

    private static void buildExistLastUpdateDate(BaseTask task) {
        MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)task.getEntityNumber());
        for (IDataEntityType entryType : entityType.getAllEntities().values()) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)entryType.getAlias(), (CharSequence)task.getTableName()) || entryType.getModifyTimeProperty() == null) continue;
            task.setExistLastUpdate(true);
            break;
        }
    }

    private static String buildErrorInfo(Throwable e) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter((Writer)sw, true);
        e.printStackTrace(pw);
        String stackTraceString = sw.getBuffer().toString();
        return stackTraceString;
    }

    public static void updatePrivacyTaskStatus(List<Long> fid) {
        if (CollectionUtils.isEmpty(fid)) {
            return;
        }
        SqlBuilder sb = new SqlBuilder();
        sb.append("update t_privacy_task set ftask_status=?,finstanceid=? where", new Object[]{1, Instance.getInstanceId()}).appendIn("fid", fid.toArray());
        DB.execute((DBRoute)DBRoute.of((String)"sys"), (SqlBuilder)sb);
    }

    public static void updateEncryptAlgorithmField(DynamicObjectCollection collection) {
        if (CollectionUtils.isEmpty((Collection)collection)) {
            return;
        }
        String updSql = "UPDATE t_privacy_scheme_encrypt SET fencrypt_algorithm = ?,fencrypt_status = ? WHERE fid != ?   AND lower(fencrypt_table_name) = ? AND lower(fencrypt_field_name) = ?";
        ArrayList<SqlParameter[]> sqlParams = new ArrayList<SqlParameter[]>(collection.size());
        for (DynamicObject dynamicObject : collection) {
            SqlParameter[] params = new SqlParameter[]{new SqlParameter(":fencrypt_algorithm", 1, (Object)dynamicObject.getString(FENCRYPT_ALGORITHM)), new SqlParameter(":fencrypt_status", 1, (Object)dynamicObject.getString(FENCRYPT_STATUS)), new SqlParameter(":fid", -5, dynamicObject.getPkValue()), new SqlParameter(":fencrypt_table_name", 12, (Object)dynamicObject.getString(FENCRYPT_TABLE_NAME).toLowerCase()), new SqlParameter(":fencrypt_field_name", 12, (Object)dynamicObject.getString(FENCRYPT_FIELD_NAME).toLowerCase())};
            sqlParams.add(params);
        }
        DB.executeBatch((DBRoute)DBRoute.of((String)"sys"), (String)updSql, sqlParams);
    }

    private static void checkTask(DynamicObject newObj, BeforeOperationArgs e) {
        String sql = "select count(1) as counter from t_privacy_task where ftable_name = ? and ffield_name = ? and ftask_status in ('1','2','4')";
        Object[] sqlParas = new SqlParameter[]{new SqlParameter(":ftable_name", 12, (Object)newObj.getString(FENCRYPT_TABLE_NAME)), new SqlParameter(":ffield_name", 12, (Object)newObj.getString(FENCRYPT_FIELD_NAME))};
        try (DataSet ds = DB.queryDataSet((String)"PrivacyTaskSplitPlugin.checkTask", (DBRoute)DBRoute.of((String)"sys"), (String)sql, (Object[])sqlParas);){
            Row row;
            if (ds != null && ds.hasNext() && (row = ds.next()).getInteger("counter") > 0) {
                e.setCancel(true);
                e.setCancelMessage(ResManager.loadKDString((String)"\u8be5\u5b9e\u4f53\u6570\u636e\u8fc1\u79fb\u4efb\u52a1\u8fd8\u672a\u5b8c\u6210,\u4e0d\u80fd\u8fdb\u884c\u518d\u6b21\u8fc1\u79fb", (String)"PrivacyTaskSplitPlugin_0", (String)"bos-privacy-plugin", (Object[])new Object[0]));
                return;
            }
        }
        catch (Exception exp) {
            logger.error((Throwable)exp);
            throw exp;
        }
    }

    private void existMigrateTask(Object schemeId, BeforeOperationArgs e) {
        String sql = "select count(1) as counter from t_privacy_task where fschemeid=? and ftask_status in ('0','1','2','4')";
        Object[] sqlParas = new SqlParameter[]{new SqlParameter(":fschemeid", -5, schemeId)};
        try (DataSet ds = DB.queryDataSet((String)"PrivacyTaskSplitPlugin.checkTask", (DBRoute)DBRoute.of((String)"sys"), (String)sql, (Object[])sqlParas);){
            Row row;
            if (ds != null && ds.hasNext() && (row = ds.next()).getInteger("counter") > 0) {
                e.setCancel(true);
                e.setCancelMessage(ResManager.loadKDString((String)"\u8be5\u65b9\u6848\u4e0b\u6570\u636e\u8fc1\u79fb\u4efb\u52a1\u8fd8\u672a\u5b8c\u6210,\u4e0d\u80fd\u8fdb\u884c\u52a0\u5bc6\u53d8\u66f4\u3002", (String)"PrivacyTaskSplitPlugin_1", (String)"bos-privacy-plugin", (Object[])new Object[0]));
                return;
            }
        }
    }

    private static String getDbRouter(MainEntityType main) {
        return main.getDBRouteKey();
    }

    private static Integer getDbPrimaryValueType(String entityNumber) {
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        return entityType.getPrimaryKey().getDbType();
    }

    private static String getDbPrimaryKey(MainEntityType main, String tableName, String filedIndent) {
        for (IDataEntityType entryType : main.getAllEntities().values()) {
            IDataEntityProperty property = (IDataEntityProperty)entryType.getProperties().get((Object)filedIndent);
            if (property != null) {
                String splitTableName;
                if (StringUtils.equalsIgnoreCase((CharSequence)entryType.getAlias(), (CharSequence)tableName)) {
                    logger.info("getDbPrimaryKey1:tableName:" + tableName + " filedIndent:" + filedIndent + " " + entryType.getPrimaryKey().getAlias());
                    return entryType.getPrimaryKey().getAlias();
                }
                if (StringUtils.isNotEmpty((CharSequence)property.getTableGroup()) && StringUtils.equals((CharSequence)(splitTableName = entryType.getAlias() + "_" + property.getTableGroup()).toLowerCase(Locale.ENGLISH), (CharSequence)tableName.toLowerCase(Locale.ENGLISH))) {
                    logger.info("getDbPrimaryKey2:tableName:" + tableName + " filedIndent:" + filedIndent + " " + entryType.getPrimaryKey().getAlias());
                    return entryType.getPrimaryKey().getAlias();
                }
                throw new KDBizException(String.format("property tablename mismatch. filedIndent : %s, tableName :%s, entryType.getAlias() :%s", filedIndent, tableName, entryType.getAlias()));
            }
            logger.info("getDbPrimaryKey4:property is null tableName:" + tableName + " filedIndent:" + filedIndent);
        }
        logger.warn("getDbPrimaryKey error, not find field in entityType, filedIndent:{}, entityNumber:{}, tableName:{}", new Object[]{filedIndent, main.getName(), tableName});
        throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5b9e\u4f53%1$s\u4e2d\u4e0d\u5b58\u5728\u5b57\u6bb5%2$s", (String)"PrivacyTaskUtils_1", (String)"bos-privacy-implement", (Object[])new Object[0]), main.getName(), filedIndent));
    }

    private static String getDbOrderBy(MainEntityType main, String tableName) {
        for (IDataEntityType entryType : main.getAllEntities().values()) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)entryType.getAlias(), (CharSequence)tableName)) continue;
            if (entryType.getModifyTimeProperty() != null) {
                logger.info("getDbOrderBy:" + entryType.getAlias() + "has modifyTime!");
                return entryType.getModifyTimeProperty().getAlias();
            }
            logger.info("getDbOrderBy:" + entryType.getAlias() + "has not modifyTime!");
            return entryType.getPrimaryKey().getAlias();
        }
        return "";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Map<String, Map<String, Object>> queryAllEncryptData(Object fid, DynamicObjectCollection entryData) {
        if (CollectionUtils.isEmpty((Collection)entryData)) {
            return null;
        }
        HashMap<String, Map<String, Object>> result = new HashMap<String, Map<String, Object>>();
        HashSet<String> tableName = new HashSet<String>();
        HashSet<String> FiledName = new HashSet<String>();
        for (DynamicObject entry : entryData) {
            tableName.add(entry.getString(FENCRYPT_TABLE_NAME).toLowerCase());
            FiledName.add(entry.getString(FENCRYPT_FIELD_NAME).toLowerCase());
        }
        SqlBuilder sb = new SqlBuilder();
        sb.append("select fid,fentryid,fencrypt_field_type,fencrypt_status,fencrypt_entity_number,fencrypt_entity_name,fencrypt_field_ident,fencrypt_field_desc,fencrypt_algorithm,fencrypt_table_name,fencrypt_field_name,fapp_route", new Object[0]).append("from t_privacy_scheme_encrypt where", new Object[0]).appendIn("lower(fencrypt_table_name)", tableName.toArray()).append("and", new Object[0]).appendIn("lower(fencrypt_field_name)", FiledName.toArray());
        try (DataSet rs = DB.queryDataSet((String)"PrivacyTaskSplitPlugin.queryEncryptData", (DBRoute)DBRoute.of((String)"sys"), (SqlBuilder)sb);){
            if (rs != null) {
                while (rs.hasNext()) {
                    Row row = rs.next();
                    String key = PrivacyTaskUtils.buildEncryptConstaintKey(row.getString(FENCRYPT_TABLE_NAME), row.getString(FENCRYPT_FIELD_NAME));
                    Map rowData = (Map)result.get(key);
                    if (!CollectionUtils.isEmpty((Map)rowData) && !StringUtils.equals((CharSequence)rowData.get("fid").toString(), (CharSequence)String.valueOf(fid))) continue;
                    HashMap<String, Object> sub = new HashMap<String, Object>();
                    sub.put("fentryid", row.get("fentryid"));
                    sub.put("fid", row.get("fid"));
                    sub.put(FENCRYPT_STATUS, row.get(FENCRYPT_STATUS));
                    sub.put(FENCRYPT_FIELD_IDENT, row.get(FENCRYPT_FIELD_IDENT));
                    sub.put(FENCRYPT_FIELD_DESC, row.get(FENCRYPT_FIELD_DESC));
                    sub.put(FENCRYPT_ENTITY_NUMBER, row.get(FENCRYPT_ENTITY_NUMBER));
                    sub.put(FENCRYPT_ENTITY_NAME, row.get(FENCRYPT_ENTITY_NAME));
                    sub.put(FENCRYPT_ALGORITHM, row.get(FENCRYPT_ALGORITHM));
                    sub.put(FENCRYPT_FIELD_TYPE, row.get(FENCRYPT_FIELD_TYPE));
                    sub.put(FENCRYPT_TABLE_NAME, row.getString(FENCRYPT_TABLE_NAME).toLowerCase());
                    sub.put(FENCRYPT_FIELD_NAME, row.getString(FENCRYPT_FIELD_NAME).toLowerCase());
                    sub.put("approute", row.get("fapp_route"));
                    result.put(key, sub);
                }
            }
            HashMap<String, Map<String, Object>> hashMap = result;
            return hashMap;
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            throw e;
        }
    }

    public static void buildPrivacyTable(Set<String> entityNumberSet) {
        for (String entityNumber : entityNumberSet) {
            String entityId = MetadataDao.getIdByNumber((String)entityNumber, (MetaCategory)MetaCategory.Form);
            EntityMetadata entityMeta = (EntityMetadata)MetadataDao.readRuntimeMeta((String)entityId, (MetaCategory)MetaCategory.Entity);
            PrivacyTableBuilderService.buildPrivacyTable(entityMeta);
        }
    }

    public static SqlParameter[] buildSqlParameter(Long schemeId, DynamicObject newObj, int taskType, String oldEncryptType) {
        SqlParameter[] sqlParas = new SqlParameter[24];
        String entityNumber = newObj.getString(FENCRYPT_ENTITY_NUMBER);
        ORM.create().getDataEntityType(entityNumber);
        String tableName = newObj.getString(FENCRYPT_TABLE_NAME);
        String fieldName = newObj.getString(FENCRYPT_FIELD_NAME);
        String fieldIdent = newObj.getString(FENCRYPT_FIELD_IDENT);
        int fieldType = newObj.getInt(FENCRYPT_FIELD_TYPE);
        try {
            MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
            String isLocale = PrivacyTaskUtils.isLocale(fieldType);
            String isCommonLang = PrivacyTaskUtils.isCommonLang(entityType, fieldType, fieldIdent);
            String pkName = PrivacyTaskUtils.getDbPrimaryKey(entityType, tableName, newObj.get(FENCRYPT_FIELD_IDENT).toString());
            long taskId = DB.genLongId((String)"t_privacy_task");
            String orderBy = PrivacyTaskUtils.getDbOrderBy(entityType, tableName);
            sqlParas[0] = new SqlParameter(":fid", -5, (Object)taskId);
            sqlParas[1] = new SqlParameter(":ftask_type", 4, (Object)taskType);
            sqlParas[2] = new SqlParameter(":ftable_name", 12, (Object)tableName);
            sqlParas[3] = new SqlParameter(":fpytable_name", 12, (Object)PrivacyMapping.buildPrivacyTableName(tableName));
            sqlParas[4] = new SqlParameter(":fcreate_date", 91, (Object)new Date());
            sqlParas[5] = new SqlParameter(":fversion", 4, (Object)newObj.getInt(FENCRYPT_VERSION));
            sqlParas[6] = new SqlParameter(":fupgrade", 12, (Object)-1);
            sqlParas[7] = new SqlParameter(":ftask_status", 4, (Object)0);
            sqlParas[8] = new SqlParameter(":ffield_name", 12, (Object)fieldName);
            sqlParas[9] = new SqlParameter(":forderby", 12, (Object)orderBy);
            sqlParas[10] = new SqlParameter(":fpkname", 12, (Object)pkName);
            sqlParas[11] = new SqlParameter(":ffield_type", 4, (Object)(fieldType == 1112 ? -9 : fieldType));
            sqlParas[12] = new SqlParameter(":fdbrouter", 12, (Object)PrivacyTaskUtils.getDbRouter(entityType));
            sqlParas[13] = new SqlParameter(":fentity_number", 12, (Object)entityNumber);
            sqlParas[14] = new SqlParameter(":fislocale", 12, (Object)isLocale);
            sqlParas[15] = new SqlParameter(":foldencrypt_type", 12, (Object)oldEncryptType);
            sqlParas[16] = new SqlParameter(":fpktype", 4, (Object)PrivacyTaskUtils.getDbPrimaryValueType(entityNumber));
            sqlParas[17] = new SqlParameter(":fiscommonlang", 12, (Object)isCommonLang);
            sqlParas[18] = new SqlParameter(":fschemeId", -5, (Object)schemeId);
            sqlParas[19] = new SqlParameter(":ftasknumber", 12, (Object)String.valueOf(taskId));
            sqlParas[20] = new SqlParameter(":fentityname", 12, newObj.get(FENCRYPT_ENTITY_NAME));
            sqlParas[21] = new SqlParameter(":ffieldident", 12, (Object)fieldIdent);
            sqlParas[22] = new SqlParameter(":ffielddesc", 12, newObj.get(FENCRYPT_FIELD_DESC));
            sqlParas[23] = new SqlParameter(":fcreater", 12, (Object)RequestContext.get().getCurrUserId());
        }
        catch (Exception exception) {
            String logMsg = "";
            if (1 == taskType) {
                logMsg = String.format(ResManager.loadKDString((String)"[SplitTask-EncodeTask]\u4efb\u52a1\u62c6\u5206\u62a5\u9519!FieldName:%1$s,TableName:%2$s", (String)"PrivacyTaskUtils_2", (String)"bos-privacy-implement", (Object[])new Object[0]), fieldName, tableName);
            } else if (2 == taskType) {
                logMsg = String.format(ResManager.loadKDString((String)"[SplitTask-DecodeTask]\u4efb\u52a1\u62c6\u5206\u62a5\u9519!FieldName:%1$s,TableName:%2$s", (String)"PrivacyTaskUtils_3", (String)"bos-privacy-implement", (Object[])new Object[0]), fieldName, tableName);
            }
            logger.info(logMsg);
            throw exception;
        }
        return sqlParas;
    }

    public static void printTaskLog(SqlParameter[] sqlParameter, int taskType) {
        String type = null;
        switch (taskType) {
            case 1: {
                type = ResManager.loadKDString((String)"\u52a0\u5bc6", (String)"PrivacyTaskSplitPlugin_2", (String)"bos-privacy-plugin", (Object[])new Object[0]);
                break;
            }
            case 2: {
                type = ResManager.loadKDString((String)"\u89e3\u5bc6", (String)"PrivacyTaskSplitPlugin_3", (String)"bos-privacy-plugin", (Object[])new Object[0]);
                break;
            }
            case 3: {
                type = ResManager.loadKDString((String)"\u4ea4\u6362", (String)"PrivacyTaskSplitPlugin_4", (String)"bos-privacy-plugin", (Object[])new Object[0]);
                break;
            }
        }
        String info = ResManager.loadKDString((String)"[SplitTask]\u4ea7\u751f\u4e86%1$s\u4efb\u52a1!TaskId:%2$s,FieldName:%3$s,TableName:%4$s,OrderBy:%5$s,isLocale%6$s,isCommonLang:%7$s", (String)"PrivacyTaskSplitPlugin_5", (String)"bos-privacy-plugin", (Object[])new Object[0]);
        logger.info(String.format(info, type, sqlParameter[0], sqlParameter[8], sqlParameter[2], sqlParameter[9], sqlParameter[14], sqlParameter[17]));
    }

    private static String isLocale(int fieldType) {
        if (fieldType == 1112) {
            return "TRUE";
        }
        return "FALSE";
    }

    private static String isCommonLang(MainEntityType entityType, int fieldType, String fieldIdent) {
        String isCommonLang = "FALSE";
        if (fieldType == 1112) {
            IDataEntityProperty property = entityType.findProperty(fieldIdent);
            if (property == null) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5b9e\u4f53%1$s\u4e2d\u4e0d\u5b58\u5728\u5b57\u6bb5%2$s", (String)"PrivacyTaskUtils_1", (String)"bos-privacy-implement", (Object[])new Object[0]), entityType.getName(), fieldIdent));
            }
            if (!property.isDbIgnore()) {
                isCommonLang = "TRUE";
            }
        }
        return isCommonLang;
    }

    public static String buildEncryptConstaintKey(String tableName, String fieldName) {
        return String.format("%s$%s", tableName.toLowerCase(), fieldName.toLowerCase());
    }
}

