/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.health.plugin;

import com.alibaba.fastjson.JSONArray;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.devportal.BizCloudServiceHelp;

public class MetadataPlugin
extends AbstractFormPlugin
implements TreeNodeClickListener {
    private static final String ENTRYENTITY = "entryentity";

    public void initialize() {
        super.initialize();
        TreeView treeView = (TreeView)this.getControl("treeview");
        treeView.addTreeNodeClickListener((TreeNodeClickListener)this);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.intiTree();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"healthvalidate"});
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    private void intiTree() {
        TreeView treeView = (TreeView)this.getControl("treeview");
        TreeNode root = new TreeNode();
        root.setText(ResManager.loadKDString((String)"\u5168\u90e8", (String)"MetadataPlugin_0", (String)"bos-healthexamination", (Object[])new Object[0]));
        root.setParentid("");
        root.setId("-1");
        root.setIsOpened(true);
        List<TreeNode> cloudNodes = this.getCloudNodes();
        for (TreeNode treeNode : cloudNodes) {
            List<TreeNode> groupNodes = this.getAppNodes(treeNode.getId());
            this.addChildNode(treeNode, groupNodes);
        }
        root.addChildren(cloudNodes);
        treeView.addNode(root);
        treeView.focusNode(root);
        TreeNodeEvent evt = new TreeNodeEvent((Object)treeView, (Object)"", (Object)"-1");
        this.treeNodeClick(evt);
    }

    private List<TreeNode> getAppNodes(String cloudId) {
        ArrayList<TreeNode> appNodes = new ArrayList<TreeNode>(10);
        DynamicObjectCollection dynamicObjects = BizAppServiceHelp.getAllBizAppsByCloudID((String)cloudId);
        for (DynamicObject dynamicObject : dynamicObjects) {
            TreeNode node = new TreeNode();
            String nodeId = dynamicObject.getString("id");
            node.setId(nodeId);
            node.setText(dynamicObject.getString("name"));
            node.setParentid(cloudId);
            appNodes.add(node);
        }
        return appNodes;
    }

    private List<TreeNode> getCloudNodes() {
        ArrayList<TreeNode> cloudNode = new ArrayList<TreeNode>(10);
        DynamicObjectCollection dynamicObjects = BizCloudServiceHelp.getAllBizClouds();
        for (DynamicObject dynamicObject : dynamicObjects) {
            TreeNode node = new TreeNode();
            node.setId(dynamicObject.getString("id"));
            node.setText(dynamicObject.getString("name"));
            node.setParentid("-1");
            cloudNode.add(node);
        }
        return cloudNode;
    }

    private TreeNode addChildNode(TreeNode pnode, List<TreeNode> childNodes) {
        for (int i = 0; i < childNodes.size(); ++i) {
            TreeNode cnode = childNodes.get(i);
            String parentId = cnode.getParentid();
            if (!pnode.getId().equals(parentId)) continue;
            pnode.addChild(this.addChildNode(cnode, childNodes));
        }
        return pnode;
    }

    public void click(EventObject evt) {
        super.click(evt);
        FormShowParameter show = new FormShowParameter();
        show.setFormId("bos_examinatonform");
        show.setCustomParam("validateType", (Object)"metadatavalidate");
        EntryGrid grid = (EntryGrid)this.getControl(ENTRYENTITY);
        grid.getSelectRows();
        this.getModel().getEntryEntity(ENTRYENTITY);
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        FormShowParameter show = new FormShowParameter();
        show.setFormId("bos_examinatonform");
        show.setCustomParam("validateType", (Object)"metadatavalidate");
        show.getOpenStyle().setShowType(ShowType.Modal);
        EntryGrid grid = (EntryGrid)this.getControl(ENTRYENTITY);
        int[] rows = grid.getSelectRows();
        ArrayList<String> list = new ArrayList<String>(4);
        for (int i : rows) {
            DynamicObject doj = this.getModel().getEntryRowEntity(ENTRYENTITY, i);
            String formNumber = doj.getString("formnumber");
            list.add(formNumber);
        }
        show.setCustomParam("validateNumberList", list);
        this.getView().showForm(show);
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        ORM orm = ORM.create();
        String selectField = "number,name,id";
        String entityName = "bos_entityobject";
        QFilter filter = this.getModelFilter(evt.getNodeId().toString());
        QFilter[] filters = new QFilter[]{filter};
        DynamicObjectCollection doc = orm.query(entityName, selectField, filters);
        this.getModel().deleteEntryData(ENTRYENTITY);
        if (doc.size() > 0) {
            this.getModel().batchCreateNewEntryRow(ENTRYENTITY, doc.size());
        }
        for (int i = 0; i < doc.size(); ++i) {
            DynamicObject doj = (DynamicObject)doc.get(i);
            this.getModel().setValue("formname", doj.get("name"), i);
            this.getModel().setValue("formnumber", doj.get("number"), i);
        }
        ((EntryGrid)this.getControl(ENTRYENTITY)).setPageIndex(1);
    }

    protected QFilter getModelFilter(String nodeId) {
        QFilter qFilter = null;
        ORM orm = ORM.create();
        boolean isCloud = orm.exists("bos_devportal_bizcloud", (Object)nodeId);
        if (nodeId.equals("-1")) {
            qFilter = new QFilter("dentityid", "is not null", (Object)"");
        } else if (isCloud) {
            JSONArray units = this.getUnitIdsByCloudId(nodeId);
            qFilter = new QFilter("bizappid", "in", (Object)units);
        } else {
            qFilter = new QFilter("bizappid", "=", (Object)nodeId);
        }
        return qFilter;
    }

    protected JSONArray getUnitIdsByCloudId(String bizCloudId) {
        JSONArray unitIds = new JSONArray();
        ORM orm = ORM.create();
        QFilter q = new QFilter("bizcloud", "=", (Object)bizCloudId);
        QFilter[] filters = new QFilter[]{q};
        String selectFields = "id";
        DynamicObjectCollection query = orm.query("bos_devportal_bizapp", selectFields, filters, "");
        for (int i = 0; i < query.size(); ++i) {
            DynamicObject dynamicObject = (DynamicObject)query.get(i);
            String bizAppId = dynamicObject.getString("id");
            unitIds.add((Object)bizAppId);
        }
        return unitIds;
    }
}

