/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.health.plugin;

import java.util.EventObject;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.health.repair.MetaDataRepairExcutor;
import kd.bos.health.repair.RepairConfig;
import kd.bos.health.svn.HealthSVNUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.SessionManager;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;

public class SVNHealthPlugin
extends AbstractFormPlugin {
    private static final Log log = LogFactory.getLog(SVNHealthPlugin.class);
    private static final String SVNPATH = "svnpath";
    private static final String USERNAME = "username";
    private static final String PW = "password";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"btnok"});
    }

    public void beforeBindData(EventObject e) {
        FormShowParameter showPara = this.getView().getFormShowParameter();
        String formNumber = (String)((Map)showPara.getCustomParam("data")).get("number");
        String username = SessionManager.getCurrent().get("smgusername");
        String password = SessionManager.getCurrent().get("smgpassword");
        String svnPath = HealthSVNUtils.getSVNUrl(formNumber);
        if (StringUtils.isBlank((CharSequence)svnPath)) {
            this.getView().showMessage(String.format(ResManager.loadKDString((String)"\u6b8b\u7559\u6570\u636e\uff0c\u627e\u4e0d\u5230svn\u5730\u5740\uff0c\u8bf7\u81ea\u884c\u5199\u811a\u672c\u5220\u9664\n\uff0c\u811a\u672c\u4e3a\uff1a%s", (String)"SVNHealthPlugin_3", (String)"bos-healthexamination", (Object[])new Object[0]), HealthSVNUtils.createRemoveSql(ResManager.loadKDString((String)"\u586b\u5199\u7f16\u7801", (String)"SVNHealthPlugin_1", (String)"bos-healthexamination", (Object[])new Object[0]), ResManager.loadKDString((String)"\u586b\u5199\u8868\u5355id", (String)"SVNHealthPlugin_2", (String)"bos-healthexamination", (Object[])new Object[0]))));
        }
        this.getModel().setValue(SVNPATH, (Object)svnPath);
        this.getModel().setValue(USERNAME, (Object)username);
        this.getModel().setValue(PW, (Object)password);
    }

    public void click(EventObject evt) {
        if (((Control)evt.getSource()).getKey().equals("btnok")) {
            String username = (String)this.getModel().getValue(USERNAME);
            String password = (String)this.getModel().getValue(PW);
            SessionManager.getCurrent().put("smgusername", username);
            SessionManager.getCurrent().put("smgpassword", password);
            try {
                Map data = (Map)this.getView().getFormShowParameter().getCustomParam("data");
                String svnPath = (String)this.getModel().getValue(SVNPATH);
                data.put(SVNPATH, svnPath);
                data.put(USERNAME, username);
                data.put(PW, password);
                data.put("annotation", this.getModel().getValue("annotation"));
                String formNumber = (String)data.get("number");
                String appNumber = BizAppServiceHelp.getAppNumByAppId((String)BizAppServiceHelp.getAppIdByFormNum((String)formNumber));
                data.put("appnumber", appNumber);
                data.put("view", this.getView());
                String className = (String)this.getView().getFormShowParameter().getCustomParam("repairclass");
                if (StringUtils.isNotBlank((CharSequence)className)) {
                    RepairConfig repairConfig = new RepairConfig(Class.forName(className));
                    MetaDataRepairExcutor metaDataRepairExcutor = new MetaDataRepairExcutor();
                    metaDataRepairExcutor.setRepairConfig(repairConfig);
                    metaDataRepairExcutor.excute(data);
                }
            }
            catch (ClassNotFoundException e) {
                log.error((Throwable)e);
            }
        }
        this.getView().close();
    }
}

