/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.filter;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import kd.bos.dataentity.entity.CollectionPropertyAttribute;
import kd.bos.dataentity.entity.DefaultValueAttribute;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.trace.EntityTraceSpan;
import kd.bos.dataentity.trace.EntityTracer;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.filter.ControlFilter;
import kd.bos.exception.KDBizException;
import kd.bos.filter.AbstractFilterGridView;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.DefaultHiddenField;
import kd.bos.filter.DependField;
import kd.bos.filter.FilterColumn;
import kd.bos.filter.ListSysPublicParameter;
import kd.bos.filter.OrgDependField;
import kd.bos.form.ClientControlTypes;
import kd.bos.orm.query.QFilter;
import kd.bos.report.IReportView;
import kd.bos.utils.SortUtil;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class FilterGridView
extends AbstractFilterGridView {
    private String selectedCommomFilterFieldName = "";
    private List<Object> selectedCommomFilterFieldValues = new ArrayList<Object>();
    private List<DefaultHiddenField> defaultHiddenFields = new ArrayList<DefaultHiddenField>();
    private Optional<Boolean> usersIsNewFilter = Optional.empty();
    private Optional<Boolean> pluginsIsNewFilter = Optional.empty();
    private Boolean isDesignerNewFilter;
    private boolean isNewFilter;
    private Map<String, Object> userCommonFilterConfig = new HashMap<String, Object>();
    private List<String> designFilterColumnKeys = new ArrayList<String>();
    private List<String> pluginFilterColumnKeys = new ArrayList<String>();
    private Set<String> hasInitFilterColumnNames = new HashSet<String>();
    private Map<String, List<QFilter>> pluginQFilterMap = new HashMap<String, List<QFilter>>(16);
    private Map<String, List<Object>> commonFilters = new HashMap<String, List<Object>>();

    Optional<Boolean> isUsersIsNewFilter() {
        return this.usersIsNewFilter;
    }

    void setUsersIsNewFilter(Optional<Boolean> usersIsNewFilter) {
        this.usersIsNewFilter = usersIsNewFilter;
    }

    Optional<Boolean> getPluginsIsNewFilter() {
        return this.pluginsIsNewFilter;
    }

    void setPluginsIsNewFilter(Optional<Boolean> pluginsIsNewFilter) {
        this.pluginsIsNewFilter = pluginsIsNewFilter;
    }

    Boolean isDesignerNewFilter() {
        return this.isDesignerNewFilter;
    }

    void setDesignerNewFilter(Boolean isDesignerNewFilter) {
        this.isDesignerNewFilter = isDesignerNewFilter;
    }

    @SimplePropertyAttribute
    @DefaultValueAttribute(value="NewFilter")
    public boolean isNewFilter() {
        return this.isNewFilter;
    }

    public void setNewFilter(boolean isNewFilter) {
        this.isNewFilter = isNewFilter;
    }

    @CollectionPropertyAttribute(collectionItemPropertyType=DefaultHiddenField.class)
    public List<DefaultHiddenField> getDefaultHiddenFields() {
        return this.defaultHiddenFields;
    }

    public void setDefaultHiddenFields(List<DefaultHiddenField> defaultHiddenFields) {
        this.defaultHiddenFields = defaultHiddenFields;
    }

    protected void setSelectedCommomFilterFieldName(String selectedCommomFilterFieldName) {
        this.selectedCommomFilterFieldName = selectedCommomFilterFieldName;
    }

    protected void setSelectedCommomFilterFieldValues(List<Object> selectedCommomFilterFieldValues) {
        this.selectedCommomFilterFieldValues = selectedCommomFilterFieldValues;
    }

    void setUserCommonFilterConfig(Map<String, Object> userCommonFilterConfig) {
        this.userCommonFilterConfig = userCommonFilterConfig;
    }

    public void initFilterColumn(FilterColumn filterColumn) {
        ArrayList<FilterColumn> filterColumns = new ArrayList<FilterColumn>();
        filterColumns.add(filterColumn);
        this.initFilterColumns(filterColumns);
    }

    @Override
    protected void initFilterColumns(List<FilterColumn> filterColumnsList) {
        LinkedHashSet<FilterColumn> filterColumns = new LinkedHashSet<FilterColumn>(16);
        for (FilterColumn filterColumn : filterColumnsList) {
            filterColumns.add(filterColumn);
        }
        this.getItems().clear();
        this.getItems().addAll(filterColumns);
        for (FilterColumn filterColumn : filterColumns) {
            this.initCommonFilterColumnContext(filterColumn);
            this.designFilterColumnKeys.add(filterColumn.getFieldName());
        }
        this.commonFilters = this.getCommonFilters(filterColumns, this.context.getControlFiltersMap());
        this.setDependFieldMap(filterColumnsList);
        this.checkCircleDependent();
        Map<String, Set<String>> beDependFieldNameMap = this.getBeDependFieldNameMap();
        for (FilterColumn filterColumn : filterColumns) {
            if (beDependFieldNameMap.containsKey(filterColumn.getFieldName()) || this.dependFieldMap.containsKey(filterColumn.getFieldName())) continue;
            this.initCommonFilterColumn(filterColumn);
        }
        for (FilterColumn filterColumn : filterColumns) {
            if (!beDependFieldNameMap.containsKey(filterColumn.getFieldName()) || this.dependFieldMap.containsKey(filterColumn.getFieldName())) continue;
            this.initCommonFilterColumn(filterColumn);
        }
        for (FilterColumn filterColumn : filterColumns) {
            List dependFields = (List)this.dependFieldMap.get(filterColumn.getFieldName());
            if (dependFields == null || dependFields.isEmpty() || !(dependFields.get(0) instanceof OrgDependField) || !this.dependFieldMap.containsKey(filterColumn.getFieldName())) continue;
            this.addDependFilter(filterColumn, dependFields);
            this.initCommonFilterColumn(filterColumn);
            this.dependFieldMap.remove(filterColumn.getFieldName());
        }
    }

    private void checkCircleDependent() {
        for (Map.Entry entry : this.dependFieldMap.entrySet()) {
            for (DependField dependField : (List)entry.getValue()) {
                if (!this.isCircleDependent(dependField.getDependFieldName(), (String)entry.getKey(), this.dependFieldMap)) continue;
                throw new KDBizException(ResManager.loadKDString((String)"\u8fc7\u6ee4\u5b57\u6bb5\u5b58\u5728\u5faa\u73af\u4f9d\u8d56\u5b57\u6bb5\uff0c\u8bf7\u8c03\u6574\u3002", (String)"FilterGridView_1", (String)"bos-form-core", (Object[])new Object[0]));
            }
        }
    }

    private boolean isCircleDependent(String dependField, String beDependField, Map<String, List<DependField>> dependFieldMap) {
        Iterator<DependField> iterator;
        if (dependFieldMap.containsKey(dependField) && (iterator = dependFieldMap.get(dependField).iterator()).hasNext()) {
            DependField dependField2 = iterator.next();
            if (beDependField.equals(dependField2.getDependFieldName())) {
                return true;
            }
            return this.isCircleDependent(dependField2.getDependFieldName(), dependField, dependFieldMap);
        }
        return false;
    }

    private void initCommonFilterColumnContext(FilterColumn filterColumn) {
        if (filterColumn instanceof CommonFilterColumn) {
            CommonFilterColumn commonFilterColumn = (CommonFilterColumn)filterColumn;
            commonFilterColumn.setCommonFilters(this.commonFilters);
            commonFilterColumn.setDependFieldMap(this.dependFieldMap);
            this.addSetFilterListener(commonFilterColumn);
        }
    }

    @Deprecated
    protected Map<String, FilterColumn> getBeDependFieldColumnMap(List<FilterColumn> commonFilterColumns) {
        HashMap<String, FilterColumn> beDependFieldColumnMap = new HashMap<String, FilterColumn>(16);
        Map<String, Set<String>> beDependFieldNameMap = this.getBeDependFieldNameMap();
        for (FilterColumn filterColumn : commonFilterColumns) {
            if (!beDependFieldNameMap.containsKey(filterColumn.getFieldName())) continue;
            beDependFieldColumnMap.put(filterColumn.getFieldName(), filterColumn);
        }
        return beDependFieldColumnMap;
    }

    protected Map<String, List<Object>> getCommonFilters(Set<FilterColumn> commonFilterColumns, Map<String, ControlFilter> controlFilters) {
        HashMap<String, List<Object>> newCommonFilters = new HashMap<String, List<Object>>();
        for (FilterColumn filterColumn : commonFilterColumns) {
            if (filterColumn instanceof CommonFilterColumn) {
                ((CommonFilterColumn)filterColumn).setCommonFilters(newCommonFilters);
            }
            if (!controlFilters.containsKey(filterColumn.getFilterFieldName())) continue;
            ControlFilter controlFilter = controlFilters.get(filterColumn.getFilterFieldName());
            newCommonFilters.put(filterColumn.getFieldName(), controlFilter.getValue());
        }
        return newCommonFilters;
    }

    protected void initDependFilterColumns(List<FilterColumn> commonFilterColumns) {
        ArrayList<FilterColumn> unFinishedCommonFilterColumns;
        for (FilterColumn filterColumn : commonFilterColumns) {
            filterColumn.setParentViewKey(this.getKey());
            filterColumn.setView(this.getView());
            filterColumn.setEntityType(this.getEntityType());
            filterColumn.setContext(this.getContext());
            this.initCommonFilterColumnContext(filterColumn);
            if (this.designFilterColumnKeys.contains(filterColumn.getFieldName())) continue;
            this.pluginFilterColumnKeys.add(filterColumn.getFieldName());
        }
        this.initDependFilterColumns(commonFilterColumns, new HashSet<String>());
        do {
            unFinishedCommonFilterColumns = new ArrayList<FilterColumn>();
            for (FilterColumn filterColumn : commonFilterColumns) {
                if (this.hasInitFilterColumnNames.contains(filterColumn.getFieldName()) || this.pluginFilterColumnKeys.contains(filterColumn.getFieldName())) continue;
                unFinishedCommonFilterColumns.add(filterColumn);
            }
            this.initDependFilterColumns(unFinishedCommonFilterColumns, new HashSet<String>());
        } while (!unFinishedCommonFilterColumns.isEmpty());
    }

    private void initDependFilterColumns(List<FilterColumn> commonFilterColumns, Set<String> dependFieldNames) {
        if (!dependFieldNames.isEmpty() && !this.isDependFieldNamesExists(commonFilterColumns, dependFieldNames)) {
            for (String dependFieldName : dependFieldNames) {
                this.hasInitFilterColumnNames.add(dependFieldName);
            }
        }
        for (FilterColumn filterColumn : commonFilterColumns) {
            if (!dependFieldNames.contains(filterColumn.getFieldName()) && !dependFieldNames.isEmpty() || !this.dependFieldMap.containsKey(filterColumn.getFieldName())) continue;
            List dependFields = (List)this.dependFieldMap.get(filterColumn.getFieldName());
            HashSet<String> beInitdependFieldNames = new HashSet<String>(16);
            for (DependField dependField : dependFields) {
                beInitdependFieldNames.add(dependField.getDependFieldName());
            }
            if (this.isAllDependFieldsFinished(dependFields)) {
                this.addDependFilter(filterColumn, dependFields);
                this.initCommonFilterColumn(filterColumn);
                continue;
            }
            this.initDependFilterColumns(commonFilterColumns, beInitdependFieldNames);
        }
    }

    private boolean isDependFieldNamesExists(List<FilterColumn> commonFilterColumns, Set<String> dependFieldNames) {
        boolean dependFieldNamesExists = false;
        for (FilterColumn filterColumn : commonFilterColumns) {
            if (!dependFieldNames.contains(filterColumn.getFieldName())) continue;
            dependFieldNamesExists = true;
            break;
        }
        return dependFieldNamesExists;
    }

    private boolean isAllDependFieldsFinished(List<DependField> dependFields) {
        for (DependField dependField : dependFields) {
            if (this.hasInitFilterColumnNames.contains(dependField.getDependFieldName()) || this.pluginFilterColumnKeys.contains(dependField.getDependFieldName())) continue;
            return false;
        }
        return true;
    }

    private void addDependFilter(FilterColumn filterColumn, List<DependField> dependFields) {
        for (DependField dependField : dependFields) {
            if (!this.hasInitFilterColumnNames.contains(dependField.getDependFieldName()) && !this.pluginFilterColumnKeys.contains(dependField.getDependFieldName())) continue;
            CommonFilterColumn commonFilterColumn = (CommonFilterColumn)filterColumn;
            commonFilterColumn.addDependFilter(dependField);
        }
    }

    Map<String, List<QFilter>> getPluginQFilterMap() {
        return this.pluginQFilterMap;
    }

    private void initCommonFilterColumn(FilterColumn filterColumn) {
        if (this.hasInitFilterColumnNames.contains(filterColumn.getFieldName())) {
            return;
        }
        filterColumn.initProperties();
        if (filterColumn instanceof CommonFilterColumn && !((CommonFilterColumn)filterColumn).getPluginInitQFilters().isEmpty()) {
            String preName = filterColumn.getFilterField().getSrcFieldKey();
            if (StringUtils.isNotBlank((CharSequence)filterColumn.getFilterField().getRefPropKey1()) && StringUtils.isNotBlank((CharSequence)filterColumn.getFilterField().getRefPropKey2())) {
                preName = preName + "." + filterColumn.getFilterField().getRefPropKey1();
            }
            this.pluginQFilterMap.put(preName, ((CommonFilterColumn)filterColumn).getPluginInitQFilters());
        }
        this.hasInitFilterColumnNames.add(filterColumn.getFieldName());
    }

    public Map<String, Object> createClientConfig() {
        Map map = super.createClientConfig();
        map.put("type", ClientControlTypes.FilterGridView);
        if (this.isInvisible()) {
            map.put("vi", 0);
        } else {
            map.put("vi", this.getVisible());
        }
        return map;
    }

    @Override
    public String getClientKey() {
        return "common";
    }

    @Override
    public Object createFilterColumns() {
        if (this.context.isLookup()) {
            return new ArrayList();
        }
        return super.createFilterColumns();
    }

    @Override
    boolean skip(FilterColumn filterColumn) {
        if (filterColumn instanceof CommonFilterColumn) {
            return this.defaultHiddenFields.stream().anyMatch(t -> t.getFieldName().equals(filterColumn.getFieldName()));
        }
        return super.skip(filterColumn);
    }

    @Override
    List<FilterColumn> filterAndSort(List<FilterColumn> filterColumns) {
        try (EntityTraceSpan span = EntityTracer.create((String)"kd.bos.filter.FilterGridView", (String)"filterAndSort");){
            Optional<Boolean> usersIsNewFilter2 = this.isUsersIsNewFilter();
            if (span.isRealtime()) {
                span.addLocaleTag("usersIsNewFilter", usersIsNewFilter2);
                span.addLocaleTag("pluginsIsNewFilter", this.getPluginsIsNewFilter());
            }
            if (this.getPluginsIsNewFilter().isPresent() || usersIsNewFilter2.isPresent() && !usersIsNewFilter2.get().booleanValue() || !usersIsNewFilter2.isPresent() && (this.isDesignerNewFilter() == null ? !this.isNewFilter() : this.isDesignerNewFilter() == false)) {
                List<FilterColumn> list = this.getVisibleFilterColumnsByDesigner(filterColumns);
                return list;
            }
            ArrayList<String> userCommonFilterNames = new ArrayList<String>();
            ArrayList<String> fullCommonFilterNames = new ArrayList<String>();
            if (!this.userCommonFilterConfig.isEmpty()) {
                List userCommonFilters = (List)this.userCommonFilterConfig.get("rows");
                for (Map map : userCommonFilters) {
                    if ((Integer)map.get("v") == 1) {
                        userCommonFilterNames.add(map.get("n").toString());
                    }
                    fullCommonFilterNames.add(map.get("n").toString());
                }
            }
            List<String> filterNames = this.filterFilterColumnsByVisibile(filterColumns, userCommonFilterNames, fullCommonFilterNames);
            List sortListByKeys = SortUtil.sortListByKeys(userCommonFilterNames, filterNames);
            LinkedHashSet sortedFilterColumns = new LinkedHashSet(16);
            for (String sortKey : sortListByKeys) {
                filterColumns.forEach(filterColumn -> {
                    if (sortKey.equals(filterColumn.getFilterFieldName())) {
                        sortedFilterColumns.add(filterColumn);
                    }
                });
            }
            if (span.isRealtime()) {
                span.addLocaleTag("filterNames", filterNames);
                span.addLocaleTag("sortListByKeys", (Object)sortListByKeys);
                span.addLocaleTag("userCommonFilterConfig", this.userCommonFilterConfig);
                span.addLocaleTag("sortedFilterColumns", sortedFilterColumns);
            }
            ArrayList arrayList = new ArrayList(sortedFilterColumns);
            return arrayList;
        }
    }

    private List<FilterColumn> getVisibleFilterColumnsByDesigner(List<FilterColumn> filterColumns) {
        ArrayList<FilterColumn> visibleFilterColumns = new ArrayList<FilterColumn>();
        for (FilterColumn filterColumn : filterColumns) {
            if (!(filterColumn instanceof CommonFilterColumn) || this.defaultHiddenFields.stream().anyMatch(t -> t.getFieldName().equals(filterColumn.getFieldName()))) continue;
            visibleFilterColumns.add(filterColumn);
        }
        return visibleFilterColumns;
    }

    private List<String> filterFilterColumnsByVisibile(List<FilterColumn> filterColumns, List<String> userCommonFilterNames, List<String> fullCommonFilterNames) {
        ArrayList<String> filterNames = new ArrayList<String>();
        if (!this.userCommonFilterConfig.isEmpty()) {
            this.filterFilterColumnsByUser(filterColumns, userCommonFilterNames, fullCommonFilterNames, filterNames);
        } else {
            this.filterFilterColumnsByDesigner(filterColumns, filterNames);
        }
        return filterNames;
    }

    private void filterFilterColumnsByDesigner(List<FilterColumn> filterColumns, List<String> filterNames) {
        for (FilterColumn filterColumn : filterColumns) {
            boolean canRemove = ((CommonFilterColumn)filterColumn).isCanRemove();
            boolean mustInput = ((CommonFilterColumn)filterColumn).isMustInput();
            if (!(filterColumn instanceof CommonFilterColumn) || canRemove && !mustInput && this.defaultHiddenFields.stream().anyMatch(t -> t.getFieldName().equals(filterColumn.getFieldName()))) continue;
            filterNames.add(filterColumn.getFilterFieldName());
        }
    }

    private void filterFilterColumnsByUser(List<FilterColumn> filterColumns, List<String> userCommonFilterNames, List<String> fullCommonFilterNames, List<String> filterNames) {
        for (FilterColumn filterColumn : filterColumns) {
            String filterFieldName = filterColumn.getFilterFieldName();
            boolean canRemove = ((CommonFilterColumn)filterColumn).isCanRemove();
            boolean mustInput = ((CommonFilterColumn)filterColumn).isMustInput();
            if ((this.defaultHiddenFields.stream().anyMatch(t -> t.getFieldName().equals(filterColumn.getFieldName())) || fullCommonFilterNames.contains(filterFieldName)) && !userCommonFilterNames.contains(filterFieldName) && (!(filterColumn instanceof CommonFilterColumn) || !mustInput && canRemove)) continue;
            filterNames.add(filterFieldName);
        }
    }

    Map<String, Object> createCommonFilterConfig() {
        List<FilterColumn> fltColumns = this.getShowFilterColumns(true);
        ArrayList<Map<String, Object>> rows = new ArrayList<Map<String, Object>>(10);
        for (FilterColumn filterColumn : fltColumns) {
            if (!(filterColumn instanceof CommonFilterColumn)) continue;
            rows.add(((CommonFilterColumn)filterColumn).createCommonFilterConfig(this.defaultHiddenFields));
        }
        HashMap<String, Object> commonFilterConfig = new HashMap<String, Object>();
        Object listfilterlayout = ListSysPublicParameter.option("listfilterlayout");
        commonFilterConfig.put("type", listfilterlayout == null ? 0 : Integer.parseInt(listfilterlayout.toString()));
        commonFilterConfig.put("rows", rows);
        return commonFilterConfig;
    }

    protected Map<String, List<Object>> getCommonFilters() {
        return this.commonFilters;
    }

    protected void setCommonFilters(Map<String, List<Object>> commonFilters) {
        this.commonFilters = commonFilters;
    }

    private void addSetFilterListener(CommonFilterColumn commonFilterColumn) {
        commonFilterColumn.setSetFilterListeners(this.getSetFilterListeners());
        if (commonFilterColumn.isEntityField()) {
            String fieldName;
            String string = fieldName = this.getView() instanceof IReportView ? commonFilterColumn.getFieldName() : commonFilterColumn.getFilterFieldName();
            if (this.selectedCommomFilterFieldName.equals(fieldName)) {
                commonFilterColumn.setSelectedCommomFilterFieldValues(this.selectedCommomFilterFieldValues);
            } else {
                this.setSelectedFilterValuesByCache(commonFilterColumn);
            }
        }
    }

    private void setSelectedFilterValuesByCache(CommonFilterColumn commonFilterColumn) {
        List<Object> valueList = this.commonFilters.get(commonFilterColumn.getFieldName());
        if (valueList != null) {
            List<Object> tmpValueList = this.getValidValues(valueList);
            commonFilterColumn.setSelectedCommomFilterFieldValues(tmpValueList);
        }
    }

    private List<Object> getValidValues(List<Object> valueList) {
        ArrayList<Object> tmpValueList = new ArrayList<Object>();
        if (valueList != null) {
            for (Object value : valueList) {
                if (!StringUtils.isNotBlank((Object)value)) continue;
                tmpValueList.add(value);
            }
        }
        return tmpValueList;
    }
}

