/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.filter;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterField;
import kd.bos.entity.property.FlexProp;
import kd.bos.entity.property.IFieldHandle;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.filter.FilterColumn;
import kd.bos.filter.FlexPropSchemeFilterColumn;
import kd.bos.filter.SchemeFilterColumn;
import kd.bos.form.control.Control;
import kd.bos.list.ExtendedFlexDimensions;
import kd.bos.list.ListFlexDimension;
import kd.bos.report.IReportView;

public class FlexSchemeFilterColumn
extends SchemeFilterColumn {
    MainEntityType dataEntityType;
    private ExtendedFlexDimensions extendedFlexDimensions;

    private void createEntityType() {
        this.dataEntityType = new MainEntityType();
        this.dataEntityType.setName(super.getEntityType().getName() + "_" + this.getKey());
    }

    @Override
    public MainEntityType getEntityType() {
        if (this.dataEntityType == null) {
            this.createEntityType();
        }
        return this.dataEntityType;
    }

    @Override
    public FilterField getFilterField() {
        if (this.filterField == null) {
            this.filterField = FilterField.create((MainEntityType)this.getEntityType(), (String)this.getFieldName());
        }
        if (!(this.getView() instanceof IReportView) && this.filterField == null) {
            throw new KDBizException(BosErrorCode.fieldNotExist, new Object[]{this.dataEntityType.getName(), String.format(ResManager.loadKDString((String)"%1$s\uff0c\u9519\u8bef\u4ee3\u7801: %2$s", (String)"FilterColumn_1", (String)"bos-form-core", (Object[])new Object[0]), this.getFieldName(), "FIELDNOTEXISTS000011")});
        }
        return this.filterField;
    }

    @Override
    public void initProperties() {
        FilterField filterField = FilterField.create((MainEntityType)super.getEntityType(), (String)this.getFieldName());
        if (!(this.getView() instanceof IReportView) && filterField == null) {
            throw new KDBizException(BosErrorCode.fieldNotExist, new Object[]{super.getEntityType().getName(), String.format(ResManager.loadKDString((String)"%1$s\uff0c\u9519\u8bef\u4ee3\u7801: %2$s", (String)"FilterColumn_1", (String)"bos-form-core", (Object[])new Object[0]), this.getFieldName(), "FIELDNOTEXISTS000012")});
        }
        String entryEntity = filterField.getEntityKey();
        this.setEntryEntity(filterField.getEntityKey());
        FlexProp flexProp = (FlexProp)filterField.getSrcFieldProp();
        this.extendedFlexDimensions = new ExtendedFlexDimensions(this.getFieldName());
        this.getContext().putExtendedFlexDimensions(this.extendedFlexDimensions);
        this.extendedFlexDimensions.setRegisterPropertyListeners(flexProp.extendFlexProperties(super.getEntityType().getName() + "_" + this.getKey(), registerFlexPropertyArgs -> {
            this.dataEntityType = registerFlexPropertyArgs.getEntityType();
            if (registerFlexPropertyArgs.getBaseProp() != null) {
                LocaleString displayName;
                BasedataEntityType type = (BasedataEntityType)registerFlexPropertyArgs.getBaseProp().getComplexType();
                if (StringUtils.isNotEmpty((CharSequence)type.getNumberProperty())) {
                    String number = String.format("%s.%s.%s", registerFlexPropertyArgs.getDimensionProp().getName(), registerFlexPropertyArgs.getBaseProp(), type.getNumberProperty());
                    displayName = new LocaleString(String.format(ResManager.loadKDString((String)"%s.\u7f16\u7801", (String)"FlexSchemeFilterColumn_0", (String)"bos-form-core", (Object[])new Object[0]), registerFlexPropertyArgs.getBaseProp().getDisplayName()));
                    this.createFlexPropSchemeFilterColumn(entryEntity, registerFlexPropertyArgs.getDataEntityProperty(), number, displayName);
                }
                if (StringUtils.isNotEmpty((CharSequence)type.getNameProperty())) {
                    String name = String.format("%s.%s.%s", registerFlexPropertyArgs.getDimensionProp().getName(), registerFlexPropertyArgs.getBaseProp(), type.getNameProperty());
                    displayName = new LocaleString(String.format(ResManager.loadKDString((String)"%s.\u540d\u79f0", (String)"FlexSchemeFilterColumn_1", (String)"bos-form-core", (Object[])new Object[0]), registerFlexPropertyArgs.getBaseProp().getDisplayName()));
                    this.createFlexPropSchemeFilterColumn(entryEntity, registerFlexPropertyArgs.getDataEntityProperty(), name, displayName);
                    this.createListFlexDimension(entryEntity, registerFlexPropertyArgs.getDataEntityProperty(), name, displayName, "basedata");
                }
            } else {
                String name = String.format("%s.%s", registerFlexPropertyArgs.getDimensionProp().getName(), "value");
                LocaleString displayName = registerFlexPropertyArgs.getDimensionProp().getDisplayName();
                this.createFlexPropSchemeFilterColumn(entryEntity, registerFlexPropertyArgs.getDataEntityProperty(), name, displayName);
                this.createListFlexDimension(entryEntity, registerFlexPropertyArgs.getDataEntityProperty(), name, displayName, "text");
            }
        }));
    }

    private void createFlexPropSchemeFilterColumn(String entryEntity, IDataEntityProperty dataEntityProperty, String name, LocaleString displayName) {
        FlexPropSchemeFilterColumn schemeFilterColumn = new FlexPropSchemeFilterColumn();
        schemeFilterColumn.setView(this.view);
        schemeFilterColumn.setEntityType(this.getEntityType());
        schemeFilterColumn.setCaption(displayName);
        schemeFilterColumn.setFieldName(name);
        schemeFilterColumn.setContext(this.context);
        schemeFilterColumn.initProperties();
        schemeFilterColumn.setEntryEntity(entryEntity);
        if (dataEntityProperty instanceof IFieldHandle) {
            schemeFilterColumn.setType(((IFieldHandle)dataEntityProperty).getFilterControlType());
        }
        this.getItems().add(schemeFilterColumn);
    }

    private void createListFlexDimension(String entryEntity, IDataEntityProperty dataEntityProperty, String name, LocaleString displayName, String type) {
        this.extendedFlexDimensions.getFlexPropList().add(new ListFlexDimension(dataEntityProperty, name, entryEntity, displayName, type));
        FilterField filterField = FilterField.create((MainEntityType)this.getEntityType(), (String)name);
        this.extendedFlexDimensions.getFilterFields().put(filterField.getFieldName(), filterField);
    }

    @Override
    public List<FilterColumn> getFilterColumns() {
        ArrayList<FilterColumn> schemeFilterColumns = new ArrayList<FilterColumn>();
        HashSet<String> filterNames = new HashSet<String>();
        for (Control control : this.getItems()) {
            FilterColumn subFilterColumn = (FilterColumn)control;
            if (filterNames.contains(subFilterColumn.getFieldName())) continue;
            schemeFilterColumns.add(subFilterColumn);
            filterNames.add(subFilterColumn.getFieldName());
        }
        return schemeFilterColumns;
    }

    @Override
    public void addFilterFields(Map<String, FilterField> filterFields) {
        filterFields.putAll(this.extendedFlexDimensions.getFilterFields());
    }
}

