/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.filter;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.entity.filter.FilterField;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.filter.AbstractFilterGridView;
import kd.bos.filter.FilterColumn;
import kd.bos.filter.SchemeFilterColumn;
import kd.bos.form.ClientControlTypes;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class SchemeFilterView
extends AbstractFilterGridView {
    private static final Log log = LogFactory.getLog(SchemeFilterView.class);

    public Map<String, Object> createClientConfig() {
        Map map = super.createClientConfig();
        map.put("type", ClientControlTypes.SchemeFilterView);
        if (this.isInvisible()) {
            map.put("vi", 0);
        } else {
            map.put("vi", this.getVisible());
        }
        return map;
    }

    private List<FilterColumn> getAllFilterColumns() {
        ArrayList<FilterColumn> schemeFilterColumns = new ArrayList<FilterColumn>();
        List<FilterColumn> filterColumns = this.getFilterColumns();
        if (filterColumns != null) {
            for (FilterColumn filterColumn : filterColumns) {
                if (!(filterColumn instanceof SchemeFilterColumn)) continue;
                SchemeFilterColumn schemeFilterColumn = (SchemeFilterColumn)filterColumn;
                for (FilterColumn subSchemeFilterColumn : schemeFilterColumn.getFilterColumns()) {
                    if (schemeFilterColumns.contains((Object)subSchemeFilterColumn)) continue;
                    schemeFilterColumns.add(subSchemeFilterColumn);
                }
            }
        }
        return schemeFilterColumns;
    }

    @Override
    public Object createFilterColumns() {
        ArrayList<Map<String, Object>> cols = new ArrayList<Map<String, Object>>(10);
        List<FilterColumn> schemeFilterColumns = this.getAllFilterColumns();
        for (FilterColumn schemeFilterColumn : schemeFilterColumns) {
            if (schemeFilterColumn.isNeedHideOrg() || schemeFilterColumn.isBlackField()) continue;
            FilterField filterField = schemeFilterColumn.getFilterField();
            if (filterField != null) {
                if (filterField.isDesenAndNoSearch()) {
                    log.info("\u8131\u654f\u5b57\u6bb5\u652f\u6301\u67e5\u8be2\u672a\u5f00\u542f\u6216\u8131\u654f\u7b56\u7565\u4e0d\u7b26\u5408\u6761\u4ef6\uff0c\u56e0\u6b64\u5c4f\u853d\u8be5\u8131\u654f\u5b57\u6bb5, prop is {}", (Object)filterField.getFieldName());
                    continue;
                }
                if (filterField.isEncryptField() && filterField.getSrcFieldProp() instanceof DateTimeProp) {
                    log.info("\u52a0\u5bc6\u5b57\u6bb5\u5c4f\u853d\u65e5\u671f, prop is {}", (Object)filterField.getFieldName());
                    continue;
                }
            }
            cols.add(schemeFilterColumn.createColumn());
        }
        HashMap<String, ArrayList<Map<String, Object>>> schemeMeta = new HashMap<String, ArrayList<Map<String, Object>>>();
        schemeMeta.put("conditions", cols);
        return schemeMeta;
    }

    @Override
    public String getClientKey() {
        return "scheme";
    }

    @Override
    void fixCompareTypes(FilterColumn filterColumn) {
        if (filterColumn instanceof SchemeFilterColumn && ((SchemeFilterColumn)filterColumn).getCompareTypes().isEmpty()) {
            filterColumn.setNewAdded(true);
        }
    }

    Map<String, Object> createSchemeFilterConfig(List<String> fixedFilters) {
        List<FilterColumn> fltColumns = this.getShowFilterColumns(true);
        ArrayList<Map<String, Object>> rows = new ArrayList<Map<String, Object>>(10);
        for (FilterColumn filterColumn : fltColumns) {
            Map<String, Object> schemeFilterConfig;
            if (!(filterColumn instanceof SchemeFilterColumn) || (schemeFilterConfig = ((SchemeFilterColumn)filterColumn).createSchemeFilterConfig(fixedFilters)) == null || schemeFilterConfig.isEmpty()) continue;
            rows.add(schemeFilterConfig);
        }
        HashMap<String, Object> schemeFilterConfig = new HashMap<String, Object>(1);
        schemeFilterConfig.put("rows", rows);
        return schemeFilterConfig;
    }
}

