/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.aicommand;

import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kd.bos.algo.DataSet;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.api.AICommandParameter;
import kd.bos.form.IFormView;
import kd.bos.form.aicommand.DefaultAICommand;
import kd.bos.form.aicommand.IAICommand;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;

public class AICommandFactory {
    private static ConcurrentMap<String, String> cmdInvokerClazzes = new ConcurrentHashMap<String, String>(16);
    private static final String BOS_FORM_CORE = "bos-form-core";

    public static IAICommand createCmdInvoker(String actionName, AICommandParameter parameter, IFormView targetView) {
        AICommandFactory.registerByDB();
        Objects.requireNonNull(actionName, ResManager.loadKDString((String)"AI\u547d\u4ee4\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (String)"AICommandFactory_0", (String)BOS_FORM_CORE, (Object[])new Object[0]));
        Objects.requireNonNull(parameter, ResManager.loadKDString((String)"AI\u547d\u4ee4\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (String)"AICommandFactory_1", (String)BOS_FORM_CORE, (Object[])new Object[0]));
        DefaultAICommand command = (DefaultAICommand)TypesContainer.createInstance((String)AICommandFactory.findCmdInvokerClazz(actionName));
        command.setCmdType(actionName);
        command.setParams(parameter);
        command.setTargetView(targetView);
        return command;
    }

    public static void registerInvoker(String type, String invokerClazz) {
        cmdInvokerClazzes.put(type, invokerClazz);
    }

    private static String findCmdInvokerClazz(String aiAction) {
        Objects.requireNonNull(aiAction, ResManager.loadKDString((String)"AI\u547d\u4ee4\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (String)"AICommandFactory_0", (String)BOS_FORM_CORE, (Object[])new Object[0]));
        return (String)cmdInvokerClazzes.get(aiAction);
    }

    private static void registerByDB() {
        Map<Object, DynamicObject> cacheDatas = AICommandFactory.loadFromCache("open_aicommand", null);
        for (DynamicObject aiCmdObj : cacheDatas.values()) {
            String number = aiCmdObj.getString("number");
            String clazz = aiCmdObj.getString("cmdclass");
            AICommandFactory.registerInvoker(number, clazz);
        }
    }

    public static Map<Object, DynamicObject> loadFromCache(String entityName, QFilter[] filters) {
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)entityName);
        ArrayList listIds = new ArrayList();
        try (DataSet ds = ORM.create().queryDataSet("BusinessDataServiceHelper.LoadFromCache", entityName, "id", filters);){
            ds.forEach(row -> listIds.add(row.get(0)));
        }
        return BusinessDataReader.loadFromCache((Object[])listIds.toArray(new Object[listIds.size()]), (DynamicObjectType)type);
    }
}

