/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.audit;

import java.lang.reflect.Method;
import java.util.concurrent.Callable;
import kd.bos.audit.Audit;
import kd.bos.audit.AuditInterceptor;
import kd.bos.audit.Auditable;
import kd.bos.dataentity.TypesContainer;
import kd.bos.form.IFormView;
import kd.bos.list.IListView;

public class OperationAudit {
    private static final String AUDIT_NAME = "operation";
    private static final String OPERATION_PREFIX_NAME = "operation_";
    public static final TypesContainer.TypeCreator auditFormViewTypeCreator = new TypesContainer.TypeCreator(){

        public <T> T createInstance(Class<T> cls) throws Exception {
            return (T)OperationAudit.createInstanceWithAudit(cls);
        }
    };

    private static <T> T createInstanceWithAudit(Class<T> cls) throws Exception {
        if (Audit.isEnable() && IFormView.class.isAssignableFrom(cls)) {
            return (T)new AuditInterceptor<T>(cls){

                public Object intercept(Object object, Method method, Object[] args, Callable<Object> callable) throws Throwable {
                    if ("invokeOperation".equals(method.getName())) {
                        String operation = object instanceof IListView ? ((IListView)object).getBillFormId() : ((IFormView)object).getFormShowParameter().getFormId();
                        operation = operation + "." + args[0];
                        try (Auditable audit = Audit.audit((String)("operation,operation_" + operation), (Object[])new Object[]{operation});){
                            Object object2 = callable.call();
                            return object2;
                        }
                    }
                    return callable.call();
                }
            }.get();
        }
        return cls.newInstance();
    }
}

