/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.control.events;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.filter.AbstractFilterGridView;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FastSearchGridView;
import kd.bos.filter.FilterColumn;
import kd.bos.filter.FilterGridView;
import kd.bos.filter.SchemeFilterColumn;
import kd.bos.filter.SchemeFilterView;
import kd.bos.script.annotations.KSMethod;
import kd.bos.script.annotations.KSObject;
import kd.sdk.annotation.SdkPublic;

@KSObject
@SdkPublic
public class FilterContainerInitEvent
extends EventObject {
    private static final long serialVersionUID = -2414517060485071139L;
    private transient List<FilterColumn> fastFilterColumns = new ArrayList<FilterColumn>();
    private transient List<FilterColumn> commonFilterColumns = new ArrayList<FilterColumn>();
    private transient List<FilterColumn> schemeFilterColumns = new ArrayList<FilterColumn>();
    private HashMap<String, List<FilterColumn>> innerFilterColumnMap = new HashMap();
    private transient FastSearchGridView fastSearchGridView;
    private transient FilterGridView filterGridView;
    private transient SchemeFilterView schemeFilterView;

    @KSMethod
    public List<FilterColumn> getFastFilterColumns() {
        return this.fastFilterColumns;
    }

    @KSMethod
    public List<FilterColumn> getCommonFilterColumns() {
        return this.commonFilterColumns;
    }

    @KSMethod
    public List<FilterColumn> getSchemeFilterColumns() {
        return this.schemeFilterColumns;
    }

    public FilterColumn getFilterColumn(String fieldName) {
        List<FilterColumn> filterColumns = this.innerFilterColumnMap.get(fieldName);
        if (filterColumns != null && !filterColumns.isEmpty()) {
            return filterColumns.get(0);
        }
        return null;
    }

    public List<FilterColumn> getFilterColumns(String fieldName) {
        return this.innerFilterColumnMap.get(fieldName);
    }

    private void putInnerFilterColumn(String fieldName, FilterColumn filterColumn) {
        List<FilterColumn> filterColumns;
        if (this.innerFilterColumnMap.get(fieldName) == null) {
            filterColumns = new ArrayList<FilterColumn>();
            filterColumns.add(filterColumn);
        } else {
            filterColumns = this.innerFilterColumnMap.get(fieldName);
        }
        this.innerFilterColumnMap.put(fieldName, filterColumns);
    }

    public void addFilterColumn(FilterColumn filterColumn) {
        AbstractFilterGridView abstractFilterGridView;
        this.putInnerFilterColumn(filterColumn.getFieldName(), filterColumn);
        if (filterColumn instanceof CommonFilterColumn) {
            abstractFilterGridView = this.filterGridView;
            this.commonFilterColumns.add(filterColumn);
        } else if (filterColumn instanceof SchemeFilterColumn) {
            abstractFilterGridView = this.schemeFilterView;
            this.schemeFilterColumns.add(filterColumn);
        } else {
            abstractFilterGridView = this.fastSearchGridView;
            this.fastFilterColumns.add(filterColumn);
        }
        abstractFilterGridView.getItems().add(filterColumn);
        filterColumn.setParentViewKey(abstractFilterGridView.getKey());
        filterColumn.setView(abstractFilterGridView.getView());
        if (filterColumn.getEntityType() == null) {
            filterColumn.setEntityType(abstractFilterGridView.getEntityType());
        }
        filterColumn.setContext(abstractFilterGridView.getContext());
        if (abstractFilterGridView instanceof FilterGridView) {
            ((FilterGridView)abstractFilterGridView).initFilterColumn(filterColumn);
        } else {
            filterColumn.initProperties();
        }
    }

    public FilterContainerInitEvent(Object source, FastSearchGridView fastSearchGridView, FilterGridView filterGridView, SchemeFilterView schemeFilterView, List<FilterColumn> fastFilterColumns, List<FilterColumn> commonFilterColumns, List<FilterColumn> schemeFilterColumns) {
        super(source);
        this.fastSearchGridView = fastSearchGridView;
        this.filterGridView = filterGridView;
        this.schemeFilterView = schemeFilterView;
        this.fastFilterColumns = fastFilterColumns;
        this.commonFilterColumns = commonFilterColumns;
        this.schemeFilterColumns = schemeFilterColumns;
        for (FilterColumn filterColumn : fastFilterColumns) {
            this.putInnerFilterColumn(filterColumn.getFieldName(), filterColumn);
        }
        for (FilterColumn filterColumn : commonFilterColumns) {
            this.putInnerFilterColumn(filterColumn.getFieldName(), filterColumn);
        }
        for (FilterColumn filterColumn : schemeFilterColumns) {
            this.putInnerFilterColumn(filterColumn.getFieldName(), filterColumn);
        }
    }
}

